/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockSided;
import com.carpentersblocks.data.PressurePlate;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentersPressurePlate
extends BlockSided {
    private static PressurePlate data = new PressurePlate();
    private boolean fullBounds = false;

    public BlockCarpentersPressurePlate(Material material) {
        super(material, data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return IconRegistry.icon_uncovered_full;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int polarity = data.getPolarity(TE) == 0 ? 1 : 0;
        data.setPolarity(TE, polarity);
        this.notifyBlocksOfPowerChange(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        if (polarity == 0) {
            ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
        } else {
            ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int trigger = data.getTriggerEntity(TE);
        if (++trigger > 3) {
            trigger = 0;
        }
        data.setTriggerEntity(TE, trigger);
        this.notifyBlocksOfPowerChange(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        if (trigger == 0) {
            ChatHandler.sendMessageToPlayer("message.trigger_player.name", entityPlayer);
        } else if (trigger == 1) {
            ChatHandler.sendMessageToPlayer("message.trigger_monster.name", entityPlayer);
        } else if (trigger == 2) {
            ChatHandler.sendMessageToPlayer("message.trigger_animal.name", entityPlayer);
        } else {
            ChatHandler.sendMessageToPlayer("message.trigger_all.name", entityPlayer);
        }
        return true;
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            float depth = this.fullBounds | !this.isDepressed(TE) ? 0.0625f : 0.03125f;
            this.setBlockBounds(0.0625f, 0.0625f, 0.0f, 0.9375f, 0.9375f, depth, data.getDirection(TE));
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            boolean depressed = false;
            if (this.isDepressed(TE)) {
                depressed = this.hasTriggerInBounds(TE);
            }
            if (depressed) {
                world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
            } else {
                this.toggleOff(TE, world, x, y, z);
            }
        }
    }

    @Override
    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && this.hasTriggerInBounds(TE)) {
            this.toggleOn(TE, world, x, y, z);
        }
    }

    private boolean hasTriggerInBounds(TEBase TE) {
        this.fullBounds = true;
        List entityList = TE.func_145831_w().func_72872_a(Entity.class, this.getSensitiveAABB(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e));
        this.fullBounds = false;
        if (!entityList.isEmpty()) {
            for (int idx = 0; idx < entityList.size(); ++idx) {
                if (!this.canEntityTrigger(TE, (Entity)entityList.get(idx))) continue;
                return true;
            }
        }
        return false;
    }

    private AxisAlignedBB getSensitiveAABB(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    private void toggleOn(TEBase TE, World world, int x, int y, int z) {
        data.setState(TE, 1, true);
        this.notifyBlocksOfPowerChange(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    private void toggleOff(TEBase TE, World world, int x, int y, int z) {
        data.setState(TE, 0, true);
        this.notifyBlocksOfPowerChange(world, x, y, z);
    }

    private boolean isDepressed(TEBase TE) {
        return data.getState(TE) == 1;
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public int getPowerOutput(TEBase TE) {
        int polarity = data.getPolarity(TE);
        if (this.isDepressed(TE)) {
            return polarity == 0 ? 15 : 0;
        }
        return polarity == 1 ? 15 : 0;
    }

    private boolean canEntityTrigger(TEBase TE, Entity entity) {
        if (entity == null) {
            return false;
        }
        int trigger = data.getTriggerEntity(TE);
        if (trigger == 0) {
            return entity instanceof EntityPlayer;
        }
        if (trigger == 1) {
            return entity.isCreatureType(EnumCreatureType.monster, false);
        }
        if (trigger == 2) {
            return entity.isCreatureType(EnumCreatureType.creature, false);
        }
        return true;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && this.isDepressed(TE)) {
            this.notifyBlocksOfPowerChange(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersPressurePlateRenderID;
    }
}

