/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Ability;

import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Auxiliary.Ability.LightCast;
import Reika.ChromatiCraft.Auxiliary.Ability.LightningTumble;
import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.Event.DimensionPingEvent;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityAbilityFireball;
import Reika.ChromatiCraft.Entity.EntityMonsterBait;
import Reika.ChromatiCraft.Entity.EntityNukerBall;
import Reika.ChromatiCraft.Items.Tools.ItemInventoryLinker;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Magic.RainbowTreeEffects;
import Reika.ChromatiCraft.ModInterface.TileEntityLifeEmitter;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFireFX;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.ProgressiveRecursiveBreaker;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Instantiable.Event.ScheduledTickEvent;
import Reika.DragonAPI.Instantiable.FlyingBlocksExplosion;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.ParticleController.BlendListColorController;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.ReactorCraft.Entities.EntityRadiation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockTNT;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidBase;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public class AbilityCalls {
    public static void convertBufferToLP(EntityPlayer ep, int data) {
        if (data > 0) {
            ep.func_70691_i((float)data);
        }
        PlayerElementBuffer.instance.removeFromPlayer(ep, TileEntityLifeEmitter.getLumensPerHundredLP());
    }

    @SideOnly(value=Side.CLIENT)
    public static void doNukerFX(World world, int x, int y, int z, EntityPlayer ep) {
        double lx = (double)x + 0.5 - ep.field_70165_t;
        double ly = (double)y + 0.5 - ep.field_70163_u;
        double lz = (double)z + 0.5 - ep.field_70161_v;
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(BlockKey.getAt((IBlockAccess)world, (int)x, (int)y, (int)z).asItemStack());
        int c = tag == null || tag.isEmpty() ? 0x22AAFF : ((CrystalElement)tag.asWeightedRandom().getRandomEntry()).getColor();
        for (double d = 0.125; d <= 1.0; d += 0.015625) {
            double dx = ep.field_70165_t + d * lx;
            double dy = ep.field_70163_u + d * ly;
            double dz = ep.field_70161_v + d * lz;
            EntityBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz).setLife(5).setAlphaFading().setScale(0.5f).setColor(c);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public static void analyzeBees(EntityPlayer ep) {
        int slot = (int)(ep.field_70170_p.func_82737_E() % (long)ep.field_71071_by.field_70462_a.length);
        ItemStack is = ep.field_71071_by.field_70462_a[slot];
        AbilityHelper.instance.analyzeGenes(is);
    }

    public static void setNoclipState(EntityPlayer ep, boolean set) {
        if (AbilityHelper.instance.isNoClipEnabled != set) {
            AbilityHelper.instance.isNoClipEnabled = set;
            if (set) {
                AbilityHelper.instance.onNoClipEnable(ep);
            } else {
                AbilityHelper.instance.onNoClipDisable(ep);
            }
            ChromatiCraft.logger.debug((Object)("Noclip state changed to " + set));
        } else if (set && ep.field_70170_p.field_72995_K && ep.field_70173_aa % 24 == 0) {
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.NOCLIPRUN, (Entity)ep, (float)1.0f, (float)1.0f);
        }
    }

    public static boolean spawnLightning(EntityPlayer ep, int power) {
        MovingObjectPosition mov;
        if (!ep.field_70170_p.field_72995_K && (mov = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)128.0, (boolean)false)) != null) {
            World world = ep.field_70170_p;
            int x = mov.field_72311_b;
            int y = mov.field_72312_c;
            int z = mov.field_72309_d;
            if (world.func_72937_j(x, y + 1, z) && ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)ep.field_70170_p), (int)x, (int)y, (int)z, (EntityPlayerMP)((EntityPlayerMP)ep))) {
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                int r = 2 + power * 4;
                if (power == 2) {
                    new FlyingBlocksExplosion(world, (double)x + 0.5, (double)y - 2.5, (double)z + 0.5, 6.0f).setTumbling((FlyingBlocksExplosion.TumbleCreator)new LightningTumble(world, x, y, z, r)).doExplosion();
                } else if (power == 1) {
                    world.func_72885_a(null, (double)x + 0.5, (double)y - 0.5, (double)z + 0.5, 4.0f, true, true);
                }
                for (int i = -r; i <= r; ++i) {
                    for (int j = -r; j <= r; ++j) {
                        for (int k = -r; k <= r; ++k) {
                            int dx = x + i;
                            int dy = y + j;
                            int dz = z + k;
                            if (!ReikaWorldHelper.flammable((IBlockAccess)world, (int)dx, (int)dy, (int)dz)) continue;
                            ReikaWorldHelper.ignite((World)world, (int)dx, (int)dy, (int)dz);
                        }
                    }
                }
                return true;
            }
            ChromaSounds.ERROR.playSound((Entity)ep);
            return false;
        }
        return false;
    }

    public static void teleportPlayerMenu(EntityPlayer ep) {
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TELEPORT.ordinal(), ep.field_70170_p, 0, 0, 0);
    }

    public static void causeShockwave(EntityPlayer ep) {
        if (ep.field_70170_p.field_72995_K) {
            AbilityCalls.spawnShockwaveParticles(ep);
        } else {
            ChromaSounds.SHOCKWAVE.playSound((Entity)ep);
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)ep.field_70165_t, (double)ep.field_70163_u, (double)ep.field_70161_v, (double)ep.field_70165_t, (double)ep.field_70163_u, (double)ep.field_70161_v).func_72314_b(16.0, 4.0, 16.0);
            List li = ep.field_70170_p.func_72872_a(EntityLivingBase.class, box);
            for (EntityLivingBase e : li) {
                if (e == ep || !(ReikaMathLibrary.py3d((double)(e.field_70165_t - ep.field_70165_t), (double)0.0, (double)(e.field_70161_v - ep.field_70161_v)) <= 16.0)) continue;
                ReikaEntityHelper.knockbackEntity((Entity)ep, (Entity)e, (double)4.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void spawnShockwaveParticles(EntityPlayer ep) {
        for (int i = 0; i < 360; ++i) {
            double dx = Math.cos(Math.toRadians(i));
            double dz = Math.sin(Math.toRadians(i));
            double vx = dx * 0.5;
            double vz = dz * 0.5;
            EntityCenterBlurFX fx = new EntityCenterBlurFX(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u - 1.62 + 0.1, ep.field_70161_v, vx, 0.0, vz).setColor(33023).setScale(2.0f);
            fx.field_70145_X = false;
            if (i % 4 == 0) {
                fx.setColor(0xFFFFFF);
            } else if (i % 2 == 0) {
                fx.setColor(255);
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            if (i % 30 != 0) continue;
            for (double d = 0.25; d <= 16.0; d += 0.5) {
                EntityCenterBlurFX fx2 = new EntityCenterBlurFX(ep.field_70170_p, ep.field_70165_t + dx * d, ep.field_70163_u - 1.62 + 0.1, ep.field_70161_v + dz * d, 0.0, 0.0, 0.0).setScale(4.0f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
            }
        }
    }

    public static void addInvPage(EntityPlayer ep) {
        if (ep.field_70170_p.field_72995_K) {
            return;
        }
        AbilityHelper.instance.addInventoryPage(ep);
        PlayerElementBuffer.instance.removeFromPlayer(ep, AbilityHelper.instance.getElementsFor(Chromabilities.HOTBAR));
    }

    public static void setPlayerMaxHealth(EntityPlayer ep, int value) {
        float factor = (float)value / 10.0f;
        ep.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111124_b(new AttributeModifier(Chromabilities.HEALTH_UUID, "Chroma", 0.0, 2));
        if (value > 0) {
            ep.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(Chromabilities.HEALTH_UUID, "Chroma", (double)factor, 2));
        }
        ep.func_70606_j(Math.min(ep.func_110143_aJ(), ep.func_110138_aP()));
        if (ep instanceof EntityPlayerMP) {
            AbilityHelper.instance.syncHealth((EntityPlayerMP)ep);
        }
    }

    public static void attractItemsAndXP(EntityPlayer ep, int range, boolean nc) {
        World world = ep.field_70170_p;
        double x = ep.field_70165_t;
        double y = ep.field_70163_u + 1.5;
        double z = ep.field_70161_v;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b((double)range, (double)range, (double)range);
        List inbox = world.func_72872_a(EntityItem.class, box);
        for (EntityItem ent : inbox) {
            if (ent.field_70128_L) continue;
            ReikaEntityHelper.setInvulnerable((Entity)ent, (boolean)true);
            if (ent.field_145804_b == 0) {
                double dx = x + 0.5 - ent.field_70165_t;
                double dy = y + 0.5 - ent.field_70163_u;
                double dz = z + 0.5 - ent.field_70161_v;
                double ddt = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
                if (ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz) < 1.0) {
                    ent.func_70100_b_(ep);
                } else {
                    ent.field_70159_w += dx / ddt / ddt / 1.0;
                    ent.field_70181_x += dy / ddt / ddt / 2.0;
                    ent.field_70179_y += dz / ddt / ddt / 1.0;
                    ent.field_70159_w = MathHelper.func_151237_a((double)ent.field_70159_w, (double)-0.75, (double)0.75);
                    ent.field_70181_x = MathHelper.func_151237_a((double)ent.field_70181_x, (double)-0.75, (double)0.75);
                    ent.field_70179_y = MathHelper.func_151237_a((double)ent.field_70179_y, (double)-0.75, (double)0.75);
                    if (ent.field_70163_u < y) {
                        ent.field_70181_x += 0.125;
                    }
                    if (ent.field_70163_u < 0.0) {
                        ent.field_70181_x = Math.max(1.0, ent.field_70181_x);
                    }
                    if (!world.field_72995_K) {
                        ent.field_70133_I = true;
                    }
                }
            }
            if (ent.field_70292_b >= ent.lifespan - 5) {
                ent.field_70292_b = 0;
            }
            if (nc) {
                ent.field_70145_X = true;
            }
            if (ent.getEntityData().func_74764_b("cc_magnetized")) continue;
            ent.getEntityData().func_74778_a("cc_magnetized", ep.func_110124_au().toString());
        }
        List inbox2 = world.func_72872_a(EntityXPOrb.class, box);
        for (EntityXPOrb ent : inbox2) {
            if (ent.field_70128_L) continue;
            ReikaEntityHelper.setInvulnerable((Entity)ent, (boolean)true);
            double dx = x + 0.5 - ent.field_70165_t;
            double dy = y + 0.5 - ent.field_70163_u;
            double dz = z + 0.5 - ent.field_70161_v;
            double ddt = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            if (ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz) < 1.0) {
                ent.func_70100_b_(ep);
            } else {
                ent.field_70159_w += dx / ddt / ddt / 2.0;
                ent.field_70181_x += dy / ddt / ddt / 2.0;
                ent.field_70179_y += dz / ddt / ddt / 2.0;
                ent.field_70159_w = MathHelper.func_151237_a((double)ent.field_70159_w, (double)-0.75, (double)0.75);
                ent.field_70181_x = MathHelper.func_151237_a((double)ent.field_70181_x, (double)-0.75, (double)0.75);
                ent.field_70179_y = MathHelper.func_151237_a((double)ent.field_70179_y, (double)-0.75, (double)0.75);
                if (ent.field_70163_u < y) {
                    ent.field_70181_x += 0.1;
                }
                if (ent.field_70163_u < 0.0) {
                    ent.field_70181_x = Math.max(1.0, ent.field_70181_x);
                }
                if (!world.field_72995_K) {
                    ent.field_70133_I = true;
                }
            }
            if (ent.field_70531_b >= 6000) {
                ent.field_70531_b = 0;
            }
            if (nc) {
                ent.field_70145_X = true;
            }
            if (ent.getEntityData().func_74764_b("cc_magnetized")) continue;
            ent.getEntityData().func_74778_a("cc_magnetized", ep.func_110124_au().toString());
        }
    }

    public static void setReachDistance(EntityPlayer player, int dist) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            EntityPlayerMP ep = (EntityPlayerMP)player;
            ep.field_71134_c.setBlockReachDistance(dist > 0 ? (double)dist : 5.0);
        } else {
            AbilityHelper.instance.playerReach = dist;
        }
    }

    public static void destroyBlocksAround(EntityPlayer ep, int power) {
        if (power <= 0) {
            return;
        }
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int y = MathHelper.func_76128_c((double)ep.field_70163_u) + 1;
        int z = MathHelper.func_76128_c((double)ep.field_70161_v);
        int r = power;
        if (!ep.field_70170_p.field_72995_K) {
            int amt;
            ItemHashMap drops = new ItemHashMap();
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    for (int k = -r; k <= r; ++k) {
                        Block b;
                        int dx = x + i;
                        int dy = y + j;
                        int dz = z + k;
                        if (!(ReikaMathLibrary.py3d((double)i, (double)j, (double)k) <= (double)r + 0.5) || (b = ep.field_70170_p.func_147439_a(dx, dy, dz)) == Blocks.field_150350_a || !b.func_149662_c() || !(b.field_149782_v >= 0.0f)) continue;
                        int meta = ep.field_70170_p.func_72805_g(dx, dy, dz);
                        if (b instanceof SemiUnbreakable && ((SemiUnbreakable)b).isUnbreakable(ep.field_70170_p, dx, dy, dz, meta) || ep.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() && (b == Blocks.field_150349_c || b == Blocks.field_150348_b || b == Blocks.field_150346_d) && ep.field_70170_p.func_72805_g(dx, dy, dz) == 1 || !ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)ep.field_70170_p), (int)dx, (int)dy, (int)dz, (EntityPlayerMP)((EntityPlayerMP)ep)) || !((float)power > b.getExplosionResistance((Entity)ep, ep.field_70170_p, dx, dy, dz, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v) / 12.0f)) continue;
                        ArrayList li = b.getDrops(ep.field_70170_p, dx, dy, dz, meta, 0);
                        if (b instanceof BlockTieredResource) {
                            BlockTieredResource bt = (BlockTieredResource)b;
                            li.clear();
                            if (bt.isPlayerSufficientTier((IBlockAccess)ep.field_70170_p, dx, dy, dz, ep)) {
                                li.addAll(bt.getHarvestResources(ep.field_70170_p, dx, dy, dz, 0, ep));
                            } else {
                                li.addAll(bt.getNoHarvestResources(ep.field_70170_p, dx, dy, dz, 0, ep));
                            }
                        }
                        ForgeEventFactory.fireBlockHarvesting((ArrayList)li, (World)ep.field_70170_p, (Block)b, (int)dx, (int)dy, (int)dz, (int)meta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)ep);
                        for (ItemStack is : li) {
                            Integer get = (Integer)drops.get(is);
                            int val = get == null ? 0 : get;
                            drops.put(is, (Object)(val + is.field_77994_a));
                        }
                        b.removedByPlayer(ep.field_70170_p, ep, dx, dy, dz, true);
                        ReikaSoundHelper.playBreakSound((World)ep.field_70170_p, (int)dx, (int)dy, (int)dz, (Block)b, (float)0.1f, (float)1.0f);
                        ep.field_70170_p.func_147468_f(dx, dy, dz);
                    }
                }
            }
            for (ItemStack is : drops.keySet()) {
                int drop;
                int max = is.func_77976_d();
                for (amt = ((Integer)drops.get(is)).intValue(); amt > 0; amt -= drop) {
                    drop = Math.min(max, amt);
                    DecimalPosition pos = ReikaRandomHelper.getRandomSphericalPosition((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (int)r);
                    ReikaItemHelper.dropItem((World)ep.field_70170_p, (double)pos.xCoord, (double)pos.yCoord, (double)pos.zCoord, (ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)drop));
                }
            }
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)r, (double)r, (double)r);
            List li = ep.field_70170_p.func_72872_a(EntityXPOrb.class, box);
            amt = 0;
            for (EntityXPOrb e : li) {
                if (!(e.func_70011_f((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= (double)r + 0.5)) continue;
                amt += e.field_70530_e;
                e.func_70106_y();
            }
            ReikaWorldHelper.splitAndSpawnXP((World)ep.field_70170_p, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (int)amt);
        }
        ep.func_85030_a("random.explode", (float)power / 6.0f, 2.0f - (float)power / 6.0f);
    }

    static boolean shiftArea(WorldServer world, BlockBox box, ForgeDirection dir, int dist, EntityPlayerMP ep) {
        FilledBlockArray moved = new FilledBlockArray((World)world);
        BlockArray toDel = new BlockArray();
        toDel.setWorld((World)world);
        int air = 0;
        for (int i = 0; i <= box.getSizeX(); ++i) {
            for (int j = 0; j <= box.getSizeY(); ++j) {
                for (int k = 0; k <= box.getSizeZ(); ++k) {
                    int x = i + box.minX;
                    int y = j + box.minY;
                    int z = k + box.minZ;
                    Block b = world.func_147439_a(x, y, z);
                    int meta = world.func_72805_g(x, y, z);
                    if (!ep.field_71075_bZ.field_75098_d && b instanceof SemiUnbreakable && ((SemiUnbreakable)b).isUnbreakable((World)world, x, y, z, meta) || !ep.field_71075_bZ.field_75098_d && ReikaBlockHelper.isUnbreakable((World)world, (int)x, (int)y, (int)z, (Block)b, (int)meta, (EntityPlayer)ep) || b.hasTileEntity(meta) && !ChromaOptions.SHIFTTILES.getState()) continue;
                    moved.setBlock(x, y, z, b, meta);
                    toDel.addBlockCoordinate(x, y, z);
                    if (!b.isAir((IBlockAccess)world, x, y, z)) continue;
                    ++air;
                }
            }
        }
        moved.offset(dir, dist);
        int factor = (int)(Math.pow(box.getVolume() - air, 1.25) * (double)dist / 5.0);
        ElementTagCompound cost = AbilityHelper.instance.getUsageElementsFor(Chromabilities.SHIFT, (EntityPlayer)ep).scale(factor);
        boolean nrg = PlayerElementBuffer.instance.playerHas((EntityPlayer)ep, cost);
        boolean flag = false;
        if (nrg && ReikaPlayerAPI.playerCanBreakAt((WorldServer)world, (BlockArray)toDel, (EntityPlayerMP)ep) && ReikaPlayerAPI.playerCanBreakAt((WorldServer)world, (BlockArray)moved, (EntityPlayerMP)ep)) {
            BlockArray toDrop = BlockArray.getIntersectedBox((BlockArray)toDel, (BlockArray)moved);
            toDrop.setWorld((World)world);
            for (ItemStack itemStack : toDrop.getAllDroppedItems((World)world, 0, (EntityPlayer)ep)) {
            }
            toDel.clearArea();
            moved.place();
            PlayerElementBuffer.instance.removeFromPlayer((EntityPlayer)ep, cost);
            flag = true;
        } else {
            flag = false;
            ChromaSounds.ERROR.playSound((Entity)ep);
        }
        Chromabilities.SHIFT.setToPlayer((EntityPlayer)ep, false);
        return flag;
    }

    public static void healPlayer(EntityPlayer ep, int health) {
        ep.func_70691_i((float)health);
    }

    public static void launchFireball(EntityPlayer ep, int charge) {
        DecimalPosition look = ReikaVectorHelper.getPlayerLookCoords((EntityPlayer)ep, (double)2.0);
        EntityAbilityFireball ef = new EntityAbilityFireball(ep.field_70170_p, ep, look.xCoord, look.yCoord + 1.0, look.zCoord);
        Vec3 lookv = ep.func_70040_Z();
        ef.field_70159_w = lookv.field_72450_a / 5.0;
        ef.field_70181_x = lookv.field_72448_b / 5.0;
        ef.field_70179_y = lookv.field_72449_c / 5.0;
        ef.field_70232_b = ef.field_70159_w;
        ef.field_70233_c = ef.field_70181_x;
        ef.field_70230_d = ef.field_70179_y;
        ef.field_92057_e = charge;
        ef.field_70163_u = ep.field_70163_u + 1.0;
        if (!ep.field_70170_p.field_72995_K) {
            ep.field_70170_p.func_72956_a((Entity)ep, "mob.ghast.fireball", 1.0f, 1.0f);
            ep.field_70170_p.func_72838_d((Entity)ef);
        }
    }

    public static void stopArrows(EntityPlayer ep) {
        if (!ep.field_70170_p.field_72995_K) {
            AxisAlignedBB box = ep.field_70121_D.func_72314_b(6.0, 4.0, 6.0);
            List li = ep.field_70170_p.func_72872_a(EntityArrow.class, box);
            for (EntityArrow e : li) {
                if (e.field_70250_c == ep || e.field_70250_c instanceof EntityPlayer && !MinecraftServer.func_71276_C().func_71219_W()) continue;
                e.field_70159_w *= (double)-0.1f;
                e.field_70181_x *= (double)-0.1f;
                e.field_70179_y *= (double)-0.1f;
                e.field_70177_z += 180.0f;
                e.field_70126_B += 180.0f;
                e.field_70257_an = 0;
            }
        }
    }

    public static void deAggroMobs(EntityPlayer ep) {
        AxisAlignedBB box = ep.field_70121_D.func_72314_b(12.0, 12.0, 12.0);
        List li = ep.field_70170_p.func_72872_a(EntityMob.class, box);
        for (EntityMob e : li) {
            EntityCreeper ec;
            if (e instanceof EntityEnderman || e instanceof EntityPigZombie) continue;
            if (e.func_70777_m() == ep || e.func_70777_m() == null) {
                // empty if block
            }
            if (!(e instanceof EntityCreeper) || (ec = (EntityCreeper)e).func_70777_m() == ep) continue;
            ec.func_70829_a(-1);
            ec.func_70096_w().func_75692_b(18, (Object)0);
            ec.field_70833_d = 0;
        }
    }

    public static void breakSurroundingBlocks(EntityPlayer ep) {
        if (!ep.field_70170_p.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                double ANGLE = 35.0;
                double phi = ReikaRandomHelper.getRandomPlusMinus((double)(ep.field_70759_as + 90.0f), (double)ANGLE);
                double theta = ReikaRandomHelper.getRandomPlusMinus((double)(-ep.field_70125_A), (double)ANGLE);
                double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)1.0, (double)theta, (double)phi);
                Coordinate c = null;
                for (double d = 0.0; d <= 8.0; d += 0.125) {
                    int z;
                    int y;
                    double dx = ep.field_70165_t + xyz[0] * d;
                    double dy = ep.field_70163_u + 1.62 + xyz[1] * d;
                    double dz = ep.field_70161_v + xyz[2] * d;
                    int x = MathHelper.func_76128_c((double)dx);
                    Block b = ep.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)dy), z = MathHelper.func_76128_c((double)dz));
                    if (b.isAir((IBlockAccess)ep.field_70170_p, x, y, z) || ReikaBlockHelper.isLiquid((Block)b) || b == Blocks.field_150474_ac || ReikaBlockHelper.isUnbreakable((World)ep.field_70170_p, (int)x, (int)y, (int)z, (Block)b, (int)ep.field_70170_p.func_72805_g(x, y, z), (EntityPlayer)ep) || !ep.field_70170_p.func_72872_a(EntityNukerBall.class, ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z)).isEmpty()) continue;
                    c = new Coordinate(x, y, z);
                    break;
                }
                if (c == null) continue;
                EntityNukerBall enb = new EntityNukerBall(ep.field_70170_p, ep, c);
                ep.field_70170_p.func_72838_d((Entity)enb);
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.NUKERLOC.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget((Entity)ep, 64.0), (int[])new int[]{c.xCoord, c.yCoord, c.zCoord, ep.func_145782_y()});
            }
        }
    }

    public static void tickFireRain(EntityPlayer ep) {
        World world = ep.field_70170_p;
        if (world.field_72995_K) {
            AbilityCalls.doFireRainParticles(ep);
        } else {
            int x = MathHelper.func_76128_c((double)ep.field_70165_t);
            int z = MathHelper.func_76128_c((double)ep.field_70161_v);
            BiomeGenBase biome = world.func_72807_a(x, z);
            int n = 4;
            if (biome.field_76791_y.contains("Dark Forest")) {
                n = 32;
            }
            for (int m = 0; m < n; ++m) {
                int dr = m < 32 ? 128 : (m < 64 ? 64 : 32);
                int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
                int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr);
                int dy = ReikaWorldHelper.getTopNonAirBlock((World)world, (int)dx, (int)dz, (boolean)true);
                ReikaWorldHelper.ignite((World)world, (int)dx, (int)dy, (int)dz);
                int r = m > 256 && world.field_73012_v.nextInt(4) == 0 ? 2 : 1;
                for (int i = -r; i <= r; ++i) {
                    for (int j = -r; j <= r; ++j) {
                        for (int k = -r; k <= r; ++k) {
                            int meta;
                            int ddx = dx + i;
                            int ddy = dy + j;
                            int ddz = dz + k;
                            Block b = world.func_147439_a(ddx, ddy, ddz);
                            ModWoodList wood = ModWoodList.getModWoodFromLeaf((Block)b, (int)(meta = world.func_72805_g(ddx, ddy, ddz)));
                            if (wood != ModWoodList.DARKWOOD) continue;
                            world.func_147449_b(ddx, ddy, ddz, (Block)Blocks.field_150480_ab);
                            if (world.field_73012_v.nextInt(60) != 0) continue;
                            world.func_72885_a((Entity)ep, (double)ddx + 0.5, (double)ddy + 0.5, (double)ddz + 0.5, 8.0f, true, true);
                        }
                    }
                }
                ChromaSounds.FIRE.playSoundAtBlock(world, dx, dy, dz, 1.5f, 1.0f + world.field_73012_v.nextFloat() * 0.5f);
            }
            if (ep.field_70173_aa % 4 == 0) {
                ChromaSounds.FIRE.playSound((Entity)ep, 0.3f, 0.2f + world.field_73012_v.nextFloat());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void doFireRainParticles(EntityPlayer ep) {
        int n = 1 + ep.field_70170_p.field_73012_v.nextInt(8);
        for (int i = 0; i < n; ++i) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70165_t, (double)32.0);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70161_v, (double)32.0);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)(ep.field_70163_u + 32.0), (double)32.0);
            float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.5, (double)0.25);
            int l = 200;
            EntityBlurFX fx = new EntityFireFX(ep.field_70170_p, rx, ry, rz).setGravity(g).setScale(8.0f).setLife(l);
            if (ep.field_70170_p.field_73012_v.nextInt(8) == 0) {
                ((EntityFireFX)fx).setExploding();
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public static boolean doLightCast(EntityPlayer ep) {
        if (ep.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() && ChromaDimensionManager.getStructurePlayerIsIn(ep) != null) {
            return false;
        }
        Coordinate c = new Coordinate((Entity)ep).offset(0, 1, 0);
        ProgressiveRecursiveBreaker.ProgressiveBreaker b = ProgressiveRecursiveBreaker.instance.addCoordinateWithReturn(ep.field_70170_p, c.xCoord, c.yCoord, c.zCoord, 200);
        for (Block bk : LightCast.getPassthroughBlocks()) {
            b.passthrough.add(new BlockKey(bk));
        }
        b.call = new LightCast(ep);
        b.player = ep;
        b.hungerFactor = 0.0f;
        b.causeUpdates = false;
        b.breakAir = true;
        ChromaSounds.LIGHTCAST.playSound((Entity)ep);
        return true;
    }

    public static boolean doJump(EntityPlayer ep, int power) {
        ep.field_70181_x += (double)power / 2.0 * (1.0 + ep.field_70170_p.field_73012_v.nextDouble());
        ep.field_70133_I = true;
        ep.field_70143_R -= 100.0f;
        ChromaSounds.RIFT.playSound((Entity)ep, 1.0f, 2.0f);
        return true;
    }

    public static boolean doLaserPulse(EntityPlayer ep) {
        World world = ep.field_70170_p;
        MovingObjectPosition p = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)128.0, (boolean)false);
        if (p == null || p.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return false;
        }
        if (!world.func_72937_j(p.field_72311_b, p.field_72312_c + 1, p.field_72309_d)) {
            return false;
        }
        if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() && p.field_72312_c < 90) {
            return false;
        }
        double px = (double)p.field_72311_b + 0.5;
        double py = (double)p.field_72312_c + 0.5;
        double pz = (double)p.field_72309_d + 0.5;
        if (world.field_72995_K) {
            AbilityCalls.doLaserPunchParticles(ep, px, py, pz);
        } else {
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)px, (double)py, (double)pz, (double)px, (double)py, (double)pz).func_72314_b(64.0, 32.0, 64.0);
            List li = world.func_72872_a(EntityLiving.class, box);
            for (EntityLiving e : li) {
                e.func_70097_a((DamageSource)new ReikaEntityHelper.WrappedDamageSource((DamageSource)ChromatiCraft.pylonDamage[CrystalElement.BLUE.ordinal()], ep), 2.1474836E9f);
            }
            double r = ReikaRandomHelper.getRandomPlusMinus((double)10.0, (double)2.0);
            double h = ReikaRandomHelper.getRandomBetween((double)r, (double)(r * 4.0));
            int i = -((int)Math.ceil(r));
            while ((double)i <= Math.ceil(r)) {
                int k = -((int)Math.ceil(r));
                while ((double)k <= Math.ceil(r)) {
                    int j = -((int)Math.ceil(h));
                    while ((double)j <= Math.ceil(h)) {
                        if (ReikaMathLibrary.isPointInsideEllipse((double)i, (double)j, (double)k, (double)r, (double)h, (double)r)) {
                            double d = ReikaMathLibrary.py3d((double)i, (double)0.0, (double)k);
                            double dx = px + (double)i;
                            double dy = py + (double)j;
                            double dz = pz + (double)k;
                            int dpx = MathHelper.func_76128_c((double)dx);
                            int dpy = MathHelper.func_76128_c((double)dy);
                            int dpz = MathHelper.func_76128_c((double)dz);
                            Block b = world.func_147439_a(dpx, dpy, dpz);
                            int meta = world.func_72805_g(dpx, dpy, dpz);
                            if (!(b == Blocks.field_150357_h && dpy <= 4 || b == ChromaBlocks.HOVER.getBlockInstance() && world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() || b instanceof SemiUnbreakable && ((SemiUnbreakable)b).isUnbreakable(world, dpx, dpy, dpz, meta) || !ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)dpx, (int)dpy, (int)dpz, (EntityPlayerMP)((EntityPlayerMP)ep)))) {
                                boolean flag = false;
                                if ((0.5 + 0.5 * world.field_73012_v.nextDouble()) * d < r * (0.5 + world.field_73012_v.nextDouble() * 0.5)) {
                                    EntityItem ei;
                                    if (ReikaBlockHelper.isOre((Block)b, (int)meta)) {
                                        ItemStack is = ReikaBlockHelper.getSilkTouch((World)world, (int)dpx, (int)dpy, (int)dpz, (Block)b, (int)meta, (EntityPlayer)ep, (boolean)false);
                                        ItemStack out = FurnaceRecipes.func_77602_a().func_151395_a(is);
                                        if (out != null) {
                                            out = out.func_77946_l();
                                            out.field_77994_a *= 2;
                                            ei = ReikaItemHelper.dropItem((World)world, (double)dx, (double)dy, (double)dz, (ItemStack)out);
                                            ReikaEntityHelper.setInvulnerable((Entity)ei, (boolean)true);
                                        }
                                    } else if (b instanceof BlockTieredResource && ((BlockTieredResource)b).isPlayerSufficientTier((IBlockAccess)world, dpx, dpy, dpz, ep)) {
                                        for (ItemStack is : ((BlockTieredResource)b).getHarvestResources(world, dpx, dpy, dpz, 3, ep)) {
                                            ei = ReikaItemHelper.dropItem((World)world, (double)dx, (double)dy, (double)dz, (ItemStack)is);
                                            ReikaEntityHelper.setInvulnerable((Entity)ei, (boolean)true);
                                        }
                                    }
                                    if (b instanceof BlockTNT) {
                                        ((BlockTNT)b).func_150114_a(world, dpx, dpy, dpz, 1, (EntityLivingBase)ep);
                                    }
                                    world.func_147449_b(dpx, dpy, dpz, Blocks.field_150350_a);
                                }
                            }
                        }
                        ++j;
                    }
                    ++k;
                }
                ++i;
            }
            for (float f = 0.1f; f <= 2.0f; f *= 2.0f) {
                ReikaSoundHelper.playSoundFromServer((World)world, (double)px, (double)py, (double)pz, (String)"random.explode", (float)2.0f, (float)f, (boolean)true);
                ReikaSoundHelper.playSoundFromServer((World)world, (double)ep.field_70165_t, (double)ep.field_70163_u, (double)ep.field_70161_v, (String)"random.explode", (float)1.0f, (float)f, (boolean)true);
            }
            ChromaSounds.LASER.playSound((Entity)ep, 2.0f, 1.0f);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private static void doLaserPunchParticles(EntityPlayer ep, double px, double py, double pz) {
        double vy;
        double vz;
        double vx;
        double v;
        int l;
        double ry;
        double rz;
        double rx;
        double r;
        double a;
        int i;
        int n = 2048 + ep.field_70170_p.field_73012_v.nextInt(16384);
        double maxr = 32.0;
        for (i = 0; i < n; ++i) {
            a = ep.field_70170_p.field_73012_v.nextDouble() * 360.0;
            r = ReikaRandomHelper.getRandomBetween((double)0.0, (double)maxr);
            rx = px + r * Math.sin(Math.toRadians(a));
            rz = pz + r * Math.cos(Math.toRadians(a));
            ry = ReikaRandomHelper.getRandomPlusMinus((double)(py + 1.5), (double)1.0) + (double)(ep.field_70170_p.func_72825_h(MathHelper.func_76128_c((double)rx), MathHelper.func_76128_c((double)rz)) - ep.field_70170_p.func_72825_h(MathHelper.func_76128_c((double)px), MathHelper.func_76128_c((double)pz)));
            l = 40 + ep.field_70170_p.field_73012_v.nextInt(120);
            v = ReikaRandomHelper.getRandomPlusMinus((double)0.25, (double)0.125) / 32.0;
            vx = (rx - px) * v;
            vz = (rz - pz) * v;
            vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            float f = (float)(r / maxr);
            float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)8.0, (double)4.0) + 4.0f * (1.0f - f);
            int c = (double)f < 0.5 ? ReikaColorAPI.mixColors((int)0xFFFFFF, (int)41215, (float)(1.0f - f * 2.0f)) : ReikaColorAPI.mixColors((int)255, (int)41215, (float)((f - 0.5f) * 2.0f));
            EntityBlurFX fx = new EntityCCBlurFX(ep.field_70170_p, rx, ry, rz, vx, vy, vz).setColor(c).setScale(s).setLife(l).setRapidExpand().setColliding();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < n / 16; ++i) {
            a = ep.field_70170_p.field_73012_v.nextDouble() * 360.0;
            r = ReikaRandomHelper.getRandomPlusMinus((double)(maxr + 24.0), (double)4.0);
            rx = px + r * Math.sin(Math.toRadians(a));
            rz = pz + r * Math.cos(Math.toRadians(a));
            ry = ReikaRandomHelper.getRandomPlusMinus((double)(py + 1.5), (double)1.0) + (double)(ep.field_70170_p.func_72825_h(MathHelper.func_76128_c((double)rx), MathHelper.func_76128_c((double)rz)) - ep.field_70170_p.func_72825_h(MathHelper.func_76128_c((double)px), MathHelper.func_76128_c((double)pz)));
            l = 40 + ep.field_70170_p.field_73012_v.nextInt(120);
            v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625) / 64.0;
            vx = (rx - px) * v;
            vz = (rz - pz) * v;
            vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)16.0, (double)4.0);
            int c = 0xA000FF;
            EntityBlurFX fx = new EntityCCBlurFX(ep.field_70170_p, rx, ry, rz, vx, vy, vz).setColor(c).setScale(s).setLife(l).setRapidExpand().setColliding();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (double dy = py; dy < 1024.0; dy += 1.0) {
            EntityBlurFX fx = new EntityCCBlurFX(ep.field_70170_p, px, dy, pz).setColor(0xFFFFFF).setScale(16.0f).setLife(120).setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public static void doGrowthAura(EntityPlayer ep) {
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int y = MathHelper.func_76128_c((double)ep.field_70163_u);
        int z = MathHelper.func_76128_c((double)ep.field_70161_v);
        if (ep.field_70170_p.field_72995_K) {
            AbilityCalls.doGrowthAuraParticles(ep, x, y, z);
        } else {
            int power = AbilityHelper.instance.getGrowAuraState(ep);
            RainbowTreeEffects.instance.doRainbowTreeEffects(ep.field_70170_p, x, y, z, 4.0f, 0.25, DragonAPICore.rand, false);
            if (power >= 1) {
                for (int i = 0; i < 8; ++i) {
                    int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)8);
                    int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)8);
                    int dy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)2);
                    ReikaWorldHelper.fertilizeAndHealBlock((World)ep.field_70170_p, (int)dx, (int)dy, (int)dz);
                    Block b = ep.field_70170_p.func_147439_a(dx, dy, dz);
                    if (power >= 3 && ModList.THAUMCRAFT.isLoaded() && b == ThaumItemHelper.BlockEntry.NODE.getBlock()) {
                        AbilityCalls.healNodes(ep.field_70170_p, dx, dy, dz);
                        continue;
                    }
                    if (power >= 2 && ep.field_70170_p.field_73012_v.nextInt(b == Blocks.field_150349_c ? 18 : 6) == 0) {
                        FakePlayer fake = ReikaPlayerAPI.getFakePlayerByNameAndUUID((WorldServer)((WorldServer)ep.field_70170_p), (String)"Random", (UUID)Chromabilities.FAKE_UUID);
                        fake.func_70062_b(0, ReikaItemHelper.bonemeal.func_77946_l());
                        ItemDye.applyBonemeal((ItemStack)fake.func_71045_bC().func_77946_l(), (World)ep.field_70170_p, (int)dx, (int)dy, (int)dz, (EntityPlayer)fake);
                        continue;
                    }
                    BlockTickEvent.fire((Block)b, (World)ep.field_70170_p, (int)dx, (int)dy, (int)dz, (Random)DragonAPICore.rand, (int)BlockTickEvent.UpdateFlags.getForcedUnstoppableTick());
                }
            }
            if (ModList.REACTORCRAFT.isLoaded() && DragonAPICore.rand.nextInt(40) == 0) {
                AbilityCalls.cleanRadiation(ep);
            }
            if (ModList.FORESTRY.isLoaded()) {
                ReikaBeeHelper.attractButterflies((World)ep.field_70170_p, (double)ep.field_70165_t, (double)ep.field_70163_u, (double)ep.field_70161_v, (double)32.0, null);
            }
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    private static void healNodes(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof INode) {
            INode n = (INode)te;
            AspectList al = n.getAspects();
            Aspect a = (Aspect)ReikaJavaLibrary.getRandomCollectionEntry((Random)world.field_73012_v, al.aspects.keySet());
            if (a != null && n.getNodeVisBase(a) > al.getAmount(a)) {
                n.addToContainer(a, 1);
            }
            if (world.field_73012_v.nextInt(8) == 0) {
                if (world.field_73012_v.nextInt(4) == 0) {
                    NodeModifier m = n.getNodeModifier();
                    if (m != NodeModifier.BRIGHT) {
                        n.setNodeModifier(m == NodeModifier.FADING ? NodeModifier.PALE : NodeModifier.BRIGHT);
                    }
                } else {
                    NodeType t = n.getNodeType();
                    if (t != NodeType.PURE && t != NodeType.NORMAL) {
                        n.setNodeType(t == NodeType.HUNGRY || t == NodeType.TAINTED ? NodeType.DARK : (t == NodeType.DARK ? NodeType.UNSTABLE : NodeType.NORMAL));
                    }
                }
            }
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.REACTORCRAFT})
    private static void cleanRadiation(EntityPlayer ep) {
        AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)ep, (double)8.0);
        for (EntityRadiation e : ep.field_70170_p.func_72872_a(EntityRadiation.class, box)) {
            e.clean();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void doGrowthAuraParticles(EntityPlayer ep, int x, int y, int z) {
        int i;
        for (i = 0; i < 4; ++i) {
            ChromaFX.doGrowthWandParticles(ep.field_70170_p, ReikaRandomHelper.getRandomPlusMinus((int)x, (int)4), y - 1, ReikaRandomHelper.getRandomPlusMinus((int)z, (int)4));
        }
        for (i = 0; i < 6; ++i) {
            double a = ep.field_70170_p.field_73012_v.nextDouble() * 360.0;
            double r = ReikaRandomHelper.getRandomPlusMinus((double)2.0, (double)0.5);
            float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125));
            float s = 1.5f + ep.field_70170_p.field_73012_v.nextFloat();
            double dx = ep.field_70165_t + r * Math.cos(Math.toRadians(a));
            double dy = ep.field_70163_u - 1.62;
            double dz = ep.field_70161_v + r * Math.sin(Math.toRadians(a));
            int c = CrystalElement.MAGENTA.getColor();
            int l = 20 + ep.field_70170_p.field_73012_v.nextInt(20);
            EntityBlurFX fx = new EntityCCBlurFX(ep.field_70170_p, dx, dy, dz).setIcon(ChromaIcons.CENTER).setGravity(g).setScale(s).setColor(c).setLife(l).setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public static void doDimensionPing(EntityPlayer ep) {
        if (ep.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            int x = MathHelper.func_76128_c((double)ep.field_70165_t);
            int z = MathHelper.func_76128_c((double)ep.field_70161_v);
            long seed = ep.field_70170_p.func_72905_C() ^ (long)ep.func_110124_au().hashCode();
            Random rand = new Random(seed);
            rand.nextBoolean();
            rand.nextBoolean();
            for (DimensionStructureGenerator.StructurePair s : ChunkProviderChroma.getStructures()) {
                if (!s.generator.isComplete()) continue;
                ChunkCoordIntPair loc = s.generator.getEntryLocation();
                int px = loc.field_77276_a << 4;
                int pz = loc.field_77275_b << 4;
                double dx = px - x;
                double dz = pz - z;
                double dist = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
                double ang = ReikaDirectionHelper.getCompassHeading((double)dx, (double)dz);
                double pow = 1.45 + 0.3 * rand.nextDouble();
                double factor = Math.pow(dist, pow);
                double fac = 18000.0 + 2000.0 * rand.nextDouble();
                int delay = Math.max(1, (int)(factor /= fac));
                DimensionPingEvent evt = new DimensionPingEvent(s.color, ep, dist, ang);
                TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)evt), delay);
            }
        } else {
            ChromaSounds.ERROR.playSound((Entity)ep);
        }
    }

    private static boolean isValidWaterBlocks(Block id, Block idbelow) {
        return (idbelow instanceof BlockLiquid || idbelow instanceof BlockFluidBase) && !(id instanceof BlockLiquid) && !(id instanceof BlockFluidBase);
    }

    public static void waterRun(EntityPlayer ep) {
        Block idbelow;
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        Block id = ep.field_70170_p.func_147439_a(x, (y = MathHelper.func_76128_c((double)ep.field_70163_u)) - 1, z = MathHelper.func_76128_c((double)ep.field_70161_v));
        if (AbilityCalls.isValidWaterBlocks(id, idbelow = ep.field_70170_p.func_147439_a(x, y - 2, z)) && ReikaMathLibrary.py3d((double)ep.field_70159_w, (double)0.0, (double)ep.field_70179_y) >= 0.15) {
            ep.field_70143_R = 0.0f;
            if (ep instanceof EntityPlayerMP) {
                ((EntityPlayerMP)ep).field_71135_a.field_147365_f = 0;
            }
            for (int i = 0; i < 8; ++i) {
                ReikaParticleHelper.RAIN.spawnAt(ep.field_70170_p, ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70165_t, (double)0.25), ep.field_70163_u - 1.0, ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70161_v, (double)0.25));
            }
            if (ep.field_70173_aa % 2 == 0) {
                ep.func_85030_a("random.splash", 0.0625f + ep.field_70170_p.field_73012_v.nextFloat() * 0.25f, 0.25f + ep.field_70170_p.field_73012_v.nextFloat());
            }
            ep.field_70181_x = Math.max(0.0, ep.field_70181_x);
            ep.func_70107_b(ep.field_70165_t, (double)((int)ep.field_70163_u) + 0.7, ep.field_70161_v);
            ep.func_70024_g(0.05 * ep.field_70159_w, 0.0, 0.05 * ep.field_70179_y);
        }
    }

    public static void superbuild(World world, int x, int y, int z, ForgeDirection dir, Block b, int meta, ItemStack is, EntityPlayer ep) {
        boolean reachedY;
        boolean reachedX;
        boolean reached = false;
        boolean hasBlock = true;
        boolean hitBlock = false;
        int delay = 1;
        double maxd = ReikaMathLibrary.py3d((double)(ep.field_70165_t - (double)x - 0.5), (double)(ep.field_70163_u - (double)y - 0.5), (double)(ep.field_70161_v - (double)z - 0.5));
        boolean bl = dir.offsetX != 0 && (dir.offsetX < 0 ? (double)x <= ep.field_70165_t : (double)x >= ep.field_70165_t) ? true : (reachedX = false);
        boolean bl2 = dir.offsetY != 0 && (dir.offsetY < 0 ? (double)y <= ep.field_70163_u - 1.0 : (double)y >= ep.field_70163_u - 1.0) ? true : (reachedY = false);
        boolean reachedZ = dir.offsetZ != 0 && (dir.offsetZ < 0 ? (double)z <= ep.field_70161_v : (double)z >= ep.field_70161_v);
        reached = reachedX || reachedY || reachedZ;
        ElementTagCompound tag = AbilityHelper.instance.getUsageElementsFor(Chromabilities.SUPERBUILD, ep).scale(0.05f);
        while (!reached && hasBlock && !hitBlock && PlayerElementBuffer.instance.playerHas(ep, tag)) {
            hitBlock = !ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)(x += dir.offsetX), (int)(y += dir.offsetY), (int)(z += dir.offsetZ));
            if (hitBlock) continue;
            if (!ep.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
            boolean bl3 = hasBlock = is.field_77994_a > 0;
            boolean bl4 = dir.offsetX != 0 && (dir.offsetX < 0 ? (double)x <= ep.field_70165_t : (double)x >= ep.field_70165_t) ? true : (reachedX = false);
            boolean bl5 = dir.offsetY != 0 && (dir.offsetY < 0 ? (double)y <= ep.field_70163_u - 1.0 : (double)y >= ep.field_70163_u - 1.0) ? true : (reachedY = false);
            reachedZ = dir.offsetZ != 0 && (dir.offsetZ < 0 ? (double)z <= ep.field_70161_v : (double)z >= ep.field_70161_v);
            reached = reachedX || reachedY || reachedZ;
            TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)new ScheduledTickEvent.ScheduledBlockPlace(world, x, y, z, b, meta)), delay);
            double d = ReikaMathLibrary.py3d((double)(ep.field_70165_t - (double)x - 0.5), (double)(ep.field_70163_u - (double)y - 0.5), (double)(ep.field_70161_v - (double)z - 0.5));
            float v = (float)(0.5 * (1.0 - d / maxd));
            TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)new ScheduledTickEvent.ScheduledSoundEvent((SoundEnum)ChromaSounds.RIFT, world, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, v, 2.0f)), delay);
            TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)new ScheduledTickEvent.ScheduledPacket("ChromaData", ChromaPackets.SUPERBUILD.ordinal(), world, x, y, z, 64, new int[]{dir.ordinal()})), delay);
            PlayerElementBuffer.instance.removeFromPlayer(ep, tag);
            delay += (int)(5.0 / Math.pow(delay, 0.33));
        }
        if (!ep.field_71075_bZ.field_75098_d) {
            --is.field_77994_a;
            ep.func_70062_b(0, is);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doSuperbuildFX(World world, int x, int y, int z, ForgeDirection dir) {
        double d;
        double o = 0.0625;
        double ox = dir.offsetX != 0 ? 0.0 : o;
        double oy = dir.offsetY != 0 ? 0.0 : o;
        double oz = dir.offsetZ != 0 ? 0.0 : o;
        for (d = -ox; d <= 1.0 + ox; d += 0.0625) {
            AbilityCalls.createSuperbuildParticle(world, (double)x + d, (double)y - oy, (double)z - oz);
            AbilityCalls.createSuperbuildParticle(world, (double)x + d, (double)(y + 1) + oy, (double)z - oz);
            AbilityCalls.createSuperbuildParticle(world, (double)x + d, (double)y - oy, (double)(z + 1) + oz);
            AbilityCalls.createSuperbuildParticle(world, (double)x + d, (double)(y + 1) + oy, (double)(z + 1) + oz);
        }
        for (d = -oy; d <= 1.0 + oy; d += 0.0625) {
            AbilityCalls.createSuperbuildParticle(world, (double)x - ox, (double)y + d, (double)z - oz);
            AbilityCalls.createSuperbuildParticle(world, (double)(x + 1) + ox, (double)y + d, (double)z - oz);
            AbilityCalls.createSuperbuildParticle(world, (double)x - ox, (double)y + d, (double)(z + 1) + oz);
            AbilityCalls.createSuperbuildParticle(world, (double)(x + 1) + ox, (double)y + d, (double)(z + 1) + oz);
        }
        for (d = -oz; d <= 1.0 + oz; d += 0.0625) {
            AbilityCalls.createSuperbuildParticle(world, (double)x - ox, (double)y - oy, (double)z + d);
            AbilityCalls.createSuperbuildParticle(world, (double)(x + 1) + ox, (double)y - oy, (double)z + d);
            AbilityCalls.createSuperbuildParticle(world, (double)x - ox, (double)(y + 1) + oy, (double)z + d);
            AbilityCalls.createSuperbuildParticle(world, (double)(x + 1) + ox, (double)(y + 1) + oy, (double)z + d);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void createSuperbuildParticle(World world, double px, double py, double pz) {
        EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setLife(30).setScale(0.625f).setRapidExpand().setAlphaFading();
        fx.setColorController((ColorController)new BlendListColorController(new ColorBlendList(10.0f, new int[]{0xFFFFFF, 0x22AAFF, 255, 0})));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public static void doChestCollection(EntityPlayerMP ep) {
        TileEntity te;
        if (ep.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            return;
        }
        if (ModList.FORESTRY.isLoaded()) {
            ReikaBeeHelper.collectButterflies((World)ep.field_70170_p, (AxisAlignedBB)ReikaAABBHelper.getEntityCenteredAABB((Entity)ep, (double)4.0), (EntityPlayer)ep);
        }
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int y = MathHelper.func_76128_c((double)ep.field_70163_u);
        int z = MathHelper.func_76128_c((double)ep.field_70161_v);
        x = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)(ep.func_70681_au().nextBoolean() ? 3 : 9));
        z = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)(ep.func_70681_au().nextBoolean() ? 3 : 9));
        if (!ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)ep.field_70170_p), (int)x, (int)(y = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)(ep.func_70681_au().nextBoolean() ? 1 : 4))), (int)z, (EntityPlayerMP)ep)) {
            return;
        }
        Block b = ep.field_70170_p.func_147439_a(x, y, z);
        if ((b instanceof BlockChest || b instanceof BlockLootChest) && (te = ep.field_70170_p.func_147438_o(x, y, z)) instanceof IInventory) {
            BlockLootChest.TileEntityLootChest tc;
            if (te instanceof BlockLootChest.TileEntityLootChest && !(tc = (BlockLootChest.TileEntityLootChest)te).isAccessibleBy((EntityPlayer)ep)) {
                return;
            }
            IInventory ii = (IInventory)te;
            int s = ii.func_70302_i_() - 1;
            for (int i = 0; i <= s; ++i) {
                ItemStack is = ii.func_70301_a(i);
                if (is != null) {
                    if (ItemInventoryLinker.tryLinkItem((EntityPlayer)ep, is)) {
                        AbilityCalls.emptySlot((EntityPlayer)ep, x, y, z, b, ii, i, s);
                    } else {
                        if (!ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)ep.field_71071_by)) break;
                        AbilityCalls.emptySlot((EntityPlayer)ep, x, y, z, b, ii, i, s);
                    }
                }
                if (i != s || ii.func_70301_a(s) != null) continue;
                AbilityCalls.breakChest((EntityPlayer)ep, x, y, z, b);
            }
        }
    }

    private static void emptySlot(EntityPlayer ep, int x, int y, int z, Block b, IInventory ii, int slot, int size) {
        ii.func_70299_a(slot, null);
        if (slot == size) {
            AbilityCalls.breakChest(ep, x, y, z, b);
        }
    }

    private static void breakChest(EntityPlayer ep, int x, int y, int z, Block b) {
        int meta = ep.field_70170_p.func_72805_g(x, y, z);
        ItemStack is = ReikaBlockHelper.getSilkTouch((World)ep.field_70170_p, (int)x, (int)y, (int)z, (Block)b, (int)meta, (EntityPlayer)ep, (boolean)false);
        if (is != null && !ItemInventoryLinker.tryLinkItem(ep, is) && !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)ep.field_71071_by)) {
            return;
        }
        ep.field_70170_p.func_147449_b(x, y, z, Blocks.field_150350_a);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)ep.field_70170_p, (int)x, (int)y, (int)z, (int)24, (int[])new int[]{Block.func_149682_b((Block)b), meta});
        ReikaSoundHelper.playBreakSound((World)ep.field_70170_p, (int)x, (int)y, (int)z, (Block)b);
    }

    public static boolean doMobBait(EntityPlayer ep) {
        AxisAlignedBB box;
        Entity at;
        if (!ep.field_70122_E) {
            return false;
        }
        if ((ep.field_70170_p.field_73011_w.field_76574_g != -1 || ep.field_70163_u < 127.5) && (at = ep.field_70170_p.func_72857_a(EntityMonsterBait.class, box = ReikaAABBHelper.getEntityCenteredAABB((Entity)ep, (double)6.0), (Entity)ep)) != null) {
            return false;
        }
        if (!ep.field_70170_p.field_72995_K) {
            EntityMonsterBait e = new EntityMonsterBait(ep.field_70170_p, ep);
            ep.field_70170_p.func_72838_d((Entity)e);
        }
        return true;
    }
}

