/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Ability;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.GUI.GuiAbilitySelect;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

@SideOnly(value=Side.CLIENT)
public class AbilityHotkeys {
    private static final String NBT_TAG = "AbilityHotkey";
    public static int SLOTS = 4;
    public static final KeyBinding[] keys = new KeyBinding[4];
    private static final boolean[] lastPress = new boolean[4];

    public static void tick(EntityPlayer ep, AbilityAPI.Ability sel, int data) {
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            boolean flag = keys[i].func_151470_d();
            if (flag && !lastPress[i]) {
                if (sel != null) {
                    AbilityHotkeys.cacheAbility(ep, sel, data, i);
                } else {
                    AbilityHotkeys.fireHotkeyForPlayer(ep, i);
                }
            }
            AbilityHotkeys.lastPress[i] = flag;
        }
    }

    public static void fireHotkeyForPlayer(EntityPlayer ep, int idx) {
        CachedAbilitySelection[] arr = AbilityHotkeys.getHotkeysForPlayer(ep);
        if (arr != null && arr[idx] != null) {
            GuiAbilitySelect.selectAbility(ep, arr[idx].ability, arr[idx].data);
        }
    }

    public static CachedAbilitySelection getCachedHotkey(EntityPlayer ep, int idx) {
        CachedAbilitySelection[] arr = AbilityHotkeys.getHotkeysForPlayer(ep);
        return arr != null && arr[idx] != null ? arr[idx] : null;
    }

    private static CachedAbilitySelection[] getHotkeysForPlayer(EntityPlayer ep) {
        NBTTagCompound tag = AbilityHotkeys.getNBT(ep);
        if (tag == null || tag.func_82582_d()) {
            return null;
        }
        CachedAbilitySelection[] ret = new CachedAbilitySelection[SLOTS];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = CachedAbilitySelection.readFromNBT(tag.func_74775_l("slot" + i));
        }
        return ret;
    }

    public static void cacheAbility(EntityPlayer ep, AbilityAPI.Ability a, int data, int slot) {
        NBTTagCompound li = AbilityHotkeys.getNBT(ep);
        CachedAbilitySelection cab = new CachedAbilitySelection(a, data);
        NBTTagCompound tag = cab.writeToNBT();
        li.func_74782_a("slot" + slot, (NBTBase)tag);
        ReikaPlayerAPI.sendCustomDataFromClient((EntityPlayer)ep);
        ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Saved ability " + a.getDisplayName() + " to ability hotkey slot " + slot + " with power level " + data));
    }

    private static NBTTagCompound getNBT(EntityPlayer ep) {
        NBTTagCompound tag = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound nbt = tag.func_74775_l(NBT_TAG);
        tag.func_74782_a(NBT_TAG, (NBTBase)nbt);
        return nbt;
    }

    public static class CachedAbilitySelection {
        public final AbilityAPI.Ability ability;
        public final int data;

        private CachedAbilitySelection(AbilityAPI.Ability a, int dat) {
            if (a == null) {
                throw new IllegalArgumentException("Null ability!");
            }
            this.ability = a;
            this.data = dat;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("ability", this.ability.getID());
            tag.func_74768_a("data", this.data);
            return tag;
        }

        public static CachedAbilitySelection readFromNBT(NBTTagCompound tag) {
            AbilityAPI.Ability a = Chromabilities.getAbility(tag.func_74779_i("ability"));
            return a != null ? new CachedAbilitySelection(a, tag.func_74762_e("data")) : null;
        }
    }
}

