/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Ability;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Magic.ElementBufferCapacityBoost;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

class LossCache {
    private static final Random rand = new Random();
    private final Collection<AbilityAPI.Ability> savedAbilities = new ArrayList<AbilityAPI.Ability>();
    private final Collection<ElementBufferCapacityBoost> savedBoosts = new ArrayList<ElementBufferCapacityBoost>();
    private final ElementTagCompound savedEnergy = new ElementTagCompound();
    private int cap;
    private static final double INIT_CHANCE = 10.0;
    private static final double INC_CHANCE = 5.0;
    private static final double MAX_CHANCE = 80.0;
    private static final int DEATH_COOLDOWN = 6000;
    static final String NBT_TAG = "bufferDeathChance";

    LossCache(EntityPlayer ep) {
        NBTTagCompound nbt = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound tag = nbt.func_74775_l(NBT_TAG);
        double chance = tag.func_74769_h("chance");
        long time = ep.field_70170_p.func_82737_E();
        if (!nbt.func_74764_b(NBT_TAG) || !tag.func_74764_b("chance")) {
            chance = 10.0;
        } else {
            long prev = tag.func_74763_f("time");
            if (time > prev + 6000L && (chance += 5.0) > 80.0) {
                chance = 80.0;
            }
        }
        tag.func_74780_a("chance", chance);
        tag.func_74772_a("time", time);
        nbt.func_74782_a(NBT_TAG, (NBTBase)tag);
        for (AbilityAPI.Ability a : Chromabilities.getAvailableFrom(ep)) {
            if (a != Chromabilities.DEATHPROOF && !ReikaRandomHelper.doWithChance((double)chance)) continue;
            this.savedAbilities.add(a);
        }
        for (ElementBufferCapacityBoost b : ElementBufferCapacityBoost.list) {
            if (!b.playerHas(ep)) continue;
            this.savedBoosts.add(b);
        }
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            int max = PlayerElementBuffer.instance.getPlayerContent(ep, e);
            if (max <= 0) continue;
            double ratio = 1.0 / (double)(2 + rand.nextInt(3));
            double nrat = 1.0 - ratio;
            int random = (int)((double)max * nrat);
            int save = (int)((double)max * ratio) + rand.nextInt(random);
            save = (int)((double)save * (chance / 100.0));
            this.savedEnergy.addTag(e, save);
        }
        this.cap = 24;
        int max = this.savedEnergy.getMaximumValue();
        while (this.cap < max) {
            this.cap *= 2;
        }
    }

    void applyToPlayer(EntityPlayer player) {
        PlayerElementBuffer.instance.setElementCap(player, this.cap, false);
        for (CrystalElement e : this.savedEnergy.elementSet()) {
            PlayerElementBuffer.instance.addToPlayer(player, e, this.savedEnergy.getValue(e), false);
        }
        for (AbilityAPI.Ability a : this.savedAbilities) {
            Chromabilities.give(player, a);
        }
        for (ElementBufferCapacityBoost b : this.savedBoosts) {
            b.give(player);
        }
    }
}

