/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Ability;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class WarpPoint
implements Comparable<WarpPoint> {
    public final String label;
    public final WorldLocation location;

    WarpPoint(String s, EntityPlayer ep) {
        this(s, new WorldLocation((Entity)ep));
    }

    private WarpPoint(String s, World world, int x, int y, int z) {
        this(s, new WorldLocation(world, x, y, z));
    }

    WarpPoint(String s, WorldLocation loc) {
        this.label = s;
        this.location = loc;
    }

    public boolean equals(Object o) {
        return o instanceof WarpPoint && ((WarpPoint)o).location.equals((Object)this.location);
    }

    public int hashCode() {
        return ~this.location.hashCode();
    }

    public String toString() {
        return this.label + " (" + this.location.toString() + ")";
    }

    void teleportPlayerTo(EntityPlayerMP ep) {
        ChromatiCraft.logger.log((Object)("Warping player " + ep.func_70005_c_() + " to warppoint " + this));
        if (ep.field_70170_p.field_73011_w.field_76574_g != this.location.dimensionID) {
            DimensionManager.getWorld((int)this.location.dimensionID).func_147439_a(this.location.xCoord, this.location.yCoord, this.location.zCoord);
            ReikaEntityHelper.transferEntityToDimension((Entity)ep, (int)this.location.dimensionID);
        }
        ep.field_71135_a.func_147364_a((double)this.location.xCoord + 0.5, (double)this.location.yCoord + 0.5, (double)this.location.zCoord + 0.5, ep.field_70177_z, ep.field_70125_A);
        ep.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        ChromatiCraft.logger.log((Object)("Player position: " + new DecimalPosition((Entity)ep)));
    }

    public boolean canTeleportPlayer(EntityPlayer ep) {
        int dim = ep.field_70170_p.field_73011_w.field_76574_g;
        if (this.location.dimensionID == ExtraChromaIDs.DIMID.getValue() || dim == ExtraChromaIDs.DIMID.getValue()) {
            return dim == this.location.dimensionID;
        }
        return true;
    }

    @Override
    public int compareTo(WarpPoint o) {
        if (this.label.startsWith("[") && o.label.startsWith("[") && this.label.length() > 1 && o.label.length() > 1) {
            String s1 = this.label.substring(1);
            String s2 = o.label.substring(1);
            if (Character.isDigit(s1.charAt(0)) && Character.isDigit(s2.charAt(0))) {
                s1 = s1.substring(0, s1.indexOf(93));
                s2 = s2.substring(0, s2.indexOf(93));
                if (ReikaJavaLibrary.isValidInteger((String)s1) && ReikaJavaLibrary.isValidInteger((String)s2)) {
                    return Integer.compare(Integer.parseInt(s1), Integer.parseInt(s2));
                }
            }
        }
        return this.label.compareToIgnoreCase(o.label);
    }
}

