/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Ability;

import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Auxiliary.Ability.WarpPoint;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class WarpPointData {
    public static final String TAG = "CHROMAWARPPOINT";

    public static void readFromNBT(EntityPlayer ep) {
        AbilityHelper.instance.teleports.clear();
        NBTTagCompound NBT = ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        NBTTagCompound nbt = NBT.func_74775_l(TAG);
        NBTTagList points = nbt.func_150295_c("points", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        HashMap<String, WarpPoint> map = new HashMap<String, WarpPoint>();
        for (Object o2 : points.field_74747_a) {
            NBTTagCompound pt = (NBTTagCompound)o2;
            String label = pt.func_74779_i("label");
            WorldLocation pos = WorldLocation.readFromNBT((String)"pos", (NBTTagCompound)pt);
            if (pos == null) continue;
            map.put(label, new WarpPoint(label, pos));
        }
        AbilityHelper.instance.teleports.put(ep, map);
    }

    public static void writeToNBT(EntityPlayer ep) {
        NBTTagCompound data = new NBTTagCompound();
        HashMap map = (HashMap)AbilityHelper.instance.teleports.get(ep);
        NBTTagList points = new NBTTagList();
        for (String label : map.keySet()) {
            WarpPoint wp = (WarpPoint)map.get(label);
            NBTTagCompound pt = new NBTTagCompound();
            pt.func_74778_a("label", label);
            wp.location.writeToNBT("pos", pt);
            points.func_74742_a((NBTBase)pt);
        }
        data.func_74782_a("points", (NBTBase)points);
        ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep).func_74782_a(TAG, (NBTBase)data);
    }

    @SideOnly(value=Side.CLIENT)
    public static Collection<WarpPoint> loadMiniMaps() {
        HashSet<WarpPoint> c = new HashSet<WarpPoint>();
        c.addAll(WarpPointData.readVoxelMap());
        c.addAll(WarpPointData.readJourneyMap());
        c.addAll(WarpPointData.readMapWriter());
        return c;
    }

    @SideOnly(value=Side.CLIENT)
    private static Collection<WarpPoint> readMapWriter() {
        HashSet<WarpPoint> map = new HashSet<WarpPoint>();
        File f = new File(DragonAPICore.getMinecraftDirectory(), "saves/mapwriter_mp_worlds");
        if (f.exists() && f.isDirectory()) {
            for (File in : ReikaFileReader.getAllFilesInFolder((File)f, (String[])new String[]{".cfg"})) {
                WarpPointData.readMapWriterFile(in, map);
            }
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    private static Collection<WarpPoint> readJourneyMap() {
        HashSet<WarpPoint> map = new HashSet<WarpPoint>();
        File f = new File(DragonAPICore.getMinecraftDirectory(), "journeymap/data/mp");
        if (f.exists() && f.isDirectory()) {
            for (File in : ReikaFileReader.getAllFilesInFolder((File)f, (String[])new String[]{".json"})) {
                WarpPointData.readJourneyMapFile(in, map);
            }
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    private static Collection<WarpPoint> readVoxelMap() {
        HashSet<WarpPoint> map = new HashSet<WarpPoint>();
        File f = new File(DragonAPICore.getMinecraftDirectory(), "mods/VoxelMods/voxelMap");
        if (f.exists() && f.isDirectory()) {
            for (File in : ReikaFileReader.getAllFilesInFolder((File)f, (String[])new String[]{".points"})) {
                WarpPointData.readVoxelMapFile(in, map);
            }
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    private static void readMapWriterFile(File f, HashSet<WarpPoint> map) {
        int idx = 0;
        for (String s : ReikaFileReader.getFileAsLines((File)f, (boolean)true)) {
            if (!s.startsWith("S:marker")) continue;
            s = s.substring(s.indexOf(61) + 1);
            String[] parts = s.split(":");
            String label = parts[0];
            String x = parts[1];
            String y = parts[2];
            String z = parts[3];
            String dim = parts[4];
            try {
                WarpPoint p = new WarpPoint("[" + idx + "] " + label, new WorldLocation(Integer.parseInt(dim), Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(z)));
                map.add(p);
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)("Could not parse waypoint entry: " + s));
                e.printStackTrace();
            }
            ++idx;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void readJourneyMapFile(File f, HashSet<WarpPoint> map) {
        JsonObject j;
        JsonElement e = ReikaFileReader.readJSON((File)f);
        if (e instanceof JsonObject && (j = (JsonObject)e).getAsJsonPrimitive("enable").getAsBoolean()) {
            JsonArray dims = j.getAsJsonArray("dimensions");
            int x = j.getAsJsonPrimitive("x").getAsInt();
            int y = j.getAsJsonPrimitive("y").getAsInt();
            int z = j.getAsJsonPrimitive("z").getAsInt();
            String id = j.getAsJsonPrimitive("name").getAsString();
            try {
                WarpPoint p = new WarpPoint(id, new WorldLocation(dims.get(0).getAsInt(), x, y, z));
                map.add(p);
            }
            catch (Exception ex) {
                ChromatiCraft.logger.logError((Object)("Could not parse waypoint entry: " + e.toString()));
                ex.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void readVoxelMapFile(File f, HashSet<WarpPoint> map) {
        int idx = 0;
        for (String s : ReikaFileReader.getFileAsLines((File)f, (boolean)true)) {
            if (!s.startsWith("name")) continue;
            String[] parts = s.split(",");
            HashMap<String, String> dat = new HashMap<String, String>();
            for (int i = 0; i < parts.length; ++i) {
                String[] data = parts[i].split(":");
                if (data.length != 2) continue;
                String name = data[0];
                String val = data[1];
                if (name.equals("dimensions")) {
                    val = val.substring(0, val.length() - 1);
                }
                dat.put(name, val);
            }
            String label = (String)dat.get("name");
            label = label.replaceAll("~comma~", ",");
            label = label.replaceAll("~colon~", ":");
            try {
                WarpPoint p = new WarpPoint("[" + idx + "] " + label, new WorldLocation(Integer.parseInt((String)dat.get("dimensions")), Integer.parseInt((String)dat.get("x")), Integer.parseInt((String)dat.get("y")), Integer.parseInt((String)dat.get("z"))));
                map.add(p);
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)("Could not parse waypoint entry: " + s));
                e.printStackTrace();
            }
            ++idx;
        }
    }
}

