/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.Dimension.Structure.LightPanel.BlockLightSwitch;
import Reika.ChromatiCraft.Block.Dimension.Structure.Locks.BlockColoredLock;
import Reika.ChromatiCraft.Block.Dimension.Structure.Locks.BlockLockKey;
import Reika.ChromatiCraft.Block.Dimension.Structure.ShiftMaze.BlockShiftLock;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.ChromatiCraft.World.Dimension.Structure.MusicPuzzleGenerator;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class BiomeStructurePuzzle
implements TileEntityStructControl.FragmentStructureData {
    private static final ArrayList<Coordinate> runeLocations = new ArrayList();
    private final ArrayList<ReikaMusicHelper.MusicKey> melody = new ArrayList();
    private final SwitchGroup[] doorKeys = new SwitchGroup[4];
    private final ArrayList<CrystalElement> crystalColors = new ArrayList();
    private final ArrayList<CrystalElement> doorColors = new ArrayList();
    private int keyIndex;
    private final HashSet<SwitchGroup> usedKeys = new HashSet();
    private final HashMap<Coordinate, CrystalElement> runes = new HashMap();
    private long musicTick;
    private long nextNoteTick = 10L;
    private int melodyIndex;
    private boolean complete;
    private final ArrayList<ReikaMusicHelper.MusicKey> remainingGuess = new ArrayList();

    public void clear() {
        this.melody.clear();
        this.crystalColors.clear();
        this.doorColors.clear();
        this.runes.clear();
        this.usedKeys.clear();
        this.remainingGuess.clear();
    }

    public void generate(Random rand) {
        this.keyIndex = rand.nextInt(8);
        for (int i = 0; i < this.doorKeys.length; ++i) {
            ForgeDirection ns = i <= 1 ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
            ForgeDirection ew = i % 2 == 0 ? ForgeDirection.WEST : ForgeDirection.EAST;
            SwitchGroup key = SwitchGroup.random(ns, ew, rand);
            while (this.usedKeys.contains(key) || key.isSameCorner()) {
                key = SwitchGroup.random(ns, ew, rand);
            }
            this.doorKeys[i] = key;
            this.usedKeys.add(key);
        }
        ArrayList li = ReikaJavaLibrary.makeListFromArray((Object[])CrystalElement.elements);
        for (int i = 0; i < 8; ++i) {
            this.doorColors.add((CrystalElement)li.remove(rand.nextInt(li.size())));
        }
        ArrayList idx = ReikaJavaLibrary.makeIntListFromArray((int[])ReikaArrayHelper.getLinearArray((int)8));
        Collections.shuffle(idx);
        for (Coordinate c : runeLocations) {
            this.runes.put(c, this.doorColors.get((Integer)idx.remove(0)));
        }
        HashSet<MusicPuzzleGenerator.MelodyPrefab> excl = new HashSet<MusicPuzzleGenerator.MelodyPrefab>();
        while (this.melody.isEmpty()) {
            int attempts;
            MusicPuzzleGenerator.MelodyPrefab pre = MusicPuzzleGenerator.getRandomPrefab(rand, Integer.MAX_VALUE, excl);
            this.melody.addAll(pre.getNotes());
            for (attempts = 0; attempts < 10 && !this.calculateCrystals(rand); ++attempts) {
                this.crystalColors.clear();
            }
            if (attempts < 10) continue;
            this.crystalColors.clear();
            this.melody.clear();
            excl.add(pre);
            ChromatiCraft.logger.log((Object)("Failed to perform " + pre + " with only eight colors"));
        }
        this.remainingGuess.addAll(this.melody);
    }

    private boolean calculateCrystals(Random rand) {
        CrystalElement e;
        HashSet<ReikaMusicHelper.MusicKey> needed = new HashSet<ReikaMusicHelper.MusicKey>(this.melody);
        while (!needed.isEmpty()) {
            e = this.findMostEffective(needed);
            if (e == null) {
                return false;
            }
            this.crystalColors.add(e);
            needed.removeAll(CrystalMusicManager.instance.getKeys(e));
        }
        if (this.crystalColors.size() > 8) {
            return false;
        }
        while (this.crystalColors.size() < 8) {
            e = CrystalElement.elements[rand.nextInt(16)];
            while (this.crystalColors.contains(e)) {
                e = CrystalElement.elements[rand.nextInt(16)];
            }
            this.crystalColors.add(e);
        }
        return true;
    }

    public void addToArray(FilledBlockArray array, int x0, int y0, int z0) {
        int i;
        Coordinate root = new Coordinate(x0, y0, z0);
        for (Map.Entry<Coordinate, CrystalElement> entry : this.runes.entrySet()) {
            Coordinate coordinate = entry.getKey().offset(x0, y0, z0);
            array.setBlock(coordinate.xCoord, coordinate.yCoord, coordinate.zCoord, ChromaBlocks.RUNE.getBlockInstance(), entry.getValue().ordinal());
        }
        for (i = 0; i < 4; ++i) {
            for (Coordinate coordinate : this.getColorDoorLocations(root, i)) {
                array.setBlock(coordinate.xCoord, coordinate.yCoord, coordinate.zCoord, ChromaBlocks.COLORLOCK.getBlockInstance());
            }
        }
        for (i = 0; i < 4; ++i) {
            for (Map.Entry<Coordinate, ForgeDirection> entry : this.getSwitchDoorLocations(root, i).entrySet()) {
                Coordinate c = entry.getKey();
                array.setBlock(c.xCoord, c.yCoord, c.zCoord, ChromaBlocks.SHIFTLOCK.getBlockInstance(), BlockShiftLock.Passability.CLOSED.ordinal());
            }
        }
        for (Coordinate coordinate : this.getSwitchLocations(root)) {
            array.setBlock(coordinate.xCoord, coordinate.yCoord, coordinate.zCoord, ChromaBlocks.PANELSWITCH.getBlockInstance());
            Coordinate coordinate2 = coordinate.offset(0, 1, 0);
            Coordinate green = coordinate.offset(0, -1, 0);
            array.setBlock(coordinate2.xCoord, coordinate2.yCoord, coordinate2.zCoord, ChromaBlocks.LIGHTPANEL.getBlockInstance(), 3);
            array.setBlock(green.xCoord, green.yCoord, green.zCoord, ChromaBlocks.LIGHTPANEL.getBlockInstance(), 0);
        }
        for (int i2 = 2; i2 < 4; ++i2) {
            ForgeDirection forgeDirection = ForgeDirection.VALID_DIRECTIONS[i2];
            int n = x0 + forgeDirection.offsetX * 2;
            int dy = y0 + 5;
            int dz = z0 + forgeDirection.offsetZ * 2;
            array.setBlock(n, dy, dz, ChromaBlocks.LOCKKEY.getBlockInstance(), this.keyIndex);
        }
        for (Coordinate coordinate : this.getBarrierLocations(root)) {
            array.setBlock(coordinate.xCoord, coordinate.yCoord, coordinate.zCoord, ChromaBlocks.DOOR.getBlockInstance());
        }
        for (int i3 = 0; i3 < 4; ++i3) {
            for (Map.Entry<Coordinate, CrystalElement> entry : this.getCrystalLocations(root).entrySet()) {
                Coordinate c = entry.getKey();
                array.setBlock(c.xCoord, c.yCoord, c.zCoord, ChromaBlocks.LAMP.getBlockInstance(), entry.getValue().ordinal());
            }
        }
        for (Coordinate coordinate : this.getLiquidLocations(root)) {
            array.setBlock(coordinate.xCoord, coordinate.yCoord, coordinate.zCoord, Blocks.field_150355_j);
        }
    }

    public void placeData(World world, TileEntityStructControl root) {
        int i;
        Coordinate ref = new Coordinate((TileEntity)root);
        for (Map.Entry<Coordinate, CrystalElement> entry : this.runes.entrySet()) {
            Coordinate c = entry.getKey().offset(root.field_145851_c, root.field_145848_d, root.field_145849_e);
            c.setBlock(world, ChromaBlocks.RUNE.getBlockInstance(), entry.getValue().ordinal());
        }
        for (i = 0; i < 4; ++i) {
            for (Coordinate c : this.getColorDoorLocations(ref, i)) {
                c.setBlock(world, ChromaBlocks.COLORLOCK.getBlockInstance());
                BlockColoredLock.TileEntityColorLock te = (BlockColoredLock.TileEntityColorLock)c.getTileEntity((IBlockAccess)world);
                if (te == null) {
                    te = new BlockColoredLock.TileEntityColorLock();
                    world.func_147455_a(c.xCoord, c.yCoord, c.zCoord, (TileEntity)te);
                }
                te.setColors(this.doorColors.get(i * 2), this.doorColors.get(i * 2 + 1));
            }
        }
        for (i = 0; i < 4; ++i) {
            for (Map.Entry<Coordinate, ForgeDirection> e : this.getSwitchDoorLocations(ref, i).entrySet()) {
                SwitchGroup gr = this.doorKeys[i];
                BlockShiftLock.Passability p = BlockShiftLock.Passability.getDirectionalPassability(e.getValue(), false);
                p = BlockShiftLock.Passability.CLOSED;
                e.getKey().setBlock(world, ChromaBlocks.SHIFTLOCK.getBlockInstance(), p.ordinal());
            }
        }
        for (Coordinate coordinate : this.getSwitchLocations(ref)) {
            coordinate.setBlock(world, ChromaBlocks.PANELSWITCH.getBlockInstance());
            BlockLightSwitch.LightSwitchTile te = (BlockLightSwitch.LightSwitchTile)coordinate.getTileEntity((IBlockAccess)world);
            te.setDelegate(ref);
            Coordinate red = coordinate.offset(0, 1, 0);
            Coordinate green = coordinate.offset(0, -1, 0);
            red.setBlock(world, ChromaBlocks.LIGHTPANEL.getBlockInstance(), 3);
            green.setBlock(world, ChromaBlocks.LIGHTPANEL.getBlockInstance(), 0);
        }
        for (int i2 = 2; i2 < 4; ++i2) {
            ForgeDirection forgeDirection = ForgeDirection.VALID_DIRECTIONS[i2];
            int dx = root.field_145851_c + forgeDirection.offsetX * 2;
            int dy = root.field_145848_d + 5;
            int dz = root.field_145849_e + forgeDirection.offsetZ * 2;
            world.func_147465_d(dx, dy, dz, ChromaBlocks.LOCKKEY.getBlockInstance(), this.keyIndex, 3);
            BlockLockKey.TileEntityLockKey te = (BlockLockKey.TileEntityLockKey)world.func_147438_o(dx, dy, dz);
            te.setDelegate(ref);
        }
        for (Coordinate coordinate : this.getBarrierLocations(ref)) {
            coordinate.setBlock(world, ChromaBlocks.DOOR.getBlockInstance());
        }
        for (int i3 = 0; i3 < 4; ++i3) {
            for (Map.Entry<Coordinate, CrystalElement> e : this.getCrystalLocations(ref).entrySet()) {
                e.getKey().setBlock(world, ChromaBlocks.LAMP.getBlockInstance(), e.getValue().ordinal());
            }
        }
        Block b = this.getLiquid(world, ref);
        for (Coordinate c : this.getLiquidLocations(ref)) {
            c.setBlock(world, b);
        }
    }

    private Block getLiquid(World world, Coordinate root) {
        BiomeGenBase b = ReikaWorldHelper.getNaturalGennedBiomeAt((World)world, (int)root.xCoord, (int)root.zCoord);
        if (ChromatiCraft.isRainbowForest(b)) {
            return ChromaBlocks.CHROMA.getBlockInstance();
        }
        if (ChromatiCraft.isEnderForest(b)) {
            return FluidRegistry.getFluid((String)"ender").getBlock();
        }
        if (BiomeGlowingCliffs.isGlowingCliffs(b)) {
            return ChromaBlocks.LUMA.getBlockInstance();
        }
        return Blocks.field_150353_l;
    }

    private CrystalElement findMostEffective(HashSet<ReikaMusicHelper.MusicKey> needed) {
        CrystalElement best = null;
        int bestAmt = 0;
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if (this.crystalColors.contains(e)) continue;
            ArrayList<ReikaMusicHelper.MusicKey> li = new ArrayList<ReikaMusicHelper.MusicKey>(CrystalMusicManager.instance.getKeys(e));
            li.retainAll(needed);
            if (li.size() <= bestAmt) continue;
            best = e;
            bestAmt = li.size();
        }
        return best;
    }

    @Override
    public void writeToNBT(NBTTagCompound NBT) {
        NBTTagList li = new NBTTagList();
        for (ReikaMusicHelper.MusicKey musicKey : this.melody) {
            li.func_74742_a((NBTBase)new NBTTagInt(musicKey.ordinal()));
        }
        NBT.func_74782_a("melody", (NBTBase)li);
        li = new NBTTagList();
        for (CrystalElement crystalElement : this.crystalColors) {
            li.func_74742_a((NBTBase)new NBTTagInt(crystalElement.ordinal()));
        }
        NBT.func_74782_a("crystals", (NBTBase)li);
        li = new NBTTagList();
        for (CrystalElement crystalElement : this.doorColors) {
            li.func_74742_a((NBTBase)new NBTTagInt(crystalElement.ordinal()));
        }
        NBT.func_74782_a("doorColors", (NBTBase)li);
        li = new NBTTagList();
        for (Map.Entry entry : this.runes.entrySet()) {
            NBTTagCompound tag = ((Coordinate)entry.getKey()).writeToTag();
            tag.func_74768_a("color", ((CrystalElement)entry.getValue()).ordinal());
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("runes", (NBTBase)li);
        for (int i = 0; i < this.doorKeys.length; ++i) {
            NBT.func_74782_a("door" + i, (NBTBase)this.doorKeys[i].writeToTag());
        }
        NBT.func_74768_a("key", this.keyIndex);
        NBT.func_74757_a("complete", this.complete);
    }

    @Override
    public void readFromNBT(NBTTagCompound NBT) {
        NBTTagInt i;
        this.clear();
        NBTTagList li = NBT.func_150295_c("melody", ReikaNBTHelper.NBTTypes.INT.ID);
        for (Object o : li.field_74747_a) {
            i = (NBTTagInt)o;
            this.melody.add(ReikaMusicHelper.MusicKey.getByIndex((int)i.func_150287_d()));
        }
        li = NBT.func_150295_c("crystals", ReikaNBTHelper.NBTTypes.INT.ID);
        for (Object o : li.field_74747_a) {
            i = (NBTTagInt)o;
            this.crystalColors.add(CrystalElement.elements[i.func_150287_d()]);
        }
        li = NBT.func_150295_c("doorColors", ReikaNBTHelper.NBTTypes.INT.ID);
        for (Object o : li.field_74747_a) {
            i = (NBTTagInt)o;
            this.doorColors.add(CrystalElement.elements[i.func_150287_d()]);
        }
        li = NBT.func_150295_c("runes", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            Coordinate c = Coordinate.readTag((NBTTagCompound)tag);
            CrystalElement e = CrystalElement.elements[tag.func_74762_e("color")];
            this.runes.put(c, e);
        }
        for (int i2 = 0; i2 < this.doorKeys.length; ++i2) {
            this.doorKeys[i2] = SwitchGroup.readTag(NBT.func_74775_l("door" + i2));
        }
        this.keyIndex = NBT.func_74762_e("key");
        this.complete = NBT.func_74767_n("complete");
        this.remainingGuess.addAll(this.melody);
    }

    @Override
    public void handleTileAdd(World world, int x, int y, int z, TileEntityStructControl.InteractionDelegateTile te, TileEntityStructControl root) {
        if (te instanceof BlockLockKey.TileEntityLockKey) {
            this.updateColorDoors(world, new Coordinate((TileEntity)root));
        }
    }

    @Override
    public void handleTileRemove(World world, int x, int y, int z, TileEntityStructControl.InteractionDelegateTile te, TileEntityStructControl root) {
        if (te instanceof BlockLockKey.TileEntityLockKey) {
            this.updateColorDoors(world, new Coordinate((TileEntity)root));
        }
    }

    @Override
    public void handleTileInteract(World world, int x, int y, int z, TileEntityStructControl.InteractionDelegateTile te, TileEntityStructControl root, EntityPlayer ep) {
        if (te instanceof BlockLightSwitch.LightSwitchTile) {
            if (!ProgressionManager.instance.playerHasPrerequisites(ep, ProgressStage.BIOMESTRUCT)) {
                world.func_72921_c(x, y, z, 0, 2);
                ChromaSounds.ERROR.playSoundAtBlock(world, x, y, z);
                return;
            }
            this.updateSwitchDoors(world, new Coordinate((TileEntity)root));
        }
    }

    @Override
    public boolean isInaccessible(World world, int x, int y, int z, TileEntityStructControl.InteractionDelegateTile te, TileEntityStructControl root, EntityPlayer ep) {
        return !ProgressionManager.instance.playerHasPrerequisites(ep, ProgressStage.BIOMESTRUCT);
    }

    @Override
    public void handleMusicTrigger(World world, int x, int y, int z, CrystalElement e, ReikaMusicHelper.MusicKey mk, TileEntityStructControl root, EntityPlayer ep) {
        if (this.complete) {
            return;
        }
        if (mk == this.remainingGuess.get(0)) {
            this.remainingGuess.remove(0);
            if (this.remainingGuess.isEmpty()) {
                this.complete(world, root, ep);
            }
        } else {
            this.remainingGuess.clear();
            this.remainingGuess.addAll(this.melody);
            ChromaSounds.ERROR.playSoundAtBlock((TileEntity)root);
        }
    }

    @Override
    public void onTileLoaded(TileEntityStructControl root) {
        if (!root.field_145850_b.field_72995_K) {
            this.updateColorDoors(root.field_145850_b, new Coordinate((TileEntity)root));
        }
    }

    private void complete(World world, TileEntityStructControl root, EntityPlayer ep) {
        this.complete = true;
        ChromaSounds.CAST.playSoundAtBlock((TileEntity)root);
        Coordinate ref = new Coordinate((TileEntity)root);
        for (Coordinate c : this.getBarrierLocations(ref)) {
            BlockChromaDoor.setOpen(world, c.xCoord, c.yCoord, c.zCoord, true);
        }
        for (Coordinate c : this.getLowerChestLocations(ref)) {
            if (c.getBlock((IBlockAccess)world) != ChromaBlocks.LOOTCHEST.getBlockInstance()) continue;
            c.setBlockMetadata(world, c.getBlockMetadata((IBlockAccess)world) % 8);
        }
    }

    private void updateColorDoors(World world, Coordinate root) {
        HashSet<CrystalElement> opened = new HashSet<CrystalElement>();
        if (this.runes.isEmpty()) {
            this.reconstructRunes(world, root);
        }
        for (Map.Entry<Coordinate, CrystalElement> e : this.runes.entrySet()) {
            Coordinate c = e.getKey().offset(root.xCoord, root.yCoord + 1, root.zCoord);
            if (c.getBlock((IBlockAccess)world) != ChromaBlocks.LOCKKEY.getBlockInstance()) continue;
            opened.add(e.getValue());
        }
        for (int i = 0; i < 4; ++i) {
            for (Coordinate c : this.getColorDoorLocations(root, i)) {
                BlockColoredLock.TileEntityColorLock te = (BlockColoredLock.TileEntityColorLock)c.getTileEntity((IBlockAccess)world);
                if (te == null) continue;
                te.setOpenColors(opened);
            }
        }
    }

    private void reconstructRunes(World world, Coordinate root) {
        for (Coordinate c : runeLocations) {
            this.runes.put(c, CrystalElement.elements[c.offset(root).getBlockMetadata((IBlockAccess)world)]);
        }
    }

    private void updateSwitchDoors(World world, Coordinate root) {
        for (int i = 0; i < 4; ++i) {
            boolean flag = this.doorKeys[i].validate(world, this.switchLoc(root, ForgeDirection.NORTH, ForgeDirection.WEST), this.switchLoc(root, ForgeDirection.SOUTH, ForgeDirection.WEST), this.switchLoc(root, ForgeDirection.NORTH, ForgeDirection.EAST), this.switchLoc(root, ForgeDirection.SOUTH, ForgeDirection.EAST));
            Coordinate sw = this.switchLoc(root, this.doorKeys[i].areaNS, this.doorKeys[i].areaEW);
            sw.offset(0, 1, 0).setBlockMetadata(world, flag ? 2 : 3);
            sw.offset(0, -1, 0).setBlockMetadata(world, flag ? 1 : 0);
            for (Coordinate c : this.getSwitchDoorLocations(root, i).keySet()) {
                BlockShiftLock.setOpen(world, c.xCoord, c.yCoord, c.zCoord, flag);
            }
        }
    }

    private Collection<Coordinate> getSwitchLocations(Coordinate root) {
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
        ret.add(this.switchLoc(root, ForgeDirection.NORTH, ForgeDirection.EAST));
        ret.add(this.switchLoc(root, ForgeDirection.NORTH, ForgeDirection.WEST));
        ret.add(this.switchLoc(root, ForgeDirection.SOUTH, ForgeDirection.EAST));
        ret.add(this.switchLoc(root, ForgeDirection.SOUTH, ForgeDirection.WEST));
        return ret;
    }

    private Coordinate switchLoc(Coordinate root, ForgeDirection ns, ForgeDirection ew) {
        return root.offset(ns.offsetZ * 3, 8, ew.offsetX * 3);
    }

    private Collection<Coordinate> getColorDoorLocations(Coordinate root, int i) {
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
        for (int y = 2; y <= 4; ++y) {
            block7: for (int d = 1; d <= 2; ++d) {
                switch (i) {
                    case 0: {
                        ret.add(root.offset(d, y, -3));
                        continue block7;
                    }
                    case 1: {
                        ret.add(root.offset(3, y, d));
                        continue block7;
                    }
                    case 2: {
                        ret.add(root.offset(-d, y, 3));
                        continue block7;
                    }
                    case 3: {
                        ret.add(root.offset(-3, y, -d));
                    }
                }
            }
        }
        return ret;
    }

    private HashMap<Coordinate, ForgeDirection> getSwitchDoorLocations(Coordinate root, int i) {
        HashMap<Coordinate, ForgeDirection> ret = new HashMap<Coordinate, ForgeDirection>();
        for (int y = 6; y <= 8; ++y) {
            block7: for (int d = 5; d <= 6; ++d) {
                switch (i) {
                    case 0: {
                        ret.put(root.offset(-2, y, -d), ForgeDirection.EAST);
                        ret.put(root.offset(-d, y, -2), ForgeDirection.SOUTH);
                        continue block7;
                    }
                    case 1: {
                        ret.put(root.offset(-2, y, d), ForgeDirection.SOUTH);
                        ret.put(root.offset(-d, y, 2), ForgeDirection.WEST);
                        continue block7;
                    }
                    case 2: {
                        ret.put(root.offset(2, y, -d), ForgeDirection.EAST);
                        ret.put(root.offset(d, y, -2), ForgeDirection.NORTH);
                        continue block7;
                    }
                    case 3: {
                        ret.put(root.offset(2, y, d), ForgeDirection.WEST);
                        ret.put(root.offset(d, y, 2), ForgeDirection.NORTH);
                    }
                }
            }
        }
        return ret;
    }

    private HashMap<Coordinate, CrystalElement> getCrystalLocations(Coordinate root) {
        HashMap<Coordinate, CrystalElement> ret = new HashMap<Coordinate, CrystalElement>();
        ret.put(root.offset(-4, 3, 1), this.crystalColors.get(ret.size()));
        ret.put(root.offset(-5, 3, 1), this.crystalColors.get(ret.size()));
        ret.put(root.offset(-1, 3, -4), this.crystalColors.get(ret.size()));
        ret.put(root.offset(-1, 3, -5), this.crystalColors.get(ret.size()));
        ret.put(root.offset(4, 3, -1), this.crystalColors.get(ret.size()));
        ret.put(root.offset(5, 3, -1), this.crystalColors.get(ret.size()));
        ret.put(root.offset(1, 3, 4), this.crystalColors.get(ret.size()));
        ret.put(root.offset(1, 3, 5), this.crystalColors.get(ret.size()));
        return ret;
    }

    private Collection<Coordinate> getLiquidLocations(Coordinate root) {
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
        for (int a = -1; a <= 1; ++a) {
            for (int b = -1; b <= 1; ++b) {
                ret.add(root.offset(a, -1, b));
            }
        }
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
            for (int a = 3; a <= 5; ++a) {
                for (int b = 4; b <= 5; ++b) {
                    if (b == 5 && a == 4) continue;
                    ret.add(root.offset(dir.offsetX * b + left.offsetX * a, 1, left.offsetZ * a + dir.offsetZ * b));
                }
            }
        }
        return ret;
    }

    private Collection<Coordinate> getLowerChestLocations(Coordinate root) {
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
            ret.add(root.offset(dir.offsetX * 5 + left.offsetX * 4, 2, left.offsetZ * 4 + dir.offsetZ * 5));
        }
        return ret;
    }

    private Collection<Coordinate> getBarrierLocations(Coordinate root) {
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                ret.add(root.offset(x, 1, z));
            }
        }
        for (int y = 2; y <= 4; ++y) {
            for (int d = 4; d <= 5; ++d) {
                ret.add(root.offset(d, y, 3));
                ret.add(root.offset(-3, y, d));
                ret.add(root.offset(-d, y, -3));
                ret.add(root.offset(3, y, -d));
            }
        }
        return ret;
    }

    @Override
    public void onTick(TileEntityStructControl te) {
        EntityPlayer ep;
        if (te.getTicksExisted() == 5 || te.getTicksExisted() % 200 == 0) {
            this.updateColorDoors(te.field_145850_b, new Coordinate((TileEntity)te));
        }
        if ((ep = te.field_145850_b.func_72977_a((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5, 20.0)) == null) {
            return;
        }
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)te).func_72314_b(1.0, 0.0, 1.0).func_72317_d(0.0, 6.0, 0.0);
        List li = te.field_145850_b.func_72872_a(EntityPlayer.class, box);
        for (EntityPlayer ep2 : li) {
            if (ProgressionManager.instance.playerHasPrerequisites(ep2, ProgressStage.BIOMESTRUCT)) continue;
            this.pushPlayer(ep2, te);
        }
        if (this.isPlayingMelody(ep)) {
            ++this.musicTick;
            if (this.musicTick >= this.nextNoteTick) {
                this.playNextNote(te);
            }
        }
    }

    private boolean isPlayingMelody(EntityPlayer ep) {
        return ChromaItems.PROBE.matchWith(ep.func_71045_bC());
    }

    private void pushPlayer(EntityPlayer ep, TileEntityStructControl te) {
        ep.field_70181_x = Math.max(0.0, ep.field_70181_x);
        ep.field_70133_I = true;
    }

    private void playNextNote(TileEntityStructControl te) {
        ReikaMusicHelper.MusicKey key = this.melody.get(this.melodyIndex);
        ChromaSounds.DING.playSoundAtBlock((TileEntity)te, 1.0f, (float)CrystalMusicManager.instance.getPitchFactor(key));
        ArrayList<CrystalElement> c = new ArrayList<CrystalElement>(CrystalMusicManager.instance.getColorsWithKey(key));
        for (CrystalElement e : c) {
            double s = 4.5 - 0.5 * (double)(c.size() - 1);
            int[] d1 = ReikaJavaLibrary.splitDoubleToInts((double)s);
            int[] d2 = ReikaJavaLibrary.splitDoubleToInts((double)0.0);
            double dd = s / 6.0;
            double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)te.field_145851_c + 0.5), (double)dd);
            double dy = ReikaRandomHelper.getRandomPlusMinus((double)((double)te.field_145848_d + 3.5), (double)dd);
            double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)te.field_145849_e + 0.5), (double)dd);
            ReikaPacketHelper.sendPositionPacket((String)"ChromaData", (int)ChromaPackets.RUNEPARTICLE.ordinal(), (World)te.field_145850_b, (double)dx, (double)dy, (double)dz, (double)32.0, (int[])new int[]{e.ordinal(), d1[0], d1[1], d2[0], d2[1], 6});
        }
        this.nextNoteTick += 8L;
        ++this.melodyIndex;
        if (this.melodyIndex >= this.melody.size()) {
            this.melodyIndex = 0;
            this.nextNoteTick += 16L;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render() {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        if (!ProgressionManager.instance.playerHasPrerequisites((EntityPlayer)ep, ProgressStage.BIOMESTRUCT)) {
            GL11.glEnable((int)3553);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaRenderHelper.disableEntityLighting();
            GL11.glDepthMask((boolean)false);
            ReikaGLHelper.BlendMode.MULTIPLY.apply();
            Tessellator var5 = Tessellator.field_78398_a;
            var5.func_78382_b();
            var5.func_78380_c(240);
            var5.func_78378_d(0xFFFFFF);
            ReikaTextureHelper.bindTerrainTexture();
            IIcon ico = ChromaIcons.X.getIcon();
            float u1 = ico.func_94209_e();
            float v1 = ico.func_94206_g();
            float du1 = ico.func_94212_f();
            float dv1 = ico.func_94210_h();
            var5.func_78374_a(-1.0, 6.75, -1.0, (double)u1, (double)v1);
            var5.func_78374_a(2.0, 6.75, -1.0, (double)du1, (double)v1);
            var5.func_78374_a(2.0, 6.75, 2.0, (double)du1, (double)dv1);
            var5.func_78374_a(-1.0, 6.75, 2.0, (double)u1, (double)dv1);
            var5.func_78381_a();
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            var5.func_78382_b();
            var5.func_78380_c(240);
            var5.func_78384_a(0xFFFFFF, 64);
            u1 = ico.func_94209_e();
            v1 = ico.func_94206_g();
            du1 = ico.func_94212_f();
            dv1 = ico.func_94210_h();
            var5.func_78374_a(-1.0, 6.75, -1.0, (double)u1, (double)v1);
            var5.func_78374_a(2.0, 6.75, -1.0, (double)du1, (double)v1);
            var5.func_78374_a(2.0, 6.75, 2.0, (double)du1, (double)dv1);
            var5.func_78374_a(-1.0, 6.75, 2.0, (double)u1, (double)dv1);
            var5.func_78381_a();
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            var5.func_78382_b();
            var5.func_78380_c(240);
            var5.func_78378_d(0x300000);
            ico = ChromaIcons.HIVE.getIcon();
            u1 = ico.func_94209_e();
            v1 = ico.func_94206_g();
            du1 = ico.func_94212_f();
            dv1 = ico.func_94210_h();
            var5.func_78374_a(-1.0, 6.0, -1.0, (double)u1, (double)v1);
            var5.func_78374_a(2.0, 6.0, -1.0, (double)du1, (double)v1);
            var5.func_78374_a(2.0, 6.0, 2.0, (double)du1, (double)dv1);
            var5.func_78374_a(-1.0, 6.0, 2.0, (double)u1, (double)dv1);
            var5.func_78374_a(-1.0, 7.0, -1.0, (double)u1, (double)v1);
            var5.func_78374_a(2.0, 7.0, -1.0, (double)du1, (double)v1);
            var5.func_78374_a(2.0, 7.0, 2.0, (double)du1, (double)dv1);
            var5.func_78374_a(-1.0, 7.0, 2.0, (double)u1, (double)dv1);
            var5.func_78378_d(0xFF0000);
            ico = ChromaIcons.RIFT.getIcon();
            u1 = ico.func_94209_e();
            v1 = ico.func_94206_g();
            du1 = ico.func_94212_f();
            dv1 = ico.func_94210_h();
            var5.func_78374_a(-1.0, 6.5, -1.0, (double)u1, (double)v1);
            var5.func_78374_a(2.0, 6.5, -1.0, (double)du1, (double)v1);
            var5.func_78374_a(2.0, 6.5, 2.0, (double)du1, (double)dv1);
            var5.func_78374_a(-1.0, 6.5, 2.0, (double)u1, (double)dv1);
            var5.func_78381_a();
            ReikaTextureHelper.bindEnchantmentTexture();
            double r = 12.0;
            int color = ReikaColorAPI.mixColors((int)0xFF0000, (int)0x700000, (float)((float)(0.5 + 0.5 * Math.sin((double)System.currentTimeMillis() / 100.0))));
            var5.func_78382_b();
            var5.func_78380_c(240);
            var5.func_78378_d(color);
            double dx = 0.5;
            double dy = 5.5;
            double dz = 0.5;
            double dk = 0.5 * r / 16.0;
            double di = 10.0;
            for (double k = -r; k <= r - dk; k += dk) {
                double r3;
                double dr = r * (1.0 - 0.75 * Math.pow(k / r, 2.0));
                double dr2 = r * (1.0 - 0.75 * Math.pow((k + dk) / r, 2.0));
                double r2 = Math.abs(k) >= r ? 0.0 : Math.sqrt(Math.max(0.0, dr * dr - k * k));
                double d = r3 = Math.abs(k) >= r ? 0.0 : Math.sqrt(Math.max(0.0, dr2 * dr2 - (k + dk) * (k + dk)));
                if (Double.isNaN(r2) || Double.isNaN(r3)) continue;
                int i = 0;
                while (i < 360) {
                    double a = Math.toRadians(i);
                    double a2 = Math.toRadians((double)i + di);
                    double ti = (double)i + (double)System.currentTimeMillis() / 50.0 % 360.0;
                    double tk = k + (double)System.currentTimeMillis() / 220.0 % 360.0;
                    double u = ti / 360.0 * 3.0;
                    double du = (ti + di) / 360.0 * 3.0;
                    double v = tk * r / 1024.0;
                    double dv = (tk + dk) * r / 1024.0;
                    double s1 = Math.sin(a);
                    double s2 = Math.sin(a2);
                    double c1 = Math.cos(a);
                    double c2 = Math.cos(a2);
                    var5.func_78374_a(dx + r2 * c1, dy + k, dz + r2 * s1, u, v);
                    var5.func_78374_a(dx + r2 * c2, dy + k, dz + r2 * s2, du, v);
                    var5.func_78374_a(dx + r3 * c2, dy + k + dk, dz + r3 * s2, du, dv);
                    var5.func_78374_a(dx + r3 * c1, dy + k + dk, dz + r3 * s1, u, dv);
                    i = (int)((double)i + di);
                }
            }
            var5.func_78381_a();
        }
    }

    static {
        runeLocations.add(new Coordinate(5, 5, 6));
        runeLocations.add(new Coordinate(6, 5, 5));
        runeLocations.add(new Coordinate(-5, 5, 6));
        runeLocations.add(new Coordinate(-6, 5, 5));
        runeLocations.add(new Coordinate(5, 5, -6));
        runeLocations.add(new Coordinate(6, 5, -5));
        runeLocations.add(new Coordinate(-5, 5, -6));
        runeLocations.add(new Coordinate(-6, 5, -5));
    }

    private static class SwitchGroup {
        private final ForgeDirection areaNS;
        private final ForgeDirection areaEW;
        private final boolean NW;
        private final boolean SW;
        private final boolean NE;
        private final boolean SE;

        private SwitchGroup(ForgeDirection ns, ForgeDirection ew, boolean nw, boolean sw, boolean ne, boolean se) {
            this.areaNS = ns;
            this.areaEW = ew;
            this.NW = nw;
            this.SW = sw;
            this.NE = ne;
            this.SE = se;
        }

        public boolean isSameCorner() {
            boolean c1 = this.areaNS == ForgeDirection.NORTH && this.areaEW == ForgeDirection.WEST && this.NW && !this.SW && !this.NE && !this.SE;
            boolean c2 = this.areaNS == ForgeDirection.SOUTH && this.areaEW == ForgeDirection.WEST && !this.NW && this.SW && !this.NE && !this.SE;
            boolean c3 = this.areaNS == ForgeDirection.NORTH && this.areaEW == ForgeDirection.EAST && !this.NW && !this.SW && this.NE && !this.SE;
            boolean c4 = this.areaNS == ForgeDirection.SOUTH && this.areaEW == ForgeDirection.EAST && !this.NW && !this.SW && !this.NE && this.SE;
            return c1 || c2 || c3 || c4;
        }

        private static SwitchGroup random(ForgeDirection ns, ForgeDirection ew, Random rand) {
            return new SwitchGroup(ns, ew, rand.nextBoolean(), rand.nextBoolean(), rand.nextBoolean(), rand.nextBoolean());
        }

        public int hashCode() {
            return (this.NW ? 1 : 0) << 0 | (this.SW ? 1 : 0) << 1 | (this.NE ? 1 : 0) << 2 | (this.SE ? 1 : 0) << 3;
        }

        public boolean equals(Object o) {
            return o instanceof SwitchGroup && this.matchKeys((SwitchGroup)o);
        }

        private boolean matchKeys(SwitchGroup o) {
            return o.NW == this.NW && o.NE == this.NE && o.SE == this.SE && o.SW == this.SW;
        }

        private NBTTagCompound writeToTag() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("nw", this.NW);
            tag.func_74757_a("ne", this.NE);
            tag.func_74757_a("sw", this.SW);
            tag.func_74757_a("se", this.SE);
            tag.func_74768_a("ew", this.areaEW.ordinal());
            tag.func_74768_a("ns", this.areaNS.ordinal());
            return tag;
        }

        private static SwitchGroup readTag(NBTTagCompound tag) {
            ForgeDirection ns = ForgeDirection.VALID_DIRECTIONS[tag.func_74762_e("ns")];
            ForgeDirection ew = ForgeDirection.VALID_DIRECTIONS[tag.func_74762_e("ew")];
            return new SwitchGroup(ns, ew, tag.func_74767_n("nw"), tag.func_74767_n("sw"), tag.func_74767_n("ne"), tag.func_74767_n("se"));
        }

        public boolean validate(World world, Coordinate switchNW, Coordinate switchSW, Coordinate switchNE, Coordinate switchSE) {
            boolean nw = this.NW == BlockLightSwitch.isSwitchUp(world, switchNW.xCoord, switchNW.yCoord, switchNW.zCoord);
            boolean sw = this.SW == BlockLightSwitch.isSwitchUp(world, switchSW.xCoord, switchSW.yCoord, switchSW.zCoord);
            boolean ne = this.NE == BlockLightSwitch.isSwitchUp(world, switchNE.xCoord, switchNE.yCoord, switchNE.zCoord);
            boolean se = this.SE == BlockLightSwitch.isSwitchUp(world, switchSE.xCoord, switchSE.yCoord, switchSE.zCoord);
            return nw && sw && ne && se;
        }
    }
}

