/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.Interfaces.CastingAutomationBlock;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityItemStand;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Collections.InventoryCache;
import Reika.DragonAPI.Instantiable.Data.Collections.ItemCollection;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.ModInteract.BasicAEInterface;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CastingAutomationSystem {
    protected final Random rand = new Random();
    protected final CastingAutomationBlock tile;
    private CastingRecipe recipe;
    private final StepTimer stepDelay;
    private final StepTimer cacheTimer = new StepTimer(40);
    private int recipesToGo = 0;
    private int recipeCycles = 0;
    protected EntityPlayer currentPlayer;
    private final InventoryCache ingredients = new InventoryCache();
    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    private MESystemReader network;
    private Object aeGridBlock;
    private Object aeGridNode;

    public CastingAutomationSystem(CastingAutomationBlock te) {
        this.tile = te;
        this.stepDelay = new StepTimer(te.getInjectionTickRate());
        if (ModList.APPENG.isLoaded()) {
            this.aeGridBlock = new BasicAEInterface((TileEntity)te, ((TileEntityChromaticBase)((Object)te)).getTile().getCraftedProduct());
            this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
        }
    }

    public final boolean isIdle() {
        return this.recipe == null || this.recipesToGo == 0;
    }

    public final CastingRecipe getCurrentRecipeOutput() {
        return this.recipe;
    }

    public final void destroy() {
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).destroy();
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public final IGridNode getGridNode(ForgeDirection dir) {
        return (IGridNode)this.aeGridNode;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public final IGridNode getActionableNode() {
        return (IGridNode)this.aeGridNode;
    }

    public void setRecipe(CastingRecipe c, int amt, EntityPlayer ep) {
        this.recipe = c;
        if (c != null && !this.tile.canTriggerCrafting()) {
            amt = Math.min(amt, 64 / c.getOutput().field_77994_a);
        }
        this.recipesToGo = amt;
        this.currentPlayer = ep;
    }

    public final void cancelCrafting() {
        this.setRecipe(null, 0, null);
    }

    protected final boolean matches(Object object, ItemStack is) {
        if (object instanceof ItemStack) {
            return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)object)) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)((ItemStack)object));
        }
        if (object instanceof List) {
            return ReikaItemHelper.listContainsItemStack((Collection)((Collection)object), (ItemStack)is, (boolean)true);
        }
        return object == null && is == null;
    }

    protected final boolean hasItem(Object item, int amt) {
        ItemStack is = this.findItem(item, amt, true);
        return is != null && is.field_77994_a >= amt;
    }

    protected final int countItem(Object item) {
        if (DragonAPICore.debugtest) {
            return Integer.MAX_VALUE;
        }
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (item instanceof ItemStack) {
            li.add((ItemStack)item);
        }
        if (item instanceof List) {
            li.addAll((List)item);
        }
        if (item instanceof ItemMatch) {
            for (KeyedItemStack ks : ((ItemMatch)item).getItemList()) {
                li.add(ks.getItemStack());
            }
        }
        if (ModList.APPENG.isLoaded()) {
            ChromatiCraft.logger.debug((Object)("Delegate " + this.tile + " counting " + li + " from " + this.ingredients + " / " + this.network));
        } else {
            ChromatiCraft.logger.debug((Object)("Delegate " + this.tile + " counting " + li + " from " + this.ingredients));
        }
        int ret = 0;
        for (ItemStack is : li) {
            if (ModList.APPENG.isLoaded() && this.network != null) {
                ret = is.func_77960_j() == Short.MAX_VALUE ? (int)((long)ret + this.network.getFuzzyItemCount(is, FuzzyMode.IGNORE_ALL, false, is.field_77990_d != null)) : (int)((long)ret + this.network.getItemCount(is, is.field_77990_d != null));
                ChromatiCraft.logger.debug((Object)(this.tile + " failed to find any " + is + " in its ME System."));
            }
            ret += this.ingredients.getItemCount(is);
        }
        return ret;
    }

    protected final Collection<ItemStack> findItems(Object item, int amt, boolean simulate) {
        return this.getItems(item, amt, simulate, true);
    }

    protected final ItemStack findItem(Object item, int amt, boolean simulate) {
        ArrayList<ItemStack> c = this.getItems(item, amt, simulate, false);
        if (c == null || c.isEmpty()) {
            return null;
        }
        return c.get(0);
    }

    protected ItemCollection getExtraItems(Object item, int amt, boolean simulate, boolean allowMultiple) {
        return null;
    }

    private final ArrayList<ItemStack> getItems(Object item, int amt, boolean simulate, boolean allowMultiple) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (item instanceof ItemStack) {
            li.add((ItemStack)item);
        }
        if (item instanceof List) {
            li.addAll((List)item);
        }
        if (item instanceof ItemMatch) {
            for (KeyedItemStack ks : ((ItemMatch)item).getItemList()) {
                li.add(ks.getItemStack());
            }
        }
        if (DragonAPICore.debugtest) {
            return ReikaJavaLibrary.makeListFrom((Object)ReikaItemHelper.getSizedItemStack((ItemStack)((ItemStack)li.get(0)), (int)amt));
        }
        if (ModList.APPENG.isLoaded()) {
            ChromatiCraft.logger.debug((Object)("Delegate " + this.tile + " requesting " + li + " from " + this.ingredients + " / " + this.network));
        } else {
            ChromatiCraft.logger.debug((Object)("Delegate " + this.tile + " requesting " + li + " from " + this.ingredients));
        }
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int wanted = amt;
        ItemCollection extra = this.getExtraItems(item, amt, simulate, allowMultiple);
        if (extra != null) {
            for (ItemStack is : extra.getItems()) {
                int num = Math.min(is.field_77994_a, wanted);
                ret.add(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)num));
                is.field_77994_a -= num;
                if ((wanted -= num) > 0) continue;
                break;
            }
            extra.clearEmpties();
        }
        if (wanted <= 0) {
            return ret;
        }
        for (ItemStack is : li) {
            int has;
            if (ModList.APPENG.isLoaded() && this.network != null) {
                if (is.func_77960_j() == Short.MAX_VALUE) {
                    MESystemReader.ExtractedItemGroup rem = this.network.removeItemFuzzy(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)wanted), simulate, FuzzyMode.IGNORE_ALL, false, is.field_77990_d != null, allowMultiple);
                    if (rem != null) {
                        for (MESystemReader.ExtractedItem ei : rem.getItems()) {
                            ItemStack is2 = ReikaItemHelper.getSizedItemStack((ItemStack)ei.getItem(), (int)((int)ei.amount));
                            is2.func_77964_b(0);
                            ret.add(is2);
                            wanted -= is2.field_77994_a;
                        }
                    }
                } else {
                    int rem = (int)this.network.removeItem(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)wanted), simulate, is.field_77990_d != null);
                    if (rem > 0) {
                        ItemStack is2 = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)rem);
                        ret.add(is2);
                        wanted -= is2.field_77994_a;
                    }
                }
                ChromatiCraft.logger.debug((Object)(this.tile + " failed to find " + is + " in its ME System."));
                if (wanted <= 0) break;
            }
            if ((has = this.ingredients.getItemCount(is)) > 0) {
                int rem = Math.min(wanted, has);
                if (!simulate) {
                    this.ingredients.removeXItems(is, rem);
                }
                ItemStack is2 = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)rem);
                ret.add(is2);
                wanted -= is2.field_77994_a;
            }
            if (wanted > 0) continue;
            break;
        }
        return ret;
    }

    public final boolean recoverItem(ItemStack is) {
        int left;
        if (DragonAPICore.debugtest) {
            return true;
        }
        if (ModList.APPENG.isLoaded() && this.network != null) {
            is.field_77994_a = left = (int)this.network.addItem(is, false);
            if (left == 0) {
                return true;
            }
        }
        return (left = this.ingredients.addItemsToUnderlyingInventories(is, false)) <= 0;
    }

    public void tick(World world) {
        TileEntityCastingTable te;
        this.cacheTimer.update();
        if (this.cacheTimer.checkCap()) {
            this.buildCache();
        }
        if (ModList.APPENG.isLoaded() && this.aeGridBlock != null && !world.field_72995_K) {
            ((BasicAEInterface)this.aeGridBlock).setPowerCost(this.recipe != null ? 6.0 : 1.0);
        }
        if ((te = this.tile.getTable()) != null && this.recipe != null && this.recipesToGo > 0 && this.tile.isAbleToRun(te)) {
            int z;
            int y;
            int x = this.getX();
            if (this.tile.canCraft(world, x, y = this.getY(), z = this.getZ(), te)) {
                if (this.isRecipeReady(world, x, y, z, te)) {
                    if (this.tile.canTriggerCrafting()) {
                        if (this.triggerCrafting(world, x, y, z, te)) {
                            this.onTriggerCrafting(this.recipe, this.recipeCycles);
                            te.syncAllData(true);
                            this.tile.consumeEnergy(this.recipe, te, null);
                            this.recipesToGo -= this.recipeCycles;
                            this.recipeCycles = 0;
                        }
                    } else {
                        this.recipesToGo -= this.recipeCycles;
                        this.recipeCycles = 0;
                    }
                } else {
                    UpdateStep c;
                    int amt = Math.min(this.recipesToGo, this.recipe.getOutput().func_77976_d() / this.recipe.getOutput().field_77994_a);
                    if (this.recipe instanceof CastingRecipe.MultiBlockCastingRecipe) {
                        CastingRecipe.MultiBlockCastingRecipe mr = (CastingRecipe.MultiBlockCastingRecipe)this.recipe;
                        amt = Math.min(amt, mr.getMainInput().func_77976_d() / mr.getRequiredCentralItemCount());
                    }
                    if ((c = this.prepareRecipeStep(world, x, y, z, te, amt)) != null) {
                        this.recipeCycles = this.recipeCycles > 0 ? Math.min(this.recipeCycles, c.getItem().field_77994_a) : c.getItem().field_77994_a;
                        ChromaSounds.CAST.playSoundAtBlock(world, c.loc.xCoord, c.loc.yCoord, c.loc.zCoord);
                        int[] dat = new int[]{c.loc.xCoord, c.loc.yCoord, c.loc.zCoord, 0, Item.func_150891_b((Item)c.getItem().func_77973_b()), c.getItem().func_77960_j(), c.getItem().field_77990_d != null ? 1 : 0};
                        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.CASTAUTOUPDATE.ordinal(), (TileEntity)((TileEntity)this.tile), (int)48, (int[])dat);
                        this.tile.consumeEnergy(this.recipe, te, c.getItem());
                        te.func_70296_d();
                        TileEntity tile = c.loc.getTileEntity((IBlockAccess)world);
                        if (tile != null) {
                            tile.func_70296_d();
                            if (tile instanceof TileEntityBase) {
                                ((TileEntityBase)tile).syncAllData(true);
                            }
                        }
                    }
                }
            }
        } else if (!(this.recipe != null && this.recipesToGo != 0 || this.isIdle())) {
            this.cancelCrafting();
        }
    }

    protected void onTriggerCrafting(CastingRecipe r, int cycles) {
    }

    private void buildCache() {
        this.ingredients.clear();
        TileEntity te = this.tile.getItemPool();
        if (te instanceof IInventory) {
            this.ingredients.addInventory((IInventory)te);
        }
        if (ModList.APPENG.isLoaded()) {
            Object oldNode = this.aeGridNode;
            if (this.aeGridNode == null) {
                Object object = this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
            }
            if (this.aeGridNode != null) {
                ((IGridNode)this.aeGridNode).updateState();
            }
            if (oldNode != this.aeGridNode || this.network == null) {
                this.network = this.aeGridNode == null ? null : (this.network == null ? new MESystemReader((IGridNode)this.aeGridNode, (IActionHost)this.tile) : new MESystemReader((IGridNode)this.aeGridNode, this.network));
            }
        }
    }

    private UpdateStep prepareRecipeStep(World world, int x, int y, int z, TileEntityCastingTable te, int amt) {
        block7: {
            block8: {
                this.stepDelay.update();
                if (!this.stepDelay.checkCap()) break block7;
                if (!(this.recipe instanceof CastingRecipe.MultiBlockCastingRecipe)) break block8;
                CastingRecipe.MultiBlockCastingRecipe mr = (CastingRecipe.MultiBlockCastingRecipe)this.recipe;
                HashMap<List<Integer>, TileEntityItemStand> map = te.getOtherStands();
                Map<List<Integer>, ItemMatch> items = mr.getAuxItems();
                for (List<Integer> key : map.keySet()) {
                    ItemMatch item = items.get(key);
                    TileEntityItemStand stand = map.get(key);
                    if (stand == null) continue;
                    ItemStack in = stand.func_70301_a(0);
                    if ((item != null || in == null) && (item == null || item.match(in))) continue;
                    if (in != null) {
                        if (!this.recoverItem(in)) continue;
                        stand.func_70299_a(0, null);
                        return new UpdateStep((TileEntity)stand, in);
                    }
                    ItemStack ret = this.findItem(item, amt, false);
                    if (ret == null) continue;
                    stand.func_70299_a(0, ret);
                    return new UpdateStep((TileEntity)stand, ret);
                }
                if (!this.tile.canPlaceCentralItemForMultiRecipes()) break block7;
                ItemStack ctr = mr.getMainInput();
                for (int i = 0; i < 9; ++i) {
                    ItemStack in = te.func_70301_a(i);
                    if (i == 4) {
                        if (in != null) {
                            if (ReikaItemHelper.matchStacks((ItemStack)in, (ItemStack)ctr) && in.field_77994_a >= mr.getRequiredCentralItemCount() && (ctr.field_77990_d == null || ItemStack.func_77970_a((ItemStack)in, (ItemStack)ctr)) || !this.recoverItem(in)) continue;
                            te.func_70299_a(i, null);
                            return new UpdateStep((TileEntity)te, in);
                        }
                        ItemStack ret = this.findItem(ctr, amt * mr.getRequiredCentralItemCount(), false);
                        if (ret == null) continue;
                        te.func_70299_a(i, ret);
                        return new UpdateStep((TileEntity)te, ret);
                    }
                    if (in == null || !this.recoverItem(in)) continue;
                    te.func_70299_a(i, null);
                    return new UpdateStep((TileEntity)te, in);
                }
                break block7;
            }
            Object[] arr = this.recipe.getInputArray();
            for (int i = 0; i < 9; ++i) {
                Object item = arr[i];
                ItemStack in = te.func_70301_a(i);
                if (this.matches(item, in)) continue;
                if (in != null) {
                    if (!this.recoverItem(in)) continue;
                    te.func_70299_a(i, null);
                    return new UpdateStep((TileEntity)te, in);
                }
                ItemStack ret = this.findItem(item, amt, false);
                if (ret == null) continue;
                te.func_70299_a(i, ret);
                return new UpdateStep((TileEntity)te, ret);
            }
        }
        return null;
    }

    private boolean triggerCrafting(World world, int x, int y, int z, TileEntityCastingTable te) {
        return te.triggerCrafting(this.currentPlayer);
    }

    private boolean isRecipeReady(World world, int x, int y, int z, TileEntityCastingTable te) {
        return te.getActiveRecipe() == this.recipe;
    }

    public final int getX() {
        return ((TileEntity)this.tile).field_145851_c;
    }

    public final int getY() {
        return ((TileEntity)this.tile).field_145848_d;
    }

    public final int getZ() {
        return ((TileEntity)this.tile).field_145849_e;
    }

    @SideOnly(value=Side.CLIENT)
    public final void receiveUpdatePacket(World world, int[] data) {
        double x = (double)data[0] + 0.5;
        double y = (double)data[1] + 0.5;
        double z = (double)data[2] + 0.5;
        ItemStack is = new ItemStack(Item.func_150899_d((int)data[4]), 1, data[5]);
        boolean nbt = data[6] > 0;
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(is);
        if (nbt && tag != null) {
            tag.addTag(CrystalElement.PURPLE, 1);
            tag.addTag(CrystalElement.BLACK, 1);
        }
        for (int i = 0; i < 32; ++i) {
            CrystalElement e = tag != null ? (CrystalElement)ReikaJavaLibrary.getRandomCollectionEntry((Random)this.rand, tag.elementSet()) : null;
            int color = e != null ? e.getColor() : 43775;
            double px = ReikaRandomHelper.getRandomPlusMinus((double)x, (double)1.0);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)y, (double)0.5);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)z, (double)1.0);
            EntityFX fx = null;
            float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125));
            switch (this.rand.nextInt(3)) {
                case 0: {
                    fx = new EntityCenterBlurFX(world, px, py, pz).setColor(color).setGravity(g);
                    break;
                }
                case 1: {
                    fx = new EntityLaserFX(CrystalElement.WHITE, world, px, py, pz).setColor(color).setGravity(g);
                    break;
                }
                default: {
                    fx = new EntityCCBlurFX(world, px, py, pz).setColor(color).setGravity(g);
                }
            }
            fx.field_70181_x = 0.03125 + this.rand.nextDouble() * 0.0625;
            Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
        }
    }

    public void writeToNBT(NBTTagCompound NBT) {
        NBT.func_74768_a("recipes", this.recipesToGo);
        NBT.func_74768_a("cycles", this.recipeCycles);
    }

    public void readFromNBT(NBTTagCompound NBT) {
        this.recipesToGo = NBT.func_74762_e("recipes");
        this.recipeCycles = NBT.func_74762_e("cycles");
    }

    public void onBreak(World world) {
    }

    private static class UpdateStep {
        public final Coordinate loc;
        private final ItemStack item;

        private UpdateStep(TileEntity te, ItemStack is) {
            this(new Coordinate(te), is);
        }

        private UpdateStep(Coordinate c, ItemStack is) {
            this.loc = c;
            this.item = is;
        }

        public ItemStack getItem() {
            return this.item.func_77946_l();
        }
    }
}

