/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Block.BlockSelectiveGlass;
import Reika.ChromatiCraft.Block.Dimension.BlockLightedLeaf;
import Reika.ChromatiCraft.Block.Worldgen.BlockCliffStone;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.ChromaGuiHandler;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityBallLightning;
import Reika.ChromatiCraft.Entity.EntityGlowCloud;
import Reika.ChromatiCraft.Entity.EntityLaserPulse;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Magic.CrystalTarget;
import Reika.ChromatiCraft.Magic.Interfaces.ChargingPoint;
import Reika.ChromatiCraft.Magic.Interfaces.PoweredItem;
import Reika.ChromatiCraft.Magic.MonumentCompletionRitual;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.TargetData;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Magic.ToolChargingSystem;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaEntities;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.Auxiliary.WorldGenInterceptionRegistry;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Entity.CustomProjectile;
import Reika.DragonAPI.Interfaces.Item.ActivatedInventoryItem;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaChunkHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BloodMagicHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ChiselBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerBlockHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.Fluid;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public class ChromaAux {
    public static final Color[] sideColors = new Color[]{Color.CYAN, Color.BLUE, Color.YELLOW, Color.BLACK, new Color(255, 120, 0), Color.MAGENTA};
    public static final String[] sideColorNames = new String[]{"CYAN", "BLUE", "YELLOW", "BLACK", "ORANGE", "MAGENTA"};
    private static HashMap<String, ArrayList<CrystalElement>> fluidRunes = new HashMap();
    private static final MultiMap<TargetData, CrystalElement> beamColorMixes = new MultiMap();
    public static final WorldGenInterceptionRegistry.IWGWatcher slimeIslandBlocker = new WorldGenInterceptionRegistry.IWGWatcher(){

        public boolean canIWGRun(IWorldGenerator gen, Random random, int cx, int cz, World world, IChunkProvider generator, IChunkProvider loader) {
            if (ReikaChunkHelper.chunkContainsBiomeType((World)world, (int)cx, (int)cz, BiomeGlowingCliffs.class)) {
                return BiomeGlowingCliffs.canRunGenerator(gen);
            }
            return true;
        }
    };
    public static final WorldGenInterceptionRegistry.InterceptionException dimensionException = new WorldGenInterceptionRegistry.InterceptionException(){

        public boolean doesExceptionApply(World world, int x, int y, int z, Block set, int meta) {
            return world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue();
        }
    };
    public static final WorldGenInterceptionRegistry.BlockSetWatcher populationWatcher = new WorldGenInterceptionRegistry.BlockSetWatcher(){

        public void onChunkGeneration(World world, Map<Coordinate, WorldGenInterceptionRegistry.BlockSetData> set) {
            for (Coordinate c : set.keySet()) {
                AspectList al;
                float f;
                INode n;
                TileEntity te;
                TileEntityMobSpawner tm;
                WorldGenInterceptionRegistry.BlockSetData dat;
                BiomeGenBase b = c.getBiome(world);
                if (ChromatiCraft.isRainbowForest(b)) {
                    dat = set.get(c);
                    if (dat.newBlock == ThaumItemHelper.BlockEntry.TOTEM.getBlock()) {
                        dat.revert(world);
                        continue;
                    }
                    if (dat.newBlock == Blocks.field_150474_ac) {
                        tm = (TileEntityMobSpawner)dat.getTileEntity(world);
                        MobSpawnerBaseLogic lgc = tm.func_145881_a();
                        lgc.field_98289_l = lgc.func_98276_e().equals("CaveSpider") && lgc.func_98274_c() < 55 ? 12 : 6;
                        lgc.field_98283_g *= 2;
                        lgc.field_98293_h *= 4;
                        continue;
                    }
                    if (ChromaTiles.getTileFromIDandMetadata(dat.newBlock, dat.newMetadata) == ChromaTiles.PYLON || !InterfaceCache.NODE.instanceOf((Object)dat.getTileEntity(world))) continue;
                    te = dat.getTileEntity(world);
                    n = (INode)te;
                    n.setNodeType(NodeType.NORMAL);
                    n.setNodeModifier(NodeModifier.BRIGHT);
                    if (te.field_145850_b.field_73012_v.nextInt(4) != 0) continue;
                    f = 2.0f + te.field_145850_b.field_73012_v.nextFloat() * 4.0f;
                    al = n.getAspects();
                    for (Aspect a : new HashSet(al.aspects.keySet())) {
                        al.aspects.put(a, (int)(f * (float)al.getAmount(a)));
                    }
                    continue;
                }
                if (!BiomeGlowingCliffs.isGlowingCliffs(b)) continue;
                dat = set.get(c);
                if (ModList.CHISEL.isLoaded() && dat.oldBlock == ChromaBlocks.CLIFFSTONE.getBlockInstance() && ChiselBlockHandler.isWorldgenBlock((Block)dat.newBlock, (int)dat.newMetadata)) {
                    dat.revert(world);
                    continue;
                }
                if (dat.newBlock == Blocks.field_150474_ac) {
                    tm = (TileEntityMobSpawner)dat.getTileEntity(world);
                    if (tm == null || !ReikaSpawnerHelper.getMobSpawnerMobName((TileEntityMobSpawner)tm).toLowerCase(Locale.ENGLISH).contains("wisp")) continue;
                    ReikaSpawnerHelper.setMobSpawnerMob((TileEntityMobSpawner)tm, (String)ChromaEntities.GLOWCLOUD.entityName);
                    continue;
                }
                if (ModList.TINKERER.isLoaded() && TinkerBlockHandler.getInstance().isSlimeIslandBlock(dat.newBlock, dat.newMetadata)) {
                    dat.revert(world);
                    continue;
                }
                if (ChromaTiles.getTileFromIDandMetadata(dat.newBlock, dat.newMetadata) == ChromaTiles.PYLON || !InterfaceCache.NODE.instanceOf((Object)dat.getTileEntity(world))) continue;
                te = dat.getTileEntity(world);
                n = (INode)te;
                n.setNodeType(NodeType.NORMAL);
                n.setNodeModifier(NodeModifier.BRIGHT);
                if (te.field_145850_b.field_73012_v.nextInt(4) != 0) continue;
                f = 1.0f + te.field_145850_b.field_73012_v.nextFloat() * 2.0f;
                al = n.getAspects();
                for (Aspect a : new HashSet(al.aspects.keySet())) {
                    al.aspects.put(a, (int)(f * (float)al.getAmount(a)));
                }
            }
        }
    };

    public static float getRFTransferEfficiency(World world, int x, int y, int z) {
        return ChromaOptions.getRFEfficiency();
    }

    public static final boolean hasGui(World world, int x, int y, int z, EntityPlayer ep) {
        Object GUI;
        ChromaTiles m = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && (GUI = ChromaGuiHandler.instance.getClientGuiElement(0, ep, world, x, y, z)) != null) {
            return true;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && (GUI = ChromaGuiHandler.instance.getServerGuiElement(0, ep, world, x, y, z)) != null;
    }

    public static int get4SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        int i;
        for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
        }
        while (i < 0) {
            i += 4;
        }
        switch (i) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return -1;
    }

    public static int get6SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        if (MathHelper.func_76135_e((float)ep.field_70125_A) < 60.0f) {
            int i;
            for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
            }
            while (i < 0) {
                i += 4;
            }
            switch (i) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 0;
                }
            }
        } else {
            if (ep.field_70125_A > 0.0f) {
                return 4;
            }
            return 5;
        }
        return -1;
    }

    public static int get2SidedMetadataFromPlayerLook(EntityLivingBase ep) {
        int i;
        for (i = MathHelper.func_76128_c((double)((double)(ep.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
        }
        while (i < 0) {
            i += 4;
        }
        switch (i) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public static boolean shouldSetFlipped(World world, int x, int y, int z) {
        boolean softBelow = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
        boolean softAbove = ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)(y + 1), (int)z);
        return !softAbove && softBelow;
    }

    public static String getMessage(String tag) {
        return StatCollector.func_74838_a((String)("message." + tag));
    }

    public static void writeMessage(String tag) {
        ReikaChatHelper.writeString((String)ChromaAux.getMessage(tag));
    }

    public static void spawnInteractionBallLightning(World world, int x, int y, int z, CrystalElement e) {
        if (!world.field_72995_K && ChromaOptions.BALLLIGHTNING.getState()) {
            int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)16);
            int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)16);
            double dy = world.func_72825_h(dx, dz) + ReikaRandomHelper.getSafeRandomInt((int)8);
            world.func_72838_d((Entity)new EntityBallLightning(world, e, (double)dx + 0.5, dy + 0.5, (double)dz + 0.5).setNoDrops());
        }
    }

    public static boolean requiresSpecialSpawnEnforcement(EntityLiving e) {
        String name = e.getClass().getName().toLowerCase(Locale.ENGLISH);
        return name.contains("lycanite");
    }

    public static void doPylonAttack(CrystalElement color, EntityLivingBase e, float amt) {
        ChromaAux.doPylonAttack(color, e, amt, false, 0, false);
    }

    public static void doPylonAttack(CrystalElement color, EntityLivingBase e, float amt, boolean taperNew, int looting, boolean progress) {
        float originalAmt = amt;
        if (e instanceof EntityPlayer) {
            EntityPlayer ep = (EntityPlayer)e;
            if (progress) {
                ProgressStage.SHOCK.stepPlayerTo(ep);
            }
            if (ModList.BLOODMAGIC.isLoaded()) {
                int drain = 5000;
                if (BloodMagicHandler.getInstance().isPlayerWearingFullBoundArmor(ep)) {
                    amt *= 10.0f;
                    drain = 50000;
                }
                SoulNetworkHandler.syphonFromNetwork((String)ep.func_70005_c_(), (int)drain);
            }
            if (taperNew) {
                if (e.field_70173_aa < 600) {
                    amt = 1.0f;
                } else if (e.field_70173_aa <= 1000) {
                    amt = 1 + (e.field_70173_aa - 600) / 100;
                }
            }
        }
        float last = e.func_110143_aJ();
        e.func_70097_a((DamageSource)ChromatiCraft.pylonDamage[color == null ? 16 : color.ordinal()], amt);
        if (e.func_110143_aJ() > Math.max(0.0f, last - originalAmt)) {
            if (originalAmt >= last) {
                e.func_70606_j(0.1f);
                e.func_70097_a((DamageSource)ChromatiCraft.pylonDamage[color == null ? 16 : color.ordinal()], Float.MAX_VALUE);
            } else {
                e.func_70606_j(last - originalAmt);
            }
        }
    }

    public static float getIslandBias(float originalBias, float dx, float dz) {
        float dist = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        return 50.0f + 50.0f * MathHelper.func_76126_a((float)(dist * 0.0625f));
    }

    public static MultiMap<TargetData, CrystalElement> getBeamColorMixes(Collection<CrystalTarget> c) {
        beamColorMixes.clear();
        for (CrystalTarget t : c) {
            beamColorMixes.addValue((Object)new TargetData(t), (Object)t.color);
        }
        return beamColorMixes;
    }

    public static void changePylonColor(World world, TileEntityCrystalPylon te, CrystalElement e) {
        try {
            ChunkCoordIntPair ch = new Coordinate((TileEntity)te).asChunkPair();
            world.func_72863_F().func_73154_d(ch.field_77276_a, ch.field_77275_b);
            TileEntityCrystalPylon old = te;
            te = (TileEntityCrystalPylon)world.func_147438_o(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            CrystalNetworker.instance.removeTile(old);
            PylonGenerator.instance.removeCachedPylon(old);
            te.setColor(e);
            BlockArray runes = te.getRuneLocations(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
            for (int i = 0; i < runes.getSize(); ++i) {
                Coordinate c = runes.getNthBlock(i);
                if (c.getBlock((IBlockAccess)te.field_145850_b) != ChromaBlocks.RUNE.getBlockInstance()) continue;
                te.field_145850_b.func_72921_c(c.xCoord, c.yCoord, c.zCoord, te.getColor().ordinal(), 3);
            }
            CrystalNetworker.instance.addTile(te);
            PylonGenerator.instance.cachePylon(te);
        }
        catch (Exception ex) {
            ChromatiCraft.logger.logError((Object)("Could not change pylon color @ " + te));
            ex.printStackTrace();
        }
    }

    public static void notifyServerPlayersExcept(EntityPlayer ep, ChromaResearchManager.ProgressElement p) {
        String sg = EnumChatFormatting.GOLD + ep.func_70005_c_() + EnumChatFormatting.RESET + " has learned something new: " + p.getFormatting() + p.getTitle();
        WorldServer[] ws = DimensionManager.getWorlds();
        for (int i = 0; i < ws.length; ++i) {
            for (EntityPlayer ep2 : ws[i].field_73010_i) {
                if (ep2 == ep) continue;
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep2, (String)sg);
            }
        }
    }

    public static void notifyServerPlayers(EntityPlayer ep, ChromaResearchManager.ProgressElement p) {
        String sg = EnumChatFormatting.GOLD + ep.func_70005_c_() + EnumChatFormatting.RESET + " has learned something new: " + p.getFormatting() + p.getTitle();
        WorldServer[] ws = DimensionManager.getWorlds();
        for (int i = 0; i < ws.length; ++i) {
            for (EntityPlayer ep2 : ws[i].field_73010_i) {
                if (ep2 != ep) {
                    ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep2, (String)sg);
                    continue;
                }
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep2, (String)("You have learned something new: " + p.getFormatting() + p.getTitle()));
            }
        }
    }

    @Deprecated
    public static void permuteRunes(HashMap<Coordinate, CrystalElement> map, World world, EntityPlayer ep) {
    }

    public static CrystalElement getRune(Fluid fluid) {
        ArrayList<CrystalElement> li = fluidRunes.get(fluid.getName());
        if (li == null) {
            String n;
            li = new ArrayList();
            fluidRunes.put(fluid.getName(), li);
            li.add(CrystalElement.CYAN);
            if (fluid.getTemperature() > 900) {
                li.add(CrystalElement.ORANGE);
            }
            if (fluid.getTemperature() < 270) {
                li.add(CrystalElement.WHITE);
            }
            if (fluid.isGaseous()) {
                li.add(CrystalElement.LIME);
            }
            if (fluid.getLuminosity() > 0) {
                li.add(CrystalElement.BLUE);
            }
            if (fluid.getDensity() > 4000) {
                li.add(CrystalElement.RED);
            }
            if ((n = fluid.getName().toLowerCase(Locale.ENGLISH)).contains("oil")) {
                li.add(CrystalElement.BROWN);
            }
            if (n.contains("fuel")) {
                li.add(CrystalElement.YELLOW);
            }
            if (n.contains("xp") || fluid == ChromatiCraft.chroma) {
                li.add(CrystalElement.PURPLE);
            }
            if (n.contains("bio") || n.contains("honey") || n.contains("seed")) {
                li.add(CrystalElement.GREEN);
            }
        }
        return li.get(ReikaRandomHelper.getSafeRandomInt((int)li.size()));
    }

    public static boolean chargePlayerFromPylon(EntityPlayer player, ChargingPoint te, CrystalElement e, int tick) {
        if (te.canConduct() && te.allowCharging(player, e) && ChromaAux.allowPlayerChargingAt(player, te, e)) {
            int energy;
            int n;
            int add = Math.max(1, (int)((float)PlayerElementBuffer.instance.getChargeSpeed(player) * te.getChargeRateMultiplier(player, e)));
            int drain = add * (n = PlayerElementBuffer.instance.getChargeInefficiency(player));
            if (drain > (energy = te.getEnergy(e))) {
                drain = energy;
                add = drain / n;
            }
            if (add > 0 && PlayerElementBuffer.instance.canPlayerAccept(player, e, add)) {
                te.onUsedBy(player, e);
                if (PlayerElementBuffer.instance.addToPlayer(player, e, add, true)) {
                    te.drain(e, drain);
                }
                ProgressStage.CHARGE.stepPlayerTo(player);
                if (te instanceof TileEntityCrystalPylon) {
                    ProgressionManager.instance.setPlayerDiscoveredColor(player, ((TileEntityCrystalPylon)te).getColor(), true, true);
                }
                if (player.field_70170_p.field_72995_K) {
                    ChromaFX.createPylonChargeBeam(te, player, (double)(tick % 20) / 20.0, e);
                } else {
                    ChromaAux.chargePlayerTools(player, te, e);
                }
                return true;
            }
        }
        return false;
    }

    public static void chargePlayerTools(EntityPlayer player, ChargingPoint te, CrystalElement e) {
        int slot = DragonAPICore.rand.nextInt(player.field_71071_by.field_70462_a.length);
        ItemStack at = player.field_71071_by.field_70462_a[slot];
        if (at != null) {
            if (at.func_77973_b() instanceof ActivatedInventoryItem) {
                ItemStack in;
                int size = ((ActivatedInventoryItem)at.func_77973_b()).getInventorySize(at);
                slot = DragonAPICore.rand.nextInt(size);
                if (((ActivatedInventoryItem)at.func_77973_b()).isSlotActive(at, slot) && (in = ((ActivatedInventoryItem)at.func_77973_b()).getItem(at, slot)) != null && in.func_77973_b() instanceof PoweredItem) {
                    ChromaAux.tryChargePoweredItem(in, player, te, e);
                }
            } else if (at.func_77973_b() instanceof PoweredItem) {
                ChromaAux.tryChargePoweredItem(at, player, te, e);
            }
        }
    }

    private static void tryChargePoweredItem(ItemStack in, EntityPlayer player, ChargingPoint te, CrystalElement e) {
        int rate;
        float sc;
        PoweredItem pi = (PoweredItem)in.func_77973_b();
        if (pi.getColor(in) == e && (sc = pi.getPlayerChargeCoefficient(in)) > 0.0f && (rate = Math.max(0, (int)(te.getHeldToolChargingPower(player, e, in) * sc * (float)ToolChargingSystem.instance.getChargeRate(in)))) > 0) {
            ToolChargingSystem.instance.addCharge(in, rate);
        }
    }

    private static boolean allowPlayerChargingAt(EntityPlayer player, ChargingPoint te, CrystalElement e) {
        return true;
    }

    public static List<AxisAlignedBB> interceptEntityCollision(World world, Entity e, AxisAlignedBB box) {
        if (!(e instanceof EntityPlayer) || world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            // empty if block
        }
        if (e instanceof EntityPlayer && Chromabilities.ORECLIP.enabledOn((EntityPlayer)e)) {
            return AbilityHelper.instance.getNoclipBlockBoxes((EntityPlayer)e, box);
        }
        return ChromaAux.getSurrogateCollidingAABBs(world, e, box);
    }

    public static List<AxisAlignedBB> getSurrogateCollidingAABBs(World world, Entity ep, AxisAlignedBB box) {
        ArrayList<AxisAlignedBB> li = new ArrayList<AxisAlignedBB>();
        int i = MathHelper.func_76128_c((double)box.field_72340_a);
        int j = MathHelper.func_76128_c((double)(box.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)box.field_72338_b);
        int l = MathHelper.func_76128_c((double)(box.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)box.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(box.field_72334_f + 1.0));
        for (int x = i; x < j; ++x) {
            for (int z = i1; z < j1; ++z) {
                if (!world.func_72899_e(x, 64, z)) continue;
                for (int y = k - 1; y < l; ++y) {
                    Block block = x >= -30000000 && x < 30000000 && z >= -30000000 && z < 30000000 ? world.func_147439_a(x, y, z) : Blocks.field_150348_b;
                    boolean flag = true;
                    if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() && ChromaDimensionManager.isBlockedAir(world, x, y, z, block, ep)) {
                        Blocks.field_150348_b.func_149743_a(world, x, y, z, box, li, ep);
                        ChromaDimensionManager.onPlayerBlockedFromBiome(world, x, y, z, ep);
                        flag = false;
                    } else if (world.field_72995_K && ChromaAux.isParticle(ep)) {
                        if (ChromaFX.cancelParticleBlockCollision(world, x, y, z, block, ep)) {
                            flag = false;
                        }
                    } else if (ep instanceof EntityGlowCloud) {
                        if (EntityGlowCloud.isBlockNonColliding(world, x, y, z, block)) {
                            flag = false;
                        }
                    } else if (ep instanceof EntityItem && ((EntityItem)ep).func_92059_d().func_77973_b() == ChromaItems.FERTILITYSEED.getItemInstance()) {
                        if (block == ChromaBlocks.DYELEAF.getBlockInstance() || block == ChromaBlocks.DECAY.getBlockInstance() || block == ChromaBlocks.GLOWLEAF.getBlockInstance()) {
                            flag = false;
                        } else if (block.func_149688_o() == Material.field_151584_j || block instanceof BlockLeavesBase || block.isLeaves((IBlockAccess)world, x, y, z)) {
                            flag = false;
                        }
                    }
                    if (!flag) continue;
                    block.func_149743_a(world, x, y, z, box, li, ep);
                }
            }
        }
        double d0 = 0.25;
        List list = world.func_72839_b(ep, box.func_72314_b(d0, d0, d0));
        for (Entity e : list) {
            AxisAlignedBB box2 = e.func_70046_E();
            if (box2 != null && box2.func_72326_a(box)) {
                li.add(box2);
            }
            if ((box2 = ep.func_70114_g(e)) == null || !box2.func_72326_a(box)) continue;
            li.add(box2);
        }
        return li;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean isParticle(Entity e) {
        return e instanceof EntityFX;
    }

    public static boolean applyNoclipPhase(EntityPlayer ep) {
        return ep.field_70145_X || Chromabilities.ORECLIP.enabledOn(ep);
    }

    public static AxisAlignedBB getInterceptedCollisionBox(Entity e, World world, int x, int y, int z, AxisAlignedBB def) {
        Block b = world.func_147439_a(x, y, z);
        if (b == ChromaBlocks.SELECTIVEGLASS.getBlockInstance() && (e instanceof IProjectile || e instanceof EntityFireball || e instanceof CustomProjectile) ? BlockSelectiveGlass.canEntityPass(world, x, y, z, e) : (e instanceof IProjectile || e instanceof EntityFireball || e instanceof CustomProjectile) && AbilityHelper.instance.canProjectilePenetrateBlock(world, x, y, z, b, e)) {
            return null;
        }
        if (e instanceof EntityLaserPulse && b == ChromaBlocks.LASEREFFECT.getBlockInstance()) {
            return null;
        }
        return def;
    }

    public static MovingObjectPosition getInterceptedRaytrace(Entity e, Vec3 vec1, Vec3 vec2, boolean b1, boolean b2, boolean b3, MovingObjectPosition def) {
        if ((e instanceof IProjectile || e instanceof EntityFireball || e instanceof CustomProjectile) && AbilityHelper.instance.canProjectilePenetrateBlocks(e)) {
            return AbilityHelper.instance.getProjectileRayTrace(e, vec1, vec2, b1, b2, b3);
        }
        if (e instanceof EntityLaserPulse) {
            return null;
        }
        return def;
    }

    public static BlockLootChest.TileEntityLootChest generateLootChest(World world, int x, int y, int z, int m, Random rand, String s, int bonus) {
        if (y < 0 || y > 256) {
            ChromatiCraft.logger.logError((Object)"Tried to generate a loot chest outside the map!");
            return null;
        }
        world.func_147465_d(x, y, z, ChromaBlocks.LOOTCHEST.getBlockInstance(), m, 3);
        BlockLootChest.TileEntityLootChest te = (BlockLootChest.TileEntityLootChest)world.func_147438_o(x, y, z);
        te.populateChest(s, null, bonus, rand);
        return te;
    }

    public static int groundOpacity(IBlockAccess iba, int x, int y, int z, Block b) {
        if (iba instanceof World) {
            World w = (World)iba;
            if (!(ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)w) || w.func_72912_H().func_76067_t() != WorldType.field_77138_c || !ReikaObfuscationHelper.isDeObfEnvironment())) {
                return b.func_149717_k();
            }
            if (!ReikaWorldHelper.isChunkPastNoiseGen((World)w, (int)(x >> 4), (int)(z >> 4))) {
                return b.func_149717_k();
            }
        }
        Block b2 = b;
        while (y >= 0 && (b2 == b || b2 == Blocks.field_150346_d || ReikaBlockHelper.isLiquid((Block)b2))) {
            b2 = iba.func_147439_a(x, --y, z);
        }
        return b2 == ChromaBlocks.CLIFFSTONE.getBlockInstance() && BlockCliffStone.isTransparent(iba, x, y, z) ? 0 : b.func_149717_k();
    }

    @SideOnly(value=Side.CLIENT)
    public static void onIconLoad(TextureAtlasSprite tex) {
        if (tex.func_94215_i().startsWith("chromaticraft:dimgen/glowleaf")) {
            BlockLightedLeaf.setAnimationData(tex);
        }
    }

    public static void dischargeIntoPlayer(double x, double y, double z, Random rand, EntityLivingBase e, CrystalElement color, float power, float beamSize) {
        if (e.field_70170_p.field_72995_K) {
            return;
        }
        ChromaAux.doPylonAttack(color, e, e.func_110143_aJ() / 4.0f * Math.min(1.0f, 2.0f * power));
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FIREDUMPSHOCK.ordinal(), (World)e.field_70170_p, (int)((int)x), (int)((int)y), (int)((int)z), (int)64, (int[])new int[]{color.ordinal(), e.func_145782_y(), Float.floatToRawIntBits(beamSize)});
        ReikaEntityHelper.knockbackEntityFromPos((double)x, (double)e.field_70163_u, (double)z, (Entity)e, (double)(1.5 * (double)Math.min(power * 4.0f, 1.0f)));
        e.field_70181_x += 0.125 + rand.nextDouble() * 0.0625;
        CrystalPotionController.instance.applyEffectFromColor((int)(100.0f * MathHelper.func_76131_a((float)power, (float)0.5f, (float)18.0f)), (int)(power / 2.0f), e, color, false, false, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean interceptClientChunkUpdates(ChunkProviderClient p) {
        return MonumentCompletionRitual.areRitualsRunning() ? false : p.func_73156_b();
    }

    public static void logTileCacheError(World world, WorldLocation loc, TileEntity te, ChromaTiles tile) {
        ChromatiCraft.logger.logError((Object)("Incorrect tile (" + te + ") @ " + loc + " (with " + loc.getBlockKey(world) + ") in " + tile.getName() + " cache!?"));
        if (loc.getBlock((IBlockAccess)world) == tile.getBlock() && loc.getBlockMetadata((IBlockAccess)world) == tile.getBlockMetadata()) {
            ChromatiCraft.logger.logError((Object)"Correct block and meta but no TileEntity!?!?");
        }
    }
}

