/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.ChromaHelpData;
import Reika.ChromatiCraft.Auxiliary.Interfaces.DynamicallyGeneratedSubpage;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.LoreScripts;
import Reika.ChromatiCraft.Magic.Network.RelayNetworker;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.ModInterface.Bees.TileEntityLumenAlveary;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaEnchants;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.Defence.TileEntityGuardianStone;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityToolStorage;
import Reika.DragonAPI.Instantiable.Data.Maps.PluralMap;
import Reika.DragonAPI.Instantiable.Event.Client.ResourceReloadEvent;
import Reika.DragonAPI.Instantiable.IO.XMLInterface;
import Reika.DragonAPI.Interfaces.DataProvider;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.ModList;
import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;

public final class ChromaDescriptions {
    private static String PARENT = ChromaDescriptions.getParent(true);
    private static final String DESC_SUFFIX = ":desc";
    private static final String NOTE_SUFFIX = ":note";
    private static final HashMap<ChromaResearch, String> data = new HashMap();
    private static final PluralMap<String> notes = new PluralMap(2);
    private static final HashMap<ChromaTiles, Object[]> machineData = new HashMap();
    private static final HashMap<ChromaTiles, Object[]> machineNotes = new HashMap();
    private static final HashMap<ChromaBlocks, Object[]> blockData = new HashMap();
    private static final HashMap<ChromaItems, Object[]> itemData = new HashMap();
    private static final HashMap<ChromaResearch, Object[]> miscData = new HashMap();
    private static final EnumMap<Chromabilities, Object[]> abilityData = new EnumMap(Chromabilities.class);
    private static final HashMap<String, Object[]> hoverData = new HashMap();
    private static final HashMap<CrystalElement, Object[]> elementData = new HashMap();
    private static final HashMap<String, String> hoverText = new HashMap();
    private static final EnumMap<ProgressStage, ProgressNote> progressText = new EnumMap(ProgressStage.class);
    private static final EnumMap<Chromabilities, String> abilityText = new EnumMap(Chromabilities.class);
    private static final EnumMap<CrystalElement, String> elementText = new EnumMap(CrystalElement.class);
    private static final XMLInterface machines = ChromaDescriptions.loadData("machines");
    private static final XMLInterface elements = ChromaDescriptions.loadData("elements");
    private static final XMLInterface blocks = ChromaDescriptions.loadData("blocks");
    private static final XMLInterface abilities = ChromaDescriptions.loadData("abilities");
    private static final XMLInterface structures = ChromaDescriptions.loadData("structure");
    private static final XMLInterface tools = ChromaDescriptions.loadData("tools");
    private static final XMLInterface resources = ChromaDescriptions.loadData("resource");
    private static final XMLInterface infos = ChromaDescriptions.loadData("info");
    private static final XMLInterface hover = ChromaDescriptions.loadData("hover");
    private static final XMLInterface progress = ChromaDescriptions.loadData("progression");
    private static final XMLInterface enchants = ChromaDescriptions.loadData("enchants");
    private static final XMLInterface lore = ChromaDescriptions.getLorePath().init();

    private static XMLInterface loadData(String name) {
        XMLInterface xml = new XMLInterface(ChromatiCraft.class, PARENT + name + ".xml", !ReikaObfuscationHelper.isDeObfEnvironment());
        xml.setFallback(ChromaDescriptions.getParent(false) + name + ".xml");
        xml.init();
        return xml;
    }

    private static XMLInterface getLorePath() {
        if (LoreScripts.instance.hasReroutePath()) {
            return new XMLInterface(LoreScripts.instance.getReroutedLoreFile(), true);
        }
        return new XMLInterface((DataProvider)LoreScripts.instance, true);
    }

    private static String getParent(boolean locale) {
        return locale && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? ChromaDescriptions.getLocalizedParent() : "Resources/";
    }

    @SideOnly(value=Side.CLIENT)
    private static String getLocalizedParent() {
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String lang = language.func_135034_a();
        if (ChromaDescriptions.hasLocalizedFor(language) && !"en_US".equals(lang)) {
            return "Resources/" + lang + "/";
        }
        return "Resources/";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SideOnly(value=Side.CLIENT)
    private static boolean hasLocalizedFor(Language language) {
        String lang = language.func_135034_a();
        try (InputStream o = ChromatiCraft.class.getResourceAsStream("Resources/" + lang + "/categories.xml");){
            boolean bl = o != null;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getHoverText(String key) {
        return hoverText.get(key);
    }

    private static void addData(ChromaTiles m, Object ... data) {
        machineData.put(m, data);
    }

    private static void addData(ChromaBlocks m, Object ... data) {
        blockData.put(m, data);
    }

    private static void addData(ChromaItems m, Object ... data) {
        itemData.put(m, data);
    }

    private static void addData(ChromaResearch h, Object ... data) {
        miscData.put(h, data);
    }

    private static void addData(CrystalElement e, Object ... data) {
        elementData.put(e, data);
    }

    private static void addData(Chromabilities a, Object ... data) {
        abilityData.put(a, data);
    }

    private static void addData(String s, Object ... data) {
        hoverData.put(s, data);
    }

    private static void addData(ChromaResearch h, int[] data) {
        Object[] o = new Object[data.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = data[i];
        }
        miscData.put(h, o);
    }

    private static void addNotes(ChromaTiles m, Object ... data) {
        machineNotes.put(m, data);
    }

    public static void reload() {
        PARENT = ChromaDescriptions.getParent(true);
        ChromaDescriptions.loadNumericalData();
        machines.reread();
        elements.reread();
        blocks.reread();
        abilities.reread();
        tools.reread();
        resources.reread();
        infos.reread();
        structures.reread();
        hover.reread();
        progress.reread();
        enchants.reread();
        lore.reread();
        ChromaDescriptions.loadRosetta();
        ChromaDescriptions.loadData();
    }

    @SideOnly(value=Side.CLIENT)
    private static void loadRosetta() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            LoreManager.instance.getOrCreateRosetta((EntityPlayer)Minecraft.func_71410_x().field_71439_g).loadText();
        }
    }

    private static void addEntry(ChromaResearch h, String sg) {
        data.put(h, sg);
    }

    public static void loadData() {
        int i;
        String desc;
        String desc2;
        ArrayList<ChromaResearch> infotabs = ChromaResearch.getInfoTabs();
        ArrayList<ChromaResearch> machinetabs = ChromaResearch.getMachineTabs();
        ArrayList<ChromaResearch> blocktabs = ChromaResearch.getBlockTabs();
        ArrayList<ChromaResearch> abilitytabs = ChromaResearch.getAbilityTabs();
        ArrayList<ChromaResearch> tooltabs = ChromaResearch.getToolTabs();
        ArrayList<ChromaResearch> resourcetabs = ChromaResearch.getResourceTabs();
        ArrayList<ChromaResearch> structuretabs = ChromaResearch.getStructureTabs();
        for (ChromaResearch h : machinetabs) {
            ChromaTiles m = h.getMachine();
            if (m == ChromaTiles.ADJACENCY) {
                int i2;
                ArrayList<String> pages = new ArrayList<String>();
                pages.add(DESC_SUFFIX);
                pages.add(NOTE_SUFFIX);
                for (i2 = 0; i2 < 16; ++i2) {
                    pages.add(":" + CrystalElement.elements[i2].name().toLowerCase());
                }
                i2 = 0;
                for (String s : pages) {
                    String text = machines.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + s);
                    boolean desc3 = s.equals(DESC_SUFFIX);
                    boolean note = s.equals(NOTE_SUFFIX);
                    if (desc3) {
                        text = String.format(text, machineData.get((Object)m));
                    } else if (note) {
                        text = String.format(text, machineNotes.get((Object)m));
                    }
                    if ("#NULL!".equals(text)) {
                        text = "There is no lexicon data for this machine yet.";
                    }
                    if (m.isIncomplete()) {
                        text = text + "\nThis machine is incomplete. Use at your own risk.";
                    }
                    if (desc3) {
                        ChromaDescriptions.addEntry(h, text);
                    } else {
                        notes.put((Object)text, new Object[]{h, i2 - 1});
                    }
                    ++i2;
                }
                continue;
            }
            desc2 = machines.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
            String aux = machines.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX);
            desc2 = String.format(desc2, machineData.get((Object)m));
            aux = String.format(aux, machineNotes.get((Object)m));
            if ("#NULL!".equals(desc2)) {
                desc2 = "There is no lexicon data for this machine yet.";
            }
            if (m.isDummiedOut()) {
                desc2 = desc2 + "\nThis machine is currently unavailable.";
                if (m.hasPrerequisite() && !m.getPrerequisite().isLoaded()) {
                    desc2 = desc2 + "\nThis machine depends on another mod.";
                }
                aux = aux + "\nNote: Dummied Out";
            }
            if (m.isCrystalNetworkTile()) {
                CrystalNetworkTile te = (CrystalNetworkTile)m.createTEInstanceForRender(0);
                if (te instanceof CrystalReceiver) {
                    aux = aux + String.format("Lumen Reception Range: %d m\n", ((CrystalReceiver)te).getReceiveRange());
                }
                if (te instanceof CrystalTransmitter) {
                    aux = aux + String.format("Lumen Transmission Range: %d m\n", ((CrystalTransmitter)te).getSendRange());
                }
            }
            if (m.hasPrerequisite()) {
                String sg = m.getPrerequisite().getModLabel().replaceAll("[|]", "");
                aux = aux + "\nDependencies: " + ReikaStringParser.capitalizeWords((String)ReikaStringParser.splitCamelCase((String)sg).replaceAll(" Craft", "Craft"));
            }
            if (m.isIncomplete()) {
                desc2 = desc2 + "\nThis machine is incomplete. Use at your own risk.";
            }
            while (aux.startsWith("\n")) {
                aux = aux.substring("\n".length());
            }
            ChromaDescriptions.addEntry(h, desc2);
            notes.put((Object)aux, new Object[]{h, 0});
        }
        for (ChromaResearch h : blocktabs) {
            desc = blocks.getValueAtNode("blocks:" + h.name().toLowerCase(Locale.ENGLISH));
            desc = String.format(desc, blockData.get((Object)h.getBlock()));
            ChromaDescriptions.addEntry(h, desc);
        }
        for (ChromaResearch h : tooltabs) {
            String key = "tools:" + h.name().toLowerCase(Locale.ENGLISH);
            desc2 = tools.getValueAtNode(key);
            desc2 = String.format(desc2, itemData.get((Object)h.getItem()));
            if (h.getItem().getItemInstance() instanceof DynamicallyGeneratedSubpage && ((DynamicallyGeneratedSubpage)h.getItem().getItemInstance()).replaceOriginal()) {
                DynamicallyGeneratedSubpage iw = (DynamicallyGeneratedSubpage)h.getItem().getItemInstance();
                for (int p = 0; p < iw.getMaxSubpage(); ++p) {
                    notes.put((Object)iw.getNotes(p), new Object[]{h, p});
                }
            } else if (tools.nodeExists(key + ":notes")) {
                notes.put((Object)tools.getValueAtNode(key + ":notes"), new Object[]{h, 0});
                desc2 = tools.getValueAtNode(key + DESC_SUFFIX);
            }
            ChromaDescriptions.addEntry(h, desc2);
        }
        for (ChromaResearch h : resourcetabs) {
            desc = resources.getValueAtNode("resource:" + h.name().toLowerCase(Locale.ENGLISH));
            ChromaDescriptions.addEntry(h, desc);
        }
        for (ChromaResearch h : structuretabs) {
            desc = structures.getValueAtNode("structure:" + h.name().toLowerCase(Locale.ENGLISH));
            ChromaDescriptions.addEntry(h, desc);
        }
        for (ChromaResearch h : infotabs) {
            desc = infos.getValueAtNode("info:" + h.name().toLowerCase(Locale.ENGLISH));
            desc = String.format(desc, miscData.get(h));
            ChromaDescriptions.addEntry(h, desc);
        }
        for (ChromaResearch h : abilitytabs) {
            Chromabilities a = h.getAbility();
            desc2 = abilities.getValueAtNode("ability:" + a.name().toLowerCase(Locale.ENGLISH));
            desc2 = String.format(desc2, abilityData.get(a));
            abilityText.put(a, desc2);
        }
        for (CrystalElement e : CrystalElement.elements) {
            String desc4 = elements.getValueAtNode("elements:" + e.name().toLowerCase(Locale.ENGLISH));
            desc4 = String.format(desc4, elementData.get(e));
            elementText.put(e, desc4);
        }
        Collection<String> keys = ChromaHelpData.instance.getHelpKeys();
        for (String s : keys) {
            desc2 = hover.getValueAtNode("hover:" + s);
            desc2 = String.format(desc2, hoverData.get(s));
            hoverText.put(s, desc2);
        }
        for (i = 0; i < ProgressStage.list.length; ++i) {
            ProgressStage p = ProgressStage.list[i];
            String title = progress.getValueAtNode("progression:" + p.name().toLowerCase(Locale.ENGLISH) + ":title");
            String hint = progress.getValueAtNode("progression:" + p.name().toLowerCase(Locale.ENGLISH) + ":hint");
            String reveal = progress.getValueAtNode("progression:" + p.name().toLowerCase(Locale.ENGLISH) + ":reveal");
            String desc5 = progress.getValueAtNode("progression:" + p.name().toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
            if (Strings.isNullOrEmpty((String)desc5)) {
                desc5 = reveal;
            }
            progressText.put(p, new ProgressNote(title.replaceAll("\\n", ""), hint.replaceAll("\\n", ""), reveal.replaceAll("\\n", ""), desc5.replaceAll("\\n", "")));
        }
        for (i = 0; i < ChromaEnchants.enchantmentList.length; ++i) {
            ChromaEnchants e = ChromaEnchants.enchantmentList[i];
            desc2 = enchants.getValueAtNode("enchants:" + e.name().toLowerCase(Locale.ENGLISH));
            notes.put((Object)desc2, new Object[]{ChromaResearch.ENCHANTS, i + 1});
        }
        String desc6 = enchants.getValueAtNode("enchants:boostedlevel");
        notes.put((Object)desc6, new Object[]{ChromaResearch.ENCHANTS, ChromaEnchants.enchantmentList.length + 1});
        for (int i3 = 0; i3 < LoreScripts.ScriptLocations.list.length; ++i3) {
            LoreScripts.ScriptLocations l = LoreScripts.ScriptLocations.list[i3];
            l.reload();
            String pre = "lore:" + l.name().toLowerCase(Locale.ENGLISH);
            Collection li = lore.getNodesWithin(pre);
            for (String s : li) {
                l.loadText(lore.getValueAtNode(s));
            }
        }
    }

    public static String getAbilityDescription(Chromabilities c) {
        String s = abilityText.get(c);
        return s != null ? s : "This ability has no lexicon info yet.";
    }

    public static String getElementDescription(CrystalElement e) {
        return elementText.get(e);
    }

    public static String getData(ChromaResearch h) {
        if (h.getAbility() != null) {
            return abilityText.get(h.getAbility());
        }
        if (!data.containsKey(h)) {
            return "This item has no lexicon info yet.";
        }
        return data.get(h);
    }

    public static String getNotes(ChromaResearch h, int page) {
        if (!notes.containsKeyV(new Object[]{h, page})) {
            return "";
        }
        return (String)notes.get(new Object[]{h, page});
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerReloadListener() {
        MinecraftForge.EVENT_BUS.register((Object)new ReloadListener());
    }

    private static void loadNumericalData() {
        ChromaDescriptions.addData(ChromaTiles.WEAKREPEATER, 48);
        ChromaDescriptions.addData(ChromaTiles.LASER, 128);
        ChromaDescriptions.addData(ChromaTiles.BEACON, CrystalElement.RED.displayName);
        ChromaDescriptions.addData(ChromaTiles.LIGHTER, CrystalElement.BLUE.displayName);
        ChromaDescriptions.addNotes(ChromaTiles.ADJACENCY, 8);
        ChromaDescriptions.addNotes(ChromaTiles.ENCHANTER, 500);
        ChromaDescriptions.addNotes(ChromaTiles.GUARDIAN, TileEntityGuardianStone.RANGE);
        ChromaDescriptions.addNotes(ChromaTiles.TANK, 4, 2000000);
        ChromaDescriptions.addNotes(ChromaTiles.CHARGER, 120000);
        ChromaDescriptions.addNotes(ChromaTiles.FURNACE, 2);
        ChromaDescriptions.addNotes(ChromaTiles.FABRICATOR, 400, Float.valueOf(0.5f), 5);
        ChromaDescriptions.addNotes(ChromaTiles.BEACON, 100, 2, 64);
        ChromaDescriptions.addNotes(ChromaTiles.COLLECTOR, 1);
        ChromaDescriptions.addNotes(ChromaTiles.ITEMCOLLECTOR, 24);
        ChromaDescriptions.addNotes(ChromaTiles.LAMP, 8);
        ChromaDescriptions.addNotes(ChromaTiles.POWERTREE, 1000, 4000, 3);
        ChromaDescriptions.addNotes(ChromaTiles.LAMPCONTROL, 64, 999);
        ChromaDescriptions.addNotes(ChromaTiles.ASPECTJAR, 6000, 500);
        ChromaDescriptions.addNotes(ChromaTiles.WIRELESS, ChromaStructures.WIRELESSPEDESTAL.getDisplayName(), ChromaTiles.WIRELESS.getName());
        if (ModList.FORESTRY.isLoaded()) {
            ChromaDescriptions.addNotes(ChromaTiles.ALVEARY, TileEntityLumenAlveary.getEffectsAsString());
        }
        ChromaDescriptions.addNotes(ChromaTiles.TOOLSTORAGE, TileEntityToolStorage.ToolType.getTypesAsString());
        ChromaDescriptions.addNotes(ChromaTiles.ITEMRIFT, CrystalElement.LIME.displayName);
        ChromaDescriptions.addData(ChromaBlocks.RELAY, RelayNetworker.instance.maxRange);
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if (e == CrystalElement.LIGHTGRAY) {
                ChromaDescriptions.addData(e, e.displayName, CrystalElement.WHITE.displayName);
                continue;
            }
            ChromaDescriptions.addData(e, e.displayName);
        }
        ChromaDescriptions.addData(ChromaItems.SHARE, ChromaTiles.TABLE.getName(), ChromaTiles.RITUAL.getName());
        ChromaDescriptions.addData(Chromabilities.REACH, 128);
        ChromaDescriptions.addData(Chromabilities.LIFEPOINT, CrystalElement.MAGENTA.displayName);
        miscData.put(ChromaResearch.ENCHANTS, new Object[]{ChromaTiles.ENCHANTER.getName()});
    }

    public static String getParentPage() {
        return PARENT;
    }

    public static ProgressNote getProgressText(ProgressStage p) {
        return progressText.containsKey(p) ? progressText.get(p) : new ProgressNote("#NULL", "#NULL", "#NULL", "#NULL");
    }

    public static boolean isUnfilled(String s) {
        return s == null || s.isEmpty() || s.endsWith("#NULL!");
    }

    static {
        ChromaDescriptions.loadNumericalData();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ChromaDescriptions.registerReloadListener();
        }
    }

    public static class ProgressNote {
        public final String title;
        public final String hint;
        public final String reveal;
        public final String desc;

        private ProgressNote(String t, String h, String rvl, String desc) {
            this.title = t;
            this.hint = h;
            this.reveal = rvl;
            this.desc = desc;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final class ReloadListener {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void reload(ResourceReloadEvent evt) {
            ChromaDescriptions.reload();
        }
    }
}

