/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.HoldingChecks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.FocusAcceleratable;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityBallLightning;
import Reika.ChromatiCraft.Magic.CrystalTarget;
import Reika.ChromatiCraft.Magic.Interfaces.ChargingPoint;
import Reika.ChromatiCraft.Magic.Network.TargetData;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityChromaFluidFX;
import Reika.ChromatiCraft.Render.Particle.EntityFlareFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.Render.Particle.EntityRelayPathFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityAtmosphericRelay;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityFluidFX;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Instantiable.ParticleController.EntityLockMotionController;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ChromaFX {
    private static final Random rand = new Random();
    private static final ColorBlendList FOCUS_CRYSTAL_PARTICLES = new ColorBlendList(6.0f, new int[]{0x45FF45, 0x45FF45, 0x45FF45, 0xFF4040, 0xFF4040, 0xFF4040, 0xFF4040, 0xFF4040, 0xFF4040, 0x22AAFF, 0x22AAFF, 0x22AAFF, 0x22AAFF, 11673855, 11673855});

    public static void drawFillBar(CrystalElement e, int x, int y, int w, int h, float f) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/bartex.png");
        float u = (float)e.ordinal() / 16.0f;
        float du = u + Math.min(0.0625f, (float)w / 512.0f);
        float v = 0.0f;
        float dv = (float)h / 128.0f;
        f = Math.min(f, 1.0f);
        int dh = (int)(f * (float)h);
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78378_d(0xFFFFFF);
        v5.func_78380_c(240);
        v5.func_78374_a((double)x, (double)(y + h), 0.0, (double)u, (double)dv);
        v5.func_78374_a((double)(x + w), (double)(y + h), 0.0, (double)du, (double)dv);
        v5.func_78374_a((double)(x + w), (double)y, 0.0, (double)du, (double)v);
        v5.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)v);
        v5.func_78381_a();
        GL11.glDisable((int)3553);
        v5.func_78382_b();
        v5.func_78378_d(e.getColor());
        v5.func_78380_c(240);
        v5.func_78377_a((double)x, (double)(y + h), 0.0);
        v5.func_78377_a((double)(x + w), (double)(y + h), 0.0);
        v5.func_78377_a((double)(x + w), (double)(y + h - dh), 0.0);
        v5.func_78377_a((double)x, (double)(y + h - dh), 0.0);
        v5.func_78381_a();
        GL11.glPopAttrib();
    }

    public static void drawHorizontalFillBar(CrystalElement e, int x, int y, int w, int h, float f) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/bartex.png");
        float u = (float)e.ordinal() / 16.0f;
        float du = u + Math.min(0.0625f, (float)h / 512.0f);
        float v = 0.0f;
        float dv = (float)w / 128.0f;
        f = Math.min(f, 1.0f);
        int dw = (int)(f * (float)w);
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78378_d(0xFFFFFF);
        v5.func_78380_c(240);
        v5.func_78374_a((double)x, (double)(y + h), 0.0, (double)du, (double)dv);
        v5.func_78374_a((double)(x + w), (double)(y + h), 0.0, (double)du, (double)v);
        v5.func_78374_a((double)(x + w), (double)y, 0.0, (double)u, (double)v);
        v5.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)dv);
        v5.func_78381_a();
        GL11.glDisable((int)3553);
        v5.func_78382_b();
        v5.func_78378_d(e.getColor());
        v5.func_78380_c(240);
        v5.func_78377_a((double)x, (double)(y + h), 0.0);
        v5.func_78377_a((double)(x + dw), (double)(y + h), 0.0);
        v5.func_78377_a((double)(x + dw), (double)y, 0.0);
        v5.func_78377_a((double)x, (double)y, 0.0);
        v5.func_78381_a();
        GL11.glPopAttrib();
    }

    public static void poolRecipeParticles(EntityItem ei) {
        double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
        double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
        double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
        float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.5);
        EntityChromaFluidFX fx = new EntityChromaFluidFX(ei.field_70170_p, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, vx, vy, vz).setGravity(0.125f).setScale(s);
        fx.field_70145_X = true;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public static void createPylonChargeBeam(ChargingPoint te, EntityPlayer ep, double dist, CrystalElement e) {
        Coordinate loc = te.getChargeParticleOrigin(ep, e);
        int sx = loc.xCoord;
        int sy = loc.yCoord;
        int sz = loc.zCoord;
        double dx = ep.field_70165_t - (double)sx - 0.5;
        double dy = ep.field_70163_u - 0.125 - (double)sy - 0.5;
        double dz = ep.field_70161_v - (double)sz - 0.5;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double r = 0.0;
        double ox = 0.0 * Math.sin(Math.toRadians((double)ep.field_70759_as + 22.5)) * Math.abs(Math.cos(ep.field_70125_A));
        double oy = -0.0625;
        double oz = 0.0 * Math.cos(Math.toRadians((double)ep.field_70759_as + 22.5)) * Math.abs(Math.cos(ep.field_70125_A));
        double x = (double)sx + 0.5 + (dx + ox) * r;
        double y = (double)sy + 0.5 + dy * r;
        double z = (double)sz + 0.5 + (dz + oz) * r;
        double dx2 = dx + ox;
        double dy2 = dy + oy;
        double dz2 = dz + oz;
        double v = 0.125;
        double vx = dx2 / dd * v;
        double vy = dy2 / dd * v;
        double vz = dz2 / dd * v;
        float s = (float)(1.875 + 0.5 * Math.sin(Math.toRadians(dist * 360.0)));
        EntityLockMotionController m = new EntityLockMotionController((Entity)ep, 0.00390625, 0.5, 0.875);
        EntityBlurFX fx = new EntityCCBlurFX(e, te.getWorld(), x, y, z, 0.0, 0.0, 0.0).setScale(s).setNoSlowdown().setLife((int)dd * 10).setMotionController((MotionController)m);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public static void killPylonChargeBeam(TileEntityCrystalPylon te, EntityPlayer ep) {
    }

    public static int getBlendedColorFromElementList(List<CrystalElement> li, double tick, double cycleModulus) {
        if (li.isEmpty()) {
            return 0;
        }
        int f1 = (int)(tick / cycleModulus);
        f1 = (f1 + li.size()) % li.size();
        int c1 = li.get(f1 % li.size()).getColor();
        int c2 = li.get((f1 + 1) % li.size()).getColor();
        float f = (float)(tick % cycleModulus / cycleModulus);
        return ReikaColorAPI.mixColors((int)c1, (int)c2, (float)(1.0f - f));
    }

    public static void drawLeyLineParticles(World world, int x, int y, int z, double r, Collection<CrystalTarget> li) {
        if (!li.isEmpty()) {
            double t = (double)System.currentTimeMillis() / 600.0 % 360.0 + 2.0;
            t /= 30.0;
            MultiMap<TargetData, CrystalElement> map = ChromaAux.getBeamColorMixes(li);
            Minecraft mc = Minecraft.func_71410_x();
            int p = mc.field_71474_y.field_74362_aa;
            for (TargetData pos : map.keySet()) {
                if (pos.targetClass == TileEntityAtmosphericRelay.class || !pos.isRenderable() || !pos.isMaximumEndpointDistanceWithin((EntityPlayer)mc.field_71439_g, 512.0)) continue;
                List lc = (List)map.get((Object)pos);
                int clr = ChromaFX.getBlendedColorFromElementList(lc, t, 0.125);
                if (rand.nextInt(1 + p * 3) != 0) continue;
                double dx = pos.position.xCoord - (double)x - 0.5;
                double dy = pos.position.yCoord - (double)y - 0.5;
                double dz = pos.position.zCoord - (double)z - 0.5;
                double dr = rand.nextDouble();
                float s = (float)(42.85714285714286 * ReikaMathLibrary.linterpolate((double)dr, (double)0.0, (double)1.0, (double)Math.min(pos.maximumWidth, r), (double)Math.min(pos.maximumWidth, pos.targetWidth)));
                double px = dx * dr + (double)x + 0.5;
                double py = dy * dr + (double)y + 0.5;
                double pz = dz * dr + (double)z + 0.5;
                EntityLaserFX fx = new EntityLaserFX(CrystalElement.WHITE, world, px, py, pz).setScale(s).setColor(clr);
                mc.field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public static void drawEnergyTransferBeams(WorldLocation src, double r, Collection<CrystalTarget> li) {
        if (!li.isEmpty()) {
            double t = (double)System.currentTimeMillis() / 600.0 % 360.0;
            ChromaFX.drawEnergyTransferBeams(src, li, r, 6, t /= 30.0);
        }
    }

    public static void drawEnergyTransferBeams(WorldLocation src, Collection<CrystalTarget> li, double r0, int sides, double tick) {
        if (!li.isEmpty()) {
            GL11.glPushAttrib((int)1048575);
            ReikaRenderHelper.disableLighting();
            GL11.glDisable((int)2884);
            GL11.glShadeModel((int)7425);
            Tessellator v5 = Tessellator.field_78398_a;
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"/Reika/ChromatiCraft/Textures/beam.png");
            double r = r0;
            MultiMap<TargetData, CrystalElement> map = ChromaAux.getBeamColorMixes(li);
            for (TargetData pos : map.keySet()) {
                if (!pos.isRenderable()) continue;
                r = Math.min(r, pos.maximumWidth);
                List lc = (List)map.get((Object)pos);
                int clr = ChromaFX.getBlendedColorFromElementList(lc, tick, 0.125);
                if (pos.targetClass == TileEntityAtmosphericRelay.class) {
                    GL11.glPushAttrib((int)1048575);
                    GL11.glEnable((int)3042);
                    ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"/Reika/ChromatiCraft/Textures/beam_trans.png");
                    DecimalPosition pos2 = DecimalPosition.interpolate((double)((double)src.xCoord + 0.5), (double)((double)src.yCoord + 0.5), (double)((double)src.zCoord + 0.5), (double)pos.position.xCoord, (double)pos.position.yCoord, (double)pos.position.zCoord, (double)0.5).offset(0.0, 192.0, 0.0);
                    ChromaFX.drawEnergyTransferBeam(src, pos2, clr, r, Math.min(pos.maximumWidth, pos.targetWidth), sides, tick, false);
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)(pos2.xCoord - (double)src.xCoord - 0.5), (double)(pos2.yCoord - (double)src.yCoord - 0.5), (double)(pos2.zCoord - (double)src.zCoord - 0.5));
                    ChromaFX.drawEnergyTransferBeam(pos2, pos.position, clr, r, Math.min(pos.maximumWidth, pos.targetWidth), sides, tick, false);
                    GL11.glPopMatrix();
                    ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"/Reika/ChromatiCraft/Textures/beam.png");
                    GL11.glPopAttrib();
                    continue;
                }
                ChromaFX.drawEnergyTransferBeam(src, pos.position, clr, r, Math.min(pos.maximumWidth, pos.targetWidth), sides, tick, false);
            }
            GL11.glShadeModel((int)7424);
            GL11.glPopAttrib();
        }
    }

    public static void drawEnergyTransferBeam(WorldLocation src, DecimalPosition tgt, int color, double r1, double r2, int sides, double tick, boolean spiralTex) {
        ChromaFX.drawEnergyTransferBeam((double)src.xCoord + 0.5, (double)src.yCoord + 0.5, (double)src.zCoord + 0.5, tgt.xCoord, tgt.yCoord, tgt.zCoord, color, color, r1, r2, sides, tick, spiralTex);
    }

    public static void drawEnergyTransferBeam(DecimalPosition src, DecimalPosition tgt, int color, double r1, double r2, int sides, double tick, boolean spiralTex) {
        ChromaFX.drawEnergyTransferBeam(src.xCoord, src.yCoord, src.zCoord, tgt.xCoord, tgt.yCoord, tgt.zCoord, color, color, r1, r2, sides, tick, spiralTex);
    }

    public static void drawEnergyTransferBeam(DecimalPosition src, DecimalPosition tgt, int color1, int color2, double r1, double r2, int sides, double tick, boolean spiralTex) {
        ChromaFX.drawEnergyTransferBeam(src.xCoord, src.yCoord, src.zCoord, tgt.xCoord, tgt.yCoord, tgt.zCoord, color1, color2, r1, r2, sides, tick, spiralTex);
    }

    public static void drawEnergyTransferBeam(double x1, double y1, double z1, double x2, double y2, double z2, int color1, int color2, double r1, double r2, int sides, double tick, boolean spiralTex) {
        Tessellator v5 = Tessellator.field_78398_a;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        GL11.glPushMatrix();
        double f7 = Math.sqrt(dx * dx + dz * dz);
        double f8 = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double ang1 = -Math.atan2(dz, dx) * 180.0 / Math.PI - 90.0;
        double ang2 = -Math.atan2(f7, dy) * 180.0 / Math.PI - 90.0;
        GL11.glRotated((double)ang1, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)ang2, (double)1.0, (double)0.0, (double)0.0);
        v5.func_78371_b(5);
        v5.func_78380_c(240);
        for (int i = 0; i <= sides; ++i) {
            double f11a = r1 * Math.sin((double)(i % sides) * Math.PI * 2.0 / (double)sides) * 0.75;
            double f12a = r1 * Math.cos((double)(i % sides) * Math.PI * 2.0 / (double)sides) * 0.75;
            double f11b = r2 * Math.sin((double)(i % sides) * Math.PI * 2.0 / (double)sides) * 0.75;
            double f12b = r2 * Math.cos((double)(i % sides) * Math.PI * 2.0 / (double)sides) * 0.75;
            double f13 = i % sides * 1 / sides;
            double d = spiralTex ? (double)i / (double)sides : 0.0;
            v5.func_78378_d(color1);
            v5.func_78374_a(f11a, f12a, 0.0, tick + d, tick + 1.0 + d);
            v5.func_78378_d(color2);
            v5.func_78374_a(f11b, f12b, f8, tick + 1.0 + d, tick + d);
        }
        v5.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void spawnRelayParticle(CrystalElement e, ArrayList<Coordinate> li) {
        while (li.size() > 1) {
            EntityRelayPathFX fx = new EntityRelayPathFX(e, li.get(0), li.get(1));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            li.remove(0);
        }
    }

    public static void doShardBoostingFX(EntityItem ei) {
        CrystalElement e = CrystalElement.elements[ei.func_92059_d().func_77960_j()];
        double rx = ReikaRandomHelper.getRandomPlusMinus((double)ei.field_70165_t, (double)0.5);
        double ry = ei.field_70163_u;
        double rz = ReikaRandomHelper.getRandomPlusMinus((double)ei.field_70161_v, (double)0.5);
        double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityRuneFX(ei.field_70170_p, rx, ry, rz, 0.0, vy, 0.0, e));
    }

    public static void spawnShardBoostedEffects(EntityItem ei) {
        for (int i = 0; i < 16; ++i) {
            double rx = ei.field_70165_t;
            double ry = ei.field_70163_u;
            double rz = ei.field_70161_v;
            CrystalElement e = CrystalElement.elements[ei.func_92059_d().func_77960_j()];
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityFlareFX(e, ei.field_70170_p, rx, ry, rz, vx, vy, vz));
        }
    }

    public static void doDashParticles(World world, EntityPlayer e, boolean offset) {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DASH, (Entity)Minecraft.func_71410_x().field_71439_g, (float)1.0f, (float)1.0f, (boolean)false);
        double x = e.field_70165_t;
        double y = e.field_70163_u;
        double z = e.field_70161_v;
        if (offset) {
            y += 1.62;
        }
        double angX = Math.cos(Math.toRadians(e.field_70759_as + 90.0f));
        double angZ = Math.sin(Math.toRadians(e.field_70759_as + 90.0f));
        double leftX = Math.cos(Math.toRadians(e.field_70759_as));
        double leftZ = Math.sin(Math.toRadians(e.field_70759_as));
        int n = 128;
        double dd = 26.0;
        for (int i = 0; i < n; ++i) {
            double d = rand.nextDouble() * dd;
            double py = y - 1.0 + rand.nextDouble() * 1.85;
            double px = x + d * angX + ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.25) * Math.abs(leftX);
            double pz = z + d * angZ + ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)1.25) * Math.abs(leftZ);
            double v = 0.125;
            double vx = v * angX;
            double vz = v * angZ;
            int l = 15 + rand.nextInt(25);
            float s = 1.0f + rand.nextFloat();
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz, vx, 0.0, vz).setScale(s).setLife(l);
            EntityBlurFX fx2 = new EntityCCBlurFX(world, px, py, pz, -vx, 0.0, -vz).setScale(s).setLife(l);
            switch (rand.nextInt(3)) {
                case 0: {
                    fx.setColor(255, 255, 255);
                    fx2.setColor(255, 255, 255);
                    break;
                }
                case 1: {
                    fx.setColor(96, 192, 255);
                    fx2.setColor(96, 192, 255);
                    break;
                }
                case 2: {
                    fx.setColor(0, 255, 0);
                    fx2.setColor(0, 255, 0);
                }
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doGrowthWandParticles(World world, int x, int y, int z) {
        double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.0625);
        double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.1875, (double)0.0625);
        double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.0625);
        EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.125, (double)z + 0.5, vx, vy, vz).setColor(0, 192, 0).setScale(1.0f).setLife(20).setGravity(0.25f);
        fx.field_70145_X = true;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @SideOnly(value=Side.CLIENT)
    public static void doGluonClientside(World world, int e1, int e2) {
        EntityBallLightning src = (EntityBallLightning)world.func_73045_a(e1);
        EntityBallLightning tgt = (EntityBallLightning)world.func_73045_a(e2);
        if (src == null || tgt == null) {
            return;
        }
        Vec3 vec = ReikaVectorHelper.getVec2Pt((double)src.field_70165_t, (double)src.field_70163_u, (double)src.field_70161_v, (double)tgt.field_70165_t, (double)tgt.field_70163_u, (double)tgt.field_70161_v);
        double lenv = vec.func_72433_c();
        float i = 0.0f;
        while ((double)i <= lenv) {
            double f = (double)i / lenv;
            double ddx = src.field_70165_t + vec.field_72450_a * f;
            double ddy = src.field_70163_u + vec.field_72448_b * f;
            double ddz = src.field_70161_v + vec.field_72449_c * f;
            int c = ReikaColorAPI.mixColors((int)tgt.getRenderColor(), (int)src.getRenderColor(), (float)((float)f));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityCCBlurFX(world, ddx, ddy, ddz).setColor(c).setLife(8));
            i = (float)((double)i + 0.125);
        }
        src.doBoltClient(tgt);
        tgt.doBoltClient(src);
    }

    public static int[] getChromaColorTiles() {
        int[] arr = new int[]{9756252, 12964977, 15122834, 16361904, 16682184, 16544213, 15753688, 13984721, 11302592, 7508138, 2664338, 46977, 50302, 1625483, 5820319, 9881778, 12500160, 14266056, 15310536, 15765697, 15566773, 14780072, 13536156, 11834774, 9937560, 7908768, 6338218, 5684661, 6340796, 7847870, 0x8FB8BB, 10005690};
        int[] arr2 = Arrays.copyOf(arr, arr.length);
        ArrayUtils.reverse((int[])arr2);
        return ArrayUtils.addAll((int[])arr, (int[])arr2);
    }

    public static void drawRadialFillbar(double frac, int tintColor, boolean segments) {
        double u = 0.0;
        double du = 0.5;
        double v = segments ? 0.5 : 0.0;
        double dv = v + 0.5;
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/radialfill.png");
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78380_c(240);
        v5.func_78378_d(0xFFFFFF);
        v5.func_78374_a(-1.0, 1.0, 0.0, u, dv);
        v5.func_78374_a(1.0, 1.0, 0.0, du, dv);
        v5.func_78374_a(1.0, -1.0, 0.0, du, v);
        v5.func_78374_a(-1.0, -1.0, 0.0, u, v);
        v5.func_78381_a();
        v5.func_78371_b(6);
        v5.func_78380_c(240);
        v5.func_78378_d(tintColor);
        u = 0.75;
        v5.func_78374_a(0.0, 0.0, 0.0, u, v += 0.25);
        double ma = 360.0 * frac;
        double da = 0.25;
        for (double a = 0.0; a < ma; a += da) {
            double x = Math.sin(Math.toRadians(a + 90.0));
            double y = Math.cos(Math.toRadians(a + 90.0));
            du = u + x * 0.25;
            dv = v + y * 0.25;
            v5.func_78374_a(x, y, 0.0, du, dv);
        }
        v5.func_78381_a();
    }

    public static void renderBeam(double x1, double y1, double z1, double x2, double y2, double z2, float par8, int a, double h) {
        ChromaFX.renderBeam(x1, y1, z1, x2, y2, z2, par8, a, h, 0xFFFFFF);
    }

    public static void renderBeam(double x1, double y1, double z1, double x2, double y2, double z2, float par8, int a, double h, int baseColor) {
        ChromaFX.renderBeam(x1, y1, z1, x2, y2, z2, par8, a, h, baseColor, baseColor);
    }

    public static void renderBeam(double x1, double y1, double z1, double x2, double y2, double z2, float par8, int a, double h, int c1, int c2) {
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        if (c1 != c2) {
            GL11.glShadeModel((int)7425);
        }
        v5.func_78371_b(1);
        v5.func_78380_c(240);
        v5.func_78384_a(c1, 255);
        v5.func_78377_a(x1, y1, z1);
        if (c1 != c2) {
            v5.func_78384_a(c2, 255);
        }
        v5.func_78377_a(x2, y2, z2);
        v5.func_78381_a();
        GL11.glEnable((int)3553);
        ReikaTextureHelper.bindTerrainTexture();
        IIcon ico = ChromaIcons.LASER.getIcon();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        double dd = ReikaMathLibrary.py3d((double)(x2 - x1), (double)(y2 - y1), (double)(z2 - z1));
        int n = (int)dd;
        double dn = dd - (double)n;
        GL11.glPushMatrix();
        v5.func_78382_b();
        v5.func_78380_c(240);
        if (c1 == c2) {
            v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)c1, (float)((float)a / 255.0f)), a);
        }
        for (double d = 0.0; d < (double)n; d += 1.0) {
            int cb;
            double nx = x1 + (x2 - x1) * d / dd;
            double ny = y1 + (y2 - y1) * d / dd;
            double nz = z1 + (z2 - z1) * d / dd;
            double px = x1 + (x2 - x1) * (d + 1.0) / dd;
            double py = y1 + (y2 - y1) * (d + 1.0) / dd;
            double pz = z1 + (z2 - z1) * (d + 1.0) / dd;
            int ca = c1 != c2 ? ReikaColorAPI.mixColors((int)c1, (int)c2, (float)(1.0f - (float)(d / dd))) : c1;
            int n2 = cb = c1 != c2 ? ReikaColorAPI.mixColors((int)c1, (int)c2, (float)(1.0f - (float)((d + 1.0) / dd))) : c1;
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)ca, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(nx, ny - h, nz, (double)u, (double)v);
            v5.func_78374_a(nx, ny + h, nz, (double)u, (double)dv);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)cb, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(px, py + h, pz, (double)du, (double)dv);
            v5.func_78374_a(px, py - h, pz, (double)du, (double)v);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)ca, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(nx - h, ny, nz, (double)u, (double)v);
            v5.func_78374_a(nx + h, ny, nz, (double)u, (double)dv);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)cb, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(px + h, py, pz, (double)du, (double)dv);
            v5.func_78374_a(px - h, py, pz, (double)du, (double)v);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)ca, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(nx, ny, nz - h, (double)u, (double)v);
            v5.func_78374_a(nx, ny, nz + h, (double)u, (double)dv);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)cb, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(px, py, pz + h, (double)du, (double)dv);
            v5.func_78374_a(px, py, pz - h, (double)du, (double)v);
        }
        if (dn > 0.0) {
            int cb;
            double nx = x1 + (x2 - x1) * (double)n / dd;
            double ny = y1 + (y2 - y1) * (double)n / dd;
            double nz = z1 + (z2 - z1) * (double)n / dd;
            double px = x1 + (x2 - x1) * (dn + (double)n) / dd;
            double py = y1 + (y2 - y1) * (dn + (double)n) / dd;
            double pz = z1 + (z2 - z1) * (dn + (double)n) / dd;
            int ca = c1 != c2 ? ReikaColorAPI.mixColors((int)c1, (int)c2, (float)(1.0f - (float)((double)n / dd))) : c1;
            int n3 = cb = c1 != c2 ? c2 : c1;
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)ca, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(nx, ny - h, nz, (double)u, (double)v);
            v5.func_78374_a(nx, ny + h, nz, (double)u, (double)dv);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)cb, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(px, py + h, pz, (double)du, (double)dv);
            v5.func_78374_a(px, py - h, pz, (double)du, (double)v);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)ca, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(nx - h, ny, nz, (double)u, (double)v);
            v5.func_78374_a(nx + h, ny, nz, (double)u, (double)dv);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)cb, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(px + h, py, pz, (double)du, (double)dv);
            v5.func_78374_a(px - h, py, pz, (double)du, (double)v);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)ca, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(nx, ny, nz - h, (double)u, (double)v);
            v5.func_78374_a(nx, ny, nz + h, (double)u, (double)dv);
            if (c1 != c2) {
                v5.func_78384_a(ReikaColorAPI.getColorWithBrightnessMultiplier((int)cb, (float)((float)a / 255.0f)), a);
            }
            v5.func_78374_a(px, py, pz + h, (double)du, (double)dv);
            v5.func_78374_a(px, py, pz - h, (double)du, (double)v);
        }
        v5.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public static void renderBolt(LightningBolt b, float par8, int a, double h, int splinePoints) {
        ChromaFX.renderBolt(b, par8, a, h, splinePoints, 0xFFFFFF);
    }

    public static void renderBolt(LightningBolt b, float par8, int a, double h, int splinePoints, int color) {
        if (splinePoints > 2) {
            Spline s = new Spline(Spline.SplineType.CENTRIPETAL);
            for (int i = 0; i <= b.nsteps; ++i) {
                DecimalPosition pos = b.getPosition(i);
                s.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(pos));
            }
            List li = s.get(splinePoints, false);
            for (int i = 0; i < li.size() - 1; ++i) {
                DecimalPosition pos1 = (DecimalPosition)li.get(i);
                DecimalPosition pos2 = (DecimalPosition)li.get(i + 1);
                ChromaFX.renderBeam(pos1.xCoord, pos1.yCoord, pos1.zCoord, pos2.xCoord, pos2.yCoord, pos2.zCoord, par8, a, h, color);
            }
        } else {
            for (int i = 0; i < b.nsteps; ++i) {
                DecimalPosition pos1 = b.getPosition(i);
                DecimalPosition pos2 = b.getPosition(i + 1);
                ChromaFX.renderBeam(pos1.xCoord, pos1.yCoord, pos1.zCoord, pos2.xCoord, pos2.yCoord, pos2.zCoord, par8, a, h, color);
            }
        }
    }

    public static void doFocusCrystalParticles(World world, int x, int y, int z, FocusAcceleratable fa) {
        if (HoldingChecks.FOCUSCRYSTAL.isClientHolding()) {
            Collection<Coordinate> set = fa.getRelativeFocusCrystalLocations();
            for (Coordinate c : set) {
                double dx = (double)(x + c.xCoord) + 0.5;
                double dy = (double)(y + c.yCoord) + 0.125;
                double dz = (double)(z + c.zCoord) + 0.5;
                int n = ReikaRandomHelper.getRandomBetween((int)1, (int)3);
                for (int i = 0; i < n; ++i) {
                    boolean ctr = rand.nextInt(3) == 0;
                    double px = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)0.03125);
                    double py = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)0.03125);
                    double pz = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)0.03125);
                    double ang = (double)world.func_82737_E() / 2.0 % 360.0;
                    int split = 6;
                    double dAng = 360.0 / (double)split * (double)rand.nextInt(split);
                    ang = (ang + dAng) % 360.0;
                    ang = ReikaRandomHelper.getRandomPlusMinus((double)ang, (double)6.0);
                    if (!ctr) {
                        double d = ReikaRandomHelper.getRandomBetween((double)0.15, (double)0.25);
                        double[] off = ReikaPhysicsHelper.polarToCartesian((double)d, (double)0.0, (double)ang);
                        px += off[0];
                        pz += off[2];
                    }
                    double vel = ctr ? 0.0 : ReikaRandomHelper.getRandomBetween((double)0.015, (double)0.03);
                    double[] v = ReikaPhysicsHelper.polarToCartesian((double)vel, (double)0.0, (double)ang);
                    float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.0, (double)0.125));
                    int l = ReikaRandomHelper.getRandomBetween((int)8, (int)40);
                    float s = (float)ReikaRandomHelper.getRandomBetween((double)0.25, (double)1.25);
                    int clr = FOCUS_CRYSTAL_PARTICLES.getColor((double)world.func_82737_E() / 8.0);
                    EntityCCBlurFX fx = new EntityCCBlurFX(world, px, py, pz, v[0], v[1], v[2]);
                    ChromaIcons ico = ChromaIcons.FADE;
                    switch (rand.nextInt(4)) {
                        case 0: {
                            ico = ChromaIcons.NODE2;
                            break;
                        }
                        case 1: {
                            ico = ChromaIcons.FLARE;
                        }
                    }
                    fx.setIcon(ico).setColor(clr).setLife(l).setScale(s).setGravity(g).setRapidExpand().setAlphaFading();
                    EntityCCBlurFX fx2 = new EntityCCBlurFX(world, px, py, pz, v[0], v[1], v[2]);
                    fx2.setIcon(ico).setColor(0xFFFFFF).setLife(l).setScale(s * 0.6f).setGravity(g).setRapidExpand().setAlphaFading().lockTo((EntityFX)fx);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
                }
            }
        }
    }

    public static void dischargeIntoPlayerFX(World world, int x, int y, int z, CrystalElement e, EntityLivingBase ep, float beamSize) {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.MONUMENTRAY, (Entity)ep, (float)1.0f, (float)((float)CrystalMusicManager.instance.getDingPitchScale(e)), (boolean)false);
        ChromaFX.doBoltFX(world, x, y, z, new DecimalPosition((Entity)ep).offset(0.0, -0.25, 0.0), e.getColor(), beamSize, 1.0);
    }

    public static void doBoltFX(World world, int x, int y, int z, DecimalPosition p2, int color, float beamSize, double varScale) {
        int n = 4 + world.field_73012_v.nextInt(4);
        LightningBolt b = new LightningBolt(new DecimalPosition((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), p2, n);
        b.scaleVariance(0.5 * varScale);
        b.maximize();
        for (int i = 0; i < b.nsteps; ++i) {
            DecimalPosition pos1 = b.getPosition(i);
            DecimalPosition pos2 = b.getPosition(i + 1);
            for (double r = 0.0; r <= 1.0; r += 0.03125) {
                double f = (double)i + r;
                float s = 1.75f * beamSize;
                int l = 20;
                int a = (int)(2.0 * f);
                DecimalPosition dd = DecimalPosition.interpolate((DecimalPosition)pos1, (DecimalPosition)pos2, (double)r);
                EntityBlurFX fx = new EntityCCBlurFX(world, dd.xCoord, dd.yCoord, dd.zCoord).setScale(s).setColor(color).setLife(l).setRapidExpand().freezeLife(a);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public static void doElementalParticle(World world, double x, double y, double z, CrystalElement e, double s, double vy, int l) {
        EntityRuneFX fx = new EntityRuneFX(world, x, y, z, 0.0, vy, 0.0, e).setGravity(0.0f).setScale((float)s).setLife(l);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public static boolean cancelParticleBlockCollision(World world, int x, int y, int z, Block block, Entity fx) {
        return block == ChromaBlocks.TANK.getBlockInstance() && (fx instanceof EntityFluidFX || fx instanceof EntityChromaFluidFX);
    }
}

