/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Block.Worldgen.BlockDecoFlower;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredPlant;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ChromaHelpData {
    public static final ChromaHelpData instance = new ChromaHelpData();
    private final BlockMap<HelpKey> data = new BlockMap();
    private static final String NBT_TAG = "ChromaExploreHelp";

    private ChromaHelpData() {
        int i;
        this.addKey(ChromaBlocks.CRYSTAL, "crystals");
        this.addKey(ChromaBlocks.RAINBOWLEAF, "rainbowleaf");
        this.addKey(ChromaBlocks.DYELEAF, "dyeleaf");
        this.addKey(ChromaBlocks.DECAY, "dyeleaf");
        this.addKey(ChromaBlocks.PYLON, ChromaTiles.PYLON.getBlockMetadata(), "pylon");
        this.addKey(ChromaBlocks.PYLONSTRUCT, 3, "pylon");
        this.addKey(ChromaBlocks.PYLONSTRUCT, 4, "pylon");
        this.addKey(ChromaBlocks.PYLONSTRUCT, 5, "pylon");
        this.addKey(ChromaTiles.DIMENSIONCORE.getBlock(), ChromaTiles.DIMENSIONCORE.getBlockMetadata(), "dimensioncore");
        this.addKey(ChromaBlocks.RUNE, "rune");
        if (ModList.FORESTRY.isLoaded()) {
            this.addKey(ChromaBlocks.HIVE, "hive");
        }
        for (i = 0; i < BlockTieredOre.TieredOres.list.length; ++i) {
            this.addKey(ChromaBlocks.TIEREDORE, i, "ore_" + BlockTieredOre.TieredOres.list[i].name().toLowerCase(Locale.ENGLISH));
        }
        for (i = 0; i < BlockTieredPlant.TieredPlants.list.length; ++i) {
            this.addKey(ChromaBlocks.TIEREDPLANT, i, "plant_" + BlockTieredPlant.TieredPlants.list[i].name().toLowerCase(Locale.ENGLISH));
        }
        for (i = 0; i < BlockDecoFlower.Flowers.list.length; ++i) {
            this.addKey(ChromaBlocks.DECOFLOWER, i, "flower_" + BlockDecoFlower.Flowers.list[i].name().toLowerCase(Locale.ENGLISH));
        }
        this.data.put(Blocks.field_150357_h, (Object)new DimBedrockHelpKey());
    }

    private void addKey(ChromaBlocks b, String s) {
        this.data.put(b.getBlockInstance(), (Object)new HelpKey(s));
    }

    private void addKey(ChromaBlocks b, int meta, String s) {
        this.data.put(b.getBlockInstance(), meta, (Object)new HelpKey(s));
    }

    private void addKey(Block b, int meta, String s) {
        this.data.put(b, meta, (Object)new HelpKey(s));
    }

    private HelpKey getKey(Block b, int meta) {
        return (HelpKey)this.data.get(b, meta);
    }

    public String getText(World world, int x, int y, int z) {
        HelpKey hk = this.getKey(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
        return hk != null && hk.isValid(world, x, y, z) ? hk.getText() : null;
    }

    public Collection<String> getHelpKeys() {
        ArrayList<String> c = new ArrayList<String>();
        for (HelpKey h : this.data.values()) {
            String s = h.key;
            if (c.contains(s)) continue;
            c.add(s);
        }
        return c;
    }

    public void markDiscovered(EntityPlayer ep, Block b, int meta) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootNBTTag(ep);
        NBTTagCompound tag = nbt.func_74775_l(NBT_TAG);
        String sg = String.format("%d:%d", Block.func_149682_b((Block)b), meta);
        boolean has = tag.func_74767_n(sg);
        if (!has) {
            tag.func_74757_a(sg, true);
            nbt.func_74782_a(NBT_TAG, (NBTBase)tag);
            ReikaPlayerAPI.sendCustomDataFromClient((EntityPlayer)ep);
        }
    }

    public boolean hasDiscovered(EntityPlayer ep, Block b, int meta) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootNBTTag(ep);
        NBTTagCompound tag = nbt.func_74775_l(NBT_TAG);
        String sg = String.format("%d:%d", Block.func_149682_b((Block)b), meta);
        return tag.func_74767_n(sg);
    }

    private static class HelpKey {
        protected final String key;

        protected HelpKey(String xml) {
            this.key = xml;
        }

        public boolean isValid(World world, int x, int y, int z) {
            return true;
        }

        public final String getText() {
            return ChromaDescriptions.getHoverText(this.key);
        }
    }

    private static class DimBedrockHelpKey
    extends HelpKey {
        protected DimBedrockHelpKey() {
            super("dimbedrock");
        }

        @Override
        public boolean isValid(World world, int x, int y, int z) {
            return world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() && y <= 24;
        }
    }
}

