/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Event.ChunkGenerationEvent;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;

public class ChunkResetter
implements TickRegistry.TickHandler {
    public static final ChunkResetter instance = new ChunkResetter();
    public static final int SPEED = 32;
    private final MultiMap<Integer, ChunkReset> chunks = new MultiMap();

    private ChunkResetter() {
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        World world = (World)tickData[0];
        if (world instanceof WorldServer) {
            ArrayList<ChunkReset> rem = new ArrayList<ChunkReset>();
            for (ChunkReset r : this.chunks.get((Object)world.field_73011_w.field_76574_g)) {
                r.step((WorldServer)world);
                if (!r.isDone()) continue;
                r.onFinish((WorldServer)world);
                rem.add(r);
            }
            for (ChunkReset r : rem) {
                this.chunks.remove((Object)world.field_73011_w.field_76574_g, (Object)r);
            }
        }
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.WORLD);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.START;
    }

    public String getLabel() {
        return "Chunk Reset";
    }

    public void addChunk(WorldServer world, Chunk ch) {
        this.chunks.addValue((Object)world.field_73011_w.field_76574_g, (Object)new ChunkReset(world, ch));
    }

    private static class ChunkReset {
        private final IChunkProvider generator;
        private final Chunk regen;
        private int stepX = 0;
        private int stepY = 0;
        private int stepZ = 0;

        private ChunkReset(WorldServer world, Chunk c) {
            this.generator = world.field_73059_b.field_73246_d;
            this.regen = this.generator.func_73154_d(c.field_76635_g, c.field_76647_h);
            MinecraftForge.EVENT_BUS.post((Event)new ChunkGenerationEvent(c));
        }

        private void step(WorldServer world) {
            for (int i = 0; i < 0x200000; ++i) {
                this.resetCoordinate(world);
                this.updateStepPosition();
                if (!this.isDone()) continue;
                this.onFinish(world);
                return;
            }
        }

        private void onFinish(WorldServer world) {
            world.func_72964_e((int)this.regen.field_76635_g, (int)this.regen.field_76647_h).field_76646_k = false;
            this.generator.func_73153_a(this.generator, this.regen.field_76635_g, this.regen.field_76647_h);
            GameRegistry.generateWorld((int)this.regen.field_76635_g, (int)this.regen.field_76647_h, (World)world, (IChunkProvider)this.generator, (IChunkProvider)this.generator);
            ReikaJavaLibrary.pConsole((Object)("Finished regenning " + this.regen.func_76632_l()));
        }

        private void resetCoordinate(WorldServer world) {
            int wx = this.stepX + (this.regen.field_76635_g << 4);
            int wz = this.stepZ + (this.regen.field_76647_h << 4);
            Block prev = world.func_147439_a(wx, this.stepY, wz);
            Block b = this.regen.func_150810_a(this.stepX, this.stepY, this.stepZ);
            int meta = this.regen.func_76628_c(this.stepX, this.stepY, this.stepZ);
            world.func_147465_d(wx, this.stepY, wz, b, meta, 3);
            TileEntity te = this.regen.getTileEntityUnsafe(this.stepX, this.stepY, this.stepZ);
            if (te != null) {
                world.func_147455_a(wx, this.stepY, wz, te);
            }
            if (prev != b) {
                if (prev != Blocks.field_150350_a) {
                    ReikaSoundHelper.playBreakSound((World)world, (int)wx, (int)this.stepY, (int)wz, (Block)prev);
                }
                if (b != Blocks.field_150350_a) {
                    ReikaSoundHelper.playPlaceSound((World)world, (int)wx, (int)this.stepY, (int)wz, (Block)b);
                }
            }
        }

        private void updateStepPosition() {
            boolean flag1 = false;
            boolean flag2 = false;
            ++this.stepX;
            if (this.stepX >= 16) {
                this.stepX = 0;
                flag1 = true;
            }
            if (flag1) {
                ++this.stepZ;
                if (this.stepZ >= 16) {
                    this.stepZ = 0;
                    flag2 = true;
                }
                if (flag2) {
                    ++this.stepY;
                }
            }
        }

        private boolean isDone() {
            return this.stepY >= 256;
        }
    }
}

