/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Command;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Magic.ElementBufferCapacityBoost;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionLoadHandler;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.DimensionTuningManager;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Instantiable.BasicModEntry;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.IO.ReikaCommandHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;

public class ProgressModifyCommand
extends DragonCommandBase {
    private final HashMap<String, AutoFiller> fillers = new HashMap();
    private CommandBase relay;

    public ProgressModifyCommand() {
        BasicModEntry mod = new BasicModEntry("chromaticommands");
        if (mod.isLoaded()) {
            try {
                Class<?> manager = Class.forName("chromaticommands.commands.Chrom_Commands");
                Class<?> obj = Class.forName("chromaticommands.commands.ChromComBase");
                Field f = manager.getDeclaredField("coms");
                f.setAccessible(true);
                ICommand comm = ReikaCommandHelper.getCommandByName((String)"/chromaprog2");
                this.relay = (CommandBase)comm;
                String n = comm.func_71517_b();
                Method name = obj.getMethod("getCommand", new Class[0]);
                Method args = obj.getMethod("validArgs", String[].class);
                Method auto = obj.getMethod("autoComplete", ICommandSender.class, String[].class);
                ArrayList li = (ArrayList)f.get(comm);
                for (Object o : li) {
                    AutoFiller fill = new AutoFiller(o, name, args, auto);
                    this.fillers.put((String)name.invoke(o, new Object[0]), fill);
                }
            }
            catch (ClassNotFoundException e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)mod, (Exception)e);
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)mod, (Exception)e);
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)mod, (Exception)e);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)mod, (Exception)e);
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)mod, (Exception)e);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)mod, (Exception)e);
                e.printStackTrace();
            }
        }
    }

    public void func_71515_b(ICommandSender ics, String[] args) {
        EntityPlayerMP ep;
        EntityPlayerMP caller = ProgressModifyCommand.func_71521_c((ICommandSender)ics);
        if (args.length < 2) {
            ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + "Invalid arguments. Use /" + this.getCommandString() + " <player> [action] [entry] [set]."));
            return;
        }
        if (args.length == 2 && (args[0].equals("debug") || args[0].equals("reset") || args[0].equals("maximize"))) {
            args = Arrays.copyOf(args, args.length + 1);
        } else if (args.length == 3 && (args[1].equals("debug") || args[1].equals("reset") || args[1].equals("maximize"))) {
            args = Arrays.copyOf(args, args.length + 1);
        }
        if (!(args.length >= 3 && args.length <= 4 || args.length > 0 && args[0].equals("dimtuning"))) {
            ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + "Invalid arguments. Use /" + this.getCommandString() + " <player> [action] [entry] [set]."));
            return;
        }
        EntityPlayerMP entityPlayerMP = args.length == 4 ? ReikaPlayerAPI.getPlayerByNameAnyWorld((String)args[0]) : (ep = ProgressModifyCommand.func_71521_c((ICommandSender)ics));
        if (!caller.field_71075_bZ.field_75098_d && !ReikaPlayerAPI.isReika((EntityPlayer)caller) && ep != caller) {
            ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + "This command can only be called from players in creative mode."));
            return;
        }
        if (args.length == 4) {
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        boolean set = Boolean.valueOf(args[2]);
        boolean rerender = true;
        ProgressionLoadHandler.instance.clearProgressCache((EntityPlayer)ep);
        switch (args[0]) {
            case "color": {
                CrystalElement e = this.getColor(args[1]);
                if (e == null) {
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + " Invalid color '" + args[1] + "'."));
                    return;
                }
                ProgressionManager.instance.setPlayerDiscoveredColor((EntityPlayer)ep, e, set, false);
                ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Color Discovery " + e.displayName + " set to " + set + " for " + ep.func_70005_c_()));
                break;
            }
            case "progress": {
                try {
                    ProgressStage p = ProgressStage.valueOf(args[1].toUpperCase());
                    ProgressionManager.instance.setPlayerStage((EntityPlayer)ep, p, set, false, false);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Progress Stage " + p.name() + " set to " + set + " for " + ep.func_70005_c_()));
                    break;
                }
                catch (IllegalArgumentException e) {
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + " Invalid progression stage '" + args[1] + "'."));
                    return;
                }
            }
            case "fragment": {
                try {
                    ChromaResearch r = ChromaResearch.valueOf(args[1].toUpperCase());
                    if (set) {
                        ChromaResearchManager.instance.givePlayerFragment((EntityPlayer)ep, r, false);
                    } else {
                        ChromaResearchManager.instance.removePlayerFragment((EntityPlayer)ep, r, false);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Fragment " + r.name() + " set to " + set + " for " + ep.func_70005_c_()));
                    break;
                }
                catch (IllegalArgumentException e) {
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + " Invalid fragment '" + args[1] + "'."));
                    return;
                }
            }
            case "abilities": 
            case "ability": {
                try {
                    AbilityAPI.Ability a = Chromabilities.getAbility(args[1].toLowerCase(Locale.ENGLISH));
                    if (set) {
                        Chromabilities.give((EntityPlayer)ep, a);
                    } else {
                        Chromabilities.removeFromPlayer((EntityPlayer)ep, a);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Ability " + a.getDisplayName() + " set to " + set + " for " + ep.func_70005_c_()));
                    break;
                }
                catch (IllegalArgumentException e) {
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + " Invalid ability '" + args[1] + "'."));
                    return;
                }
            }
            case "level": {
                try {
                    ResearchLevel r = ResearchLevel.valueOf(args[1].toUpperCase());
                    ChromaResearchManager.instance.setPlayerResearchLevel((EntityPlayer)ep, r, false);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Research level set to " + r.name() + " for " + ep.func_70005_c_()));
                    break;
                }
                catch (IllegalArgumentException e) {
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + " Invalid research level '" + args[1] + "'."));
                    return;
                }
            }
            case "dimstruct": {
                CrystalElement e = this.getColor(args[1]);
                if (e == null) {
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + " Invalid color '" + args[1] + "'."));
                    return;
                }
                ProgressionManager.instance.markPlayerCompletedStructureColor((EntityPlayer)ep, null, e, set, false);
                ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Structure " + e.displayName + " set to " + set + " for " + ep.func_70005_c_()));
                break;
            }
            case "dimtuning": {
                int amt = args.length >= 2 ? Integer.parseInt(args[1]) : 200000;
                DimensionTuningManager.instance.tunePlayer((EntityPlayer)ep, amt);
                ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Player " + ep.func_70005_c_() + " tuned to " + amt));
                break;
            }
            case "buffer": {
                ElementBufferCapacityBoost b = ElementBufferCapacityBoost.valueOf(args[1].toUpperCase(Locale.ENGLISH));
                if (set) {
                    if (!b.give((EntityPlayer)ep)) {
                        ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + "Player " + ep.func_70005_c_() + " could not be given buffer boost " + (Object)((Object)b)));
                        return;
                    }
                } else {
                    b.remove((EntityPlayer)ep);
                }
                ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Player " + ep.func_70005_c_() + " given buffer boost " + (Object)((Object)b)));
                break;
            }
            case "towers": 
            case "lore": {
                if (args[1].equalsIgnoreCase("puzzle")) {
                    LoreManager.instance.setBoardCompletion((EntityPlayer)ep, set);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Puzzle completion set to " + set + " for " + ep.func_70005_c_()));
                    break;
                }
                Towers t = null;
                try {
                    t = Towers.towerList[Integer.parseInt(args[1])];
                }
                catch (Exception e) {
                    try {
                        t = Towers.valueOf(args[1].toUpperCase(Locale.ENGLISH));
                    }
                    catch (Exception e2) {
                        ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + "Unrecognized tower '" + args[1] + "'"));
                        break;
                    }
                }
                LoreManager.instance.setPlayerScanned((EntityPlayer)ep, t, set);
                ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Data Tower " + t.character + " set to " + set + " for " + ep.func_70005_c_()));
                break;
            }
            case "reset": {
                if (args[1].equals("all") || args[1].equals("progress") || args[1].equals("progression")) {
                    ProgressionManager.instance.resetPlayerProgression((EntityPlayer)ep, false);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Progression reset for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("fragment") || args[1].equals("research")) {
                    ChromaResearchManager.instance.resetPlayerResearch((EntityPlayer)ep, false);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Fragments reset for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("ability") || args[1].equals("abilities")) {
                    for (AbilityAPI.Ability c : Chromabilities.getAbilities()) {
                        Chromabilities.removeFromPlayer((EntityPlayer)ep, c);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Abilities reset for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("dimstruct")) {
                    for (int i = 0; i < 16; ++i) {
                        ProgressionManager.instance.markPlayerCompletedStructureColor((EntityPlayer)ep, null, CrystalElement.elements[i], false, false);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Dimstruct reset for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("colors")) {
                    for (int i = 0; i < 16; ++i) {
                        ProgressionManager.instance.setPlayerDiscoveredColor((EntityPlayer)ep, CrystalElement.elements[i], false, false);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Color discovery reset for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("buffer")) {
                    for (ElementBufferCapacityBoost b : ElementBufferCapacityBoost.list) {
                        b.remove((EntityPlayer)ep);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Element buffer boosts reset for " + ep.func_70005_c_()));
                }
                if (!args[1].equals("all") && !args[1].equals("lore") && !args[1].equals("towers")) break;
                for (int i = 0; i < Towers.towerList.length; ++i) {
                    LoreManager.instance.setPlayerScanned((EntityPlayer)ep, Towers.towerList[i], false);
                }
                LoreManager.instance.setBoardCompletion((EntityPlayer)ep, false);
                ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Tower scanning reset for " + ep.func_70005_c_()));
                break;
            }
            case "maximize": {
                if (args[1].equals("all") || args[1].equals("progress") || args[1].equals("progression")) {
                    ProgressionManager.instance.maxPlayerProgression((EntityPlayer)ep, false);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Progression maximized for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("fragment") || args[1].equals("research")) {
                    ChromaResearchManager.instance.maxPlayerResearch((EntityPlayer)ep, false);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Fragments maximized for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("ability") || args[1].equals("abilities")) {
                    for (AbilityAPI.Ability c : Chromabilities.getAbilities()) {
                        if (Chromabilities.playerHasAbility((EntityPlayer)ep, c)) continue;
                        Chromabilities.give((EntityPlayer)ep, c);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Abilities maximized for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("dimstruct")) {
                    for (int i = 0; i < 16; ++i) {
                        ProgressionManager.instance.markPlayerCompletedStructureColor((EntityPlayer)ep, null, CrystalElement.elements[i], true, false);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Dimstruct maximized for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("buffer")) {
                    for (ElementBufferCapacityBoost b : ElementBufferCapacityBoost.list) {
                        b.give((EntityPlayer)ep);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Element buffer boosts maximized for " + ep.func_70005_c_()));
                }
                if (args[1].equals("all") || args[1].equals("colors")) {
                    for (int i = 0; i < 16; ++i) {
                        ProgressionManager.instance.setPlayerDiscoveredColor((EntityPlayer)ep, CrystalElement.elements[i], true, false);
                    }
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Color discovery maximized for " + ep.func_70005_c_()));
                }
                if (!args[1].equals("all") && !args[1].equals("lore") && !args[1].equals("towers")) break;
                for (int i = 0; i < Towers.towerList.length; ++i) {
                    LoreManager.instance.setPlayerScanned((EntityPlayer)ep, Towers.towerList[i], true);
                }
                LoreManager.instance.setBoardCompletion((EntityPlayer)ep, true);
                ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Tower scanning maximized for " + ep.func_70005_c_()));
                break;
            }
            case "debug": {
                rerender = false;
                if (args[1].equals("all") || args[1].equals("fragment") || args[1].equals("research")) {
                    ResearchLevel pl = ChromaResearchManager.instance.getPlayerResearchLevel((EntityPlayer)ep);
                    Collection<ChromaResearch> cp = ChromaResearchManager.instance.getFragments((EntityPlayer)ep);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)"Player research: ");
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)("Level " + pl));
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)("Fragments: " + cp));
                    HashSet<ChromaResearch> missing = ChromaResearchManager.instance.getResearchLevelMissingFragments((EntityPlayer)ep);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)("Can step to " + pl.post() + ": F=" + pl.post().canProgressTo((EntityPlayer)ep) + " && R=" + missing.isEmpty()));
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)("Missing research for " + pl + ": " + missing));
                }
                if (args[1].equals("all") || args[1].equals("progress") || args[1].equals("progression")) {
                    Collection<ProgressStage> c = ProgressionManager.instance.getStagesFor((EntityPlayer)ep);
                    Collection<CrystalElement> c2 = ProgressionManager.instance.getColorsFor((EntityPlayer)ep);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)("Progress for " + ep.func_70005_c_() + ":\n" + c.toString()));
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)("Elements for " + ep.func_70005_c_() + ":\n" + c2.toString()));
                }
                if (args[1].equals("all") || args[1].equals("dimstruct")) {
                    Collection<CrystalElement> c3 = ProgressionManager.instance.getStructuresFor((EntityPlayer)ep);
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)("Structure Flags for " + ep.func_70005_c_() + ":\n" + c3.toString()));
                }
                if (!args[1].equals("all") && !args[1].equals("lore") && !args[1].equals("towers")) break;
                for (int i = 0; i < Towers.towerList.length; ++i) {
                    Towers t = Towers.towerList[i];
                    ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Tower " + t.character + " status for " + ep.func_70005_c_() + ": " + LoreManager.instance.hasPlayerScanned((EntityPlayer)ep, t)));
                }
                ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)("Puzzle completion for " + ep.func_70005_c_() + ":\n" + LoreManager.instance.hasPlayerCompletedBoard((EntityPlayer)ep)));
                break;
            }
            default: {
                ProgressModifyCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + " Unrecognized progress action/type '" + args[0] + "'."));
            }
        }
        if (rerender) {
            ProgressionManager.instance.updateChunks((EntityPlayer)ep);
        }
        ReikaJavaLibrary.pConsole((Object)("Player " + ep.func_70005_c_() + " used /chromaprog with args " + Arrays.toString(args)));
    }

    private CrystalElement getColor(String s) {
        try {
            return CrystalElement.valueOf(s.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return CrystalElement.getByName(ReikaStringParser.capFirstChar((String)s.toLowerCase(Locale.ENGLISH)));
        }
    }

    public String getCommandString() {
        return "chromaprog";
    }

    protected boolean isAdminOnly() {
        return true;
    }

    public List func_71516_a(ICommandSender ics, String[] args) {
        return this.relay != null ? this.relay.func_71516_a(ics, args) : super.func_71516_a(ics, args);
    }

    private static class AutoFiller {
        private final Method autoComplete;
        private final Method validArgs;
        private final Method getCommand;
        private final Object reference;

        private AutoFiller(Object o, Method n, Method v, Method c) {
            this.getCommand = n;
            this.autoComplete = c;
            this.validArgs = v;
            this.reference = o;
        }
    }
}

