/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Command;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaDecorator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;

public class RedecorateCommand
extends DragonCommandBase {
    private static final MultiMap<String, ChunkCoordIntPair> generatedChunks = new MultiMap(MultiMap.CollectionType.HASHSET);

    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args.length != 2) {
            RedecorateCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + "Incorrect formatting. Use [radius] [generator]"));
            return;
        }
        int r = Integer.parseInt(args[0]);
        ChromaDecorator d = ChromatiCraft.getDecorator(args[1].toLowerCase(Locale.ENGLISH));
        if (d == null) {
            RedecorateCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED + "Unrecognized decorator."));
            return;
        }
        EntityPlayerMP ep = RedecorateCommand.func_71521_c((ICommandSender)ics);
        World world = ep.field_70170_p;
        int x = MathHelper.func_76128_c((double)ep.field_70165_t) >> 4;
        int z = MathHelper.func_76128_c((double)ep.field_70161_v) >> 4;
        this.loadFile(world, d);
        int n = 0;
        int rc = r >> 4;
        for (int i = -rc; i <= rc; ++i) {
            for (int k = -rc; k <= rc; ++k) {
                Chunk ch;
                if (!ReikaWorldHelper.isChunkGeneratedChunkCoords((WorldServer)((WorldServer)world), (int)(x + i), (int)(z + k)) || !this.shouldDecorateChunk(ch = world.func_72964_e(x + i, z + k), d)) continue;
                this.decorate(world, ch, d);
                ++n;
            }
        }
        this.updateFile(world, d);
        RedecorateCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.GREEN + "Decorator run on " + n + " chunks."));
    }

    private boolean shouldDecorateChunk(Chunk ch, ChromaDecorator d) {
        HashSet c = (HashSet)generatedChunks.get((Object)d.getCommandID());
        return !c.contains(ch.func_76632_l());
    }

    private void decorate(World world, Chunk ch, ChromaDecorator d) {
        IChunkProvider prov = world.func_72863_F();
        IChunkProvider gen = ((ChunkProviderServer)prov).field_73246_d;
        d.generate(world.field_73012_v, ch.field_76635_g, ch.field_76647_h, world, gen, prov);
        generatedChunks.addValue((Object)d.getCommandID(), (Object)ch.func_76632_l());
    }

    public String getCommandString() {
        return "redecorate";
    }

    protected boolean isAdminOnly() {
        return true;
    }

    private void loadFile(World world, ChromaDecorator d) {
        generatedChunks.remove((Object)d.getCommandID());
        File f = this.getFile(world, d);
        if (f.exists()) {
            ArrayList li = ReikaFileReader.getFileAsLines((File)f, (boolean)true);
            for (String s : li) {
                ChunkCoordIntPair p = this.parseCoordPair(s);
                generatedChunks.addValue((Object)d.getCommandID(), (Object)p);
            }
        }
    }

    private void updateFile(World world, ChromaDecorator d) {
        File f = this.getFile(world, d);
        try {
            f.delete();
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> li = new ArrayList<String>();
        for (ChunkCoordIntPair p : generatedChunks.get((Object)d.getCommandID())) {
            li.add(this.toString(p));
        }
        ReikaFileReader.writeLinesToFile((File)f, li, (boolean)true);
    }

    private File getFile(World world, ChromaDecorator d) {
        File f = world.func_72860_G().func_75765_b();
        if (f != null) {
            return new File(f, "DIM" + world.field_73011_w.field_76574_g + "/redecorate_" + d.getCommandID() + ".dat");
        }
        return null;
    }

    private ChunkCoordIntPair parseCoordPair(String s) {
        String[] parts = s.split(":");
        return new ChunkCoordIntPair(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    private String toString(ChunkCoordIntPair p) {
        return p.field_77276_a + ":" + p.field_77275_b;
    }
}

