/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Command;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityDimensionCore;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.ChromatiCraft.World.Dimension.Structure.MonumentGenerator;
import Reika.ChromatiCraft.World.Dimension.StructureCalculator;
import Reika.ChromatiCraft.World.Dimension.ThreadedGenerators;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;

public class StructureGenCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            EntityPlayerMP ep = StructureGenCommand.func_71521_c((ICommandSender)ics);
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"Generating structures...");
            if (args.length > 0 && args[0].equals("finished")) {
                StructureCalculator.allowUnfinishedStructures = false;
                args = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
            }
            ChunkProviderChroma.triggerGenerator(ThreadedGenerators.STRUCTURE);
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"Generation complete.");
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("monument")) {
                    ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"Placing monument...");
                    MonumentGenerator gen = new MonumentGenerator();
                    int x0 = MathHelper.func_76128_c((double)ep.field_70165_t);
                    int z0 = MathHelper.func_76128_c((double)ep.field_70161_v);
                    int cx = 21;
                    int cy = 5;
                    int cz = 21;
                    gen.startCalculate(x0, z0, ep.field_70170_p.field_73012_v);
                    gen.generateAll(ep.field_70170_p);
                    Map<Coordinate, Block> map = gen.getMineralBlocks();
                    for (Map.Entry<Coordinate, Block> entry : map.entrySet()) {
                        entry.getKey().setBlock(ep.field_70170_p, entry.getValue());
                    }
                    ((TileEntityStructControl)gen.getController().getTileEntity((IBlockAccess)ep.field_70170_p)).setPlacer((EntityPlayer)ep);
                    for (int i = 0; i < 16; ++i) {
                        CrystalElement crystalElement = CrystalElement.elements[i];
                        Coordinate rel = TileEntityDimensionCore.getLocation(crystalElement);
                        Coordinate c2 = rel.offset(gen.getPosX(), gen.getPosY() + cy, gen.getPosZ());
                        c2.setBlock(ep.field_70170_p, ChromaTiles.DIMENSIONCORE.getBlock(), ChromaTiles.DIMENSIONCORE.getBlockMetadata());
                        TileEntityDimensionCore te = (TileEntityDimensionCore)c2.getTileEntity((IBlockAccess)ep.field_70170_p);
                        te.setColor(crystalElement);
                        te.setPlacer((EntityPlayer)ep);
                        te.prime(true);
                    }
                } else {
                    ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Placing " + args.length + " structures (" + Arrays.toString(args) + ")..."));
                    while (!ChunkProviderChroma.areGeneratorsReady()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    HashSet<DimensionStructureGenerator.DimensionStructureType> set = new HashSet<DimensionStructureGenerator.DimensionStructureType>();
                    for (DimensionStructureGenerator.StructurePair p : ChunkProviderChroma.getStructures()) {
                        p.generatedDimension = ep.field_70170_p.field_73011_w.field_76574_g;
                        DimensionStructureGenerator.DimensionStructureType type = p.generator.getType();
                        if (set.contains((Object)type)) continue;
                        set.add(type);
                        if (ReikaArrayHelper.arrayContains((String[])args, (String)type.name(), (boolean)true)) {
                            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Generating " + (Object)((Object)type) + " @ " + p.generator.getEntryPosX() + ", " + p.generator.getEntryPosZ() + "..."));
                            p.generator.generateAll(ep.field_70170_p);
                            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Generating " + (Object)((Object)type) + " complete."));
                            continue;
                        }
                        ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Not generating " + (Object)((Object)type) + ". " + Arrays.toString(args) + " does not contain '" + type.name() + "'."));
                    }
                }
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)"Placing complete.");
            }
        }
    }

    public String getCommandString() {
        return "gendimstructures";
    }

    protected boolean isAdminOnly() {
        return true;
    }
}

