/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Command;

import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.World.IWG.DungeonGenerator;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.IO.MapOutput;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;

public class StructureMapCommand
extends DragonCommandBase {
    public static final int PACKET_COMPILE = 2048;
    private static final Random rand = new Random();
    private static final HashMap<Integer, StructureMap> activeMaps = new HashMap();

    public void func_71515_b(ICommandSender ics, String[] args) {
        Object[] ret = this.getPlayer(ics, args);
        EntityPlayerMP ep = (EntityPlayerMP)ret[0];
        if (((Boolean)ret[1]).booleanValue()) {
            String[] nargs = new String[args.length - 1];
            System.arraycopy(args, 1, nargs, 0, nargs.length);
            args = nargs;
        }
        if (args.length < 2) {
            StructureMapCommand.sendChatToSender((ICommandSender)ics, (String)(EnumChatFormatting.RED.toString() + "Illegal arguments. Use <seed> [structType] [range]"));
            return;
        }
        int range = Integer.parseInt(args[1]);
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int z = MathHelper.func_76128_c((double)ep.field_70161_v);
        long start = System.currentTimeMillis();
        ChromaStructures s = ChromaStructures.valueOf(args[0].toUpperCase(Locale.ENGLISH));
        this.generateMap(ep, start, x, z, range, s);
    }

    private void generateMap(EntityPlayerMP ep, long start, int x, int z, int range, ChromaStructures s) {
        int hash = rand.nextInt();
        int dim = ep.field_70170_p.field_73011_w.field_76574_g;
        String name = ep.field_70170_p.func_72912_H().func_76065_j() + "/[" + ep.field_70170_p.func_72860_G().func_75760_g() + "]";
        if (DragonAPICore.isSinglePlayer()) {
            StructureMapCommand.startCollecting(s, hash, name, dim, x, z, range);
        } else {
            ReikaPacketHelper.sendStringIntPacket((String)"DragonAPIData", (int)ChromaPackets.STRUCTMAPSTART.ordinal(), (EntityPlayerMP)ep, (String)name, (int[])new int[]{hash, dim, x, z, range, s.ordinal()});
        }
        ArrayList<Integer> dat = new ArrayList<Integer>();
        dat.add(hash);
        int n = 0;
        DungeonGenerator.StructureGenStatus[][] data = new DungeonGenerator.StructureGenStatus[range * 2 + 1][range * 2 + 1];
        for (int i = -range; i <= range; ++i) {
            for (int k = -range; k <= range; ++k) {
                int rx = x + i * 16;
                int rz = z + k * 16;
                DungeonGenerator.StructureGenStatus st = DungeonGenerator.StructureGenStatus.PLANNED;
                DungeonGenerator.StructureGenStatus at = DungeonGenerator.instance.getGenStatus(s, (WorldServer)ep.field_70170_p, rx, rz);
                if (at != null) {
                    st = at;
                }
                data[i + range][k + range] = st;
            }
        }
        int cx = x >> 4;
        int cz = z >> 4;
        for (int i = -range; i <= range; ++i) {
            for (int k = -range; k <= range; ++k) {
                int dx = x + i;
                int dz = z + k;
                DungeonGenerator.StructureGenStatus f = data[i + range][k + range];
                ++n;
                if (DragonAPICore.isSinglePlayer()) {
                    StructureMapCommand.addDataPoint(hash, dx, dz, f);
                } else {
                    dat.add(dx);
                    dat.add(dz);
                    dat.add(f.ordinal());
                }
                if (n < 2048 || DragonAPICore.isSinglePlayer()) continue;
                ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)ChromaPackets.STRUCTMAPDAT.ordinal(), (EntityPlayerMP)ep, dat);
                n = 0;
                dat.clear();
                dat.add(hash);
            }
        }
        if (dat.size() > 1) {
            int m = (dat.size() - 1) / 3;
            DungeonGenerator.StructureGenStatus f = data[range][range];
            if (DragonAPICore.isSinglePlayer()) {
                StructureMapCommand.addDataPoint(hash, x, z, f);
            } else {
                for (int i = m; i < 2048; ++i) {
                    dat.add(cx);
                    dat.add(cz);
                    dat.add(f.ordinal());
                }
                ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)ChromaPackets.STRUCTMAPDAT.ordinal(), (EntityPlayerMP)ep, dat);
                n = 0;
                dat.clear();
                dat.add(hash);
            }
        }
        if (DragonAPICore.isSinglePlayer()) {
            StructureMapCommand.finishCollectingAndMakeImage(hash);
        } else {
            ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)ChromaPackets.STRUCTMAPEND.ordinal(), (EntityPlayerMP)ep, (int[])new int[]{hash});
        }
    }

    private Object[] getPlayer(ICommandSender ics, String[] args) {
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = StructureMapCommand.func_71521_c((ICommandSender)ics);
            objectArray[1] = false;
            return objectArray;
        }
        catch (Exception e) {
            EntityPlayerMP ep = ReikaPlayerAPI.getPlayerByNameAnyWorld((String)args[0]);
            if (ep == null) {
                StructureMapCommand.sendChatToSender((ICommandSender)ics, (String)"If you specify a player, they must exist.");
                throw new IllegalArgumentException(e);
            }
            return new Object[]{ep, true};
        }
    }

    public String getCommandString() {
        return "ccstructmap";
    }

    protected boolean isAdminOnly() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void startCollecting(ChromaStructures s, int hash, String world, int dim, int x, int z, int range) {
        StructureMap map = new StructureMap(s, world, dim, x, z, range);
        activeMaps.put(hash, map);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addDataPoint(int hash, int x, int z, DungeonGenerator.StructureGenStatus data) {
        StructureMap map = activeMaps.get(hash);
        if (map != null) {
            map.addPoint(x, z, (Object)data);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void finishCollectingAndMakeImage(int hash) {
        StructureMap map = activeMaps.remove(hash);
        if (map != null) {
            try {
                map.addGrid();
                String path = map.createImage();
                long dur = System.currentTimeMillis() - map.startTime;
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String)(EnumChatFormatting.GREEN + "File created in " + dur + " ms: " + path));
            }
            catch (IOException e) {
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (String)(EnumChatFormatting.RED + "Failed to create file: " + e.toString()));
                e.printStackTrace();
            }
        }
    }

    private static class StructureMap
    extends MapOutput<DungeonGenerator.StructureGenStatus> {
        private final ChromaStructures type;

        private StructureMap(ChromaStructures s, String name, int dim, int x, int z, int r) {
            super(name, dim, x, z, r, 1, -1, false);
            this.type = s;
        }

        protected int getColor(int x, int z, DungeonGenerator.StructureGenStatus data) {
            return data.renderColor;
        }

        protected String getFileNameDetails() {
            String sr = String.valueOf(this.range * 2 + 1);
            return this.type.name().toLowerCase(Locale.ENGLISH) + " (" + sr + "x" + sr + ").png";
        }
    }
}

