/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class CrystalMusicManager {
    public static final CrystalMusicManager instance = new CrystalMusicManager();
    private final EnumMap<CrystalElement, ReikaMusicHelper.MusicKey> baseKeys = new EnumMap(CrystalElement.class);
    private final EnumMap<CrystalElement, ArrayList<ReikaMusicHelper.MusicKey>> allKeys = new EnumMap(CrystalElement.class);
    private final MultiMap<ReikaMusicHelper.MusicKey, CrystalElement> sourceElements = new MultiMap(MultiMap.CollectionType.HASHSET);
    private static final Random rand = new Random();

    private CrystalMusicManager() {
        this.addTonic(CrystalElement.BLACK, ReikaMusicHelper.MusicKey.C4);
        this.addTonic(CrystalElement.BROWN, ReikaMusicHelper.MusicKey.D4);
        this.addTonic(CrystalElement.BLUE, ReikaMusicHelper.MusicKey.E4);
        this.addTonic(CrystalElement.GREEN, ReikaMusicHelper.MusicKey.F4);
        this.addTonic(CrystalElement.RED, ReikaMusicHelper.MusicKey.G4);
        this.addTonic(CrystalElement.PURPLE, ReikaMusicHelper.MusicKey.A4);
        this.addTonic(CrystalElement.MAGENTA, ReikaMusicHelper.MusicKey.B4);
        this.addTonic(CrystalElement.CYAN, ReikaMusicHelper.MusicKey.A4);
        this.addTonic(CrystalElement.LIGHTGRAY, ReikaMusicHelper.MusicKey.D5);
        this.addTonic(CrystalElement.GRAY, ReikaMusicHelper.MusicKey.C5);
        this.addTonic(CrystalElement.LIME, ReikaMusicHelper.MusicKey.E5);
        this.addTonic(CrystalElement.PINK, ReikaMusicHelper.MusicKey.F5);
        this.addTonic(CrystalElement.YELLOW, ReikaMusicHelper.MusicKey.G5);
        this.addTonic(CrystalElement.LIGHTBLUE, ReikaMusicHelper.MusicKey.A5);
        this.addTonic(CrystalElement.ORANGE, ReikaMusicHelper.MusicKey.E4);
        this.addTonic(CrystalElement.WHITE, ReikaMusicHelper.MusicKey.C6);
    }

    private void addTonic(CrystalElement e, ReikaMusicHelper.MusicKey m) {
        this.baseKeys.put(e, m);
        ArrayList<ReikaMusicHelper.MusicKey> li = new ArrayList<ReikaMusicHelper.MusicKey>();
        li.add(m);
        li.add(this.isMinorKey(e) ? m.getMinorThird() : m.getMajorThird());
        li.add(m.getFifth());
        li.add(m.getOctave());
        this.allKeys.put(e, li);
        this.sourceElements.addValue((Object)m, (Object)e);
        this.sourceElements.addValue((Object)(this.isMinorKey(e) ? m.getMinorThird() : m.getMajorThird()), (Object)e);
        this.sourceElements.addValue((Object)m.getFifth(), (Object)e);
        this.sourceElements.addValue((Object)m.getOctave(), (Object)e);
    }

    public int getBasePitch(CrystalElement e) {
        return this.baseKeys.get((Object)e).pitch;
    }

    public double getPitchFactor(ReikaMusicHelper.MusicKey key) {
        return key.getRatio(ReikaMusicHelper.MusicKey.C5);
    }

    public double getThird(CrystalElement e) {
        ReikaMusicHelper.MusicKey key = this.baseKeys.get(e);
        double base = this.getDingPitchScale(e);
        return this.isMinorKey(e) ? base * key.getMinorThird().getRatio(key) : base * key.getMajorThird().getRatio(key);
    }

    public double getFifth(CrystalElement e) {
        ReikaMusicHelper.MusicKey key = this.baseKeys.get(e);
        double base = this.getDingPitchScale(e);
        return base * key.getFifth().getRatio(key);
    }

    public double getOctave(CrystalElement e) {
        ReikaMusicHelper.MusicKey key = this.baseKeys.get(e);
        double base = this.getDingPitchScale(e);
        return base * key.getOctave().getRatio(key);
    }

    public int getIntervalFor(CrystalElement e, ReikaMusicHelper.MusicKey key) {
        ReikaMusicHelper.MusicKey base = this.baseKeys.get(e);
        if (base == key) {
            return 0;
        }
        if ((this.isMinorKey(e) ? base.getMinorThird() : base.getMajorThird()) == key) {
            return 1;
        }
        if (base.getFifth() == key) {
            return 2;
        }
        if (base.getOctave() == key) {
            return 3;
        }
        return -1;
    }

    public double getDingPitchScale(CrystalElement e) {
        return this.getPitchFactor(this.baseKeys.get(e));
    }

    public float getRandomScaledDing(CrystalElement e) {
        int n = rand.nextInt(4);
        return this.getScaledDing(e, n);
    }

    public float getScaledDing(CrystalElement e, int n) {
        ReikaMusicHelper.MusicKey key = this.baseKeys.get(e);
        double base = this.getDingPitchScale(e);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                base *= this.isMinorKey(e) ? key.getMinorThird().getRatio(key) : key.getMajorThird().getRatio(key);
                break;
            }
            case 2: {
                base *= key.getFifth().getRatio(key);
                break;
            }
            case 3: {
                base *= key.getOctave().getRatio(key);
            }
        }
        return (float)base;
    }

    public boolean isMinorKey(CrystalElement e) {
        if (e == CrystalElement.CYAN || e == CrystalElement.ORANGE || e == CrystalElement.GREEN || e == CrystalElement.LIGHTGRAY || e == CrystalElement.GRAY) {
            return true;
        }
        return CrystalPotionController.instance.isBadPotion(e);
    }

    public List<ReikaMusicHelper.MusicKey> getKeys(CrystalElement e) {
        return Collections.unmodifiableList((List)this.allKeys.get(e));
    }

    public ReikaMusicHelper.KeySignature getSignature(CrystalElement e) {
        if (this.isMinorKey(e)) {
            return ReikaMusicHelper.KeySignature.getByMinorTonic((ReikaMusicHelper.MusicKey)this.baseKeys.get(e));
        }
        return ReikaMusicHelper.KeySignature.getByTonic((ReikaMusicHelper.MusicKey)this.baseKeys.get(e));
    }

    public HashSet<CrystalElement> getFullChordMixes(ReikaMusicHelper.KeySignature ks) {
        HashSet<CrystalElement> set = new HashSet<CrystalElement>();
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            boolean flag = true;
            for (ReikaMusicHelper.MusicKey ms : this.getKeys(e)) {
                ReikaMusicHelper.Note n = ms.getNote();
                if (ks.isNoteValid(n)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            set.add(e);
        }
        return set;
    }

    public HashSet<ReikaMusicHelper.MusicKey> getValidNotesToMixWith(CrystalElement main) {
        HashSet<ReikaMusicHelper.MusicKey> set = new HashSet<ReikaMusicHelper.MusicKey>();
        ReikaMusicHelper.KeySignature ks = this.getSignature(main);
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            for (ReikaMusicHelper.MusicKey ms : this.getKeys(e)) {
                ReikaMusicHelper.Note n = ms.getNote();
                if (!ks.isNoteValid(n)) continue;
                Collection keys = ReikaMusicHelper.MusicKey.getAllOf((ReikaMusicHelper.Note)n);
                for (ReikaMusicHelper.MusicKey key : keys) {
                    if (!this.canPlayKey(key)) continue;
                    set.add(key);
                }
            }
        }
        return set;
    }

    public CrystalElement getColorForKeySignature(ReikaMusicHelper.KeySignature ks) {
        ArrayList<CrystalElement> li = new ArrayList<CrystalElement>(this.getFullChordMixes(ks));
        return !li.isEmpty() ? li.get(0) : null;
    }

    public Set<CrystalElement> getColorsWithKey(ReikaMusicHelper.MusicKey key) {
        return (Set)this.sourceElements.get((Object)key);
    }

    public Set<CrystalElement> getColorsWithKeyAnyOctave(ReikaMusicHelper.MusicKey key) {
        Set<CrystalElement> set = this.getColorsWithKey(key);
        if (set.isEmpty()) {
            set = this.getColorsWithKey(key.getOctave());
        }
        if (set.isEmpty()) {
            set = this.getColorsWithKey(key.getInterval(-12));
        }
        if (set.isEmpty()) {
            set = this.getColorsWithKey(key.getInterval(-24));
        }
        if (set.isEmpty()) {
            set = this.getColorsWithKey(key.getInterval(-36));
        }
        if (set.isEmpty()) {
            set = this.getColorsWithKey(key.getInterval(24));
        }
        return set;
    }

    public boolean canPlayKey(ReikaMusicHelper.MusicKey key) {
        return this.sourceElements.containsKey((Object)key);
    }

    public CrystalNote getNote(CrystalElement e, int step) {
        return new CrystalNote(e, this.allKeys.get(e).get(step));
    }

    public static class CrystalNote {
        public final CrystalElement color;
        public final ReikaMusicHelper.MusicKey key;

        private CrystalNote(CrystalElement e, ReikaMusicHelper.MusicKey m) {
            this.color = e;
            this.key = m;
        }
    }
}

