/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.util.MathHelper;

public final class ElementEncodedNumber {
    private final int offset;
    public final int originalValue;
    private final CrystalElement[] encodedValue;
    private final int minimumLength;

    public ElementEncodedNumber(int value) {
        this(value, 1);
    }

    public ElementEncodedNumber(int value, int len) {
        this(value, 0, len);
    }

    public ElementEncodedNumber(int value, int bitOffset, int minLength) {
        bitOffset = (bitOffset % 16 + 16) % 16;
        this.originalValue = value;
        this.offset = bitOffset;
        this.minimumLength = minLength;
        this.encodedValue = ElementEncodedNumber.encodeValue(Math.abs(value), bitOffset, minLength);
    }

    private static CrystalElement[] encodeValue(int value, int offset, int len) {
        byte[] vals = ReikaJavaLibrary.splitIntToHexChars((int)value);
        ArrayList v = ReikaJavaLibrary.makeIntListFromArray((byte[])vals);
        Collections.reverse(v);
        while ((Byte)v.get(0) == 0 && v.size() > len) {
            v.remove(0);
        }
        CrystalElement[] ret = new CrystalElement[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            int idx = ((Byte)v.get(i) + offset) % 16;
            ret[i] = CrystalElement.elements[idx];
        }
        return ret;
    }

    public boolean match(byte[] chars) {
        if (chars.length != this.encodedValue.length) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == this.encodedValue[i].ordinal()) continue;
            return false;
        }
        return true;
    }

    public int getLength() {
        return this.encodedValue.length;
    }

    public CrystalElement getSlot(int idx) {
        return this.encodedValue[idx];
    }

    public String toString() {
        return this.originalValue + " = " + Arrays.deepToString(this.encodedValue);
    }

    public static class EncodedPosition {
        private final int offset;
        private final ElementEncodedNumber x;
        private final ElementEncodedNumber z;

        public EncodedPosition(int o, int xVal, int zVal) {
            this.offset = o = (o % 16 + 16) % 16;
            this.x = new ElementEncodedNumber(MathHelper.func_76128_c((double)xVal), this.offset, 1);
            this.z = new ElementEncodedNumber(MathHelper.func_76128_c((double)zVal), this.offset, 1);
        }

        public void writeData(ByteBuf buf) {
            buf.writeInt(this.offset);
            buf.writeInt(this.x.originalValue);
            buf.writeInt(this.z.originalValue);
        }

        public static EncodedPosition readData(ByteBuf buf) {
            return new EncodedPosition(buf.readInt(), buf.readInt(), buf.readInt());
        }

        public int totalLength() {
            return this.x.getLength() + this.z.getLength() + 1;
        }

        public CrystalElement getColor(int idx) {
            if (idx == 0) {
                return CrystalElement.elements[this.offset];
            }
            if (idx <= this.x.getLength()) {
                return this.x.getSlot(idx - 1);
            }
            return this.z.getSlot(idx - 1 - this.x.getLength());
        }

        public boolean isVariableChange(int idx) {
            return idx == 1 || idx == this.x.getLength() + 1;
        }

        public boolean isPartOfNegative(int idx) {
            if (idx == 0) {
                return false;
            }
            if (idx <= this.x.getLength()) {
                return this.x.originalValue < 0;
            }
            return this.z.originalValue < 0;
        }
    }
}

