/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ProgressionTrigger;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.ModInterface.ModInteraction;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.World.BiomeRainbowForest;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ExplorationMonitor
implements TickRegistry.TickHandler {
    public static final ExplorationMonitor instance = new ExplorationMonitor();

    private ExplorationMonitor() {
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        EntityPlayer ep = (EntityPlayer)tickData[0];
        World world = ep.field_70170_p;
        if (!world.field_72995_K) {
            if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world)) {
                ProgressStage.MYST.stepPlayerTo(ep);
            }
            int x0 = MathHelper.func_76128_c((double)ep.field_70165_t);
            int y0 = MathHelper.func_76128_c((double)ep.field_70163_u) + 1;
            int z0 = MathHelper.func_76128_c((double)ep.field_70161_v);
            MovingObjectPosition mov = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)4.0, (boolean)true);
            if (mov != null) {
                Block b;
                TileEntityCrystalPylon te;
                int x = mov.field_72311_b;
                int y = mov.field_72312_c;
                int z = mov.field_72309_d;
                if (ChromaTiles.getTile((IBlockAccess)world, x, y, z) == ChromaTiles.PYLON && (te = (TileEntityCrystalPylon)world.func_147438_o(x, y, z)).hasStructure() && te.getEnergy(te.getColor()) >= te.getMaxStorage(te.getColor()) / 10) {
                    ProgressionManager.instance.setPlayerDiscoveredColor(ep, te.getColor(), true, true);
                    if (ModList.THAUMCRAFT.isLoaded() && ReikaItemHelper.matchStacks((ItemStack)ep.func_71045_bC(), (ItemStack)ThaumItemHelper.ItemEntry.THAUMOMETER.getItem()) && ep.func_71039_bw() && ep.field_71072_f <= 5 && !ModInteraction.triggerPylonScanProgress(ep, te)) {
                        ep.func_71041_bz();
                    }
                }
                if ((b = world.func_147439_a(x, y, z)) instanceof ProgressionTrigger) {
                    ProgressStage[] ps = ((ProgressionTrigger)b).getTriggers(ep, world, x, y, z);
                    if (ps != null) {
                        for (int i = 0; i < ps.length; ++i) {
                            ProgressStage p = ps[i];
                            p.stepPlayerTo(ep);
                        }
                    }
                } else if (b == Blocks.field_150357_h && y < 6) {
                    ProgressStage.BEDROCK.stepPlayerTo(ep);
                } else if (b == Blocks.field_150474_ac) {
                    ProgressStage.FINDSPAWNER.stepPlayerTo(ep);
                } else if (ModList.THAUMCRAFT.isLoaded() && b == ThaumItemHelper.BlockEntry.NODE.getBlock()) {
                    ProgressStage.NODE.stepPlayerTo(ep);
                }
            }
            if (world.field_73011_w.field_76574_g == -1 && ep.field_70163_u > 128.0) {
                ProgressStage.NETHERROOF.stepPlayerTo(ep);
            }
            if (world.field_73011_w.field_76574_g == 0 && ep.field_70163_u < 18.0 && world.func_72972_b(EnumSkyBlock.Sky, x0, y0, z0) == 0) {
                ProgressStage.DEEPCAVE.stepPlayerTo(ep);
            }
            if (world.field_73011_w.field_76574_g == 0 && world.func_72807_a(x0, z0) instanceof BiomeRainbowForest) {
                ProgressStage.RAINBOWFOREST.stepPlayerTo(ep);
            }
        }
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.PLAYER);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.START;
    }

    public String getLabel() {
        return "ChromatiCraft Exploration Monitor";
    }
}

