/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.ProtectionZone;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.TileEntity.AOE.Defence.TileEntityGuardianStone;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class GuardianStoneManager {
    public static final GuardianStoneManager instance = new GuardianStoneManager();
    private final ArrayList<ProtectionZone> zones = new ArrayList();
    private final MultiMap<BlockKey, PlayerInteractEvent.Action> blockExceptions = new MultiMap(MultiMap.CollectionType.HASHSET);
    private final MultiMap<KeyedItemStack, PlayerInteractEvent.Action> itemExceptions = new MultiMap(MultiMap.CollectionType.HASHSET);

    private GuardianStoneManager() {
        for (String s : ChromatiCraft.config.getGuardianExceptions()) {
            if (this.parseString(s)) {
                ChromatiCraft.logger.log((Object)("Registered Guardian Stone Exception: " + s));
                continue;
            }
            ChromatiCraft.logger.logError((Object)("Could not parse Guardian Stone exception, due to a malformed line (or missing item): " + s));
        }
    }

    private boolean parseString(String s) {
        ItemStack is;
        String[] parts = s.split("#");
        if (parts.length != 2) {
            return false;
        }
        boolean empty = parts[0].equals("none") || parts[0].equals("null") || parts[0].equals("empty");
        ItemStack itemStack = is = empty ? null : ReikaItemHelper.lookupItem((String)parts[0]);
        if (is == null && !empty) {
            return false;
        }
        PlayerInteractEvent.Action a = null;
        try {
            a = PlayerInteractEvent.Action.valueOf((String)parts[1].toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (a == null) {
            return false;
        }
        if (empty) {
            this.itemExceptions.addValue(null, (Object)a);
        } else {
            Block b = Block.func_149634_a((Item)is.func_77973_b());
            if (b != null && b != Blocks.field_150350_a) {
                this.addBlockException(new BlockKey(b, is.func_77960_j()), a);
            } else {
                this.addItemException(is, a);
            }
        }
        return true;
    }

    public void addBlockException(BlockKey bk, PlayerInteractEvent.Action a) {
        this.blockExceptions.addValue((Object)bk, (Object)a);
    }

    public void addItemException(ItemStack is, PlayerInteractEvent.Action a) {
        this.itemExceptions.addValue((Object)new KeyedItemStack(is).setSimpleHash(true), (Object)a);
    }

    public boolean canPlayerOverrideProtections(EntityPlayer ep) {
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return false;
        }
        return ReikaPlayerAPI.isReika((EntityPlayer)ep) || ep instanceof EntityPlayerMP && ReikaPlayerAPI.isAdmin((EntityPlayerMP)((EntityPlayerMP)ep));
    }

    public ProtectionZone addZone(World world, int x, int y, int z, EntityPlayer ep, int r) {
        if (ep == null) {
            int dim = world.field_73011_w.field_76574_g;
            ChromatiCraft.logger.logError((Object)("Tried to generate a protection zone for a null player at " + x + ", " + y + ", " + z + " in " + dim));
            return null;
        }
        ProtectionZone zone = new ProtectionZone(world, ep, x, y, z, r);
        this.zones.add(zone);
        return zone;
    }

    private ArrayList<ProtectionZone> getProtectionZonesForArea(World world, int x, int y, int z) {
        ArrayList<ProtectionZone> in = new ArrayList<ProtectionZone>();
        for (int i = 0; i < this.zones.size(); ++i) {
            ProtectionZone zone = this.zones.get(i);
            if (world.field_73011_w.field_76574_g != zone.dimensionID || !zone.isBlockInZone(x, y, z)) continue;
            in.add(zone);
        }
        return in;
    }

    public ArrayList<ProtectionZone> getProtectionZonesForPlayer(EntityPlayer ep) {
        ArrayList<ProtectionZone> in = new ArrayList<ProtectionZone>();
        for (int i = 0; i < this.zones.size(); ++i) {
            ProtectionZone zone = this.zones.get(i);
            if (!zone.creator.equals(ep.func_70005_c_())) continue;
            in.add(zone);
        }
        return in;
    }

    public void removeAreasForStone(TileEntityGuardianStone te) {
        int id = te.field_145850_b.field_73011_w.field_76574_g;
        int x = te.field_145851_c;
        int y = te.field_145848_d;
        int z = te.field_145849_e;
        Iterator<ProtectionZone> it = this.zones.iterator();
        while (it.hasNext()) {
            ProtectionZone zone = it.next();
            if (zone.originX != x || zone.originY != y || zone.originZ != z || zone.dimensionID != id) continue;
            it.remove();
        }
    }

    public boolean doesPlayerHavePermissions(World world, int x, int y, int z, EntityPlayer ep) {
        if (this.canPlayerOverrideProtections(ep)) {
            return true;
        }
        for (int i = 0; i < this.zones.size(); ++i) {
            ProtectionZone zone = this.zones.get(i);
            if (world.field_73011_w.field_76574_g != zone.dimensionID || !zone.isBlockInZone(x, y, z) || zone.canPlayerEditIn(ep)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.zones.toString();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void guardArea(BlockEvent.BreakEvent event) {
        EntityPlayer ep = event.getPlayer();
        if (ep == null) {
            ChromatiCraft.logger.logError((Object)"Something tried a null-player break event!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        if (!world.field_72995_K && !this.doesPlayerHavePermissions(world, x, y, z, ep)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void guardArea(PlayerInteractEvent event) {
        EntityPlayer ep = event.entityPlayer;
        if (ep == null) {
            ChromatiCraft.logger.logError((Object)"Something tried a null-player interact event!");
            ReikaJavaLibrary.dumpStack();
            return;
        }
        World world = ep.field_70170_p;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        if (!(world.field_72995_K || this.doesPlayerHavePermissions(world, x, y, z, ep) || this.isWhitelistedAction(event.action, world, x, y, z, ep.func_71045_bC()))) {
            event.setCanceled(true);
        }
    }

    private boolean isWhitelistedAction(PlayerInteractEvent.Action a, World world, int x, int y, int z, ItemStack is) {
        return this.blockExceptions.get((Object)BlockKey.getAt((IBlockAccess)world, (int)x, (int)y, (int)z)).contains(a) || this.itemExceptions.get(is != null ? new KeyedItemStack(is).setSimpleHash(true) : null).contains(a);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void preventEndermen(EnderTeleportEvent event) {
        int z;
        int y;
        int x;
        if (event.entityLiving instanceof EntityEnderman && !this.getProtectionZonesForArea(event.entityLiving.field_70170_p, x = MathHelper.func_76128_c((double)event.targetX), y = MathHelper.func_76128_c((double)event.targetY), z = MathHelper.func_76128_c((double)event.targetZ)).isEmpty()) {
            event.setCanceled(true);
        }
    }
}

