/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Auxiliary.Trackers.RemoteAssetLoader;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.Collection;

@SideOnly(value=Side.CLIENT)
public class MusicLoader {
    public static final MusicLoader instance = new MusicLoader();
    private static final File mcDir = DragonAPICore.getMinecraftDirectory();
    private static final String hashURL = "https://cache.techjargaming.com/reika/list.php?dir=ccmusic/";
    public static final File musicPath = new File(mcDir, "mods/Reika/ChromatiCraft/Music");
    private final MusicFolder folder = new MusicFolder();

    private MusicLoader() {
    }

    public void registerAssets() {
        RemoteAssetLoader.instance.registerAssets((RemoteAssetLoader.RemoteAssetRepository)this.folder);
    }

    public Collection<String> getMusicFiles() {
        return this.folder.getAvailableResources();
    }

    private static class MusicAsset
    extends RemoteAssetLoader.RemoteAsset {
        private String track;

        private MusicAsset(MusicFolder f) {
            super((DragonAPIMod)ChromatiCraft.instance, (RemoteAssetLoader.RemoteAssetRepository)f);
        }

        protected RemoteAssetLoader.AssetData constructData(String line) {
            String[] parts = line.split("\\|");
            String path = parts[0];
            String hash = parts[1];
            String size = parts[2];
            String name = path.substring(path.lastIndexOf(47) + 1, path.length() - 4);
            return new RemoteAssetLoader.AssetData((RemoteAssetLoader.RemoteAsset)this, path, name, hash, Long.parseLong(size));
        }

        public String getDisplayName() {
            return "Music Track '" + this.track + "'";
        }

        public String setFilename(String line) {
            String name;
            String[] parts = line.split("\\|");
            String path = parts[0];
            this.track = name = path.substring(path.lastIndexOf(47) + 1, path.length() - 4);
            return this.track;
        }

        public String setExtension(String line) {
            String[] parts = line.split("\\|");
            String path = parts[0];
            String name = path.substring(path.lastIndexOf(47) + 1, path.length() - 4);
            return path.substring(path.length() - 3, path.length());
        }
    }

    private static class MusicFolder
    extends RemoteAssetLoader.RemoteAssetRepository {
        private MusicFolder() {
            super((DragonAPIMod)ChromatiCraft.instance);
        }

        public String getRepositoryURL() {
            return MusicLoader.hashURL;
        }

        protected RemoteAssetLoader.RemoteAsset parseAsset(String line) {
            return new MusicAsset(this);
        }

        public String getDisplayName() {
            return "ChromatiCraft Dimension Music";
        }

        private Collection<RemoteAssetLoader.RemoteAsset> getMusicAssets() {
            return this.getAssets();
        }

        public File getLocalStorageFolder() {
            return musicPath;
        }
    }
}

