/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.API.Interfaces.RangeUpgradeable;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityRangeBoost;
import Reika.DragonAPI.Base.TileEntityBase;
import net.minecraft.nbt.NBTTagCompound;

public class RangeTracker {
    protected final int baseRange;
    private final int stepSpeed;
    protected int currentRange;

    public RangeTracker(int r) {
        this(r, 1);
    }

    public RangeTracker(int r, int s) {
        this.baseRange = r;
        this.stepSpeed = s;
        this.currentRange = this.baseRange;
    }

    public int getRange() {
        return this.currentRange;
    }

    protected final int getMaxUpgradedRange(RangeUpgradeable te) {
        int max = this.baseRange;
        int boost = TileEntityAdjacencyUpgrade.getAdjacentUpgrade((TileEntityBase)te, CrystalElement.LIME);
        if (boost > 0) {
            double fac = TileEntityRangeBoost.getFactor(boost - 1);
            max = (int)((double)max * fac);
        }
        return max;
    }

    public void initialize(RangeUpgradeable te) {
        this.currentRange = this.getMaxUpgradedRange(te);
    }

    public final boolean update(RangeUpgradeable te) {
        if (((TileEntityBase)te).field_145850_b.field_72995_K) {
            return false;
        }
        int max = this.getMaxUpgradedRange(te);
        if (max > this.currentRange) {
            this.currentRange = Math.min(max, this.currentRange + this.stepSpeed);
            return true;
        }
        if (max < this.currentRange) {
            this.currentRange = max;
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("current", this.currentRange);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.currentRange = tag.func_74762_e("current");
    }

    public static final class ConfigurableRangeTracker
    extends RangeTracker {
        private final int minimumRange;
        private int configuredRange;

        public ConfigurableRangeTracker(int r, int min) {
            super(r);
            this.minimumRange = min;
            this.configuredRange = this.baseRange;
        }

        public ConfigurableRangeTracker(int r, int s, int min) {
            super(r, s);
            this.minimumRange = min;
            this.configuredRange = this.baseRange;
        }

        @Override
        public void initialize(RangeUpgradeable te) {
            this.currentRange = this.configuredRange;
        }

        public boolean decrement(RangeUpgradeable te, int amt) {
            return this.setRange(Math.max(this.configuredRange - amt, this.minimumRange));
        }

        public boolean increment(RangeUpgradeable te, int amt) {
            return this.setRange(Math.min(this.configuredRange + amt, this.getMaxUpgradedRange(te)));
        }

        private boolean setRange(int r) {
            if (r != this.configuredRange) {
                this.configuredRange = r;
                return true;
            }
            return false;
        }

        @Override
        public int getRange() {
            return Math.min(super.getRange(), this.configuredRange);
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            tag.func_74768_a("range", this.configuredRange);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            this.configuredRange = tag.func_74762_e("range");
        }
    }
}

