/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Blocks;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.CoreRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Items.ItemTieredResource;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class CrystalStoneRecipe
extends CastingRecipe
implements CoreRecipe {
    private final HashSet<ProgressStage> requiredProgress = new HashSet();

    public CrystalStoneRecipe(BlockPylonStructure.StoneTypes s, int amt, IRecipe recipe) {
        super(CrystalStoneRecipe.calcOutput(s, amt), recipe);
    }

    public CrystalStoneRecipe(BlockPylonStructure.StoneTypes s, int amt, Object ... recipe) {
        super(CrystalStoneRecipe.calcOutput(s, amt), CrystalStoneRecipe.getRecipe(s, amt, recipe));
        for (Object o : recipe) {
            if (!(o instanceof ItemStack)) continue;
            ItemStack is = (ItemStack)o;
            if (ChromaItems.SHARD.matchWith(is) && is.func_77960_j() >= 16) {
                this.requiredProgress.add(ProgressStage.SHARDCHARGE);
                continue;
            }
            if (ChromaBlocks.RUNE.match(is)) {
                this.requiredProgress.add(ProgressStage.ALLCOLORS);
                continue;
            }
            if (ReikaItemHelper.matchStacks((ItemStack)ChromaStacks.iridCrystal, (ItemStack)is)) {
                this.requiredProgress.add(ProgressStage.INFUSE);
                continue;
            }
            if (!ChromaItems.TIERED.matchWith(is)) continue;
            this.requiredProgress.add(((ItemTieredResource)is.func_77973_b()).getDiscoveryTier(is));
        }
    }

    private static IRecipe getRecipe(BlockPylonStructure.StoneTypes s, int amt, Object ... recipe) {
        return ReikaRecipeHelper.getShapedRecipeFor((ItemStack)CrystalStoneRecipe.calcOutput(s, amt), (Object[])recipe);
    }

    private static ItemStack calcOutput(BlockPylonStructure.StoneTypes s, int amt) {
        return new ItemStack(ChromaBlocks.PYLONSTRUCT.getBlockInstance(), amt, s.ordinal());
    }

    @Override
    public final boolean canBeSimpleAutomated() {
        return true;
    }

    @Override
    protected final void getRequiredProgress(Collection<ProgressStage> c) {
        super.getRequiredProgress(c);
        c.addAll(this.requiredProgress);
    }
}

