/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Blocks;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.CoreRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Tiles.RecipeCrystalRepeater;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntitySparkleFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PortalRecipe
extends CastingRecipe.PylonCastingRecipe
implements CoreRecipe {
    public PortalRecipe(ItemStack out, ItemStack main, RecipeCrystalRepeater repeater) {
        super(out, main);
        this.addAuxItem(ChromaStacks.energyPowder, -2, 0);
        this.addAuxItem(ChromaStacks.energyPowder, 2, 0);
        this.addAuxItem(ChromaStacks.energyPowder, 0, 2);
        this.addAuxItem(ChromaStacks.energyPowder, 0, -2);
        this.addAuxItem(ChromaStacks.spaceDust, -2, -2);
        this.addAuxItem(ChromaStacks.spaceDust, 2, -2);
        this.addAuxItem(ChromaStacks.spaceDust, -2, 2);
        this.addAuxItem(ChromaStacks.spaceDust, 2, 2);
        this.addAuxItem(Items.field_151114_aO, -4, 0);
        this.addAuxItem(Items.field_151114_aO, 4, 0);
        this.addAuxItem(Items.field_151061_bv, 0, 4);
        this.addAuxItem(Items.field_151061_bv, 0, -4);
        this.addAuxItem(ChromaStacks.complexIngot, -4, -4);
        this.addAuxItem(ChromaStacks.complexIngot, 4, 4);
        this.addAuxItem((Block)Blocks.field_150461_bJ, -4, 4);
        this.addAuxItem((Block)Blocks.field_150461_bJ, 4, -4);
        this.addAuxItem(Blocks.field_150377_bs, -2, -4);
        this.addAuxItem(Blocks.field_150377_bs, 4, -2);
        this.addAuxItem(Blocks.field_150377_bs, 2, 4);
        this.addAuxItem(Blocks.field_150377_bs, -4, 2);
        this.addAuxItem(Items.field_151166_bC, 2, -4);
        this.addAuxItem(Items.field_151166_bC, -4, -2);
        this.addAuxItem(Items.field_151166_bC, -2, 4);
        this.addAuxItem(Items.field_151166_bC, 4, 2);
        for (int i = 0; i < 16; ++i) {
            CrystalElement e;
            this.addAuraRequirement(e, (e = CrystalElement.elements[i]).isPrimary() ? 120000 : 60000);
            this.addRuneRingRune(e);
        }
        this.addRunes(repeater.getRunes());
    }

    @Override
    public int getNumberProduced() {
        return 9;
    }

    @Override
    public void onCrafted(TileEntityCastingTable te, EntityPlayer ep, ItemStack output, int amount) {
        super.onCrafted(te, ep, output, amount);
    }

    @Override
    public void onRecipeTick(TileEntityCastingTable te) {
        if (!te.field_145850_b.field_72995_K) {
            int tick = te.getCraftingTick();
            for (int i = 0; i < EffectType.list.length; ++i) {
                EffectType e = EffectType.list[i];
                if (!e.getChance(te.getRandom(), tick)) continue;
                e.doEffect(te);
                ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.PORTALRECIPE.ordinal(), (TileEntity)te, (int)64, (int[])new int[]{i});
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void onClientSideRandomTick(TileEntityCastingTable te, int effect) {
        EffectType.list[effect].doEffect(te);
    }

    @Override
    public ChromaSounds getSoundOverride(TileEntityCastingTable te, int soundTimer) {
        return null;
    }

    @Override
    protected void getRequiredProgress(Collection<ProgressStage> c) {
        c.addAll(ProgressionManager.instance.getPrereqs(ProgressStage.DIMENSION));
    }

    @Override
    public int getExperience() {
        return super.getExperience() * 50;
    }

    @Override
    public int getDuration() {
        return 2400;
    }

    @Override
    public int getTypicalCraftedAmount() {
        return 1;
    }

    @Override
    public int getPenaltyThreshold() {
        return 1;
    }

    @Override
    public float getPenaltyMultiplier() {
        return 0.0f;
    }

    private static void genExplosion(TileEntityCastingTable te) {
        int x = ReikaRandomHelper.getRandomPlusMinus((int)te.field_145851_c, (int)8);
        int y = ReikaRandomHelper.getRandomPlusMinus((int)te.field_145848_d, (int)2);
        int z = ReikaRandomHelper.getRandomPlusMinus((int)te.field_145849_e, (int)8);
        ReikaParticleHelper.EXPLODE.spawnAroundBlock(te.field_145850_b, x, y, z, 4);
        ReikaSoundHelper.playSoundAtBlock((World)te.field_145850_b, (int)x, (int)y, (int)z, (String)"random.explode");
        ReikaSoundHelper.playSoundAtBlock((World)te.field_145850_b, (int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e, (String)"random.explode");
    }

    private static void genLightning(TileEntityCastingTable te) {
        te.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(te.field_145850_b, (double)te.field_145851_c, (double)te.field_145848_d, (double)te.field_145849_e));
        ChromaSounds.DISCHARGE.playSoundAtBlock((TileEntity)te);
    }

    @SideOnly(value=Side.CLIENT)
    private static void generateBurstParticles(TileEntityCastingTable te) {
        int x = te.field_145851_c;
        int y = te.field_145848_d;
        int z = te.field_145849_e;
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.INFUSE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)1.0f);
        ElementTagCompound tag = ElementTagCompound.getUniformTag(1);
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if (!e.isPrimary()) continue;
            tag.setTag(e, 4);
        }
        WeightedRandom<CrystalElement> w = tag.asWeightedRandom();
        for (int i = 0; i < 32; ++i) {
            CrystalElement e = (CrystalElement)w.getRandomEntry();
            double ang = te.getRandom().nextDouble() * 360.0;
            double v = 0.125;
            double vx = v * Math.cos(Math.toRadians(ang));
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)v, (double)v);
            double vz = v * Math.sin(Math.toRadians(ang));
            int c = ReikaColorAPI.mixColors((int)e.getColor(), (int)0xFFFFFF, (float)0.5f);
            EntitySparkleFX fx = new EntitySparkleFX(te.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vx, vy, vz).setColor(c).setScale(1.0f);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
        return 6.0f;
    }

    private static enum EffectType {
        EXPLODE(true),
        LIGHTNING(true),
        INFUSE(false);

        public final boolean runServerside;
        private static final EffectType[] list;

        private EffectType(boolean b) {
            this.runServerside = b;
        }

        public boolean getChance(Random rand, int tick) {
            switch (this) {
                case EXPLODE: {
                    return rand.nextInt(5 + tick / 2) == 0;
                }
                case LIGHTNING: {
                    return rand.nextInt(10 + tick / 4) == 0;
                }
                case INFUSE: {
                    return rand.nextInt(5 + tick % 32) == 0;
                }
            }
            return false;
        }

        public void doEffect(TileEntityCastingTable te) {
            if (!te.field_145850_b.field_72995_K && !this.runServerside) {
                return;
            }
            switch (this) {
                case EXPLODE: {
                    PortalRecipe.genExplosion(te);
                    break;
                }
                case LIGHTNING: {
                    PortalRecipe.genLightning(te);
                    break;
                }
                case INFUSE: {
                    PortalRecipe.generateBurstParticles(te);
                }
            }
        }

        static {
            list = EffectType.values();
        }
    }
}

