/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Special;

import Reika.ChromatiCraft.API.CastingAPI;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Decoration.TileEntityParticleSpawner;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;

public class ConfigRecipe {
    public static CastingAPI.FXCallback constructFXFromLuaBlock(LuaBlock c) {
        ConfigFX ret = new ConfigFX();
        for (LuaBlock lb : c.getChildren()) {
            ConfigParticle fx = new ConfigParticle(lb);
            ret.particles.add(fx);
        }
        return ret;
    }

    private static class ConfigParticle {
        private final TileEntityParticleSpawner.ParticleDefinition particle;
        private final float chancePerTick;
        private final int minTickDelay;
        private int ticksSinceSpawned;

        private ConfigParticle(LuaBlock lb) {
            this.chancePerTick = (float)lb.getDouble("chance_per_tick");
            this.minTickDelay = lb.getInt("min_interval");
            this.particle = new TileEntityParticleSpawner.ParticleDefinition();
            this.particle.readLuaBlock(lb.getChild("particle_data"));
        }

        private boolean canSpawn(Random rand) {
            return this.ticksSinceSpawned >= this.minTickDelay && rand.nextFloat() <= this.chancePerTick;
        }

        @SideOnly(value=Side.CLIENT)
        private void spawn(TileEntityCastingTable te) {
            this.particle.setLocation((TileEntity)te);
            EntityFX fx = this.particle.getFX(te.getTicksExisted());
            if (fx != null) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
            }
            this.ticksSinceSpawned = 0;
        }
    }

    private static class ConfigFX
    implements CastingAPI.FXCallback {
        private final ArrayList<ConfigParticle> particles = new ArrayList();

        private ConfigFX() {
        }

        @Override
        public void onEffectTick(TileEntity te, Object recipe, ItemStack output) {
            for (ConfigParticle fx : this.particles) {
                if (fx.canSpawn(DragonAPICore.rand)) {
                    fx.spawn((TileEntityCastingTable)te);
                }
                fx.ticksSinceSpawned++;
            }
        }
    }

    public static final class Pylon
    extends CastingRecipe.PylonCastingRecipe {
        private final int duration;
        private final int typicalCrafted;
        private final ItemStack centralLeftover;
        private final float automationCost;
        private final float experienceFactor;
        private final Collection<ProgressStage> extraProgress;

        public Pylon(ItemStack out, ItemStack center, int dur, int typical, ItemStack leftover, float autocost, float xp, HashMap<Coordinate, CrystalElement> runes, HashMap<Coordinate, Object> items, HashMap<CrystalElement, Integer> energy, Collection<ProgressStage> p) {
            super(out, center);
            for (Coordinate c : runes.keySet()) {
                this.addRune(runes.get(c).ordinal(), c.xCoord, c.yCoord, c.zCoord);
            }
            for (Coordinate c : items.keySet()) {
                Object o = items.get(c);
                if (o instanceof String) {
                    this.addAuxItem((String)o, c.xCoord, c.zCoord);
                }
                if (!(o instanceof ItemStack)) continue;
                this.addAuxItem((ItemStack)o, c.xCoord, c.zCoord);
            }
            for (CrystalElement e : energy.keySet()) {
                this.addAuraRequirement(e, (int)energy.get(e));
            }
            this.duration = dur;
            this.typicalCrafted = typical;
            this.centralLeftover = leftover;
            this.automationCost = autocost;
            this.experienceFactor = xp;
            this.extraProgress = p;
        }

        @Override
        public int getDuration() {
            return this.duration > 0 ? this.duration : super.getDuration();
        }

        @Override
        public int getTypicalCraftedAmount() {
            return this.typicalCrafted;
        }

        @Override
        public float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
            return this.automationCost;
        }

        @Override
        public ItemStack getCentralLeftover(ItemStack is) {
            return this.centralLeftover;
        }

        @Override
        public void getRequiredProgress(Collection<ProgressStage> c) {
            super.getRequiredProgress(c);
            c.addAll(this.extraProgress);
        }

        @Override
        public int getExperience() {
            return (int)((float)super.getExperience() * this.experienceFactor);
        }
    }

    public static final class Multi
    extends CastingRecipe.MultiBlockCastingRecipe {
        private final int duration;
        private final int typicalCrafted;
        private final ItemStack centralLeftover;
        private final float automationCost;
        private final float experienceFactor;
        private final Collection<ProgressStage> extraProgress;

        public Multi(ItemStack out, ItemStack center, int dur, int typical, ItemStack leftover, float autocost, float xp, HashMap<Coordinate, CrystalElement> runes, HashMap<Coordinate, Object> items, Collection<ProgressStage> p) {
            super(out, center);
            for (Coordinate c : runes.keySet()) {
                this.addRune(runes.get(c).ordinal(), c.xCoord, c.yCoord, c.zCoord);
            }
            for (Coordinate c : items.keySet()) {
                Object o = items.get(c);
                if (o instanceof String) {
                    this.addAuxItem((String)o, c.xCoord, c.zCoord);
                }
                if (!(o instanceof ItemStack)) continue;
                this.addAuxItem((ItemStack)o, c.xCoord, c.zCoord);
            }
            this.duration = dur;
            this.typicalCrafted = typical;
            this.centralLeftover = leftover;
            this.automationCost = autocost;
            this.experienceFactor = xp;
            this.extraProgress = p;
        }

        @Override
        public int getDuration() {
            return this.duration > 0 ? this.duration : super.getDuration();
        }

        @Override
        public int getTypicalCraftedAmount() {
            return this.typicalCrafted;
        }

        @Override
        public float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
            return this.automationCost;
        }

        @Override
        public ItemStack getCentralLeftover(ItemStack is) {
            return this.centralLeftover;
        }

        @Override
        public void getRequiredProgress(Collection<ProgressStage> c) {
            super.getRequiredProgress(c);
            c.addAll(this.extraProgress);
        }

        @Override
        public int getExperience() {
            return (int)((float)super.getExperience() * this.experienceFactor);
        }
    }

    public static final class Rune
    extends CastingRecipe.TempleCastingRecipe {
        private final int duration;
        private final int typicalCrafted;
        private final ItemStack centralLeftover;
        private final float automationCost;
        private final float experienceFactor;
        private final Collection<ProgressStage> extraProgress;

        public Rune(IRecipe ir, int dur, int typical, ItemStack leftover, float autocost, float xp, HashMap<Coordinate, CrystalElement> runes, Collection<ProgressStage> p) {
            super(ir.func_77571_b(), ir);
            for (Coordinate c : runes.keySet()) {
                this.addRune(runes.get(c).ordinal(), c.xCoord, c.yCoord, c.zCoord);
            }
            this.duration = dur;
            this.typicalCrafted = typical;
            this.centralLeftover = leftover;
            this.automationCost = autocost;
            this.experienceFactor = xp;
            this.extraProgress = p;
        }

        @Override
        public int getDuration() {
            return this.duration > 0 ? this.duration : super.getDuration();
        }

        @Override
        public int getTypicalCraftedAmount() {
            return this.typicalCrafted;
        }

        @Override
        public float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
            return this.automationCost;
        }

        @Override
        public ItemStack getCentralLeftover(ItemStack is) {
            return this.centralLeftover;
        }

        @Override
        public void getRequiredProgress(Collection<ProgressStage> c) {
            super.getRequiredProgress(c);
            c.addAll(this.extraProgress);
        }

        @Override
        public int getExperience() {
            return (int)((float)super.getExperience() * this.experienceFactor);
        }
    }

    public static final class Basic
    extends CastingRecipe {
        private final int duration;
        private final int typicalCrafted;
        private final ItemStack centralLeftover;
        private final float automationCost;
        private final float experienceFactor;
        private final Collection<ProgressStage> extraProgress;

        public Basic(IRecipe ir, int dur, int typical, ItemStack leftover, float autocost, float xp, Collection<ProgressStage> p) {
            super(ir.func_77571_b(), ir);
            this.duration = dur;
            this.typicalCrafted = typical;
            this.centralLeftover = leftover;
            this.automationCost = autocost;
            this.experienceFactor = xp;
            this.extraProgress = p;
        }

        @Override
        public int getDuration() {
            return this.duration > 0 ? this.duration : super.getDuration();
        }

        @Override
        public int getTypicalCraftedAmount() {
            return this.typicalCrafted;
        }

        @Override
        public float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
            return this.automationCost;
        }

        @Override
        public ItemStack getCentralLeftover(ItemStack is) {
            return this.centralLeftover;
        }

        @Override
        public void getRequiredProgress(Collection<ProgressStage> c) {
            super.getRequiredProgress(c);
            c.addAll(this.extraProgress);
        }

        @Override
        public int getExperience() {
            return (int)((float)super.getExperience() * this.experienceFactor);
        }
    }
}

