/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Special;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class EnchantmentRecipe
extends CastingRecipe.MultiBlockCastingRecipe {
    private static final HashMap<Coordinate, CrystalElement> runeMap = new HashMap();
    public final ChromaResearch parent;
    public final Enchantment enchantment;
    public final int level;

    public EnchantmentRecipe(ChromaResearch r, ItemStack ctr, ItemStack side, ItemStack top, ItemStack bottom, Enchantment e, int lvl) {
        super(ctr, ctr);
        this.addAuxItem(top, 0, -2);
        this.addAuxItem(bottom, 0, 2);
        this.addAuxItem(side, 2, 0);
        this.addAuxItem(side, -2, 0);
        this.addAuxItem(ChromaItems.ELEMENTAL.getStackOf(CrystalElement.PURPLE), -2, -2);
        this.addAuxItem(ChromaItems.ELEMENTAL.getStackOf(CrystalElement.BLACK), 2, 2);
        this.addAuxItem(ChromaStacks.bindingCrystal, -2, 2);
        this.addAuxItem(ChromaStacks.bindingCrystal, 2, -2);
        for (Coordinate c : runeMap.keySet()) {
            this.addRune(runeMap.get(c), c.xCoord, c.yCoord, c.zCoord);
        }
        this.enchantment = e;
        this.level = lvl;
        this.parent = r;
        if (this.parent == null) {
            throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "No parent for enchantment recipe " + ctr.func_82833_r() + " {" + e.func_77320_a() + " " + lvl + "}");
        }
        this.setFragment(ChromaResearch.ENCHANTING);
    }

    @Override
    public NBTTagCompound getOutputTag(EntityPlayer ep, NBTTagCompound input) {
        NBTTagCompound tag = input != null ? (NBTTagCompound)input.func_74737_b() : new NBTTagCompound();
        ReikaEnchantmentHelper.addEnchantment((NBTTagCompound)tag, (Enchantment)this.enchantment, (int)this.level, (boolean)false);
        return tag;
    }

    @Override
    protected boolean isValidCentralNBT(ItemStack is) {
        return super.isValidCentralNBT(is) && ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)this.enchantment, (ItemStack)is) < this.level;
    }

    @Override
    public int getDuration() {
        return 12 * super.getDuration();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return "Star Enchanting: " + this.enchantment.func_77316_c(this.level);
    }

    public static Map<Coordinate, CrystalElement> getEnchantingRunes() {
        return Collections.unmodifiableMap(runeMap);
    }

    static {
        runeMap.put(new Coordinate(4, -1, -4), CrystalElement.PURPLE);
        runeMap.put(new Coordinate(-4, -1, 4), CrystalElement.BLACK);
    }
}

