/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Tiles;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.AdjacencyUpgrades;
import Reika.ChromatiCraft.Registry.CrystalElement;
import java.util.Collection;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class AdjacencyRecipe
extends CastingRecipe.PylonCastingRecipe {
    private static final Item[] upgrade = new Item[]{Items.field_151042_j, Items.field_151042_j, Items.field_151043_k, Items.field_151043_k, Items.field_151045_i, Items.field_151166_bC, Items.field_151156_bN};
    private final int tier;

    public AdjacencyRecipe(CrystalElement e, int n) {
        super(AdjacencyRecipe.getItem(e, n), AdjacencyRecipe.getMainItem(e, n));
        this.tier = n;
        ItemStack corner = this.tier == 0 ? new ItemStack(Items.field_151045_i) : new ItemStack(upgrade[this.tier - 1]);
        this.addAuxItem(corner, -2, -2);
        this.addAuxItem(corner, 2, -2);
        this.addAuxItem(corner, 2, 2);
        this.addAuxItem(corner, -2, 2);
        ItemStack shard = AdjacencyRecipe.getChargedShard(e);
        this.addAuxItem(shard, 0, -2);
        this.addAuxItem(shard, 2, 0);
        this.addAuxItem(shard, 0, 2);
        this.addAuxItem(shard, -2, 0);
        this.addAuraRequirement(e, 20000 * (this.tier * 2 + 1));
        this.addAuraRequirement(CrystalElement.YELLOW, 500 * (this.tier + 1));
        this.addRuneRingRune(e);
    }

    @Override
    public int getDuration() {
        return super.getDuration() * (int)(1.0 + (double)this.tier / 2.0);
    }

    private static ItemStack getMainItem(CrystalElement e, int tier) {
        return tier == 0 ? ChromaStacks.crystalStar : AdjacencyRecipe.getItem(e, tier - 1);
    }

    private static ItemStack getItem(CrystalElement e, int tier) {
        return AdjacencyUpgrades.upgrades[e.ordinal()].getStackOfTier(tier);
    }

    @Override
    public int getTypicalCraftedAmount() {
        return 32;
    }

    @Override
    protected void getRequiredProgress(Collection<ProgressStage> c) {
        switch (this.tier) {
            case 7: {
                c.add(ProgressStage.CTM);
                break;
            }
            case 6: {
                c.add(ProgressStage.ALLCORES);
                break;
            }
            case 5: {
                c.add(ProgressStage.STRUCTCOMPLETE);
                break;
            }
            case 4: {
                c.add(ProgressStage.DIMENSION);
            }
        }
    }
}

