/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Tiles;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class MeteorTowerRecipe
extends CastingRecipe.PylonCastingRecipe {
    public MeteorTowerRecipe(int tier) {
        super(MeteorTowerRecipe.getOutput(tier), MeteorTowerRecipe.getCentral(tier));
        this.addAuxItem(ChromaStacks.thermiticCrystal, 0, -2);
        this.addAuxItem(ChromaStacks.thermiticCrystal, 0, 2);
        this.addAuxItem(ChromaStacks.thermiticCrystal, 0, -2);
        this.addAuxItem(ChromaStacks.thermiticCrystal, 0, -4);
        this.addAuxItem(ChromaStacks.thermiticCrystal, -2, -4);
        this.addAuxItem(ChromaStacks.thermiticCrystal, 2, -4);
        if (tier == 0) {
            this.addAuxItem(ChromaStacks.fieryIngot, -4, -4);
            this.addAuxItem(ChromaStacks.fieryIngot, 4, -4);
            this.addAuxItem(ChromaStacks.fieryIngot, -4, 4);
            this.addAuxItem(ChromaStacks.fieryIngot, 4, 4);
        }
        this.addAuxItem(MeteorTowerRecipe.getGlowSource(tier), -2, 4);
        this.addAuxItem(MeteorTowerRecipe.getGlowSource(tier), 0, 4);
        this.addAuxItem(MeteorTowerRecipe.getGlowSource(tier), 2, 4);
        this.addAuxItem(ChromaStacks.energyPowder, -2, 2);
        this.addAuxItem(ChromaStacks.energyPowder, 0, 2);
        this.addAuxItem(ChromaStacks.energyPowder, 2, 2);
        this.addAuxItem(Blocks.field_150343_Z, -4, 2);
        this.addAuxItem(Blocks.field_150343_Z, 4, 2);
        this.addAuxItem(Items.field_151045_i, -2, 0);
        this.addAuxItem(Items.field_151045_i, 2, 0);
        this.addAuxItem(MeteorTowerRecipe.getResoSource(tier), -4, 0);
        this.addAuxItem(MeteorTowerRecipe.getResoSource(tier), 4, 0);
        this.addAuxItem(MeteorTowerRecipe.getFocus(tier), -2, -2);
        this.addAuxItem(MeteorTowerRecipe.getFocus(tier), 2, -2);
        this.addAuxItem(ChromaStacks.firaxite, -4, -2);
        this.addAuxItem(ChromaStacks.firaxite, 4, -2);
        this.addAuraRequirement(CrystalElement.PINK, 40000 * (1 + tier));
        this.addAuraRequirement(CrystalElement.ORANGE, 40000 * (1 + tier));
    }

    private static ItemStack getResoSource(int tier) {
        switch (tier) {
            default: {
                return ChromaStacks.resonanceDust;
            }
            case 1: {
                return ChromaStacks.resocrystal;
            }
            case 2: 
        }
        return ChromaStacks.resocrystal;
    }

    private static ItemStack getGlowSource(int tier) {
        switch (tier) {
            default: {
                return new ItemStack(Blocks.field_150426_aN);
            }
            case 1: {
                return ChromaStacks.glowbeans;
            }
            case 2: 
        }
        return ChromaStacks.lumaDust;
    }

    private static ItemStack getFocus(int tier) {
        switch (tier) {
            default: {
                return ChromaStacks.focusDust;
            }
            case 1: {
                return ChromaStacks.focusDust;
            }
            case 2: 
        }
        return ChromaStacks.spaceDust;
    }

    private static ItemStack getCentral(int tier) {
        return tier == 0 ? ChromaStacks.energyCoreHigh : MeteorTowerRecipe.getOutput(tier - 1);
    }

    private static ItemStack getOutput(int tier) {
        return ChromaTiles.METEOR.getCraftedNBTProduct("tier", tier);
    }
}

