/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemTieredResource;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ItemMagicRegistry;
import Reika.ChromatiCraft.TileEntity.Processing.TileEntityGlowFire;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModInteract.ItemHandlers.BloodMagicHandler;
import Reika.DragonAPI.ModList;
import Reika.GeoStrata.Registry.GeoBlocks;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;

public class FabricationRecipes {
    private static final FabricationRecipes instance = new FabricationRecipes();
    private final HashMap<KeyedItemStack, FabricationRecipe> data = new HashMap();
    private final HashMap<String, FabricationRecipe> fluidRecipes = new HashMap();
    public static final float SCALE = 0.8f;
    public static final float INITFACTOR = 0.5f;
    public static final int FACTOR = 400;
    public static final int POWER = 5;
    private int max;

    public static FabricationRecipes recipes() {
        return instance;
    }

    private FabricationRecipes() {
        ItemStack item;
        ElementTagCompound tag;
        Collection<KeyedItemStack> c = ItemMagicRegistry.instance.keySet();
        for (KeyedItemStack k : c) {
            tag = ItemMagicRegistry.instance.getItemValue(k);
            tag = this.processTag(tag);
            k.setSimpleHash(true);
            this.data.put(k, new FabricationRecipe(k.getItemStack(), tag));
            this.max = Math.max(this.max, tag.getMaximumValue());
        }
        for (int i = 0; i < ChromaItems.TIERED.getNumberMetadatas(); ++i) {
            ItemStack is = ChromaItems.TIERED.getStackOfMetadata(i);
            tag = ItemElementCalculator.instance.getValueForItem(is);
            if (tag == null || tag.isEmpty()) continue;
            tag = this.processTag(tag);
            ProgressStage level = ((ItemTieredResource)is.func_77973_b()).getDiscoveryTier(is);
            float scale = 5.0f;
            if (level.isGatedAfter(ProgressStage.CTM)) {
                scale = 50.0f;
            } else if (level.isGatedAfter(ProgressStage.STRUCTCOMPLETE)) {
                scale = 30.0f;
            } else if (level.isGatedAfter(ProgressStage.DIMENSION)) {
                scale = 20.0f;
            } else if (level.isGatedAfter(ProgressStage.PYLON) || level.isGatedAfter(ProgressStage.ABILITY)) {
                scale = 10.0f;
            }
            tag.scale(scale);
            this.addRecipe(is, false, tag, ProgressStage.CTM);
        }
        ElementTagCompound tag2 = new ElementTagCompound();
        tag2.addTag(CrystalElement.RED, 5000);
        tag2.addTag(CrystalElement.BROWN, 500);
        tag2.addTag(CrystalElement.BLACK, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.STONE.ordinal()), false, tag2, ProgressStage.ANYSTRUCT);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.COBBLE.ordinal()), false, tag2, ProgressStage.ANYSTRUCT);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CRACK.ordinal()), false, tag2, ProgressStage.ANYSTRUCT);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CRACKS.ordinal()), false, tag2, ProgressStage.ANYSTRUCT);
        ElementTagCompound tag22 = tag2.copy();
        tag22.addTag(CrystalElement.WHITE, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.GLASS.ordinal()), false, tag22, ProgressStage.ANYSTRUCT);
        tag22 = tag2.copy();
        tag22.addTag(CrystalElement.WHITE, 500);
        tag22.addTag(CrystalElement.BLUE, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.LIGHT.ordinal()), false, tag22, ProgressStage.ANYSTRUCT);
        tag22 = tag2.copy();
        tag22.addTag(CrystalElement.GREEN, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.MOSS.ordinal()), false, tag22, ProgressStage.ANYSTRUCT);
        tag22 = tag2.copy();
        tag22.addTag(CrystalElement.BLUE, 500);
        this.addRecipe(ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CLOAK.ordinal()), false, tag22, ProgressStage.ANYSTRUCT);
        tag2 = new ElementTagCompound();
        tag2.addTag(CrystalElement.BROWN, 500);
        tag2.addTag(CrystalElement.BLACK, 10000);
        tag2.addTag(CrystalElement.YELLOW, 25000);
        this.addRecipe(ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.GLOWBEAM.ordinal()), false, tag2, new ProgressStage[0]);
        this.addRecipe(ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.GLOWCOL.ordinal()), false, tag2, new ProgressStage[0]);
        this.addRecipe(ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.FOCUS.ordinal()), false, tag2, new ProgressStage[0]);
        if (ModList.THAUMCRAFT.isLoaded() && (item = ReikaItemHelper.lookupItem((ModList)ModList.THAUMCRAFT, (String)"ItemEldritchObject", (int)3)) != null) {
            tag2 = new ElementTagCompound();
            HashSet<CrystalElement> set = new HashSet<CrystalElement>();
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.AIR, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.FIRE, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.WATER, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.ENTROPY, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.EARTH, true));
            set.addAll(ChromaAspectManager.instance.getColorsForAspect(Aspect.ORDER, true));
            for (CrystalElement e : set) {
                tag2.addTag(e, 1000000);
            }
            tag2.addTag(CrystalElement.PINK, 100000);
            tag2.addTag(CrystalElement.BLACK, 100000);
            this.addRecipe(item, true, tag2, new ProgressStage[0]);
        }
        if (ModList.BOTANIA.isLoaded()) {
            item = ReikaItemHelper.lookupItem((ModList)ModList.BOTANIA, (String)"manaResource", (int)5);
            if (item != null) {
                tag2 = new ElementTagCompound();
                tag2.addValueToColor(CrystalElement.PINK, 40000);
                tag2.addValueToColor(CrystalElement.BLACK, 20000);
                tag2.addValueToColor(CrystalElement.GREEN, 20000);
                this.addRecipe(item, false, tag2, new ProgressStage[0]);
            }
            if ((item = ReikaItemHelper.lookupItem((String)"Botania:dice")) != null) {
                tag2 = new ElementTagCompound();
                tag2.addValueToColor(CrystalElement.PINK, 600000);
                tag2.addValueToColor(CrystalElement.BLACK, 1200000);
                tag2.addValueToColor(CrystalElement.GREEN, 300000);
                tag2.addValueToColor(CrystalElement.GRAY, 120000);
                tag2.addValueToColor(CrystalElement.PURPLE, 60000);
                this.addRecipe(item, false, tag2, new ProgressStage[0]);
            }
        }
        if (ModList.BLOODMAGIC.isLoaded()) {
            item = BloodMagicHandler.getInstance().demonShardID;
            if (item != null) {
                tag2 = new ElementTagCompound();
                tag2.addValueToColor(CrystalElement.PINK, 80000);
                tag2.addValueToColor(CrystalElement.BLACK, 20000);
                tag2.addValueToColor(CrystalElement.MAGENTA, 40000);
                tag2.addValueToColor(CrystalElement.LIGHTGRAY, 20000);
                this.addRecipe(new ItemStack((Item)item), true, tag2, new ProgressStage[0]);
            }
            if ((item = BloodMagicHandler.getInstance().resourceID) != null) {
                tag2 = new ElementTagCompound();
                tag2.addValueToColor(CrystalElement.PINK, 20000);
                tag2.addValueToColor(CrystalElement.BLACK, 5000);
                tag2.addValueToColor(CrystalElement.MAGENTA, 10000);
                tag2.addValueToColor(CrystalElement.LIGHTGRAY, 5000);
                this.addRecipe(new ItemStack((Item)item, 1, 29), false, tag2, new ProgressStage[0]);
                this.addRecipe(new ItemStack((Item)item, 1, 28), false, tag2, new ProgressStage[0]);
            }
        }
        if (ModList.THAUMICTINKER.isLoaded()) {
            ElementTagCompound nether = new ElementTagCompound();
            nether.addValueToColor(CrystalElement.ORANGE, 25000);
            nether.addValueToColor(CrystalElement.PINK, 25000);
            nether.addValueToColor(CrystalElement.BLACK, 10000);
            ElementTagCompound end = new ElementTagCompound();
            end.addValueToColor(CrystalElement.LIGHTGRAY, 25000);
            end.addValueToColor(CrystalElement.PINK, 25000);
            end.addValueToColor(CrystalElement.BLACK, 10000);
            this.addRecipe(ReikaItemHelper.lookupItem((ModList)ModList.THAUMICTINKER, (String)"kamiResource", (int)6), false, nether, new ProgressStage[0]);
            this.addRecipe(ReikaItemHelper.lookupItem((ModList)ModList.THAUMICTINKER, (String)"kamiResource", (int)7), false, end, new ProgressStage[0]);
        }
        if (ModList.APPENG.isLoaded() && (item = GameRegistry.findBlock((String)ModList.APPENG.modLabel, (String)"tile.BlockSkyStone")) != null) {
            tag2 = new ElementTagCompound();
            tag2.addValueToColor(CrystalElement.BROWN, 500);
            tag2.addValueToColor(CrystalElement.LIME, 200);
            tag2.addValueToColor(CrystalElement.WHITE, 100);
            this.addRecipe(new ItemStack((Block)item, 1, 0), false, tag2, new ProgressStage[0]);
        }
        if (ModList.FORBIDDENMAGIC.isLoaded() && (item = ReikaItemHelper.lookupItem((String)"ForbiddenMagic:NetherShard:1")) != null) {
            tag2 = new ElementTagCompound();
            tag2.addValueToColor(CrystalElement.PINK, 500);
            tag2.addValueToColor(CrystalElement.ORANGE, 1000);
            tag2.addValueToColor(CrystalElement.LIGHTGRAY, 100);
            this.addRecipe(item, false, tag2, new ProgressStage[0]);
        }
        if (ModList.TINKERER.isLoaded()) {
            ItemStack redheart = ReikaItemHelper.lookupItem((String)"TConstruct:heartCanister:1");
            ItemStack yellowheart = ReikaItemHelper.lookupItem((String)"TConstruct:heartCanister:3");
            if (redheart != null) {
                tag2 = new ElementTagCompound();
                tag2.addValueToColor(CrystalElement.MAGENTA, 900);
                tag2.addValueToColor(CrystalElement.PURPLE, 300);
                tag2.addValueToColor(CrystalElement.RED, 100);
                this.addRecipe(redheart, false, tag2, new ProgressStage[0]);
            }
            if (yellowheart != null) {
                tag2 = new ElementTagCompound();
                tag2.addValueToColor(CrystalElement.MAGENTA, 3000);
                tag2.addValueToColor(CrystalElement.PURPLE, 1000);
                tag2.addValueToColor(CrystalElement.RED, 600);
                tag2.addValueToColor(CrystalElement.PINK, 100);
                this.addRecipe(redheart, false, tag2, new ProgressStage[0]);
            }
        }
        if (ModList.TWILIGHT.isLoaded()) {
            item = ReikaItemHelper.lookupItem((String)"TwilightForest:item.charmOfLife1");
            if (item != null) {
                tag2 = new ElementTagCompound();
                tag2.addValueToColor(CrystalElement.MAGENTA, 2500);
                tag2.addValueToColor(CrystalElement.BLACK, 1000);
                this.addRecipe(item, true, tag2, ProgressStage.TWILIGHT);
            }
            if ((item = ReikaItemHelper.lookupItem((String)"TwilightForest:tile.TFFirefly")) != null) {
                tag2 = new ElementTagCompound();
                tag2.addValueToColor(CrystalElement.BLUE, 300);
                tag2.addValueToColor(CrystalElement.GREEN, 60);
                this.addRecipe(item, false, tag2, ProgressStage.TWILIGHT);
            }
            if ((item = ReikaItemHelper.lookupItem((String)"TwilightForest:item.borerEssence")) != null) {
                tag2 = new ElementTagCompound();
                tag2.addValueToColor(CrystalElement.PINK, 500);
                tag2.addValueToColor(CrystalElement.BROWN, 100);
                tag2.addValueToColor(CrystalElement.LIGHTGRAY, 50);
                this.addRecipe(item, false, tag2, ProgressStage.TWILIGHT);
            }
        }
        if (ModList.GEOSTRATA.isLoaded()) {
            this.addGlowCrystal();
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.GEOSTRATA})
    private void addGlowCrystal() {
        for (int i = 0; i < 4; ++i) {
            ElementTagCompound tag = new ElementTagCompound();
            tag.addValueToColor(CrystalElement.BROWN, 2500);
            tag.addValueToColor(CrystalElement.BLUE, 1000);
            tag.addValueToColor(CrystalElement.WHITE, 250);
            this.addRecipe(GeoBlocks.GLOWCRYS.getStackOfMetadata(i), false, tag, new ProgressStage[0]);
        }
    }

    private void addOreDictRecipe(String ore, ElementTagCompound tag) {
        ArrayList li = OreDictionary.getOres((String)ore);
        for (ItemStack is : li) {
            this.addRecipe(is, false, tag.copy(), new ProgressStage[0]);
        }
    }

    public ElementTagCompound processTag(ElementTagCompound tag) {
        tag = tag.copy();
        tag.scale(0.5f);
        tag.power(5.0);
        tag.scale(400.0f);
        return tag;
    }

    private FabricationRecipe addRecipe(ItemStack is, boolean useNBT, ElementTagCompound tag, ProgressStage ... progress) {
        if (is == null || is.func_77973_b() == null) {
            ChromatiCraft.logger.logError((Object)"Cannot add recipe for null!");
            Thread.dumpStack();
            return null;
        }
        FabricationRecipe f = new FabricationRecipe(is, tag);
        for (ProgressStage p : progress) {
            f.addProgress(p);
        }
        KeyedItemStack ks = new KeyedItemStack(is).setSimpleHash(true);
        if (!useNBT) {
            ks.setIgnoreNBT(true);
        }
        this.data.put(ks, f);
        this.max = Math.max(this.max, tag.getMaximumValue());
        return f;
    }

    private FabricationRecipe addFluidRecipe(ItemStack is, Fluid fluid, ElementTagCompound tag, ProgressStage ... progress) {
        FabricationRecipe f = new FabricationRecipe(is, tag);
        for (ProgressStage p : progress) {
            f.addProgress(p);
        }
        this.fluidRecipes.put(fluid.getName(), f);
        if (fluid.getBlock() != null) {
            f.displayItem = new ItemStack(fluid.getBlock());
        }
        this.max = Math.max(this.max, tag.getMaximumValue());
        return f;
    }

    public Collection<ItemStack> getItemsFabricableWith(ElementTagCompound tag) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (KeyedItemStack ks : this.data.keySet()) {
            ElementTagCompound val = this.data.get(ks).getCost().scale(0.8f);
            if (!tag.containsAtLeast(val)) continue;
            items.add(ks.getItemStack());
        }
        return items;
    }

    public boolean isItemFabricable(ItemStack is) {
        KeyedItemStack ks = new KeyedItemStack(is).setSimpleHash(true);
        return this.data.containsKey(ks);
    }

    public boolean isItemFabricable(ItemStack is, ElementTagCompound tag) {
        KeyedItemStack ks = new KeyedItemStack(is).setSimpleHash(true);
        return this.data.containsKey(ks) && tag.containsAtLeast(this.getItemCost(ks));
    }

    public FabricationRecipe getItemRecipe(ItemStack is) {
        return this.data.get(new KeyedItemStack(is).setSimpleHash(true));
    }

    private ElementTagCompound getItemCost(KeyedItemStack is) {
        FabricationRecipe tag = this.data.get(is);
        return tag != null ? tag.getCost().scale(1.25f) : null;
    }

    public int getMaximumCost() {
        return this.max;
    }

    public Collection<KeyedItemStack> getFabricableItems() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public Collection<KeyedItemStack> getConsumableItems() {
        HashSet<KeyedItemStack> ret = new HashSet<KeyedItemStack>(this.data.keySet());
        for (Object o : Item.field_150901_e.func_148742_b()) {
            String s = (String)o;
            Item i = (Item)Item.field_150901_e.func_82594_a(s);
            for (ItemStack is : ReikaItemHelper.getAllMetadataPermutations((Item)i)) {
                ElementTagCompound val = TileEntityGlowFire.getDecompositionValue(is);
                if (val == null || val.isEmpty()) continue;
                ret.add(new KeyedItemStack(is));
            }
        }
        return ret;
    }

    public FabricationRecipe getOrCreateFluidRecipe(ItemStack is, Fluid f) {
        if (this.fluidRecipes.containsKey(f.getName())) {
            return this.fluidRecipes.get(f.getName());
        }
        ElementTagCompound ftag = ItemMagicRegistry.instance.getFluidValue(f);
        if (ftag == null) {
            return null;
        }
        ElementTagCompound tag = FabricationRecipes.recipes().processTag(ftag).scale(1.25f);
        return this.addFluidRecipe(is, f, tag, new ProgressStage[0]);
    }

    public static class FabricationRecipe {
        private final ItemStack item;
        private final ElementTagCompound energy;
        private Collection<ProgressStage> progress;
        private ItemStack displayItem;

        private FabricationRecipe(ItemStack is, ElementTagCompound tag) {
            this.item = is;
            this.energy = tag;
            this.displayItem = this.item;
        }

        private FabricationRecipe addProgress(ProgressStage p) {
            if (this.progress == null) {
                this.progress = new HashSet<ProgressStage>();
            }
            this.progress.add(p);
            return this;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getDisplay() {
            return this.displayItem.func_77946_l();
        }

        public ItemStack getItem() {
            return this.item.func_77946_l();
        }

        public ElementTagCompound getCost() {
            return this.energy.copy();
        }

        public Collection<ProgressStage> getProgress() {
            return this.progress != null ? Collections.unmodifiableCollection(this.progress) : new ArrayList();
        }

        public boolean hasProgress(EntityPlayer ep) {
            if (this.progress == null || this.progress.isEmpty()) {
                return true;
            }
            if (ep == null || ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
                return false;
            }
            for (ProgressStage p : this.progress) {
                if (p.isPlayerAtStage(ep)) continue;
                return false;
            }
            return true;
        }
    }
}

