/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Base.BlockChromaTile;
import Reika.ChromatiCraft.Base.ItemChromaBasic;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class InscriptionRecipes {
    public static final InscriptionRecipes instance = new InscriptionRecipes();
    private final OneWayCollections.OneWayMap<BlockKey, InscriptionRecipe> recipes = new OneWayCollections.OneWayMap();
    private final OneWayCollections.OneWayMap<Integer, InscriptionRecipe> recipeIDs = new OneWayCollections.OneWayMap();

    private InscriptionRecipes() {
        this.addRecipe(ChromaBlocks.PYLONSTRUCT.getBlockInstance(), BlockPylonStructure.StoneTypes.SMOOTH.ordinal(), ChromaTiles.PYLONLINK, 100);
    }

    private InscriptionRecipe addRecipe(Block in, ChromaTiles out, int time) {
        return this.addRecipe(new BlockKey(in), out, time);
    }

    private InscriptionRecipe addRecipe(Block in, int meta, ChromaTiles out, int time) {
        return this.addRecipe(new BlockKey(in, meta), out, time);
    }

    private InscriptionRecipe addRecipe(BlockKey in, ChromaTiles out, int time) {
        return this.addRecipe(in, new BlockKey(out.getBlock(), out.getBlockMetadata()), time);
    }

    private InscriptionRecipe addRecipe(Block in, BlockKey out, int time) {
        return this.addRecipe(new BlockKey(in), out, time);
    }

    private InscriptionRecipe addRecipe(BlockKey in, BlockKey out, int time) {
        InscriptionRecipe r = new InscriptionRecipe(in, out, time, this.recipes.size());
        this.recipes.put((Object)in, (Object)r);
        this.recipeIDs.put((Object)r.referenceIndex, (Object)r);
        return r;
    }

    public InscriptionRecipe getInscriptionRecipe(World world, int x, int y, int z) {
        return (InscriptionRecipe)this.recipes.get((Object)BlockKey.getAt((IBlockAccess)world, (int)x, (int)y, (int)z));
    }

    public InscriptionRecipe getInscriptionRecipeByOutput(BlockKey out) {
        for (InscriptionRecipe p : this.getAllInscriptionRecipes()) {
            if (!p.output.equals((Object)out)) continue;
            return p;
        }
        return null;
    }

    public void loadCustomInscriptionRecipes() {
        CustomRecipeList crl = new CustomRecipeList((DragonAPIMod)ChromatiCraft.instance, "inscription");
        if (crl.load()) {
            for (LuaBlock lb : crl.getEntries()) {
                Exception e = null;
                boolean flag = false;
                try {
                    flag = this.addCustomRecipe(lb, crl);
                }
                catch (Exception ex) {
                    e = ex;
                    flag = false;
                }
                if (flag) {
                    ChromatiCraft.logger.log((Object)("Loaded custom inscription recipe '" + lb.getString("type") + "'"));
                    continue;
                }
                ChromatiCraft.logger.logError((Object)("Could not load custom inscription recipe '" + lb.getString("type") + "'"));
                if (e == null) continue;
                e.printStackTrace();
            }
        }
    }

    protected final void verifyOutputItem(ItemStack is) {
        if (is.func_77973_b() instanceof ItemChromaBasic || is.func_77973_b().getClass().getName().startsWith("Reika.ChromatiCraft")) {
            throw new IllegalArgumentException("This item is not allowed as an output, as it is a native ChromatiCraft item with its own recipe.");
        }
    }

    private boolean addCustomRecipe(LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack out = CustomRecipeList.parseItemString((String)lb.getString("output"), null, (boolean)false);
        this.verifyOutputItem(out);
        ItemStack in = CustomRecipeList.parseItemString((String)lb.getString("input"), null, (boolean)false);
        int time = lb.getInt("duration");
        try {
            InscriptionRecipe inscriptionRecipe = this.addCustomRecipe(BlockKey.fromItem((ItemStack)in), BlockKey.fromItem((ItemStack)out), time);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The specified item is not a block!");
        }
        return true;
    }

    public InscriptionRecipe addCustomRecipe(BlockKey in, BlockKey out, int time) {
        InscriptionRecipe r = this.addRecipe(in, out, time);
        r.isCustom = true;
        return r;
    }

    public Collection<InscriptionRecipe> getAllInscriptionRecipes() {
        return Collections.unmodifiableCollection(this.recipes.values());
    }

    public Collection<BlockKey> getAllInputs() {
        HashSet<BlockKey> c = new HashSet<BlockKey>();
        for (InscriptionRecipe pr : this.getAllInscriptionRecipes()) {
            c.add(pr.input);
        }
        return c;
    }

    public Collection<BlockKey> getAllOutputs() {
        HashSet<BlockKey> c = new HashSet<BlockKey>();
        for (InscriptionRecipe pr : this.getAllInscriptionRecipes()) {
            c.add(pr.output);
        }
        return c;
    }

    public InscriptionRecipe getRecipeByID(int id) {
        return (InscriptionRecipe)this.recipeIDs.get((Object)id);
    }

    public static class InscriptionRecipe {
        public final BlockKey input;
        public final BlockKey output;
        public final int duration;
        public final int referenceIndex;
        private boolean isCustom = false;

        private InscriptionRecipe(BlockKey in, BlockKey out, int time, int idx) {
            this.input = in;
            this.output = out;
            this.duration = time;
            this.referenceIndex = idx;
        }

        public ElementTagCompound getInputElements() {
            ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(this.input.asItemStack());
            if (this.duration > 200) {
                tag.addValueToColor(CrystalElement.LIGHTBLUE, 2);
            }
            return tag;
        }

        public boolean isCustom() {
            return this.isCustom;
        }

        @SideOnly(value=Side.CLIENT)
        public void doFX(World world, int x, int y, int z) {
            ColorBlendList cbl = new ColorBlendList(2.0f, ChromaFX.getChromaColorTiles());
            for (int i = 0; i < 32; ++i) {
                double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.75);
                double py = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5), (double)0.75);
                double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.75);
                int c = cbl.getRandomBlendedColor(world.field_73012_v);
                int l = ReikaRandomHelper.getRandomBetween((int)10, (int)30);
                EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setColor(c).setScale(1.0f + world.field_73012_v.nextFloat()).setLife(l);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.CAST, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)1.0f);
        }

        public void place(World world, int x, int y, int z, EntityPlayer ep) {
            this.output.place(world, x, y, z);
            if (this.output.blockID instanceof BlockChromaTile) {
                ((TileEntityChromaticBase)world.func_147438_o(x, y, z)).setPlacer(ep);
            }
        }
    }
}

