/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Base.ItemChromaBasic;
import Reika.ChromatiCraft.Block.BlockActiveChroma;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemUnknownArtefact;
import Reika.ChromatiCraft.Magic.Artefact.ArtefactWithDataCrystalAlloyingEffect;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.AEPatternHandling;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PoolRecipes {
    public static final PoolRecipes instance = new PoolRecipes();
    private final ItemHashMap<Collection<PoolRecipe>> recipes = new ItemHashMap().setOneWay();
    private final HashMap<String, PoolRecipe> recipesByID = new HashMap();

    private PoolRecipes() {
        this.addRecipe(ChromaStacks.chromaIngot, new ItemStack(Items.field_151042_j), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.chromaDust, (int)16));
        this.addRecipe(ChromaStacks.fieryIngot, new ItemStack(Items.field_151043_k), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.firaxite, (int)16), new ItemStack(Items.field_151065_br, 8), new ItemStack(Items.field_151044_h, 2, 0));
        this.addRecipe(ChromaStacks.enderIngot, new ItemStack(Items.field_151042_j), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.enderDust, (int)16), new ItemStack(Items.field_151079_bi, 4, 0));
        this.addRecipe(ChromaStacks.waterIngot, new ItemStack(Items.field_151042_j), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.waterDust, (int)16), new ItemStack(Items.field_151043_k, 2, 0));
        this.addRecipe(ChromaStacks.conductiveIngot, new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151137_ax, 8, 0), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.beaconDust, (int)16));
        this.addRecipe(ChromaStacks.auraIngot, new ItemStack(Items.field_151042_j), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.auraDust, (int)8), new ItemStack(Items.field_151114_aO, 8, 0), new ItemStack(Items.field_151137_ax, 16, 0), new ItemStack(Items.field_151128_bU, 4, 0));
        this.addRecipe(ChromaStacks.spaceIngot, new ItemStack(Items.field_151042_j), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.spaceDust, (int)16), new ItemStack(Items.field_151114_aO, 32, 0), new ItemStack(Items.field_151137_ax, 64, 0), new ItemStack(Items.field_151128_bU, 16, 0), new ItemStack(Items.field_151045_i, 4, 0));
        PoolRecipe pr = this.addRecipe(ChromaStacks.experienceGem, ChromaStacks.iridChunk, new ItemStack(Blocks.field_150343_Z, 4, 0), new ItemStack(Items.field_151166_bC, 8, 0));
        pr = this.addRecipe(ChromaStacks.complexIngot, ChromaStacks.experienceGem, ChromaStacks.chromaIngot, ChromaStacks.enderIngot, ChromaStacks.waterIngot, ChromaStacks.spaceIngot, ChromaStacks.fieryIngot, ChromaStacks.auraIngot, ChromaStacks.conductiveIngot);
        pr = this.addRecipe(ChromaItems.DATACRYSTAL.getStackOf(), ChromaItems.DATACRYSTAL.getStackOf(), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.crystalPowder, (int)18)).addProgress(ProgressStage.TOWER);
        pr = this.addRecipe(ChromaItems.STRUCTMAP.getStackOf(), new ItemStack((Item)Items.field_151148_bJ), new ItemStack(Items.field_151111_aL), ChromaItems.DATACRYSTAL.getStackOf(), ChromaItems.ARTEFACT.getStackOfMetadata(ItemUnknownArtefact.ArtefactTypes.ARTIFACT.ordinal()), ChromaBlocks.METAALLOYLAMP.getStackOf(), ChromaItems.ENDEREYE.getCraftedProduct(12), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.auraDust, (int)64), ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.spaceDust, (int)48), new ItemStack(Items.field_151114_aO, 32)).addProgress(ProgressStage.TOWER).addProgress(ProgressStage.ARTEFACT);
        pr.effects.add(ArtefactWithDataCrystalAlloyingEffect.instance);
        pr.allowDoubling = false;
        pr.minDuration = 2400;
    }

    private PoolRecipe addRecipe(ItemStack out, ItemStack main, ItemStack ... ingredients) {
        Collection c = (Collection)this.recipes.get(main);
        if (c == null) {
            c = new OneWayCollections.OneWayList();
            this.recipes.put(main, (Object)c);
        }
        String id = "#" + this.recipes.size() + "=" + main + ">" + out + "+" + ingredients.length;
        PoolRecipe r = new PoolRecipe(id, out, main, ingredients);
        c.add(r);
        this.recipesByID.put(id, r);
        return r;
    }

    public PoolRecipe getByID(String id) {
        return this.recipesByID.get(id);
    }

    public PoolRecipe getPoolRecipe(EntityItem ei) {
        return this.getPoolRecipe(ei, null, true, ReikaItemHelper.getDropper((EntityItem)ei));
    }

    public PoolRecipe getPoolRecipe(EntityItem ei, Collection<EntityItem> li, boolean block, EntityPlayer ep) {
        Collection prs = (Collection)this.recipes.get(ei.func_92059_d());
        if (prs != null) {
            int x = MathHelper.func_76128_c((double)ei.field_70165_t);
            int y = MathHelper.func_76128_c((double)ei.field_70163_u);
            int z = MathHelper.func_76128_c((double)ei.field_70161_v);
            if (!block || ei.field_70170_p.func_147439_a(x, y, z) == ChromaBlocks.CHROMA.getBlockInstance() && ei.field_70170_p.func_72805_g(x, y, z) == 0) {
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
                if (li == null) {
                    li = ei.field_70170_p.func_72872_a(EntityItem.class, box);
                }
                for (PoolRecipe pr : prs) {
                    if (ep == null || !pr.playerHasProgress(ep) || !pr.canBeMadeFrom(li)) continue;
                    return pr;
                }
            }
        }
        return null;
    }

    public PoolRecipe getPoolRecipe(ArrayList<ItemStack> li) {
        for (int i = 0; i < li.size(); ++i) {
            ItemStack is = li.get(i);
            ArrayList<ItemStack> li2 = new ArrayList<ItemStack>(li);
            li2.remove(i);
            PoolRecipe pr = this.getPoolRecipe(is, li2);
            if (pr == null) continue;
            return pr;
        }
        return null;
    }

    public PoolRecipe getPoolRecipe(ItemStack main, Collection<ItemStack> li) {
        Collection prs = (Collection)this.recipes.get(main);
        if (prs != null) {
            for (PoolRecipe pr : prs) {
                if (!pr.canBeMadeFromItems(li)) continue;
                return pr;
            }
        }
        return null;
    }

    public PoolRecipe getPoolRecipeByOutput(ItemStack is) {
        for (PoolRecipe p : this.getAllPoolRecipes()) {
            if (!ReikaItemHelper.matchStacks((ItemStack)p.output, (ItemStack)is)) continue;
            return p;
        }
        return null;
    }

    public void makePoolRecipe(EntityItem ei, PoolRecipe pr, int ether, int x, int y, int z) {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
        List li = ei.field_70170_p.func_72872_a(EntityItem.class, box);
        boolean flag = ei.field_70170_p.func_147439_a(x, y, z) == ChromaBlocks.CHROMA.getBlockInstance();
        pr.makeFrom(li);
        ReikaEntityHelper.decrEntityItemStack((EntityItem)ei, (int)1);
        int n = pr.allowDoubling() && ReikaRandomHelper.doWithChance((double)BlockActiveChroma.getDoublingChance(ether)) ? 2 : 1;
        EntityPlayer ep = ReikaItemHelper.getDropper((EntityItem)ei);
        if (Chromabilities.DOUBLECRAFT.enabledOn(ep)) {
            n *= 2;
        }
        int n2 = n * pr.getOutput().field_77994_a;
        for (int i = 0; i < n2; ++i) {
            EntityItem newitem = ReikaItemHelper.dropItem((Entity)ei, (ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)pr.getOutput(), (int)1));
            newitem.lifespan = Integer.MAX_VALUE;
            for (AlloyingEffect e : pr.effects) {
                e.onFinish(ei, newitem);
            }
        }
        if (flag) {
            ei.field_70170_p.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
        ReikaWorldHelper.causeAdjacentUpdates((World)ei.field_70170_p, (int)x, (int)y, (int)z);
        ProgressStage.ALLOY.stepPlayerTo(ep);
    }

    public void loadCustomPoolRecipes() {
        CustomRecipeList crl = new CustomRecipeList((DragonAPIMod)ChromatiCraft.instance, "alloying");
        if (crl.load()) {
            for (LuaBlock lb : crl.getEntries()) {
                Exception e = null;
                boolean flag = false;
                try {
                    flag = this.addCustomRecipe(lb, crl);
                }
                catch (Exception ex) {
                    e = ex;
                    flag = false;
                }
                if (flag) {
                    ChromatiCraft.logger.log((Object)("Loaded custom alloying recipe '" + lb.getString("type") + "'"));
                    continue;
                }
                ChromatiCraft.logger.logError((Object)("Could not load custom alloying recipe '" + lb.getString("type") + "'"));
                if (e == null) continue;
                e.printStackTrace();
            }
        }
    }

    protected final void verifyOutputItem(ItemStack is) {
        if (is.func_77973_b() instanceof ItemChromaBasic || is.func_77973_b().getClass().getName().startsWith("Reika.ChromatiCraft")) {
            throw new IllegalArgumentException("This item is not allowed as an output, as it is a native ChromatiCraft item with its own recipe.");
        }
    }

    private boolean addCustomRecipe(LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack out = CustomRecipeList.parseItemString((String)lb.getString("output"), (LuaBlock)lb.getChild("output_nbt"), (boolean)false);
        this.verifyOutputItem(out);
        ItemStack main = CustomRecipeList.parseItemString((String)lb.getString("catalyst"), null, (boolean)false);
        LuaBlock items = lb.getChild("items");
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (String s : items.getDataValues()) {
            ItemStack is = CustomRecipeList.parseItemString((String)s, null, (boolean)false);
            li.add(is);
        }
        PoolRecipe r = this.addCustomRecipe(out, main, li.toArray(new ItemStack[li.size()]));
        r.allowDoubling = lb.containsKey("allow_doubling") ? lb.getBoolean("allow_doubling") : true;
        return true;
    }

    public PoolRecipe addCustomRecipe(ItemStack out, ItemStack main, ItemStack ... ingredients) {
        PoolRecipe r = this.addRecipe(out, main, ingredients);
        r.isCustom = true;
        return r;
    }

    public Collection<PoolRecipe> getRecipesForItem(ItemStack is) {
        Collection c = (Collection)this.recipes.get(is);
        return c != null ? Collections.unmodifiableCollection(c) : new ArrayList<PoolRecipe>();
    }

    public boolean isCompatibleWith(ItemStack is) {
        Collection c = (Collection)this.recipes.get(is);
        for (PoolRecipe r : c) {
            if (!r.inputs.containsKey(is)) continue;
            return true;
        }
        return false;
    }

    public Collection<PoolRecipe> getAllPoolRecipes() {
        return Collections.unmodifiableCollection(ReikaJavaLibrary.getCompoundCollection((Collection)this.recipes.values()));
    }

    public Collection<PoolRecipe> getAllPoolRecipesForPlayer(EntityPlayer ep) {
        ArrayList<PoolRecipe> c = new ArrayList<PoolRecipe>();
        for (PoolRecipe p : this.getAllPoolRecipes()) {
            if (!p.playerHasProgress(ep)) continue;
            c.add(p);
        }
        return c;
    }

    public Collection<ItemStack> getAllOutputItems() {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        for (PoolRecipe pr : this.getAllPoolRecipes()) {
            if (ReikaItemHelper.collectionContainsItemStack(c, (ItemStack)pr.output)) continue;
            c.add(pr.output.func_77946_l());
        }
        return c;
    }

    public boolean canAlloyItem(EntityItem ei) {
        EntityPlayer ep = ReikaItemHelper.getDropper((EntityItem)ei);
        return ep != null && ProgressStage.ALLOY.playerHasPrerequisites(ep);
    }

    public static interface AlloyingEffect {
        public void initialize(EntityItem var1);

        public void doEffect(EntityItem var1);

        public void onFinish(EntityItem var1, EntityItem var2);
    }

    public static class PoolRecipe {
        public final String ID;
        private final ItemStack main;
        private final ItemHashMap<Integer> inputs = new ItemHashMap().setOneWay();
        private final ItemStack output;
        private final HashSet<ProgressStage> progress = new HashSet();
        private boolean allowDoubling = true;
        private boolean isCustom = false;
        private final ItemHashMap<NBTTagCompound> NBTMatches = new ItemHashMap().setOneWay();
        private final ArrayList<AlloyingEffect> effects = new ArrayList();
        private int minDuration = 0;

        private PoolRecipe(String id, ItemStack out, ItemStack m, ItemStack ... input) {
            this.ID = id;
            this.output = out.func_77946_l();
            this.main = m;
            for (int i = 0; i < input.length; ++i) {
                if (this.inputs.containsKey(input[i])) {
                    throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "You cannot have two stacks of " + input[i] + "!");
                }
                int amt = input[i].field_77994_a;
                if (amt > input[i].func_77976_d()) {
                    throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Stack size of " + input[i] + " too big!");
                }
                this.inputs.put(input[i], (Object)amt);
            }
        }

        public PoolRecipe addProgress(ProgressStage p) {
            this.progress.add(p);
            return this;
        }

        public PoolRecipe disallowDoubling() {
            this.allowDoubling = false;
            return this;
        }

        public PoolRecipe addNBTMatch(ItemStack is) {
            this.NBTMatches.put(is, (Object)((NBTTagCompound)is.field_77990_d.func_74737_b()));
            return this;
        }

        public boolean playerHasProgress(EntityPlayer ep) {
            for (ProgressStage p : this.progress) {
                if (p.isPlayerAtStage(ep)) continue;
                return false;
            }
            return true;
        }

        public void addItem(ItemStack is, int amt) {
            Integer has = (Integer)this.inputs.get(is);
            int val = has != null ? has : 0;
            this.inputs.put(is, (Object)amt);
        }

        private void makeFrom(Collection<EntityItem> li) {
            ItemHashMap map = this.inputs.clone();
            for (EntityItem ei : li) {
                ItemStack is = ei.func_92059_d();
                Integer get = this.countNeeded((ItemHashMap<Integer>)map, is);
                if (get == null || get <= 0) continue;
                int rem = Math.min(is.field_77994_a, get);
                get = get - rem;
                ReikaEntityHelper.decrEntityItemStack((EntityItem)ei, (int)rem);
                if (get > 0) continue;
                map.remove(is);
                if (!map.isEmpty()) continue;
                return;
            }
        }

        private Integer countNeeded(ItemHashMap<Integer> map, ItemStack is) {
            NBTTagCompound tag;
            Integer get = (Integer)map.get(is);
            if (get != null && get > 0 && !this.NBTMatches.isEmpty() && (tag = (NBTTagCompound)this.NBTMatches.get(is)) != null && !ReikaNBTHelper.areNBTTagsEqual((NBTTagCompound)tag, (NBTTagCompound)is.field_77990_d)) {
                get = null;
            }
            return get;
        }

        private boolean canBeMadeFrom(Collection<EntityItem> li) {
            ItemHashMap map = this.inputs.clone();
            for (EntityItem ei : li) {
                ItemStack is = ei.func_92059_d();
                Integer get = this.countNeeded((ItemHashMap<Integer>)map, is);
                if (get == null || get <= 0) continue;
                int rem = Math.min(is.field_77994_a, get);
                if ((get = Integer.valueOf(get - rem)) > 0) continue;
                map.remove(is);
                if (!map.isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean canBeMadeFromItems(Collection<ItemStack> li) {
            ItemHashMap map = this.inputs.clone();
            for (ItemStack is : li) {
                Integer get = this.countNeeded((ItemHashMap<Integer>)map, is);
                if (get == null || get <= 0) continue;
                int rem = Math.min(is.field_77994_a, get);
                if ((get = Integer.valueOf(get - rem)) > 0) continue;
                map.remove(is);
                if (!map.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public int getMinDuration() {
            return this.minDuration;
        }

        public ItemStack getMainInput() {
            return this.main.func_77946_l();
        }

        public Collection<ItemStack> getInputs() {
            ArrayList<ItemStack> c = new ArrayList<ItemStack>();
            for (ItemStack is : this.inputs.keySet()) {
                ItemStack in = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)((Integer)this.inputs.get(is)));
                NBTTagCompound tag = (NBTTagCompound)this.NBTMatches.get(in);
                if (tag != null) {
                    in.field_77990_d = (NBTTagCompound)tag.func_74737_b();
                }
                c.add(in);
            }
            return c;
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public ElementTagCompound getInputElements() {
            ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(this.main);
            for (ItemStack is : this.inputs.keySet()) {
                tag.addButMinimizeWith(ItemElementCalculator.instance.getValueForItem(is));
            }
            return tag;
        }

        public boolean isCustom() {
            return this.isCustom;
        }

        public boolean allowDoubling() {
            return this.allowDoubling;
        }

        public void doFX(EntityItem ei) {
            for (AlloyingEffect c : this.effects) {
                c.doEffect(ei);
            }
        }

        public void initialize(EntityItem ei) {
            for (AlloyingEffect c : this.effects) {
                c.initialize(ei);
            }
        }

        @DependentMethodStripper.ModDependent(value={ModList.APPENG})
        public ItemStack programToAEPattern(boolean berries) {
            ArrayList<ItemStack> in = new ArrayList<ItemStack>();
            in.add(this.main);
            for (ItemStack is : this.inputs.keySet()) {
                in.add(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)((Integer)this.inputs.get(is))));
            }
            ItemStack out = this.output.func_77946_l();
            if (berries && this.allowDoubling()) {
                out.field_77994_a *= 2;
                in.add(ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.etherBerries, (int)16));
            }
            return AEPatternHandling.getEncodedPattern((ItemStack)out, (boolean)false, (boolean)false, (ItemStack[])in.toArray(new ItemStack[in.size()]));
        }
    }
}

