/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.RecipeManagers;

import Reika.ChromatiCraft.Auxiliary.Interfaces.EnergyLinkingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingAuto;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class RepeaterRecipe
extends CastingRecipe.MultiBlockCastingRecipe
implements EnergyLinkingRecipe {
    private final ChromaTiles tile;

    public RepeaterRecipe(ChromaTiles c, ItemStack main) {
        super(c.getCraftedProduct(), main);
        this.tile = c;
        this.addRune(CrystalElement.BLACK, 0, -1, 5);
        this.addRune(CrystalElement.BLACK, 0, -1, -5);
        this.addRune(CrystalElement.BLACK, 5, -1, 0);
        this.addRune(CrystalElement.BLACK, -5, -1, 0);
        this.addRune(CrystalElement.WHITE, 5, -1, 5);
        this.addRune(CrystalElement.WHITE, -5, -1, -5);
        this.addRune(CrystalElement.WHITE, 5, -1, -5);
        this.addRune(CrystalElement.WHITE, -5, -1, 5);
        this.addRune(CrystalElement.RED, -5, -1, -4);
        this.addRune(CrystalElement.RED, 5, -1, 4);
        this.addRune(CrystalElement.BLUE, 5, -1, -4);
        this.addRune(CrystalElement.BLUE, -5, -1, 4);
        this.addRune(CrystalElement.GREEN, -4, -1, -5);
        this.addRune(CrystalElement.GREEN, 4, -1, 5);
        this.addRune(CrystalElement.YELLOW, 4, -1, -5);
        this.addRune(CrystalElement.YELLOW, -4, -1, 5);
    }

    @Override
    public int getDuration() {
        return (int)(2.4 * (double)super.getDuration());
    }

    @Override
    public float[] getHarmonics() {
        return new float[]{(float)ReikaMusicHelper.MusicKey.A5.getRatio(ReikaMusicHelper.MusicKey.D5), (float)ReikaMusicHelper.MusicKey.Fs5.getRatio(ReikaMusicHelper.MusicKey.D5)};
    }

    @Override
    public final boolean canRunRecipe(TileEntity te, EntityPlayer ep) {
        return super.canRunRecipe(te, ep) && ChromaResearchManager.instance.getPlayerResearchLevel(ep).ordinal() >= ResearchLevel.NETWORKING.ordinal() && ProgressStage.BLOWREPEATER.isPlayerAtStage(ep);
    }

    @Override
    public final NBTTagCompound handleNBTResult(TileEntityCastingTable te, EntityPlayer ep, NBTTagCompound originalCenter, NBTTagCompound tag) {
        if (this.tile.isTurbochargeableRepeater()) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74757_a("boosted", false);
        }
        if (this.tile.getFragment().level.ordinal() >= ResearchLevel.NETWORKING.ordinal()) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            tag.func_74778_a("caster", ep.func_110124_au().toString());
        }
        return tag;
    }

    @Override
    public void onCrafted(TileEntityCastingTable te, EntityPlayer ep, ItemStack output, int amount) {
        super.onCrafted(te, ep, output, amount);
        ProgressStage.REPEATER.stepPlayerTo(ep);
    }

    @Override
    protected final void filterMatchTags(ItemStack is) {
        super.filterMatchTags(is);
        is.field_77990_d.func_82580_o("boosted");
        is.field_77990_d.func_82580_o("caster");
    }

    @Override
    public final float getAutomationCostFactor(TileEntityCastingAuto ae, TileEntityCastingTable te, ItemStack is) {
        switch (this.tile) {
            case REPEATER: {
                return 1.5f;
            }
            case COMPOUND: {
                return 2.0f;
            }
            case BROADCAST: {
                return 3.0f;
            }
        }
        return 1.0f;
    }

    @Override
    public final boolean requiresTuningKey() {
        return true;
    }
}

