/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary;

import Reika.ChromatiCraft.Auxiliary.CastingAutomationSystem;
import Reika.ChromatiCraft.Auxiliary.Interfaces.CastingAutomationBlock;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.DragonAPI.Instantiable.Data.Collections.ItemCollection;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class RecursiveCastingAutomationSystem
extends CastingAutomationSystem {
    private RecipeChain prereqs;
    private final HashSet<String> priorityRecipes = new HashSet();
    private final IngredientCache cachedIngredients = new IngredientCache();
    public boolean recursionEnabled = false;

    public RecursiveCastingAutomationSystem(CastingAutomationBlock te) {
        super(te);
    }

    @Override
    public void tick(World world) {
        RecipePrereq p;
        super.tick(world);
        if (this.isIdle() && this.prereqs != null && (p = this.prereqs.getNextInQueue()) != null) {
            super.setRecipe(p.recipe, p.craftsRemaining, this.currentPlayer);
        }
    }

    public boolean isRecursiveCrafting() {
        return this.prereqs != null;
    }

    public void cacheIngredient(ItemStack is) {
        this.cachedIngredients.add(is);
    }

    @Override
    protected ItemCollection getExtraItems(Object item, int amt, boolean simulate, boolean allowMultiple) {
        if (item instanceof Block) {
            item = new ItemMatch((Block)item);
        } else if (item instanceof Item) {
            item = new ItemMatch((Item)item);
        } else if (item instanceof ItemStack) {
            item = new ItemMatch((ItemStack)item);
        }
        Ingredient i = (Ingredient)this.cachedIngredients.data.get(item);
        return i != null ? i.found : null;
    }

    @Override
    protected void onTriggerCrafting(CastingRecipe r, int cycles) {
        if (this.prereqs != null) {
            this.prereqs.craft(r, cycles);
            if (this.prereqs.isDone()) {
                this.recoverCachedIngredients();
                this.prereqs = null;
            }
        }
    }

    private void recoverCachedIngredients() {
        Iterator it = this.cachedIngredients.data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Ingredient i = (Ingredient)e.getValue();
            if (!this.recoverIngredient(i)) continue;
            it.remove();
        }
    }

    private boolean recoverIngredient(Ingredient i) {
        ArrayList c = new ArrayList(i.found.getItems());
        for (ItemStack is : c) {
            if (!this.recoverItem(is)) continue;
            i.found.removeItem(is);
        }
        return i.found.isEmpty();
    }

    @Override
    public void setRecipe(CastingRecipe c, int amt, EntityPlayer ep) {
        this.recoverCachedIngredients();
        this.prereqs = null;
        if (c != null && this.recursionEnabled && this.tile.canRecursivelyRequest(c) && this.cachedIngredients.isEmpty()) {
            this.prereqs = new RecipeChain(this.tile.getAvailableRecipes());
            RecipePrereq pre = this.prereqs.createPrereq(null, new ItemMatch(c.getOutput()), c, amt * c.getOutput().field_77994_a);
            Event.Result res = this.determinePrerequisites(pre);
            for (int tries = 0; res == Event.Result.DEFAULT && tries < 60; ++tries) {
                res = this.determinePrerequisites(pre);
            }
            if (res == Event.Result.ALLOW) {
                this.intakeNecessaryItems();
            } else {
                this.prereqs = null;
            }
            super.setRecipe(null, 0, ep);
        } else {
            super.setRecipe(c, amt, ep);
        }
    }

    private void intakeNecessaryItems() {
        int amt;
        for (ItemMatch im : this.prereqs.getAllUsedItems()) {
            amt = this.prereqs.getDeficit(im);
            int has = this.countItem(im);
            if (has >= amt) continue;
            this.prereqs = null;
            return;
        }
        this.cachedIngredients.clear();
        for (ItemMatch im : this.prereqs.getAllUsedItems()) {
            amt = this.prereqs.getDeficit(im);
            if (amt <= 0) continue;
            Collection<ItemStack> is = this.findItems(im, amt, false);
            if (is == null) {
                ReikaJavaLibrary.pConsole((Object)("Got null list for " + im + "?!?!"));
            }
            this.cachedIngredients.add(im, is);
        }
    }

    private Event.Result determinePrerequisites(RecipePrereq r) {
        this.prereqs.calculateItems();
        CountMap needed = new CountMap();
        for (ItemMatch im : this.prereqs.getAllUsedItems()) {
            int has;
            int amt = this.prereqs.getDeficit(im);
            if (amt <= 0 || (has = this.countItem(im)) >= amt) continue;
            int craft = amt - has;
            needed.increment((Object)im, craft);
        }
        if (needed.getTotalCount() == 0) {
            return Event.Result.ALLOW;
        }
        for (ItemMatch im : needed.keySet()) {
            RecipePrereq c = this.prereqs.selectRecipeToMake(r, im, needed.get((Object)im));
            if (c != null) continue;
            return Event.Result.DENY;
        }
        return Event.Result.DEFAULT;
    }

    public void toggleRecipePriority(CastingRecipe cr) {
        String s = cr.getIDString();
        if (this.priorityRecipes.contains(s)) {
            this.priorityRecipes.remove(s);
        } else {
            this.priorityRecipes.add(s);
        }
    }

    public boolean isRecipePriority(CastingRecipe cr) {
        return this.priorityRecipes.contains(cr.getIDString());
    }

    private int getRecipeValue(CastingRecipe cr) {
        int base = this.getRecipeEfficiencyValue(cr);
        if (this.isRecipePriority(cr)) {
            base += 1000000;
        }
        if (this.hasAllIngredients(cr)) {
            base += 100000000;
        }
        return base;
    }

    private int getRecipeEfficiencyValue(CastingRecipe cr) {
        int out = cr.getOutput().field_77994_a;
        ElementTagCompound tag = cr.getInputElements(true);
        return out * 1000 / (cr.getInputCount() + tag.getTotalEnergy());
    }

    private boolean hasAllIngredients(CastingRecipe cr) {
        if (cr instanceof CastingRecipe.MultiBlockCastingRecipe) {
            CastingRecipe.MultiBlockCastingRecipe mb = (CastingRecipe.MultiBlockCastingRecipe)cr;
            ItemStack ctr = mb.getMainInput();
            if (!this.hasItem(ctr, mb.getRequiredCentralItemCount())) {
                return false;
            }
            for (ItemMatch im : mb.getAuxItems().values()) {
                if (this.hasItem(im, 1)) continue;
                return false;
            }
        } else {
            Object[] in;
            for (Object o : in = cr.getInputArray()) {
                if (this.hasItem(o, 1)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound NBT) {
        super.writeToNBT(NBT);
        NBT.func_74757_a("recursion", this.recursionEnabled);
        ReikaNBTHelper.writeCollectionToNBT(this.priorityRecipes, (NBTTagCompound)NBT, (String)"priority");
        NBTTagCompound tag = new NBTTagCompound();
        this.cachedIngredients.writeToNBT(tag);
        NBT.func_74782_a("ingredients", (NBTBase)tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound NBT) {
        super.readFromNBT(NBT);
        this.recursionEnabled = NBT.func_74767_n("recursion");
        ReikaNBTHelper.readCollectionFromNBT(this.priorityRecipes, (NBTTagCompound)NBT, (String)"priority");
        this.cachedIngredients.readFromNBT(NBT.func_74775_l("ingredients"));
    }

    @Override
    public void onBreak(World world) {
        super.onBreak(world);
        this.cachedIngredients.drop(world, this.getX(), this.getY(), this.getZ());
    }

    private static class Ingredient {
        private final ItemMatch seek;
        private final ItemCollection found;

        private Ingredient(ItemMatch im, ItemCollection is) {
            this.seek = im;
            this.found = is;
        }

        public void addItems(Collection<ItemStack> is) {
            this.found.add(is);
        }

        public int removeItems(int amt) {
            return this.found.removeItems(amt);
        }

        public String toString() {
            return this.seek.toString() + " > " + this.found.toString();
        }

        public void writeToNBT(NBTTagCompound NBT) {
            NBTTagCompound tag1 = new NBTTagCompound();
            NBTTagCompound tag2 = new NBTTagCompound();
            this.found.writeToNBT(tag1);
            this.seek.writeToNBT(tag2);
            NBT.func_74782_a("item", (NBTBase)tag1);
            NBT.func_74782_a("match", (NBTBase)tag2);
        }

        public static Ingredient readFromNBT(NBTTagCompound NBT) {
            NBTTagCompound tag1 = NBT.func_74775_l("item");
            NBTTagCompound tag2 = NBT.func_74775_l("match");
            ItemCollection is = new ItemCollection();
            is.readFromNBT(tag1);
            ItemMatch im = ItemMatch.readFromNBT((NBTTagCompound)tag2);
            Ingredient ret = new Ingredient(im, is);
            return ret;
        }
    }

    private static class IngredientCache {
        private HashMap<ItemMatch, Ingredient> data = new HashMap();

        private IngredientCache() {
        }

        public int subtract(ItemMatch im, int amt) {
            Ingredient i = this.data.get(im);
            int ret = i.removeItems(amt);
            if (i.found.isEmpty()) {
                this.data.remove(im);
            }
            return ret;
        }

        public Collection<Ingredient> getItems() {
            return Collections.unmodifiableCollection(this.data.values());
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public void add(ItemStack is) {
            for (Ingredient i : this.data.values()) {
                if (!i.seek.match(is)) continue;
                i.found.add(is);
                return;
            }
            this.add(new ItemMatch(is), is);
        }

        private void add(ItemMatch im, ItemStack is) {
            Ingredient i = this.data.get(im);
            if (i == null) {
                ItemCollection ic = new ItemCollection();
                ic.add(is);
                i = new Ingredient(im, ic);
                this.data.put(im, i);
            } else {
                i.found.add(is);
            }
        }

        public void add(ItemMatch im, Collection<ItemStack> is) {
            Ingredient i = this.data.get(im);
            if (i == null) {
                i = new Ingredient(im, new ItemCollection(is));
                this.data.put(im, i);
            } else {
                i.addItems(is);
            }
        }

        public int count(ItemMatch im) {
            Ingredient i = this.data.get(im);
            return i != null ? i.found.count() : 0;
        }

        public void drop(World world, int x, int y, int z) {
            for (Ingredient i : this.data.values()) {
                i.found.drop(world, x, y, z);
            }
        }

        public void writeToNBT(NBTTagCompound NBT) {
            NBTTagList li = new NBTTagList();
            for (Map.Entry<ItemMatch, Ingredient> e : this.data.entrySet()) {
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagCompound key = new NBTTagCompound();
                NBTTagCompound value = new NBTTagCompound();
                e.getKey().writeToNBT(key);
                e.getValue().writeToNBT(value);
                tag.func_74782_a("key", (NBTBase)key);
                tag.func_74782_a("value", (NBTBase)value);
                li.func_74742_a((NBTBase)tag);
            }
            NBT.func_74782_a("data", (NBTBase)li);
        }

        public void readFromNBT(NBTTagCompound NBT) {
            this.clear();
            NBTTagList li = NBT.func_150295_c("data", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            this.data.clear();
            for (Object o : li.field_74747_a) {
                NBTTagCompound tag = (NBTTagCompound)o;
                NBTTagCompound key = tag.func_74775_l("key");
                NBTTagCompound value = tag.func_74775_l("value");
                ItemMatch im = ItemMatch.readFromNBT((NBTTagCompound)key);
                Ingredient i = Ingredient.readFromNBT(value);
                this.data.put(im, i);
            }
        }

        public void clear() {
            this.data.clear();
        }

        public String toString() {
            return this.data.values().toString();
        }
    }

    private static class RecipePrereq {
        private final CastingRecipe recipe;
        private final ItemMatch item;
        private int totalItemsNeeded;
        private int craftsRemaining;
        private final Collection<RecipePrereq> dependencies = new HashSet<RecipePrereq>();

        private RecipePrereq(ItemMatch im, CastingRecipe cr, int n) {
            this.recipe = cr;
            this.item = im;
            this.totalItemsNeeded = n;
        }

        private boolean craft(int cycles) {
            this.craftsRemaining -= Math.min(this.craftsRemaining, cycles);
            return this.craftsRemaining <= 0;
        }

        private void calculate() {
            this.craftsRemaining = MathHelper.func_76123_f((float)((float)this.totalItemsNeeded / (float)this.recipe.getOutput().field_77994_a));
        }

        public boolean isReady() {
            for (RecipePrereq r : this.dependencies) {
                if (r.craftsRemaining <= 0) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.recipe.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof RecipePrereq && ((RecipePrereq)o).recipe.equals(this.recipe);
        }

        public String toString() {
            return "(" + this.recipe.toString() + ") x" + this.totalItemsNeeded + " / " + this.craftsRemaining;
        }
    }

    private class RecipeChain {
        private final HashMap<ItemMatch, RecipePrereq> recipesByItem = new HashMap();
        private final HashMap<String, RecipePrereq> recipesByRecipe = new HashMap();
        private final HashSet<String> validRecipes = new HashSet();
        private final CountMap<ItemMatch> totalNeeded = new CountMap();
        private final CountMap<ItemMatch> totalProduction = new CountMap();
        private RecipePrereq root;

        private RecipeChain(Collection<CastingRecipe> c) {
            for (CastingRecipe cr : c) {
                this.validRecipes.add(cr.getIDString());
            }
        }

        public Collection<ItemMatch> getAllUsedItems() {
            return this.totalNeeded.keySet();
        }

        public RecipePrereq getCachedRecipe(ItemMatch im) {
            RecipePrereq ret = this.recipesByItem.get(im);
            return ret;
        }

        public RecipePrereq getCachedRecipe(CastingRecipe cr) {
            RecipePrereq ret = this.recipesByRecipe.get(cr.getIDString());
            return ret;
        }

        public RecipePrereq selectRecipeToMake(RecipePrereq p, ItemMatch im, int needed) {
            RecipePrereq pre = this.getCachedRecipe(im);
            if (pre != null) {
                p.dependencies.add(pre);
                RecipePrereq recipePrereq = pre;
                recipePrereq.totalItemsNeeded = recipePrereq.totalItemsNeeded + needed;
                return pre;
            }
            ArrayList<CastingRecipe> c = new ArrayList<CastingRecipe>();
            for (KeyedItemStack is : im.getItemList()) {
                c.addAll(RecipesCastingTable.instance.getAllRecipesMaking(is.getItemStack()));
            }
            if (c.isEmpty()) {
                return null;
            }
            int max = -1;
            CastingRecipe sel = null;
            for (CastingRecipe cr : c) {
                if (!this.isRecursable(cr)) continue;
                int w = RecursiveCastingAutomationSystem.this.getRecipeValue(cr);
                if (sel != null && w <= max) continue;
                sel = cr;
                max = w;
            }
            return sel != null ? this.createPrereq(p, im, sel, needed) : null;
        }

        public RecipePrereq createPrereq(RecipePrereq p, ItemMatch im, CastingRecipe sel, int needed) {
            RecipePrereq ret = new RecipePrereq(im, sel, needed);
            this.recipesByItem.put(im, ret);
            this.recipesByRecipe.put(sel.getIDString(), ret);
            if (p != null) {
                p.dependencies.add(ret);
            }
            if (p == null && this.root == null) {
                this.root = ret;
            }
            return ret;
        }

        public boolean isRecursable(CastingRecipe cr) {
            return this.validRecipes.contains(cr.getIDString());
        }

        public int getDeficit(ItemMatch im) {
            return this.totalNeeded.get((Object)im) - this.totalProduction.get((Object)im);
        }

        private void calculateItems() {
            for (RecipePrereq r : this.recipesByItem.values()) {
                r.calculate();
            }
            this.totalNeeded.clear();
            this.totalProduction.clear();
            for (RecipePrereq r : this.recipesByItem.values()) {
                for (int i = 0; i < r.craftsRemaining; ++i) {
                    this.totalProduction.increment((Object)r.item, ((RecipePrereq)r).recipe.getOutput().field_77994_a);
                    this.totalNeeded.increment(r.recipe.getItemCounts());
                }
            }
        }

        public void craft(CastingRecipe r, int cycles) {
            RecipePrereq r0 = this.getCachedRecipe(r);
            if (r0 != null && r0.craft(cycles)) {
                this.removeRecipe(r0);
                for (RecipePrereq r2 : this.recipesByItem.values()) {
                    r2.dependencies.remove(r);
                }
            }
        }

        public boolean isDone() {
            return this.recipesByItem.isEmpty();
        }

        private void removeRecipe(RecipePrereq r0) {
            this.recipesByItem.remove(r0.item);
            this.recipesByRecipe.remove(r0.recipe.getIDString());
        }

        public RecipePrereq getNextInQueue() {
            for (RecipePrereq req : this.recipesByItem.values()) {
                if (!req.isReady()) continue;
                return req;
            }
            return null;
        }

        public String toString() {
            return this.recipesByItem.values().toString();
        }
    }
}

