/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Auxiliary.ChromaHelpData;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ChromaHelpHUD {
    public static ChromaHelpHUD instance = new ChromaHelpHUD();
    private int rollx;
    private int rolly;
    private String last_text;
    private String text;
    private int posX;
    private int posY;
    private int posZ;
    private Block block;
    private int metadata;
    private boolean tierView;
    private static final int xSize = 64;
    private static final int ySize = 128;

    private ChromaHelpHUD() {
    }

    @SubscribeEvent
    public void renderHUD(RenderGameOverlayEvent evt) {
        if (evt.type == RenderGameOverlayEvent.ElementType.HELMET) {
            boolean recalc;
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            boolean bl = recalc = ep.field_70173_aa % 8 == 0;
            if (recalc) {
                this.getData((EntityPlayer)ep);
            }
            if (this.text == null || this.text.isEmpty() || this.text != this.last_text) {
                this.closePanel();
            } else {
                this.openPanel();
            }
            if (this.rollx > 0) {
                boolean flag = true;
                if (this.block instanceof BlockTieredResource) {
                    flag = this.tierView;
                }
                int gsc = evt.resolution.func_78325_e();
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)930.0);
                this.renderPanel(gsc);
                if (this.isPanelOpen()) {
                    this.renderText(this.text, gsc, flag);
                    if (flag && recalc) {
                        ChromaHelpData.instance.markDiscovered((EntityPlayer)ep, this.block, this.metadata);
                    }
                }
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            this.last_text = this.text;
            ReikaTextureHelper.bindHUDTexture();
        }
    }

    private void getData(EntityPlayer ep) {
        MovingObjectPosition look = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)5.0, (boolean)false);
        if (look != null) {
            this.posX = look.field_72311_b;
            this.posY = look.field_72312_c;
            this.posZ = look.field_72309_d;
            this.block = ep.field_70170_p.func_147439_a(this.posX, this.posY, this.posZ);
            this.metadata = ep.field_70170_p.func_72805_g(this.posX, this.posY, this.posZ);
            this.text = ChromaHelpData.instance.getText(ep.field_70170_p, this.posX, this.posY, this.posZ);
            this.tierView = this.block instanceof BlockTieredResource ? ((BlockTieredResource)this.block).isPlayerSufficientTier((IBlockAccess)Minecraft.func_71410_x().field_71441_e, this.posX, this.posY, this.posZ, ep) : false;
        } else {
            this.text = null;
            this.posX = -1;
            this.posY = -1;
            this.posZ = -1;
            this.block = null;
            this.metadata = -1;
        }
    }

    private void renderHelpGui(int gsc) {
    }

    private void renderPanel(int gsc) {
        Tessellator v5 = Tessellator.field_78398_a;
        boolean big = gsc > 2;
        double sc = big ? 1.375 : 0.75;
        int n1 = gsc;
        int n2 = 2 * gsc;
        int w = (int)(sc * (double)this.rollx * 2.0 / (double)gsc);
        int h = (int)(sc * (double)this.rolly * 2.0 / (double)gsc);
        int hm = (int)(sc * 128.0 * 2.0 / (double)gsc);
        int dx = Minecraft.func_71410_x().field_71443_c / n1 - w - 3;
        int dy = Minecraft.func_71410_x().field_71440_d / n2 - hm / 2;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        v5.func_78371_b(2);
        v5.func_78384_a(0xFFFFFF, 255);
        v5.func_78377_a((double)dx, (double)dy, 0.0);
        v5.func_78377_a((double)(dx + w), (double)dy, 0.0);
        v5.func_78377_a((double)(dx + w), (double)(dy + h), 0.0);
        v5.func_78377_a((double)dx, (double)(dy + h), 0.0);
        v5.func_78381_a();
        GL11.glEnable((int)3553);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/GUIs/helphud4.png");
        v5.func_78382_b();
        double u = 0.25 * (double)this.rollx / 64.0;
        double v = 0.5 * (double)this.rolly / 128.0;
        v5.func_78374_a((double)dx, (double)(dy + h), 0.0, 0.0, v);
        v5.func_78374_a((double)(dx + w), (double)(dy + h), 0.0, u, v);
        v5.func_78374_a((double)(dx + w), (double)dy, 0.0, u, 0.0);
        v5.func_78374_a((double)dx, (double)dy, 0.0, 0.0, 0.0);
        v5.func_78381_a();
    }

    private void renderText(String s, int gsc, boolean know) {
        ChromaFontRenderer f = know ? ChromaFontRenderer.FontType.HUD.renderer : ChromaFontRenderer.FontType.OBFUSCATED.renderer;
        GL11.glPushMatrix();
        boolean big = gsc > 2;
        double ft = big ? 2.0 : 1.0;
        double d = ft / (double)gsc;
        double fac = big ? 1.375 : 0.75;
        int w = (int)(fac * (double)this.rollx * 2.0 / (double)gsc);
        int wm = (int)(fac * 64.0 * 2.0 / (double)gsc);
        int hm = (int)(fac * 128.0 * 2.0 / (double)gsc);
        int n1 = gsc;
        int n2 = 2 * gsc;
        GL11.glScaled((double)d, (double)d, (double)d);
        int dx = (int)((double)(Minecraft.func_71410_x().field_71443_c / n1 - w - 1) / d);
        int dy = (int)((double)(Minecraft.func_71410_x().field_71440_d / n2 - hm / 2 + 2) / d);
        int tw = (int)((double)(gsc * wm - 10) / ft);
        f.func_78279_b(s, dx, dy, tw, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private boolean isPanelOpen() {
        return this.rollx == 64 && this.rolly == 128;
    }

    private void openPanel() {
        int step = Math.max(1, 90 / Math.max(1, ReikaRenderHelper.getFPS()));
        if (this.rollx < 64) {
            this.rollx += step;
        } else if (this.rolly < 128) {
            this.rolly += step;
        }
        if (this.rollx > 64) {
            this.rollx = 64;
        }
        if (this.rolly > 128) {
            this.rolly = 128;
        }
    }

    private void closePanel() {
        if (this.rolly > 0) {
            this.rolly -= Math.min(4, this.rolly);
        } else if (this.rollx > 0) {
            this.rollx -= Math.min(3, this.rollx);
        }
    }
}

