/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Auxiliary.ElementEncodedNumber;
import Reika.ChromatiCraft.Magic.Lore.KeyAssemblyPuzzle;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Registry.ChromaShaders;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Math.HexGrid;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class FullScreenOverlayRenderer {
    static final FullScreenOverlayRenderer instance = new FullScreenOverlayRenderer();
    private static final int WASHOUT_LENGTH = 312;
    private static final int WASHOUT_FACTOR = 2;
    private static final int FLASH_FADE = 4;
    private boolean rehideGui;
    private int washout;
    private CrystalElement washoutColor;
    private final EnumMap<CrystalElement, Float> factors = new EnumMap(CrystalElement.class);
    private static final int GROUP_LIFESPAN = 100;
    private final Collection<FullElementRender> renderingGroups = new ArrayList<FullElementRender>();

    private FullScreenOverlayRenderer() {
    }

    void triggerWashout(CrystalElement e) {
        this.rehideGui = Minecraft.func_71410_x().field_71474_y.field_74319_N;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
        this.washout = Math.max(this.washout, 308);
        this.washoutColor = e;
    }

    boolean isWashoutActive() {
        return this.washout > 0;
    }

    void renderWashout(RenderGameOverlayEvent.Pre evt, int tick) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2929);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        int mx = Minecraft.func_71410_x().field_71443_c / evt.resolution.func_78325_e();
        int my = Minecraft.func_71410_x().field_71440_d / evt.resolution.func_78325_e();
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78380_c(240);
        int a = (int)(this.washout > 308 ? 255.0f * (float)(312 - this.washout) / 4.0f : 255.0f * Math.min(1.0f, (float)this.washout / 255.0f));
        int c1 = ReikaColorAPI.mixColors((int)this.washoutColor.getColor(), (int)0xFFFFFF, (float)0.5f);
        int c = ReikaColorAPI.mixColors((int)0xFFFFFF, (int)c1, (float)Math.min(0.95f, (float)a / 255.0f));
        v5.func_78384_a(c, Math.min(255, a));
        v5.func_78377_a(0.0, 0.0, 0.0);
        v5.func_78377_a((double)mx, 0.0, 0.0);
        v5.func_78377_a((double)mx, (double)my, 0.0);
        v5.func_78377_a(0.0, (double)my, 0.0);
        v5.func_78381_a();
        if (!Minecraft.func_71410_x().func_147113_T()) {
            if (this.washout >= 308 || tick % 2 == 0) {
                this.washout -= Math.max(1, 90 / Math.max(1, ReikaRenderHelper.getFPS()));
            }
            if (this.washout == 0 && this.rehideGui) {
                Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
            }
        }
        GL11.glPopAttrib();
    }

    void triggerPylonEffect(CrystalElement e) {
        this.factors.put(e, Float.valueOf(2.0f));
    }

    void renderPylonAura(EntityPlayer ep, int gsc) {
        float maxIntensity = -1.0f;
        double cdd = -1.0;
        CrystalElement glowColor = null;
        Coordinate glowCenter = null;
        float glowIntensity = 0.0f;
        int hazeRed = 0;
        int hazeGreen = 0;
        int hazeBlue = 0;
        boolean ability = Chromabilities.PYLON.enabledOn(ep) | GuiScreen.func_146271_m();
        for (int i = 0; i < 16; ++i) {
            double dd;
            PylonGenerator.PylonEntry c;
            CrystalElement e = CrystalElement.elements[i];
            boolean containsColor = this.factors.containsKey(e);
            PylonGenerator.PylonEntry pylonEntry = c = containsColor ? null : PylonGenerator.instance.getNearestPylonSpawn(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, e);
            double d = containsColor ? 0.0 : (dd = c != null ? c.location.getDistanceTo(ep.field_70165_t, (ep.field_70163_u + (double)c.location.yCoord + 0.5) * 0.5, ep.field_70161_v) : Double.POSITIVE_INFINITY);
            if (!containsColor && !(dd < 36.0)) continue;
            if (ability) {
                dd = dd > 2.0 ? Math.max(4.0, dd * 1.6) : dd * 2.0;
            }
            int alpha = 255;
            float cache = containsColor ? this.factors.get(e).floatValue() : 0.0f;
            float bright = Math.min(1.0f, (float)(1.75 - dd / 24.0));
            float res = Math.max(cache, bright);
            if (containsColor) {
                if ((double)cache > 0.01) {
                    this.factors.put(e, Float.valueOf(cache * 0.975f));
                } else {
                    this.factors.remove(e);
                }
            }
            if (!(res > 0.0f)) continue;
            if (res > maxIntensity) {
                maxIntensity = res;
                cdd = dd;
                glowColor = e;
                float f = Math.min(1.0f, (float)(1.5 - dd / 20.0));
                glowIntensity = (f * f - 0.75f) * 2.0f;
                if (dd < 6.0) {
                    glowIntensity = Math.min(1.0f, glowIntensity + (float)(6.0 - dd) / 12.0f);
                }
                glowCenter = c != null ? new Coordinate(c.location) : null;
            }
            float mult = Math.min(1.0f, res);
            int red = (int)(mult * (float)e.getRed());
            int green = (int)(mult * (float)e.getGreen());
            int blue = (int)(mult * (float)e.getBlue());
            hazeRed = Math.min(255, hazeRed + red);
            hazeGreen = Math.min(255, hazeGreen + green);
            hazeBlue = Math.min(255, hazeBlue + blue);
        }
        if (ability) {
            maxIntensity = (float)((double)maxIntensity * (1.0 - Math.min(0.25, cdd * 0.03125)));
        }
        ChromaShaders.PYLONAURA.setIntensity(maxIntensity);
        if (maxIntensity > 0.0f) {
            ChromaShaders.PYLONAURA.getShader().setField("hazeRed", (Object)hazeRed);
            ChromaShaders.PYLONAURA.getShader().setField("hazeGreen", (Object)hazeGreen);
            ChromaShaders.PYLONAURA.getShader().setField("hazeBlue", (Object)hazeBlue);
        }
        ChromaShaders.PYLON.setIntensity(glowIntensity);
        if (glowColor != null) {
            ChromaShaders.PYLON.getShader().setField("pylonRed", (Object)glowColor.getRed());
            ChromaShaders.PYLON.getShader().setField("pylonGreen", (Object)glowColor.getGreen());
            ChromaShaders.PYLON.getShader().setField("pylonBlue", (Object)glowColor.getBlue());
            if (glowCenter != null) {
                ChromaShaders.PYLON.getShader().setFocus(glowCenter);
            }
        }
    }

    boolean isPylonOverlayForced() {
        return !this.factors.isEmpty();
    }

    void addLoreNote(EntityPlayer ep, Towers t) {
        Collection<KeyAssemblyPuzzle.TileGroup> groups = LoreManager.instance.getGroupsForTower(ep, t);
        for (KeyAssemblyPuzzle.TileGroup g : groups) {
            this.renderingGroups.add(new TileGroupRender(g));
        }
    }

    void addStructurePasswordNote(EntityPlayer ep, int hex) {
        this.renderingGroups.add(new StructurePasswordRender(new ElementEncodedNumber(hex, 8)));
    }

    boolean renderLoreHexes(RenderGameOverlayEvent.Pre evt, int tick) {
        if (!this.renderingGroups.isEmpty()) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            float maxa = 0.0f;
            for (FullElementRender t : this.renderingGroups) {
                maxa = Math.max(maxa, t.getAlpha());
            }
            GL11.glPushAttrib((int)1048575);
            maxa = Math.min(maxa * 2.0f, 1.0f);
            double dz = -500.0;
            GL11.glTranslated((double)0.0, (double)0.0, (double)dz);
            int c1 = -1072689136;
            int c2 = -804253680;
            c1 = (int)(maxa * (float)ReikaColorAPI.getAlpha((int)c1)) << 24 | c1 & 0xFFFFFF;
            c2 = (int)(maxa * (float)ReikaColorAPI.getAlpha((int)c2)) << 24 | c2 & 0xFFFFFF;
            ReikaGuiAPI.instance.func_73733_a(0, 0, evt.resolution.func_78326_a(), evt.resolution.func_78328_b(), c1, c2);
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-dz));
            GL11.glPopAttrib();
            GL11.glPushMatrix();
            int i = -this.renderingGroups.size() / 2;
            double s = 2.0;
            GL11.glTranslated((double)(evt.resolution.func_78327_c() / 2.0), (double)(evt.resolution.func_78324_d() / 2.0), (double)800.0);
            GL11.glTranslated((double)(-7.5 * s - 0.5), (double)(-7.5 * s + 2.0), (double)0.0);
            GL11.glScaled((double)s, (double)s, (double)s);
            Iterator<FullElementRender> it = this.renderingGroups.iterator();
            while (it.hasNext()) {
                FullElementRender t = it.next();
                GL11.glPushMatrix();
                GL11.glTranslated((double)(i * 60), (double)0.0, (double)0.0);
                ++t.age;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)t.getAlpha());
                t.render();
                GL11.glPopMatrix();
                ++i;
                if (t.age < t.lifespan) continue;
                it.remove();
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            return true;
        }
        return false;
    }

    public boolean isRenderingHexGroups() {
        return !this.renderingGroups.isEmpty();
    }

    private static class TileGroupRender
    extends FullElementRender {
        private final KeyAssemblyPuzzle.TileGroup group;

        private TileGroupRender(KeyAssemblyPuzzle.TileGroup g) {
            super(100);
            this.group = g;
        }

        @Override
        protected void render() {
            KeyAssemblyPuzzle p = LoreManager.instance.getPuzzle((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            HexGrid.Point pt = this.group.getCenter(p);
            GL11.glTranslated((double)(-pt.x), (double)(-pt.y), (double)0.0);
            for (HexGrid.Hex h : this.group.getHexes()) {
                GL11.glPushMatrix();
                KeyAssemblyPuzzle.HexCell c = p.getCell(h);
                HexGrid.Point pt2 = p.getHexLocation(h);
                GL11.glTranslated((double)pt2.x, (double)pt2.y, (double)0.0);
                c.render(p, Tessellator.field_78398_a, false, 1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    private static class StructurePasswordRender
    extends FullElementRender {
        private final ElementEncodedNumber colors;

        private StructurePasswordRender(ElementEncodedNumber c) {
            super(700);
            this.colors = c;
        }

        @Override
        protected void render() {
            ReikaTextureHelper.bindTerrainTexture();
            int l = Math.min(this.colors.getLength(), this.age / 5);
            boolean full = false;
            for (int i = 0; i < l; ++i) {
                int x = (i % 16 - 4) * 24 + 12;
                int y = 0;
                float f = full ? 1.0f : 1.0f + (float)(0.625 * Math.sin((double)System.currentTimeMillis() / 300.0 - (double)i));
                f = Math.min(1.0f, f);
                GL11.glColor4f((float)f, (float)f, (float)f, (float)this.getAlpha());
                CrystalElement e = this.colors.getSlot(i);
                ReikaGuiAPI.instance.func_94065_a(x, y, e.getOutlineRune(), 16, 16);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float w = GL11.glGetFloat((int)2849);
                GL11.glLineWidth((float)5.0f);
                int alpha = this.age < this.lifespan - 100 ? 255 : (this.lifespan - this.age + 1) * 255 / 100;
                for (int d = 0; d <= 2; ++d) {
                    int c = full ? e.getColor() : ReikaColorAPI.getColorWithBrightnessMultiplier((int)e.getColor(), (float)(1.0f - f * (float)d / 3.0f));
                    c = ReikaColorAPI.getColorWithAlpha((int)c, (float)alpha);
                    ReikaGuiAPI.instance.drawRectFrame(x - d, y - d, 16 + d * 2, 16 + d * 2, c);
                }
                GL11.glLineWidth((float)w);
            }
        }
    }

    private static abstract class FullElementRender {
        protected final int lifespan;
        protected int age;

        protected FullElementRender(int life) {
            this.lifespan = life;
        }

        protected final float getAlpha() {
            if (this.age < this.lifespan / 8) {
                return (float)this.age * 8.0f / (float)this.lifespan;
            }
            if (this.age > this.lifespan / 2) {
                return 1.0f - ((float)this.age - (float)this.lifespan / 2.0f) / ((float)this.lifespan / 2.0f);
            }
            return 1.0f;
        }

        protected abstract void render();
    }
}

