/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Instantiable.Event.Client.EntityRenderingLoopEvent;
import Reika.DragonAPI.Interfaces.Entity.TameHostile;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.Satisforestry.API.LizardDoggo;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class MobSonarRenderer {
    public static final MobSonarRenderer instance = new MobSonarRenderer();
    private final TimerMap<EntityEntry> coords = new TimerMap();
    private final ArrayList<Ping> pings = new ArrayList();
    private static final int DURATION = 20;

    private MobSonarRenderer() {
    }

    @SideOnly(value=Side.CLIENT)
    public void addCoordinate(Entity e) {
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_71045_bC();
        if (!ChromaItems.MOBSONAR.matchWith(held)) {
            return;
        }
        EntityEntry ee = new EntityEntry(e);
        if (held.field_77990_d != null) {
            int flags = held.field_77990_d.func_74762_e("typeFlags");
            if ((1 << ee.type.ordinal() & flags) == 0) {
                return;
            }
        }
        this.coords.put((Object)ee, 20);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DING, (Entity)e, (float)1.0f, (float)ee.type.soundPitch);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DING, (Entity)Minecraft.func_71410_x().field_71439_g, (float)0.2f, (float)ee.type.soundPitch);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tick(TickEvent.ClientTickEvent evt) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        this.coords.tick();
        Iterator<Ping> it = this.pings.iterator();
        while (it.hasNext()) {
            Ping p = it.next();
            if (!p.tick((World)Minecraft.func_71410_x().field_71441_e)) continue;
            it.remove();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void render(EntityRenderingLoopEvent evt) {
        if (!this.coords.isEmpty()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            ReikaRenderHelper.disableEntityLighting();
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            GL11.glDisable((int)3008);
            GL11.glDisable((int)3553);
            ReikaTextureHelper.bindTerrainTexture();
            int dim = Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g;
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            RenderManager rm = RenderManager.field_78727_a;
            GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
            GL11.glLineWidth((float)1.5f);
            Tessellator.field_78398_a.func_78371_b(1);
            for (EntityEntry loc : this.coords.keySet()) {
                if (loc.dimID != dim) continue;
                this.renderPoint(loc, this.coords.get((Object)loc), (EntityPlayer)ep, Tessellator.field_78398_a);
            }
            Tessellator.field_78398_a.func_78381_a();
            GL11.glPopAttrib();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPoint(EntityEntry loc, int ticks, EntityPlayer ep, Tessellator v5) {
        float f1 = (float)ticks / 20.0f;
        float f = Math.min(1.0f, f1 + 0.375f);
        double s = 1.5 * Math.sqrt(f);
        int c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)loc.type.baseColor, (float)f1);
        v5.func_78378_d(c);
        for (int i = 0; i <= loc.type.highlight; ++i) {
            double nx = ((EntityEntry)loc).box.field_72340_a - (double)i / 8.0;
            double ny = ((EntityEntry)loc).box.field_72338_b - (double)i / 8.0;
            double nz = ((EntityEntry)loc).box.field_72339_c - (double)i / 8.0;
            double px = ((EntityEntry)loc).box.field_72336_d + (double)i / 8.0;
            double py = ((EntityEntry)loc).box.field_72337_e + (double)i / 8.0;
            double pz = ((EntityEntry)loc).box.field_72334_f + (double)i / 8.0;
            v5.func_78377_a(nx, ny, nz);
            v5.func_78377_a(px, ny, nz);
            v5.func_78377_a(nx, ny, nz);
            v5.func_78377_a(nx, py, nz);
            v5.func_78377_a(nx, ny, nz);
            v5.func_78377_a(nx, ny, pz);
            v5.func_78377_a(px, py, pz);
            v5.func_78377_a(nx, py, pz);
            v5.func_78377_a(px, py, pz);
            v5.func_78377_a(px, ny, pz);
            v5.func_78377_a(px, py, pz);
            v5.func_78377_a(px, py, nz);
            v5.func_78377_a(px, py, pz);
            v5.func_78377_a(px, ny, pz);
            v5.func_78377_a(px, py, pz);
            v5.func_78377_a(px, py, nz);
            v5.func_78377_a(px, ny, nz);
            v5.func_78377_a(px, py, nz);
            v5.func_78377_a(px, ny, nz);
            v5.func_78377_a(px, ny, pz);
            v5.func_78377_a(nx, py, nz);
            v5.func_78377_a(px, py, nz);
            v5.func_78377_a(nx, py, nz);
            v5.func_78377_a(nx, py, pz);
            v5.func_78377_a(nx, ny, pz);
            v5.func_78377_a(px, ny, pz);
            v5.func_78377_a(nx, ny, pz);
            v5.func_78377_a(nx, py, pz);
        }
    }

    public void addPing(EntityPlayer ep, int range) {
        this.pings.add(new Ping((Entity)ep, range, 0.125));
    }

    private static class Ping {
        private final DecimalPosition center;
        private final double maxRadius;
        private final double radialSpeed;
        private double radius;
        private final HashSet<Integer> usedIDs = new HashSet();

        private Ping(Entity e, double r, double vr) {
            this.center = new DecimalPosition(e);
            this.maxRadius = r;
            this.radialSpeed = vr;
        }

        private boolean tick(World world) {
            this.radius += this.radialSpeed;
            List<Entity> li = this.getEntities(world);
            for (Entity e : li) {
                instance.addCoordinate(e);
            }
            return this.radius >= this.maxRadius;
        }

        @SideOnly(value=Side.CLIENT)
        private List<Entity> getEntities(World world) {
            ArrayList<Entity> li = new ArrayList<Entity>();
            AxisAlignedBB box = this.center.getAABB(this.radius);
            List in = world.func_72872_a(EntityLiving.class, box);
            for (Entity e : in) {
                if (e == Minecraft.func_71410_x().field_71439_g) continue;
                double d = e.func_70092_e(this.center.xCoord, this.center.yCoord, this.center.zCoord);
                double d2 = this.radius * this.radius;
                if (this.usedIDs.contains(e.func_145782_y())) continue;
                li.add(e);
                this.usedIDs.add(e.func_145782_y());
            }
            return li;
        }
    }

    public static enum EntitySonarType {
        DOGGO(ReikaMusicHelper.MusicKey.A5, 16744288, 2),
        TAMEHOSTILE(ReikaMusicHelper.MusicKey.E4, 0xFFFF44),
        TAMEABLE(ReikaMusicHelper.MusicKey.C6, 12216831, 1),
        ANIMAL(ReikaMusicHelper.MusicKey.G5, 0x22FF22),
        MOB(ReikaMusicHelper.MusicKey.C4, 0xFF2222),
        WATER(ReikaMusicHelper.MusicKey.G4, 0x22AAFF),
        OTHER(ReikaMusicHelper.MusicKey.C5, 0xFFFFFF);

        private final int baseColor;
        private final float soundPitch;
        private final int highlight;

        private EntitySonarType(ReikaMusicHelper.MusicKey k, int c) {
            this(k, c, 0);
        }

        private EntitySonarType(ReikaMusicHelper.MusicKey k, int c, int h) {
            this.baseColor = c;
            this.soundPitch = (float)ReikaMusicHelper.MusicKey.C5.getRatio(k);
            this.highlight = h;
        }

        public static EntitySonarType getFromEntity(Entity e) {
            if (e instanceof LizardDoggo) {
                return DOGGO;
            }
            if (e instanceof TameHostile) {
                return TAMEHOSTILE;
            }
            if (e instanceof EntityTameable) {
                return TAMEABLE;
            }
            if (e instanceof EntityAnimal) {
                return ANIMAL;
            }
            if (e instanceof EntityMob) {
                return MOB;
            }
            if (e instanceof EntityWaterMob) {
                return WATER;
            }
            return OTHER;
        }

        public static int getAllFlags() {
            return (1 << OTHER.ordinal() + 1) - 1;
        }
    }

    private static class EntityEntry {
        private final int entityID;
        private final int dimID;
        private final DecimalPosition location;
        private final Class entityType;
        private final AxisAlignedBB box;
        private final EntitySonarType type;

        private EntityEntry(Entity e) {
            this.entityID = e.func_145782_y();
            this.dimID = e.field_70170_p.field_73011_w.field_76574_g;
            this.location = new DecimalPosition(e);
            this.entityType = e.getClass();
            this.box = e.field_70121_D != null ? e.field_70121_D.func_72329_c() : null;
            this.type = EntitySonarType.getFromEntity(e);
        }

        public int hashCode() {
            return this.entityID;
        }

        public boolean equals(Object o) {
            return o instanceof EntityEntry && ((EntityEntry)o).entityID == this.entityID;
        }
    }
}

