/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.FocusAcceleratable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PoolRecipes;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Block.BlockDummyAux;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementBufferCapacityBoost;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.LumenRequestingTile;
import Reika.ChromatiCraft.Magic.Interfaces.LumenTile;
import Reika.ChromatiCraft.ModInterface.Bees.ChromaBeeHelpers;
import Reika.ChromatiCraft.ModInterface.Bees.ProductChecks;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.NodeRecharger;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityChromaCrafter;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityPlayerInfuser;
import Reika.ChromatiCraft.TileEntity.TileEntityLumenWire;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IChromosomeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.nodes.INode;

public class MouseoverOverlayRenderer {
    public static final MouseoverOverlayRenderer instance = new MouseoverOverlayRenderer();
    private final RenderItem itemRender = new RenderItem();

    private MouseoverOverlayRenderer() {
    }

    void renderTileOverlays(EntityPlayer ep, int gsc) {
        MovingObjectPosition pos = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, (double)4.0, (boolean)false);
        if (pos != null) {
            TileEntity te = ep.field_70170_p.func_147438_o(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            if (te instanceof BlockDummyAux.TileEntityDummyAux) {
                te = ((BlockDummyAux.TileEntityDummyAux)te).getLinkedTile();
            }
            if (te instanceof LumenTile) {
                if (te instanceof TileEntityAdjacencyUpgrade && !ChromaOptions.POWEREDACCEL.getState()) {
                    return;
                }
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                this.renderStorageOverlay(ep, gsc, (LumenTile)te);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (te instanceof OperationInterval) {
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                this.renderStatusOverlay(ep, gsc, (OperationInterval)te);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (te instanceof FocusAcceleratable && ChromaResearch.FOCUSCRYSTALS.playerHas(ep)) {
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                this.renderAccelerationOverlay(ep, gsc, (FocusAcceleratable)te);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (te instanceof TileEntityChromaCrafter) {
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                this.renderItemContents(ep, gsc, (TileEntityChromaCrafter)te);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (te instanceof TileEntityLumenWire) {
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                this.renderDetectionMode(ep, gsc, (TileEntityLumenWire)te);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (te instanceof TileEntityPlayerInfuser) {
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                this.renderInfuserStatuses(ep, gsc, (TileEntityPlayerInfuser)te);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (ModList.FORESTRY.isLoaded() && InterfaceCache.BEEHOUSE.instanceOf((Object)te)) {
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                this.renderConditionalBeeProductOverlay(ep, gsc, (IBeeHousing)te);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (ModList.THAUMCRAFT.isLoaded() && InterfaceCache.NODE.instanceOf((Object)te) && NodeRecharger.instance.hasLocation(new WorldLocation(te))) {
                GL11.glPushAttrib((int)1048575);
                GL11.glPushMatrix();
                NodeRecharger.instance.renderNodeOverlay(ep, gsc, (INode)te);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
        }
    }

    private void renderStatusOverlay(EntityPlayer ep, int gsc, OperationInterval te) {
        int ar = 12;
        int ox = Minecraft.func_71410_x().field_71443_c / (gsc * 2) + ar - 8;
        int oy = Minecraft.func_71410_x().field_71440_d / (gsc * 2) + ar - 8;
        OperationInterval.OperationState state = te.getState();
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/infoicons.png");
        int idx = state.ordinal();
        double u = 0.125 * (double)idx;
        double v = 0.25;
        double u2 = 0.5;
        double v2 = 0.25;
        double s = 0.125;
        double r = 32.0;
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        int sh = 3;
        v5.func_78374_a((double)(ox + 0 - sh), (double)oy + r + (double)sh, 0.0, u2, v2 + s);
        v5.func_78374_a((double)ox + r + (double)sh, (double)oy + r + (double)sh, 0.0, u2 + s, v2 + s);
        v5.func_78374_a((double)ox + r + (double)sh, (double)(oy + 0 - sh), 0.0, u2 + s, v2);
        v5.func_78374_a((double)(ox + 0 - sh), (double)(oy + 0 - sh), 0.0, u2, v2);
        v5.func_78374_a((double)(ox + 0), (double)oy + r, 0.0, u, v + s);
        v5.func_78374_a((double)ox + r, (double)oy + r, 0.0, u + s, v + s);
        v5.func_78374_a((double)ox + r, (double)(oy + 0), 0.0, u + s, v);
        v5.func_78374_a((double)(ox + 0), (double)(oy + 0), 0.0, u, v);
        v5.func_78381_a();
        if (state == OperationInterval.OperationState.RUNNING) {
            idx = state.ordinal() + 1;
            u = 0.125 * (double)idx;
            v = 0.25;
            v5.func_78371_b(6);
            v5.func_78374_a((double)ox + r / 2.0, (double)oy + r / 2.0, 0.0, u + 0.0625, v + 0.0625);
            float f = te.getOperationFraction();
            double ma = 360.0f * f;
            double da = 0.25;
            for (double a = 0.0; a < ma; a += da) {
                double dx = Math.sin(Math.toRadians(a + 90.0));
                double dy = Math.cos(Math.toRadians(a + 90.0));
                double x = (double)ox + r / 2.0 + r / 2.0 * dx;
                double y = (double)oy + r / 2.0 + r / 2.0 * dy;
                double du = u + 0.0625 + dx * s / 2.0;
                double dv = v + 0.0625 + dy * s / 2.0;
                v5.func_78374_a(x, y, 0.0, du, dv);
            }
            v5.func_78381_a();
        }
    }

    private void renderAccelerationOverlay(EntityPlayer ep, int gsc, FocusAcceleratable te) {
        int ar = 30;
        int ox = Minecraft.func_71410_x().field_71443_c / (gsc * 2) + ar + 8;
        int oy = Minecraft.func_71410_x().field_71440_d / (gsc * 2) - ar - 8;
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/infoicons.png");
        double u = 0.625;
        double v = 0.25;
        double s = 0.125;
        double r = 32.0;
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        v5.func_78374_a((double)(ox + 0), (double)oy + r, 0.0, u, v + s);
        v5.func_78374_a((double)ox + r, (double)oy + r, 0.0, u + s, v + s);
        v5.func_78374_a((double)ox + r, (double)(oy + 0), 0.0, u + s, v);
        v5.func_78374_a((double)(ox + 0), (double)(oy + 0), 0.0, u, v);
        v5.func_78381_a();
        u = 0.875;
        v = 0.25;
        v5.func_78371_b(6);
        v5.func_78374_a((double)ox + r / 2.0, (double)oy + r / 2.0, 0.0, u + 0.0625, v + 0.0625);
        float f = (te.getAccelerationFactor() - 1.0f) / (te.getMaximumAcceleratability() - 1.0f);
        double ma = 360.0f * f;
        double da = 0.25;
        for (double a = 0.0; a < ma; a += da) {
            double dx = Math.sin(Math.toRadians(a + 90.0));
            double dy = Math.cos(Math.toRadians(a + 90.0));
            double x = (double)ox + r / 2.0 + r / 2.0 * dx;
            double y = (double)oy + r / 2.0 + r / 2.0 * dy;
            double du = u + 0.0625 + dx * s / 2.0;
            double dv = v + 0.0625 + dy * s / 2.0;
            v5.func_78374_a(x, y, 0.0, du, dv);
        }
        v5.func_78381_a();
        float p = te.getProgressToNextStep();
        if (p > 0.0f) {
            u = 0.75;
            v = 0.25;
            v5.func_78371_b(6);
            v5.func_78374_a((double)ox + r / 2.0, (double)oy + r / 2.0, 0.0, u + 0.0625, v + 0.0625);
            double ma2 = ma + (360.0 - ma) * (double)p;
            for (double a = ma; a < ma2; a += da) {
                double dx = Math.sin(Math.toRadians(a + 90.0));
                double dy = Math.cos(Math.toRadians(a + 90.0));
                double x = (double)ox + r / 2.0 + r / 2.0 * dx;
                double y = (double)oy + r / 2.0 + r / 2.0 * dy;
                double du = u + 0.0625 + dx * s / 2.0;
                double dv = v + 0.0625 + dy * s / 2.0;
                v5.func_78374_a(x, y, 0.0, du, dv);
            }
            v5.func_78381_a();
        }
    }

    public void renderStorageOverlay(EntityPlayer ep, int gsc, LumenTile lt) {
        double a;
        double y;
        double x;
        int r;
        LumenRequestingTile lrt;
        ElementTagCompound tag = lt.getEnergy();
        if (lt instanceof LumenRequestingTile && (tag = (lrt = (LumenRequestingTile)lt).getRequestedTotal()) == null) {
            return;
        }
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        Tessellator v5 = Tessellator.field_78398_a;
        int ar = 12;
        int rb = r = Keyboard.isKeyDown((int)42) ? ar * 2 : ar;
        int ox = Minecraft.func_71410_x().field_71443_c / (gsc * 2) - ar - 8;
        int oy = Minecraft.func_71410_x().field_71440_d / (gsc * 2) - ar - 8;
        int hash = System.identityHashCode(lt);
        double oa = hash + 2 * lt.getTicksExisted() * (hash % 2 == 0 ? 1 : -1);
        int n = tag.tagCount();
        int i = 0;
        double angleStep = ReikaMathLibrary.isInteger((double)(360.0 / (double)n)) ? 2.0 : 1.0;
        for (CrystalElement e : tag.elementSet()) {
            double min = (double)i * 360.0 / (double)n;
            double max = (double)(i + 1) * 360.0 / (double)n;
            double maxe = lt.getMaxStorage(e);
            if (lt instanceof LumenRequestingTile) {
                maxe = ((LumenRequestingTile)lt).getRequestedTotal().getValue(e);
            }
            v5.func_78371_b(5);
            int color = ReikaColorAPI.mixColors((int)e.getColor(), (int)0, (float)0.25f);
            v5.func_78378_d(color);
            v5.func_78380_c(240);
            for (double a2 = min; a2 <= max; a2 += angleStep) {
                double x2 = (double)ox + (double)r * Math.cos(Math.toRadians(oa + a2));
                double y2 = (double)oy + (double)r * Math.sin(Math.toRadians(oa + a2));
                v5.func_78377_a(x2, y2, 0.0);
                v5.func_78377_a((double)ox, (double)oy, 0.0);
            }
            v5.func_78381_a();
            v5.func_78371_b(5);
            color = e.getColor();
            v5.func_78378_d(color);
            v5.func_78380_c(240);
            double dr = Math.min((double)r, (double)((long)r * (long)lt.getEnergy(e)) / maxe);
            for (double a3 = min; a3 <= max; a3 += angleStep) {
                double x3 = (double)ox + dr * Math.cos(Math.toRadians(oa + a3));
                double y3 = (double)oy + dr * Math.sin(Math.toRadians(oa + a3));
                v5.func_78377_a(x3, y3, 0.0);
                v5.func_78377_a((double)ox, (double)oy, 0.0);
            }
            v5.func_78381_a();
            ++i;
        }
        float wide = GL11.glGetFloat((int)2849);
        GL11.glLineWidth((float)1.0f);
        if (n > 1) {
            v5.func_78371_b(1);
            v5.func_78378_d(0);
            v5.func_78380_c(240);
            for (double a4 = 0.0; a4 < 360.0; a4 += 360.0 / (double)n) {
                x = (double)ox + (double)rb * Math.cos(Math.toRadians(oa + a4));
                y = (double)oy + (double)rb * Math.sin(Math.toRadians(oa + a4));
                v5.func_78377_a(x, y, 0.0);
                v5.func_78377_a((double)ox, (double)oy, 0.0);
            }
            v5.func_78381_a();
        }
        v5.func_78371_b(2);
        v5.func_78378_d(0);
        v5.func_78380_c(240);
        for (a = 0.0; a <= 360.0; a += 5.0) {
            x = (double)ox + (double)r * Math.cos(Math.toRadians(oa + a));
            y = (double)oy + (double)r * Math.sin(Math.toRadians(oa + a));
            v5.func_78377_a(x, y, 0.0);
        }
        v5.func_78381_a();
        GL11.glLineWidth((float)2.0f);
        if (n > 1) {
            v5.func_78371_b(1);
            v5.func_78384_a(0, 180);
            v5.func_78380_c(240);
            for (a = 0.0; a < 360.0; a += 360.0 / (double)n) {
                x = (double)ox + (double)rb * Math.cos(Math.toRadians(oa + a));
                y = (double)oy + (double)rb * Math.sin(Math.toRadians(oa + a));
                v5.func_78377_a(x, y, 0.0);
                v5.func_78377_a((double)ox, (double)oy, 0.0);
            }
            v5.func_78381_a();
        }
        v5.func_78371_b(2);
        v5.func_78384_a(0, 180);
        v5.func_78380_c(240);
        for (a = 0.0; a <= 360.0; a += 5.0) {
            x = (double)ox + (double)r * Math.cos(Math.toRadians(oa + a));
            y = (double)oy + (double)r * Math.sin(Math.toRadians(oa + a));
            v5.func_78377_a(x, y, 0.0);
        }
        v5.func_78381_a();
        GL11.glLineWidth((float)wide);
        GL11.glEnable((int)3553);
    }

    private void renderItemContents(EntityPlayer ep, int gsc, TileEntityChromaCrafter te) {
        PoolRecipes.PoolRecipe r;
        ItemHashMap<Integer> c = te.getCurrentItems();
        if (c == null || c.isEmpty()) {
            return;
        }
        int ar = 16;
        int ox = Minecraft.func_71410_x().field_71443_c / (gsc * 2) + ar - 8;
        int oy = Minecraft.func_71410_x().field_71440_d / (gsc * 2) - ar - 8;
        int i = 0;
        int h = 3;
        int mx = ox;
        int my = oy;
        ReikaRenderHelper.disableLighting();
        ReikaRenderHelper.disableEntityLighting();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator.field_78398_a.func_78380_c(240);
        Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
        for (ItemStack is : c.keySet()) {
            int x = ox + i / h * 18;
            int y = oy - i % h * 16;
            mx = x;
            my = Math.min(my, y);
            ReikaGuiAPI.instance.drawItemStack(this.itemRender, Minecraft.func_71410_x().field_71466_p, ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)((Integer)c.get(is))), x, y);
            ++i;
        }
        int berries = te.getBerryCount();
        if (berries > 0) {
            int r2 = 2;
            int clr = ReikaColorAPI.mixColors((int)-65536, (int)0xFFFFFF, (float)Math.min(1.0f, (float)berries / 16.0f));
            ReikaGuiAPI.instance.drawRectFrame(ox - r2, my - r2 + 1, mx - ox + 18 + r2 * 2, oy - my + 16 + r2 * 2, clr);
            String s = String.valueOf(berries) + " " + ChromaStacks.etherBerries.func_82833_r();
            int ds = 1;
            ChromaFontRenderer.FontType.GUI.renderer.func_78276_b(s, mx + 19 - ChromaFontRenderer.FontType.GUI.renderer.func_78256_a(s) + ds, oy + 21 + ds, ReikaColorAPI.getColorWithBrightnessMultiplier((int)clr, (float)0.65f));
            ChromaFontRenderer.FontType.GUI.renderer.func_78276_b(s, mx + 19 - ChromaFontRenderer.FontType.GUI.renderer.func_78256_a(s), oy + 21, ReikaColorAPI.mixColors((int)clr, (int)-1, (float)0.45f));
        }
        if ((r = te.getActiveRecipe()) != null) {
            ItemStack out = r.getOutput();
            if (r.allowDoubling() && berries >= 16) {
                out.field_77994_a *= 2;
            }
            String s = "Crafting: " + out.func_82833_r();
            int x = Minecraft.func_71410_x().field_71443_c / (gsc * 2);
            int y = Minecraft.func_71410_x().field_71440_d / (gsc * 2) + 40;
            ReikaGuiAPI.instance.func_73732_a((FontRenderer)ChromaFontRenderer.FontType.GUI.renderer, s, x - 3, y, 0xFFFFFF);
            ReikaGuiAPI.instance.drawItemStack(this.itemRender, (FontRenderer)ChromaFontRenderer.FontType.GUI.renderer, out, x + ChromaFontRenderer.FontType.GUI.renderer.func_78256_a(s) / 2 + 3, y - 4);
        }
    }

    private void renderDetectionMode(EntityPlayer ep, int gsc, TileEntityLumenWire te) {
        int ar = 12;
        int ox = Minecraft.func_71410_x().field_71443_c / (gsc * 2) + ar - 8;
        int oy = Minecraft.func_71410_x().field_71440_d / (gsc * 2) + ar - 8;
        TileEntityLumenWire.CheckType mode = te.getMode();
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/infoicons.png");
        double u = 0.0625 * (double)mode.ordinal();
        double v = 0.0625;
        double s = 0.0625;
        double r = 12.0;
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78382_b();
        float f = 0.75f + 0.25f * (float)Math.sin((double)System.currentTimeMillis() / 80.0);
        int c = ReikaColorAPI.mixColors((int)mode.renderColor, (int)0xFFFFFF, (float)f);
        v5.func_78378_d(c);
        int sh = 3;
        v5.func_78374_a((double)(ox + 0), (double)oy + r, 0.0, u, v + s);
        v5.func_78374_a((double)ox + r, (double)oy + r, 0.0, u + s, v + s);
        v5.func_78374_a((double)ox + r, (double)(oy + 0), 0.0, u + s, v);
        v5.func_78374_a((double)(ox + 0), (double)(oy + 0), 0.0, u, v);
        v5.func_78381_a();
    }

    private void renderInfuserStatuses(EntityPlayer ep, int gsc, TileEntityPlayerInfuser te) {
        int ar = 16;
        int ox = Minecraft.func_71410_x().field_71443_c / (gsc * 2) + ar - 8;
        int oy = Minecraft.func_71410_x().field_71440_d / (gsc * 2) - ar - 8;
        ReikaRenderHelper.disableLighting();
        ReikaRenderHelper.disableEntityLighting();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator.field_78398_a.func_78380_c(240);
        Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
        ElementBufferCapacityBoost r = te.getSelectedEffect();
        int x = Minecraft.func_71410_x().field_71443_c / (gsc * 2);
        int y = Minecraft.func_71410_x().field_71440_d / (gsc * 2) + 40;
        if (r != null) {
            r.drawIcon(Tessellator.field_78398_a, x, y, 16.0);
            if (!r.isAvailableToPlayer(ep) || r.playerHas(ep)) {
                ReikaGuiAPI.instance.func_94065_a(x + 1, y - 6, ChromaIcons.NOENTER.getIcon(), 16, 16);
            }
        } else {
            int dx = x;
            boolean flag = false;
            for (ElementBufferCapacityBoost b : ElementBufferCapacityBoost.list) {
                if (!b.playerHas(ep) && !b.isAvailableToPlayer(ep)) continue;
                flag = true;
                b.drawIcon(Tessellator.field_78398_a, dx + 3, y - 4, 16.0);
                if (b.playerHas(ep)) {
                    ReikaTextureHelper.bindTerrainTexture();
                    ReikaGuiAPI.instance.func_94065_a(dx + 3 + 8, y + 4, ChromaIcons.CHECK.getIcon(), 8, 8);
                    continue;
                }
                ItemStack out = b.getIngredient();
                if (out == null) continue;
                ReikaGuiAPI.instance.drawItemStack(this.itemRender, (FontRenderer)ChromaFontRenderer.FontType.GUI.renderer, out, dx + 3 + 6, y + 4);
                dx += 18;
            }
            if (!flag) {
                ReikaGuiAPI.instance.func_94065_a(x + 1, y - 6, ChromaIcons.X.getIcon(), 16, 16);
            }
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    private void renderConditionalBeeProductOverlay(EntityPlayer ep, int gsc, IBeeHousing te) {
        IAlleleBeeSpecies type;
        IBee bee;
        ItemStack queen = te.getBeeInventory().getQueen();
        if (queen != null && (bee = (IBee)AlleleManager.alleleRegistry.getIndividual(queen)) != null && (type = (IAlleleBeeSpecies)bee.getGenome().getActiveAllele((IChromosomeType)EnumBeeChromosome.SPECIES)) instanceof ChromaBeeHelpers.ConditionalProductBee) {
            int ox = Minecraft.func_71410_x().field_71443_c / (gsc * 2) - 8;
            int oy = Minecraft.func_71410_x().field_71440_d / (gsc * 2) - 8;
            ChromaBeeHelpers.ConditionalProductProvider p = ((ChromaBeeHelpers.ConditionalProductBee)type).getProductProvider();
            ItemHashMap<ProductChecks.ProductCondition> map = p.getConditions();
            for (ItemStack is : map.keySet()) {
                ProductChecks.ProductCondition productCondition = (ProductChecks.ProductCondition)map.get(is);
            }
        }
    }
}

