/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.API.Interfaces.OrePings;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.ProgressiveRecursiveBreaker;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Event.Client.EntityRenderingLoopEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class OreOverlayRenderer {
    public static final OreOverlayRenderer instance = new OreOverlayRenderer();
    private final HashMap<BlockKey, OrePings.OrePingDelegate> blocks = new HashMap();
    private final HashMap<WorldLocation, OreRender> coords = new HashMap();
    private final HashMap<String, Long> lastSoundTick = new HashMap();
    private static final int DURATION_PING = 720;
    private static final int DURATION_SCAN = 90;
    private static final int PING_RANGE = 48;

    private OreOverlayRenderer() {
        this.loadOres();
    }

    public void loadOres() {
        for (ReikaOreHelper reikaOreHelper : ReikaOreHelper.oreList) {
            this.blocks.put(new BlockKey(reikaOreHelper.getOreBlockInstance()), new OreBlock((OreType)reikaOreHelper));
        }
        this.blocks.put(new BlockKey(Blocks.field_150439_ay), this.blocks.get(new BlockKey(Blocks.field_150450_ax)));
        for (ReikaOreHelper reikaOreHelper : ModOreList.oreList) {
            OreBlock ob = new OreBlock((OreType)reikaOreHelper);
            for (ItemStack is : reikaOreHelper.getAllOreBlocks()) {
                this.blocks.put(BlockKey.fromItem((ItemStack)is), ob);
            }
        }
        ChromatiCraft.logger.log((Object)("Initialized ore map with " + this.blocks.size() + " entries: " + this.blocks.keySet()));
    }

    public OrePings.OrePingDelegate getForBlock(Block b, int meta) {
        return this.blocks.get(new BlockKey(b, meta));
    }

    public OrePings.OrePingDelegate getOreTypeByData(ItemStack is) {
        if (is.field_77990_d == null || !is.field_77990_d.func_74764_b("oreType")) {
            return null;
        }
        ItemStack ore = ItemStack.func_77949_a((NBTTagCompound)is.field_77990_d.func_74775_l("oreType"));
        if (ore == null) {
            return null;
        }
        return this.blocks.get(BlockKey.fromItem((ItemStack)ore));
    }

    public static void addBlockDelegate(Block b, int meta, OrePings.OrePingDelegate delegate) {
        BlockKey bk = new BlockKey(b, meta);
        if (OreOverlayRenderer.instance.blocks.containsKey(bk)) {
            throw new IllegalArgumentException("Block already present!");
        }
        OreOverlayRenderer.instance.blocks.put(bk, delegate);
    }

    public void addCoordinate(World world, int x, int y, int z, Block id, int meta, boolean ping) {
        if (world.field_72995_K) {
            this.coords.put(new WorldLocation(world, x, y, z), new OreRender(id, meta, ping));
        } else {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.OREPINGLOC.ordinal(), (World)world, (int)x, (int)y, (int)z, (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x, (double)y, (double)z, 90.0), (int[])new int[]{Block.func_149682_b((Block)id), meta, ping ? 1 : 0});
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tick(TickEvent.ClientTickEvent evt) {
        Iterator<Map.Entry<WorldLocation, OreRender>> it = this.coords.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<WorldLocation, OreRender> e = it.next();
            OreRender key = e.getValue();
            key.life--;
            if (key.life > 0) continue;
            it.remove();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void render(EntityRenderingLoopEvent evt) {
        if (!this.coords.isEmpty()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            ReikaRenderHelper.disableEntityLighting();
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            GL11.glDisable((int)3008);
            ReikaTextureHelper.bindTerrainTexture();
            int dim = Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g;
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            for (WorldLocation loc : this.coords.keySet()) {
                if (loc.dimensionID != dim) continue;
                this.renderPoint(loc, this.coords.get(loc), (EntityPlayer)ep);
            }
            GL11.glPopAttrib();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPoint(WorldLocation loc, OreRender val, EntityPlayer ep) {
        GL11.glPushMatrix();
        RenderManager rm = RenderManager.field_78727_a;
        GL11.glTranslated((double)((double)loc.xCoord + 0.5 - RenderManager.field_78725_b), (double)((double)loc.yCoord + 0.5 - RenderManager.field_78726_c), (double)((double)loc.zCoord + 0.5 - RenderManager.field_78723_d));
        GL11.glRotatef((float)(-rm.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        Tessellator v5 = Tessellator.field_78398_a;
        IIcon ico = ChromaIcons.FADE_BASICBLEND.getIcon();
        float u = ico.func_94209_e();
        float v = ico.func_94206_g();
        float du = ico.func_94212_f();
        float dv = ico.func_94210_h();
        v5.func_78382_b();
        v5.func_78380_c(240);
        float f1 = val.getOpacity();
        float f = Math.min(1.0f, f1 + 0.375f);
        double s = 1.5 * Math.sqrt(f);
        int c = val.getColor();
        v5.func_78384_a(c, (int)(f1 * 255.0f));
        v5.func_78374_a(-s, s, 0.0, (double)u, (double)dv);
        v5.func_78374_a(s, s, 0.0, (double)du, (double)dv);
        v5.func_78374_a(s, -s, 0.0, (double)du, (double)v);
        v5.func_78374_a(-s, -s, 0.0, (double)u, (double)v);
        v5.func_78381_a();
        GL11.glPopMatrix();
    }

    public void startScan(World world, int x, int y, int z, EntityPlayer ep) {
        ProgressiveRecursiveBreaker.ProgressiveBreaker b = ProgressiveRecursiveBreaker.instance.addCoordinateWithReturn(world, x, y, z, 80);
        b.call = new OreScanCallback();
        this.addBreaker(b, ep);
    }

    public void startPing(World world, int x, int y, int z, EntityPlayer ep) {
        int r = 48;
        ProgressiveRecursiveBreaker.ProgressiveBreaker b = ProgressiveRecursiveBreaker.instance.addCoordinateWithReturn(world, x, y, z, r);
        b.isOmni = true;
        b.breakAir = true;
        this.addBreaker(b, ep);
        b.tickRate = 1;
        b.call = new OrePingCallback();
        ChromaSounds.NETWORKOPT.playSound((Entity)ep, 1.0f, 0.5f);
    }

    private void addBreaker(ProgressiveRecursiveBreaker.ProgressiveBreaker b, EntityPlayer ep) {
        b.pathTracking = true;
        b.doBreak = false;
        b.player = ep;
    }

    private void playSoundWithCooldown(SoundEnum s, EntityPlayer ep, float vol, float pitch) {
        Long last = this.lastSoundTick.get(s.getName());
        if (last != null && ep.field_70170_p.func_82737_E() <= last) {
            return;
        }
        this.lastSoundTick.put(s.getName(), ep.field_70170_p.func_82737_E());
        s.playSound((Entity)ep, vol, pitch);
    }

    private static class OreBlock
    implements OrePings.OrePingDelegate {
        private final OreType ore;

        private OreBlock(OreType ore) {
            this.ore = ore;
        }

        @Override
        public boolean match(Block b, int meta) {
            if (this.ore instanceof ReikaOreHelper) {
                return ReikaOreHelper.getFromVanillaOre((Block)b) == this.ore;
            }
            if (this.ore instanceof ModOreList) {
                return ModOreList.getModOreFromOre((Block)b, (int)meta) == this.ore;
            }
            return false;
        }

        @Override
        public int getColor() {
            return this.ore.getDisplayColor();
        }

        @Override
        public boolean isVisible(EntityPlayer ep) {
            return true;
        }

        @Override
        public IIcon getIcon() {
            ItemStack is = this.ore.getFirstOreBlock();
            return Block.func_149634_a((Item)is.func_77973_b()).func_149691_a(0, is.func_77960_j());
        }

        @Override
        public ItemStack getPrimary() {
            return this.ore.getFirstOreBlock();
        }
    }

    private static class OreRender {
        public final Block block;
        public final int metadata;
        private final int lifetime;
        private int life;
        private final int color;

        private OreRender(Block b, int meta, boolean ping) {
            this.block = b;
            this.metadata = meta;
            BlockKey bk = new BlockKey(b, meta);
            OrePings.OrePingDelegate del = (OrePings.OrePingDelegate)instance.blocks.get(bk);
            if (del == null) {
                ChromatiCraft.logger.logError((Object)("Block " + bk + " has null oreping delegate?!"));
            }
            this.color = del != null ? del.getColor() : 13926143;
            this.life = this.lifetime = ping ? 720 : 90;
        }

        public int getColor() {
            return this.color;
        }

        public float getOpacity() {
            return (float)this.life / (float)this.lifetime;
        }
    }

    private static class OrePingCallback
    extends OreOverlayCallback {
        private OrePingCallback() {
        }

        @Override
        protected void onAdd(World world, int x, int y, int z, ProgressiveRecursiveBreaker.ProgressiveBreaker b, Block id, int meta) {
            BlockArray arr = new BlockArray();
            b.tickRate = 5;
            arr.recursiveAddWithMetadata((IBlockAccess)world, x, y, z, id, meta);
            instance.playSoundWithCooldown((SoundEnum)ChromaSounds.BOUNCE, b.player, 0.5f, 1.0f);
            for (Coordinate c : arr.keySet()) {
                b.exclude(c);
                instance.addCoordinate(world, c.xCoord, c.yCoord, c.zCoord, id, meta, true);
            }
        }
    }

    private static class OreScanCallback
    extends OreOverlayCallback {
        private int blocksFound;

        private OreScanCallback() {
        }

        @Override
        protected void onAdd(World world, int x, int y, int z, ProgressiveRecursiveBreaker.ProgressiveBreaker b, Block id, int meta) {
            instance.playSoundWithCooldown((SoundEnum)ChromaSounds.BUFFERWARNING, b.player, 1.0f, 0.5f);
            ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.NUMBERPARTICLE.ordinal(), (World)world, (int)x, (int)y, (int)z, (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x, (double)y, (double)z, 90.0), (int[])new int[]{++this.blocksFound});
        }
    }

    private static abstract class OreOverlayCallback
    implements ProgressiveRecursiveBreaker.BreakerCallback {
        private OreOverlayCallback() {
        }

        public final boolean canBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
            return true;
        }

        public final void onPreBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        }

        public final void onFinish(ProgressiveRecursiveBreaker.ProgressiveBreaker b) {
        }

        public final void onPostBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
            OrePings.OrePingDelegate opd = (OrePings.OrePingDelegate)instance.blocks.get(new BlockKey(id, meta));
            if (opd != null) {
                instance.addCoordinate(world, x, y, z, id, meta, this instanceof OrePingCallback);
                this.onAdd(world, x, y, z, b, id, meta);
            }
        }

        protected abstract void onAdd(World var1, int var2, int var3, int var4, ProgressiveRecursiveBreaker.ProgressiveBreaker var5, Block var6, int var7);
    }
}

