/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class ProbeInfoOverlayRenderer {
    public static final ProbeInfoOverlayRenderer instance = new ProbeInfoOverlayRenderer();
    private static final int CONNECTIVITY_DURATION = 480;
    private final EnumMap<CrystalElement, PylonConnection> connectivityFlags = new EnumMap(CrystalElement.class);

    private ProbeInfoOverlayRenderer() {
    }

    @SideOnly(value=Side.CLIENT)
    void renderConnectivityOverlays(EntityPlayer ep, int gsc) {
        if (!this.connectivityFlags.isEmpty()) {
            Iterator<Map.Entry<CrystalElement, PylonConnection>> it = this.connectivityFlags.entrySet().iterator();
            boolean nonEmpty = false;
            Tessellator v5 = Tessellator.field_78398_a;
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            ReikaTextureHelper.bindTerrainTexture();
            v5.func_78382_b();
            v5.func_78378_d(0xFFFFFF);
            while (it.hasNext()) {
                Map.Entry<CrystalElement, PylonConnection> e = it.next();
                PylonConnection tick = e.getValue();
                if (tick.age == 475) {
                    ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.BOUNCE, (Entity)ep, (float)0.25f, (float)2.0f);
                }
                if (tick.shouldRender()) {
                    this.renderConnectivityStatus(v5, ep, gsc, tick);
                }
                if (tick.age > 0) {
                    tick.age--;
                }
                if (tick.age <= 0) {
                    it.remove();
                    continue;
                }
                e.setValue(tick);
                nonEmpty = true;
            }
            v5.func_78381_a();
            if (!nonEmpty) {
                this.connectivityFlags.clear();
            }
            GL11.glPopAttrib();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderConnectivityStatus(Tessellator v5, EntityPlayer ep, int gsc, PylonConnection pc) {
        int ar = 12;
        IIcon ico = pc.valid ? (pc.connected ? ChromaIcons.CHECK.getIcon() : ChromaIcons.X.getIcon()) : ChromaIcons.NOENTER.getIcon();
        IIcon ico2 = pc.color.getOutlineRune();
        v5.func_78384_a(0xFFFFFF, pc.getAlpha());
        int dx = pc.color.ordinal() >= 8 ? 20 : -40;
        int dy = pc.color.ordinal() % 8 * 15 - 65;
        int ox = dx + Minecraft.func_71410_x().field_71443_c / (gsc * 2) + ar - 8;
        int oy = dy + Minecraft.func_71410_x().field_71440_d / (gsc * 2) + ar - 8;
        double u = ico.func_94209_e();
        double v = ico.func_94206_g();
        double du = ico.func_94212_f();
        double dv = ico.func_94210_h();
        double u2 = ico2.func_94209_e();
        double v2 = ico2.func_94206_g();
        double du2 = ico2.func_94212_f();
        double dv2 = ico2.func_94210_h();
        double r = 12.0;
        int dw = 7;
        v5.func_78374_a((double)(ox + 0 + dw), (double)oy + r, 0.0, u, dv);
        v5.func_78374_a((double)ox + r + (double)dw, (double)oy + r, 0.0, du, dv);
        v5.func_78374_a((double)ox + r + (double)dw, (double)(oy + 0), 0.0, du, v);
        v5.func_78374_a((double)(ox + 0 + dw), (double)(oy + 0), 0.0, u, v);
        v5.func_78374_a((double)(ox + 0 - dw), (double)oy + r, 0.0, u2, dv2);
        v5.func_78374_a((double)ox + r - (double)dw, (double)oy + r, 0.0, du2, dv2);
        v5.func_78374_a((double)ox + r - (double)dw, (double)(oy + 0), 0.0, du2, v2);
        v5.func_78374_a((double)(ox + 0 - dw), (double)(oy + 0), 0.0, u2, v2);
    }

    public void markConnectivity(EntityPlayer ep, CrystalElement e, boolean connected, boolean valid) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.connectivityFlags.put(e, new PylonConnection(e, connected, valid));
        } else {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.CONNECTIVITY.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{e.ordinal(), connected ? 1 : 0, valid ? 1 : 0});
        }
    }

    private static class PylonConnection {
        public final CrystalElement color;
        public final boolean connected;
        public final boolean valid;
        private int age;

        private PylonConnection(CrystalElement e, boolean conn, boolean v) {
            this.color = e;
            this.age = 480 + e.ordinal() % 8 * 6;
            this.connected = conn;
            this.valid = v;
        }

        public boolean shouldRender() {
            return this.age >= -480 && this.age <= 480;
        }

        public int getAlpha() {
            int ret = 255;
            int t = Math.abs(this.age);
            if (t < 20) {
                ret = Math.min(255, 13 * t);
            } else if (t > 460) {
                ret = Math.min(255, 255 - 12 * (t -= 460));
            }
            return ret;
        }
    }
}

