/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaShaders;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class ProgressOverlayRenderer {
    static final ProgressOverlayRenderer instance = new ProgressOverlayRenderer();
    private static final RenderItem itemRender = new RenderItem();
    private static final int PROGRESS_DURATION = Math.max(100, ChromaOptions.PROGRESSDURATION.getValue());
    private final TreeMap<ChromaResearchManager.ProgressElement, Integer> progressFlags = new TreeMap(new ProgressComparator());
    private int soundCooldown;

    private ProgressOverlayRenderer() {
    }

    void renderProgressOverlays(EntityPlayer ep, int gsc) {
        HashMap<ChromaResearchManager.ProgressElement, Integer> map = new HashMap<ChromaResearchManager.ProgressElement, Integer>();
        int dy = 0;
        for (ChromaResearchManager.ProgressElement p : this.progressFlags.keySet()) {
            int tick = this.progressFlags.get(p);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            ChromaFontRenderer fr = ChromaFontRenderer.FontType.HUD.renderer;
            int sw = Math.max(40, fr.func_78256_a(p.getTitle()));
            int sh = 24 + (fr.func_78271_c(p.getShortDesc(), sw * 2).size() - 1) * 4;
            int w = sw + 28;
            int h = tick > PROGRESS_DURATION - sh ? PROGRESS_DURATION - tick : (tick < sh ? tick : sh);
            int x = Minecraft.func_71410_x().field_71443_c / gsc - w - 1;
            ReikaGuiAPI.func_73734_a((int)x, (int)dy, (int)(x + w), (int)(dy + h), (int)-12303292);
            ReikaGuiAPI.instance.drawRectFrame(x + 1, dy + 1, w - 2, h - 2, 0xCCCCCC);
            ReikaGuiAPI.instance.drawRectFrame(x + 2, dy + 2, w - 4, h - 4, 0xCCCCCC);
            GL11.glEnable((int)3553);
            if (h == sh) {
                fr.func_78276_b(p.getTitle(), x + w - 4 - sw, dy + 8 - 4, 0xFFFFFF);
                GL11.glPushMatrix();
                double s = 0.5;
                GL11.glScaled((double)s, (double)s, (double)s);
                GL11.glTranslated((double)(x + 16 + 8), (double)(dy + 16 - 1), (double)0.0);
                fr.func_78279_b(p.getShortDesc(), x + w - 4 - sw, dy + 8 + 4, sw * 2, 0xFFFFFF);
                GL11.glPopMatrix();
                GL11.glEnable((int)2896);
                p.renderIcon(itemRender, (FontRenderer)fr, x + 4, dy + 4);
            }
            GL11.glEnable((int)2896);
            if (tick > 1) {
                map.put(p, tick - (DragonAPICore.debugtest ? 32 : 1));
            }
            if ((dy += h + 4) <= Minecraft.func_71410_x().field_71440_d / gsc - h) continue;
            map.put(p, tick);
        }
        this.progressFlags.clear();
        this.progressFlags.putAll(map);
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
    }

    void addProgressionNote(ChromaResearchManager.ProgressElement p) {
        this.progressFlags.put(p, PROGRESS_DURATION);
        if (this.soundCooldown == 0) {
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GAINPROGRESS, (Entity)Minecraft.func_71410_x().field_71439_g, (float)0.5f, (float)1.0f, (boolean)false);
            this.soundCooldown = 24;
        }
        if (p instanceof ProgressStage) {
            if (ChromaOptions.PROGSHADER.getState()) {
                ChromaShaders.GAINPROGRESS.setIntensity(1.0625f);
                ChromaShaders.GAINPROGRESS.refresh();
                ChromaShaders.GAINPROGRESS.lingerTime = 0;
                ChromaShaders.GAINPROGRESS.rampDownAmount = 0.009f;
                ChromaShaders.GAINPROGRESS.rampDownFactor = 0.99f;
            } else {
                ChromaShaders.GAINPROGRESS.setIntensity(1.0f);
                ChromaShaders.GAINPROGRESS.refresh();
                ChromaShaders.GAINPROGRESS.lingerTime = 30;
                ChromaShaders.GAINPROGRESS.rampDownAmount = 0.004f;
                ChromaShaders.GAINPROGRESS.rampDownFactor = 0.997f;
            }
        }
    }

    private static final class ProgressComparator
    implements Comparator<ChromaResearchManager.ProgressElement> {
        private ProgressComparator() {
        }

        @Override
        public int compare(ChromaResearchManager.ProgressElement o1, ChromaResearchManager.ProgressElement o2) {
            return this.getIndex(o1) - this.getIndex(o2);
        }

        private int getIndex(ChromaResearchManager.ProgressElement e) {
            if (e instanceof ProgressionManager.ColorDiscovery) {
                return ((ProgressionManager.ColorDiscovery)e).color.ordinal();
            }
            if (e instanceof ProgressionManager.StructureComplete) {
                return 500000 + ((ProgressionManager.StructureComplete)e).color.ordinal();
            }
            if (e instanceof ProgressStage) {
                return 1000000 + ((ProgressStage)e).ordinal();
            }
            if (e instanceof ResearchLevel) {
                return 2000000 + ((ResearchLevel)e).ordinal();
            }
            if (e instanceof ChromaResearch) {
                return 3000000 + 1000 * ((ChromaResearch)e).level.ordinal() + ((ChromaResearch)e).ordinal();
            }
            if (e instanceof CastingRecipe) {
                return 3000000 + RecipesCastingTable.instance.getIDForRecipe((CastingRecipe)((Object)e));
            }
            return -1;
        }
    }
}

