/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.Tools.ItemBottleneckFinder;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class PylonFinderOverlay {
    public static final PylonFinderOverlay instance = new PylonFinderOverlay();
    private static final ColorBlendList powerCrystalDiamondColor = new ColorBlendList(200.0f).addAll(ChromaFX.getChromaColorTiles());
    private Collection<RenderEntry> renders = new ArrayList<RenderEntry>();

    private PylonFinderOverlay() {
    }

    @SubscribeEvent
    public void renderPylonFinderHUD(RenderGameOverlayEvent evt) {
        if (evt.type == RenderGameOverlayEvent.ElementType.HELMET) {
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            if (PylonGenerator.instance.canGenerateIn(ep.field_70170_p)) {
                boolean compass;
                boolean bl = compass = ChromaItems.FINDER.matchWith(ep.func_71045_bC()) || ep.getEntityData().func_74764_b("pylonoverlay") && ep.getEntityData().func_74763_f("pylonoverlay") >= ep.field_70170_p.func_82737_E() - 20L;
                if (compass || !this.renders.isEmpty()) {
                    Object e;
                    GL11.glPushAttrib((int)1048575);
                    Tessellator v5 = Tessellator.field_78398_a;
                    int h = evt.resolution.func_78328_b() / 2;
                    float yaw = ep.field_70759_as % 360.0f;
                    float pitch = ep.field_70125_A + 90.0f;
                    if (yaw < 0.0f) {
                        yaw += 360.0f;
                    }
                    int fov = ReikaRenderHelper.getRealFOV();
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glDisable((int)3553);
                    if (compass) {
                        for (int i = 0; i < CrystalElement.elements.length; ++i) {
                            e = CrystalElement.elements[i];
                            PylonGenerator.PylonEntry c = PylonGenerator.instance.getNearestPylonSpawn(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u + (double)ep.func_70047_e(), ep.field_70161_v, (CrystalElement)e);
                            if (c == null) continue;
                            RenderPosition pos = new RenderPosition(c.location, (EntityPlayer)ep, yaw, pitch, fov, h);
                            new PylonDisplay(c).render(v5, (EntityPlayer)ep, pos, fov, h, evt.resolution);
                        }
                    }
                    Iterator<RenderEntry> it = this.renders.iterator();
                    while (it.hasNext()) {
                        e = it.next();
                        RenderPosition pos = new RenderPosition(((RenderEntry)e).location, (EntityPlayer)ep, yaw, pitch, fov, h);
                        ((RenderEntry)e).render(v5, (EntityPlayer)ep, pos, fov, h, evt.resolution);
                        if (!((RenderEntry)e).tick()) continue;
                        it.remove();
                    }
                    GL11.glEnable((int)3553);
                    GL11.glPopAttrib();
                    GL11.glPopMatrix();
                }
            }
        }
    }

    public void addBottleneckWarning(WorldLocation loc, CrystalElement e, ItemBottleneckFinder.WarningLevels w, boolean isThroughput) {
        BottleneckWarning bw = new BottleneckWarning(loc, e, w, isThroughput);
        this.renders.add(bw);
    }

    private static class RenderPosition {
        private double phi;
        private double dl;
        private double cy;

        private RenderPosition(WorldLocation loc, EntityPlayer ep, float yaw, float pitch, int fov, int h) {
            double dx = (double)loc.xCoord + 0.5 - ep.field_70165_t;
            double dy = (double)loc.yCoord + 0.5 - ep.field_70163_u;
            double dz = (double)loc.zCoord + 0.5 - ep.field_70161_v;
            this.dl = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
            double arel = -Math.toDegrees(Math.atan2(dx, dz));
            double prel = 90.0 - Math.toDegrees(Math.atan2(dy, this.dl));
            if (arel < 0.0) {
                arel += 360.0;
            }
            this.phi = arel - (double)yaw;
            double theta = prel - (double)pitch;
            if (this.phi < 0.0) {
                this.phi += 360.0;
            }
            this.cy = (double)h + (double)(h * 2) * Math.sin(Math.toRadians(theta));
        }
    }

    private static class BottleneckWarning
    extends RenderEntry {
        private final boolean isThroughput;
        private final ItemBottleneckFinder.WarningLevels level;
        private final CrystalElement color;

        private BottleneckWarning(WorldLocation loc, CrystalElement e, ItemBottleneckFinder.WarningLevels w, boolean thru) {
            super(loc, 6000);
            this.level = w;
            this.isThroughput = thru;
            this.color = e;
        }

        @Override
        protected void render(Tessellator v5, EntityPlayer ep, RenderPosition pos, int fov, int h, ScaledResolution resolution) {
            if (!(pos.phi >= 180.0 && (double)(360 - fov) > pos.phi || pos.phi < 180.0 && pos.phi > (double)fov)) {
                double w = (double)resolution.func_78326_a() / 2.0;
                double cx = w + 1.0 * w * Math.sin(Math.toRadians(pos.phi));
                double cy = pos.cy;
                double s = 8.0;
                float u = this.isThroughput ? 0.0f : 0.5f;
                float du = u + 0.5f;
                float v = (float)this.level.ordinal() / 4.0f;
                float dv = v + 0.25f;
                if (this.isThroughput) {
                    cx -= 12.0;
                    cy -= 12.0;
                } else {
                    cx += 12.0;
                    cy += 12.0;
                }
                GL11.glShadeModel((int)7425);
                ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/pylonbottleneck.png");
                GL11.glEnable((int)3553);
                ReikaGLHelper.BlendMode.DEFAULT.apply();
                GL11.glEnable((int)3042);
                v5.func_78382_b();
                int a = 192;
                if (this.age * 2 >= this.lifespan) {
                    a *= 2 - this.age / this.lifespan;
                }
                v5.func_78384_a(ReikaColorAPI.mixColors((int)this.color.getColor(), (int)0xFFFFFF, (float)0.675f), a);
                v5.func_78380_c(240);
                v5.func_78374_a(cx - s, cy + s, 0.0, (double)u, (double)dv);
                v5.func_78374_a(cx + s, cy + s, 0.0, (double)du, (double)dv);
                v5.func_78374_a(cx + s, cy - s, 0.0, (double)du, (double)v);
                v5.func_78374_a(cx - s, cy - s, 0.0, (double)u, (double)v);
                v5.func_78381_a();
                GL11.glDisable((int)3553);
            }
        }
    }

    private static class PylonDisplay
    extends RenderEntry {
        private PylonGenerator.PylonEntry loc;

        private PylonDisplay(PylonGenerator.PylonEntry c) {
            super(c.location, Integer.MAX_VALUE);
            this.loc = c;
        }

        @Override
        protected void render(Tessellator v5, EntityPlayer ep, RenderPosition pos, int fov, int h, ScaledResolution resolution) {
            CrystalElement e = this.loc.color;
            float u = e.getFaceRune().func_94209_e();
            float v = e.getFaceRune().func_94206_g();
            float du = e.getFaceRune().func_94212_f();
            float dv = e.getFaceRune().func_94210_h();
            float u2 = ChromaIcons.DIAMOND.getIcon().func_94209_e();
            float v2 = ChromaIcons.DIAMOND.getIcon().func_94206_g();
            float du2 = ChromaIcons.DIAMOND.getIcon().func_94212_f();
            float dv2 = ChromaIcons.DIAMOND.getIcon().func_94210_h();
            if (pos.phi >= 180.0 && (double)(360 - fov) > pos.phi) {
                int cx = 10;
                v5.func_78371_b(5);
                v5.func_78384_a(e.getColor(), 96);
                v5.func_78380_c(240);
                v5.func_78377_a((double)(cx + 10), pos.cy + 10.0, 0.0);
                v5.func_78377_a((double)(cx + 10), pos.cy - 10.0, 0.0);
                v5.func_78377_a((double)cx, pos.cy, 0.0);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78378_d(e.getColor());
                v5.func_78380_c(240);
                v5.func_78377_a((double)cx, pos.cy, 0.0);
                v5.func_78377_a((double)(cx + 10), pos.cy - 10.0, 0.0);
                v5.func_78377_a((double)(cx + 10), pos.cy + 10.0, 0.0);
                v5.func_78381_a();
                ReikaTextureHelper.bindTerrainTexture();
                GL11.glEnable((int)3553);
                v5.func_78382_b();
                v5.func_78378_d(e.getColor());
                v5.func_78380_c(240);
                v5.func_78374_a((double)(cx + 10), pos.cy + 8.0, 0.0, (double)u, (double)dv);
                v5.func_78374_a((double)(cx + 26), pos.cy + 8.0, 0.0, (double)du, (double)dv);
                v5.func_78374_a((double)(cx + 26), pos.cy - 8.0, 0.0, (double)du, (double)v);
                v5.func_78374_a((double)(cx + 10), pos.cy - 8.0, 0.0, (double)u, (double)v);
                v5.func_78381_a();
                GL11.glDisable((int)3553);
            } else if (pos.phi < 180.0 && pos.phi > (double)fov) {
                int cx = resolution.func_78326_a() - 10;
                v5.func_78371_b(5);
                v5.func_78384_a(e.getColor(), 96);
                v5.func_78380_c(240);
                v5.func_78377_a((double)cx, pos.cy, 0.0);
                v5.func_78377_a((double)(cx - 10), pos.cy - 10.0, 0.0);
                v5.func_78377_a((double)(cx - 10), pos.cy + 10.0, 0.0);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78378_d(e.getColor());
                v5.func_78380_c(240);
                v5.func_78377_a((double)cx, pos.cy, 0.0);
                v5.func_78377_a((double)(cx - 10), pos.cy - 10.0, 0.0);
                v5.func_78377_a((double)(cx - 10), pos.cy + 10.0, 0.0);
                v5.func_78381_a();
                ReikaTextureHelper.bindTerrainTexture();
                GL11.glEnable((int)3553);
                v5.func_78382_b();
                v5.func_78378_d(e.getColor());
                v5.func_78380_c(240);
                v5.func_78374_a((double)(cx - 26), pos.cy + 8.0, 0.0, (double)u, (double)dv);
                v5.func_78374_a((double)(cx - 10), pos.cy + 8.0, 0.0, (double)du, (double)dv);
                v5.func_78374_a((double)(cx - 10), pos.cy - 8.0, 0.0, (double)du, (double)v);
                v5.func_78374_a((double)(cx - 26), pos.cy - 8.0, 0.0, (double)u, (double)v);
                v5.func_78381_a();
                GL11.glDisable((int)3553);
            } else {
                boolean link;
                v5.func_78382_b();
                v5.func_78384_a(e.getColor(), 32);
                v5.func_78380_c(240);
                double w = (double)resolution.func_78326_a() / 2.0;
                double cx = w + 1.0 * w * Math.sin(Math.toRadians(pos.phi));
                v5.func_78377_a(cx - 8.0, pos.cy + 8.0, 0.0);
                v5.func_78377_a(cx + 8.0, pos.cy + 8.0, 0.0);
                v5.func_78377_a(cx + 8.0, pos.cy - 8.0, 0.0);
                v5.func_78377_a(cx - 8.0, pos.cy - 8.0, 0.0);
                v5.func_78381_a();
                v5.func_78371_b(2);
                v5.func_78378_d(e.getColor());
                v5.func_78380_c(240);
                v5.func_78377_a(cx - 8.0, pos.cy + 8.0, 0.0);
                v5.func_78377_a(cx + 8.0, pos.cy + 8.0, 0.0);
                v5.func_78377_a(cx + 8.0, pos.cy - 8.0, 0.0);
                v5.func_78377_a(cx - 8.0, pos.cy - 8.0, 0.0);
                v5.func_78381_a();
                GL11.glShadeModel((int)7425);
                boolean bl = link = this.loc.playerLink != null && this.loc.playerLink.equals(ep.func_110124_au());
                if (link) {
                    v5.func_78371_b(2);
                    v5.func_78380_c(240);
                    double t = (double)System.currentTimeMillis() / 250.0 % 360.0;
                    double f1 = 0.5 + 0.5 * Math.sin(t);
                    double f2 = 0.5 + 0.5 * Math.sin(t + 90.0);
                    double f3 = 0.5 + 0.5 * Math.sin(t + 180.0);
                    double f4 = 0.5 + 0.5 * Math.sin(t + 270.0);
                    int c1 = ReikaColorAPI.mixColors((int)e.getColor(), (int)0, (float)((float)f1));
                    int c2 = ReikaColorAPI.mixColors((int)e.getColor(), (int)0, (float)((float)f2));
                    int c3 = ReikaColorAPI.mixColors((int)e.getColor(), (int)0, (float)((float)f3));
                    int c4 = ReikaColorAPI.mixColors((int)e.getColor(), (int)0, (float)((float)f4));
                    v5.func_78378_d(c1);
                    v5.func_78377_a(cx - 12.0, pos.cy + 12.0, 0.0);
                    v5.func_78378_d(c2);
                    v5.func_78377_a(cx + 12.0, pos.cy + 12.0, 0.0);
                    v5.func_78378_d(c3);
                    v5.func_78377_a(cx + 12.0, pos.cy - 12.0, 0.0);
                    v5.func_78378_d(c4);
                    v5.func_78377_a(cx - 12.0, pos.cy - 12.0, 0.0);
                    v5.func_78381_a();
                    GL11.glEnable((int)3553);
                    int count = this.loc.getLinkedPylons();
                    String s = String.valueOf(count);
                    int sw = ChromaFontRenderer.FontType.HUD.renderer.func_78256_a(s);
                    ChromaFontRenderer.FontType.HUD.drawString(s, (int)cx + 1 - sw / 2, (int)pos.cy + 16, 0xFFFFFF);
                }
                ReikaTextureHelper.bindTerrainTexture();
                GL11.glEnable((int)3553);
                v5.func_78382_b();
                v5.func_78378_d(e.getColor());
                v5.func_78380_c(240);
                v5.func_78374_a(cx - 8.0, pos.cy + 8.0, 0.0, (double)u, (double)dv);
                v5.func_78374_a(cx + 8.0, pos.cy + 8.0, 0.0, (double)du, (double)dv);
                v5.func_78374_a(cx + 8.0, pos.cy - 8.0, 0.0, (double)du, (double)v);
                v5.func_78374_a(cx - 8.0, pos.cy - 8.0, 0.0, (double)u, (double)v);
                v5.func_78381_a();
                if (!this.loc.hasStructure) {
                    GL11.glPushAttrib((int)1048575);
                    GL11.glDepthMask((boolean)false);
                    ReikaGLHelper.BlendMode.DEFAULT.apply();
                    float lw = GL11.glGetFloat((int)2849);
                    GL11.glLineWidth((float)(3.5f * (float)resolution.func_78325_e()));
                    ReikaRenderHelper.prepareGeoDraw((boolean)true);
                    v5.func_78371_b(2);
                    v5.func_78384_a(0xFF0000, 72);
                    v5.func_78380_c(240);
                    double r = 15.0;
                    for (double d = 0.0; d <= 360.0; d += 5.0) {
                        double a = Math.toRadians(d);
                        double dx = cx + r * Math.cos(a);
                        double dy = pos.cy + r * Math.sin(a);
                        v5.func_78377_a(dx, dy, 1.0);
                    }
                    v5.func_78381_a();
                    double r2 = r * 0.707;
                    v5.func_78371_b(1);
                    v5.func_78384_a(0xFF0000, 72);
                    v5.func_78380_c(240);
                    v5.func_78377_a(cx - r2, pos.cy - r2, 1.0);
                    v5.func_78377_a(cx + r2, pos.cy + r2, 1.0);
                    v5.func_78381_a();
                    GL11.glLineWidth((float)lw);
                    GL11.glPopAttrib();
                }
                if (this.loc.isTurboCharged) {
                    GL11.glDepthMask((boolean)false);
                    ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
                    IIcon ico = ChromaIcons.ECLIPSEFLARE.getIcon();
                    u = ico.func_94209_e();
                    v = ico.func_94206_g();
                    du = ico.func_94212_f();
                    dv = ico.func_94210_h();
                    v5.func_78382_b();
                    v5.func_78378_d(e.getColor());
                    v5.func_78380_c(240);
                    v5.func_78374_a(cx - 36.0, pos.cy + 36.0, -1.0, (double)u, (double)dv);
                    v5.func_78374_a(cx + 36.0, pos.cy + 36.0, -1.0, (double)du, (double)dv);
                    v5.func_78374_a(cx + 36.0, pos.cy - 36.0, -1.0, (double)du, (double)v);
                    v5.func_78374_a(cx - 36.0, pos.cy - 36.0, -1.0, (double)u, (double)v);
                    v5.func_78381_a();
                }
                for (Coordinate c2 : this.loc.getCrystals()) {
                    int px = (c2.xCoord - this.location.xCoord) * 4;
                    int pz = (c2.zCoord - this.location.zCoord) * 4;
                    v5.func_78382_b();
                    v5.func_78378_d(powerCrystalDiamondColor.getColor((double)(System.currentTimeMillis() + (long)(c2.hashCode() / 2))));
                    v5.func_78380_c(240);
                    v5.func_78374_a(cx + (double)px - 4.0, pos.cy + (double)pz + 4.0, 0.0, (double)u2, (double)dv2);
                    v5.func_78374_a(cx + (double)px + 4.0, pos.cy + (double)pz + 4.0, 0.0, (double)du2, (double)dv2);
                    v5.func_78374_a(cx + (double)px + 4.0, pos.cy + (double)pz - 4.0, 0.0, (double)du2, (double)v2);
                    v5.func_78374_a(cx + (double)px - 4.0, pos.cy + (double)pz - 4.0, 0.0, (double)u2, (double)v2);
                    v5.func_78381_a();
                }
                ChromaFontRenderer fr = ChromaFontRenderer.FontType.HUD.renderer;
                int base = ReikaMathLibrary.intpow2((int)10, (int)((int)ReikaMathLibrary.logbase((double)pos.dl, (double)10.0)));
                int dist = ReikaMathLibrary.roundToNearestX((int)base, (int)((int)Math.round(pos.dl)));
                String unit = ReikaEngLibrary.getSIPrefix((double)dist);
                String s = String.format("%.0f%sm", ReikaMathLibrary.getThousandBase((double)dist), unit);
                int d = link ? 4 : 0;
                fr.func_78276_b(s, (int)cx + 11 + d, (int)pos.cy + 11 - d, ReikaColorAPI.mixColors((int)0, (int)e.getColor(), (float)0.67f));
                fr.func_78276_b(s, (int)cx + 10 + d, (int)pos.cy + 10 - d, ReikaColorAPI.mixColors((int)0xFFFFFF, (int)e.getColor(), (float)0.8f));
                GL11.glDisable((int)3553);
            }
        }
    }

    private static abstract class RenderEntry {
        protected final WorldLocation location;
        protected final int lifespan;
        protected int age;

        protected RenderEntry(WorldLocation loc, int life) {
            this.location = loc;
            this.lifespan = life;
        }

        private final boolean tick() {
            ++this.age;
            return this.age >= this.lifespan;
        }

        protected abstract void render(Tessellator var1, EntityPlayer var2, RenderPosition var3, int var4, int var5, ScaledResolution var6);
    }
}

