/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Render;

import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.CubePoints;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Event.Client.EntityRenderingLoopEvent;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class StructureErrorOverlays
implements FilledBlockArray.BlockMatchFailCallback {
    public static final StructureErrorOverlays instance = new StructureErrorOverlays();
    private final ArrayList<ErrorOverlay> coords = new ArrayList();
    private static final int DURATION = 1440;

    private StructureErrorOverlays() {
    }

    public void addCoordinate(World world, int x, int y, int z, BlockKey bk) {
        this.coords.add(new ErrorOverlay(new WorldLocation(world, x, y, z)));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void render(EntityRenderingLoopEvent evt) {
        if (!this.coords.isEmpty()) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            RenderManager rm = RenderManager.field_78727_a;
            GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
            GL11.glDisable((int)2896);
            ReikaRenderHelper.disableEntityLighting();
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2929);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            GL11.glDisable((int)3008);
            Tessellator.field_78398_a.func_78382_b();
            int dim = Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g;
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            Iterator<ErrorOverlay> it = this.coords.iterator();
            while (it.hasNext()) {
                ErrorOverlay loc = it.next();
                if (((ErrorOverlay)loc).location.dimensionID != dim) continue;
                this.renderPoint(loc, (EntityPlayer)ep);
                loc.age--;
                if (loc.age > 0) continue;
                it.remove();
            }
            Tessellator.field_78398_a.func_78381_a();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPoint(ErrorOverlay ticks, EntityPlayer ep) {
        double o = 0.03125;
        Tessellator v5 = Tessellator.field_78398_a;
        int a = 255;
        int br = ReikaRandomHelper.getRandomBetween((int)212, (int)255);
        if (ticks.age < 360) {
            float f = (float)ticks.age * 4.0f / 1440.0f;
            br = (int)((float)br * f);
        }
        v5.func_78384_a(ReikaColorAPI.GStoHex((int)br), a);
        v5.func_78380_c(240);
        ticks.renderArea(v5);
    }

    public void onBlockFailure(World world, int x, int y, int z, BlockCheck seek) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.addCoordinate(world, x, y, z, seek.asBlockKey());
        } else {
            BlockKey bk = seek.asBlockKey();
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.STRUCTUREERROR.ordinal(), (World)world, (int)x, (int)y, (int)z, (int)32, (int[])new int[]{Block.func_149682_b((Block)bk.blockID), bk.metadata});
        }
    }

    private static class ErrorOverlay {
        private final WorldLocation location;
        private final CubePoints box;
        private final CubePoints renderBox;
        private int age;
        private String currentEdgeStretch;

        private ErrorOverlay(WorldLocation loc) {
            this.location = loc;
            this.box = CubePoints.fullBlock();
            this.box.expand(0.03125);
            this.renderBox = this.box.copy();
            this.age = 1440;
        }

        @SideOnly(value=Side.CLIENT)
        public void renderArea(Tessellator v5) {
            IIcon ico = ChromaIcons.STATIC.getIcon();
            this.renderBox.renderIconOnSides((IBlockAccess)Minecraft.func_71410_x().field_71441_e, this.location.xCoord, this.location.yCoord, this.location.zCoord, ico, v5);
            if (this.age % 5 == 0) {
                String off;
                if (this.age % 40 == 0) {
                    this.currentEdgeStretch = null;
                }
                double r = 0.046875;
                String string = off = ReikaRandomHelper.doWithChance((double)0.033) ? ((CubePoints.CubeVertex)ReikaJavaLibrary.getRandomCollectionEntry((Random)DragonAPICore.rand, (Collection)this.box.getVertices())).ID : null;
                if (off != null) {
                    this.currentEdgeStretch = off;
                    ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ERROR, (double)this.location.xCoord, (double)this.location.yCoord, (double)this.location.zCoord, (float)0.5f, (float)2.0f);
                }
                this.jitter(off, r);
            }
        }

        public void jitter(String bigOffset, double r) {
            for (CubePoints.CubeVertex cv : this.renderBox.getVertices()) {
                if (!cv.ID.equals(this.currentEdgeStretch)) {
                    cv.setPosition(this.box.getVertex(cv.ID));
                }
                double dr = cv.ID.equals(bigOffset) ? r * 8.0 : r;
                cv.offset(ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)dr), ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)dr), ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)dr));
            }
        }
    }
}

