/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Structure;

import Reika.ChromatiCraft.Base.ChromaStructureBase;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityPowerTree;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class LumenTreeStructure
extends ChromaStructureBase {
    private boolean addTreeSender;
    private int leafStage;

    public void setShowLeaves(int stage) {
        this.leafStage = stage;
    }

    public void disableLeaves() {
        this.leafStage = 0;
    }

    @Override
    public void resetToDefaults() {
        super.resetToDefaults();
        this.disableLeaves();
    }

    static void getLeafBlocks(FilledBlockArray array, int x, int y, int z) {
        for (int c = 0; c < 16; ++c) {
            CrystalElement e = CrystalElement.elements[c];
            int max = TileEntityPowerTree.maxLeafCount(e);
            for (int i = 0; i < max; ++i) {
                Coordinate cc = TileEntityPowerTree.getLeafLocation(e, i);
                cc = cc.offset(0, array.getMaxY(), 0);
                array.setBlock(cc.xCoord, cc.yCoord, cc.zCoord, ChromaBlocks.POWERTREE.getBlockInstance(), e.ordinal());
            }
        }
    }

    static void getTrunkBlocks(FilledBlockArray array, int x, int y, int z) {
        for (int i = 0; i <= 12; ++i) {
            int dy = y - i;
            if (i == 0) {
                array.setBlock(x, dy, z - 1, Blocks.field_150359_w);
                array.setBlock(x + 1, dy, z, Blocks.field_150359_w);
                array.setBlock(x + 1, dy, z - 1, Blocks.field_150359_w);
            } else {
                int meta = i == 3 || i == 5 || i == 7 || i == 9 ? 15 : 11;
                array.setBlock(x, dy, z, crystalstone, meta);
                array.setBlock(x, dy, z - 1, crystalstone, meta);
                array.setBlock(x + 1, dy, z, crystalstone, meta);
                array.setBlock(x + 1, dy, z - 1, crystalstone, meta);
            }
            if (i <= 1) continue;
            array.addEmpty(x - 1, dy, z, false, false, new Block[0]);
            array.addEmpty(x - 1, dy, z - 1, false, false, new Block[0]);
            array.addEmpty(x - 1, dy, z - 2, false, false, new Block[0]);
            array.addEmpty(x - 1, dy, z + 1, false, false, new Block[0]);
            array.addEmpty(x + 2, dy, z, false, false, new Block[0]);
            array.addEmpty(x + 2, dy, z - 1, false, false, new Block[0]);
            array.addEmpty(x + 2, dy, z + 1, false, false, new Block[0]);
            array.addEmpty(x + 2, dy, z - 2, false, false, new Block[0]);
            array.addEmpty(x, dy, z - 2, false, false, new Block[0]);
            array.addEmpty(x + 1, dy, z - 2, false, false, new Block[0]);
            array.addEmpty(x, dy, z + 1, false, false, new Block[0]);
            array.addEmpty(x + 1, dy, z + 1, false, false, new Block[0]);
            Block b2 = ChromaBlocks.POWERTREE.getBlockInstance();
            array.addBlock(x - 1, dy, z, b2);
            array.addBlock(x - 1, dy, z - 1, b2);
            array.addBlock(x - 1, dy, z - 2, b2);
            array.addBlock(x - 1, dy, z + 1, b2);
            array.addBlock(x + 2, dy, z, b2);
            array.addBlock(x + 2, dy, z - 1, b2);
            array.addBlock(x + 2, dy, z + 1, b2);
            array.addBlock(x + 2, dy, z - 2, b2);
            array.addBlock(x, dy, z - 2, b2);
            array.addBlock(x + 1, dy, z - 2, b2);
            array.addBlock(x, dy, z + 1, b2);
            array.addBlock(x + 1, dy, z + 1, b2);
        }
        array.setBlock(x - 1, y - 1, z, crystalstone, 14);
        array.setBlock(x - 1, y - 1, z - 1, crystalstone, 14);
        array.setBlock(x + 2, y - 1, z, crystalstone, 14);
        array.setBlock(x + 2, y - 1, z - 1, crystalstone, 14);
        array.setBlock(x, y - 1, z - 2, crystalstone, 14);
        array.setBlock(x + 1, y - 1, z - 2, crystalstone, 14);
        array.setBlock(x, y - 1, z + 1, crystalstone, 14);
        array.setBlock(x + 1, y - 1, z + 1, crystalstone, 14);
    }

    public FilledBlockArray getArray(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        if (this.isDisplay()) {
            this.setShowLeaves(20);
        }
        LumenTreeStructure.getTrunkBlocks(array, x, y, z);
        if (this.leafStage > 0) {
            LumenTreeStructure.getLeafBlocks(array, x, y, z);
        }
        FilledBlockArray treeSend = ChromaStructures.TREE_SENDER.getArray(world, x, y, z);
        if (this.addTreeSender) {
            array.addAll((BlockArray)treeSend);
        } else {
            for (Coordinate c : treeSend.keySet()) {
                if (array.hasBlock(c)) continue;
                array.addEmpty(c.xCoord, c.yCoord, c.zCoord, false, false, new Block[0]);
                Block bk = treeSend.getBlockAt(c.xCoord, c.yCoord, c.zCoord);
                int meta = treeSend.getMetaAt(c.xCoord, c.yCoord, c.zCoord);
                array.addBlock(c.xCoord, c.yCoord, c.zCoord, bk, meta);
            }
        }
        return array;
    }
}

