/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Structure.Worldgen;

import Reika.ChromatiCraft.Auxiliary.BiomeStructurePuzzle;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Base.FragmentStructureWithBonusLoot;
import Reika.ChromatiCraft.Block.BlockHoverBlock;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BiomeStructure
extends FragmentStructureWithBonusLoot {
    private BiomeStructurePuzzle puzzle;

    public BiomeStructure() {
        this.addBonusItem(new ItemStack(Items.field_151079_bi), 2, 8, 25);
        this.addBonusItem(new ItemStack(Items.field_151137_ax), 12, 24, 20);
        this.addBonusItem(new ItemStack(Items.field_151045_i), 1, 5, 10);
        this.addBonusItem(new ItemStack(Items.field_151043_k), 4, 18, 10);
        this.addBonusItem(new ItemStack(Items.field_151042_j), 12, 32, 20);
        this.addBonusItem(new ItemStack(Items.field_151128_bU), 2, 16, 10);
        this.addBonusItem(new ItemStack(Items.field_151166_bC), 1, 4, 5);
        this.addBonusItem(new ItemStack(Items.field_151065_br), 2, 8, 10);
        this.addBonusItem(new ItemStack(Items.field_151016_H), 4, 12, 15);
        this.addBonusItem(new ItemStack(Items.field_151123_aH), 1, 4, 5);
        this.addBonusItem(new ItemStack(Items.field_151114_aO), 4, 32, 15);
        for (int i = 0; i < 32; ++i) {
            boolean charge = i >= 16;
            int min = charge ? 1 : 4;
            int max = charge ? 6 : 24;
            this.addBonusItem(ChromaItems.SHARD.getStackOfMetadata(i), min, max, charge ? 2 : 6);
        }
        this.addBonusItem(ChromaStacks.chromaDust, 16, 48, 30);
        this.addBonusItem(ChromaStacks.auraDust, 8, 32, 25);
        this.addBonusItem(ChromaStacks.bindingCrystal, 4, 20, 18);
        this.addBonusItem(ChromaStacks.focusDust, 4, 16, 10);
        this.addBonusItem(ChromaStacks.purityDust, 12, 16, 10);
        this.addBonusItem(ChromaStacks.beaconDust, 16, 32, 25);
    }

    @Override
    public void resetToDefaults() {
        super.resetToDefaults();
    }

    @Override
    public void setRNG(Random r) {
        this.puzzle = new BiomeStructurePuzzle();
        this.puzzle.generate(r);
    }

    @Override
    public Coordinate getControllerRelativeLocation() {
        return new Coordinate(0, 0, 0);
    }

    @Override
    public int getStructureVersion() {
        return 0;
    }

    @Override
    protected void initDisplayData() {
        Random r = new Random(0L);
        r.nextBoolean();
        r.nextBoolean();
        this.setRNG(r);
    }

    @Override
    protected void finishDisplayCall() {
        this.puzzle = null;
    }

    public FilledBlockArray getArray(World world, int x, int y, int z) {
        int d;
        int k;
        int i;
        int m;
        int d2;
        int k2;
        int i2;
        int j;
        if (this.puzzle == null) {
            throw new RuntimeException("Puzzle not set!");
        }
        FilledBlockArray array = new FilledBlockArray(world);
        Coordinate c = new Coordinate(x, y, z);
        array.setBlock(x, y, z, ChromaTiles.STRUCTCONTROL.getBlock(), ChromaTiles.STRUCTCONTROL.getBlockMetadata());
        this.addCallback(c, new PuzzleCacheCallback(this.puzzle));
        for (j = 5; j <= 9; ++j) {
            for (i2 = -6; i2 <= 6; ++i2) {
                for (k2 = -6; k2 <= 6; ++k2) {
                    array.setBlock(x + i2, y + j, z + k2, Blocks.field_150350_a);
                }
            }
        }
        for (j = -2; j <= 6; ++j) {
            int r = j == -2 ? 1 : 2;
            for (int i3 = -r; i3 <= r; ++i3) {
                for (int k3 = -r; k3 <= r; ++k3) {
                    if (j == 0 && i3 == 0 && k3 == 0) continue;
                    int d3 = Math.max(Math.abs(i3), Math.abs(k3));
                    Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                    int m2 = BlockStructureShield.BlockType.CLOAK.metadata;
                    if (j == -1 && d3 <= 1) {
                        b = Blocks.field_150350_a;
                        m2 = 0;
                    } else if (j == 0) {
                        if (d3 <= 1) {
                            b = Blocks.field_150350_a;
                            m2 = 0;
                        } else {
                            m2 = BlockStructureShield.BlockType.STONE.metadata;
                        }
                    } else if (j == 1) {
                        if (d3 <= 1) {
                            b = ChromaBlocks.DOOR.getBlockInstance();
                            m2 = 0;
                        } else {
                            m2 = BlockStructureShield.BlockType.COBBLE.metadata;
                        }
                    } else if (j > 0 && d3 <= 1) {
                        b = ChromaBlocks.HOVER.getBlockInstance();
                        m2 = BlockHoverBlock.HoverType.ELEVATE.getPermanentMeta();
                    } else if (j > 0) {
                        if (j == 6 && d3 > 1) {
                            m2 = BlockStructureShield.BlockType.COBBLE.metadata;
                        } else {
                            b = Blocks.field_150350_a;
                            m2 = 0;
                        }
                    }
                    array.setBlock(x + i3, y + j, z + k3, b, m2);
                }
            }
        }
        for (j = 1; j <= 9; ++j) {
            for (i2 = -3; i2 <= 3; ++i2) {
                for (k2 = -3; k2 <= 3; ++k2) {
                    if (j <= 6 && Math.abs(i2) != 3 && Math.abs(k2) != 3) continue;
                    Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                    int m3 = BlockStructureShield.BlockType.STONE.metadata;
                    if (j > 6) {
                        b = Blocks.field_150350_a;
                        m3 = 0;
                    } else if ((i2 == 0 || k2 == 0) && j > 1 && j < 6) {
                        m3 = BlockStructureShield.BlockType.COBBLE.metadata;
                    } else if (j == 6 && (Math.abs(i2) == 2 || Math.abs(k2) == 2)) {
                        m3 = BlockStructureShield.BlockType.COBBLE.metadata;
                    } else if (j == 3 && (Math.abs(i2) == 1 || Math.abs(k2) == 1)) {
                        m3 = BlockStructureShield.BlockType.GLASS.metadata;
                    }
                    array.setBlock(x + i2, y + j, z + k2, b, m3);
                }
            }
        }
        for (j = 6; j <= 9; ++j) {
            for (d2 = -4; d2 <= 4; ++d2) {
                Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                m = BlockStructureShield.BlockType.COBBLE.metadata;
                if (j != 9 && Math.abs(d2) == 4) continue;
                if (Math.abs(d2) <= 1) {
                    b = j == 6 || j == 9 ? Blocks.field_150390_bg : Blocks.field_150350_a;
                    m = 0;
                }
                if (m == BlockStructureShield.BlockType.COBBLE.metadata && (j == 9 || Math.abs(d2) > 2)) {
                    m = BlockStructureShield.BlockType.STONE.metadata;
                }
                array.setBlock(x + d2, y + j, z + 4, b, b == Blocks.field_150390_bg ? this.getStairMeta(d2, j, 4) : m);
                array.setBlock(x + d2, y + j, z - 4, b, b == Blocks.field_150390_bg ? this.getStairMeta(d2, j, -4) : m);
                array.setBlock(x + 4, y + j, z + d2, b, b == Blocks.field_150390_bg ? this.getStairMeta(4, j, d2) : m);
                array.setBlock(x - 4, y + j, z + d2, b, b == Blocks.field_150390_bg ? this.getStairMeta(-4, j, d2) : m);
            }
        }
        for (j = 5; j <= 8; ++j) {
            for (d2 = -6; d2 <= 6; ++d2) {
                Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                m = BlockStructureShield.BlockType.STONE.metadata;
                if (Math.abs(d2) <= 1) {
                    b = j == 5 ? Blocks.field_150390_bg : Blocks.field_150350_a;
                    m = 0;
                } else if (Math.abs(d2) == 2) {
                    m = BlockStructureShield.BlockType.COBBLE.metadata;
                } else if ((j == 7 || j == 8) && Math.abs(d2) >= 3 && Math.abs(d2) <= 5) {
                    m = BlockStructureShield.BlockType.GLASS.metadata;
                }
                array.setBlock(x + d2, y + j, z + 7, b, b == Blocks.field_150390_bg ? this.getStairMeta(d2, j, 7) : m);
                array.setBlock(x + d2, y + j, z - 7, b, b == Blocks.field_150390_bg ? this.getStairMeta(d2, j, -7) : m);
                array.setBlock(x + 7, y + j, z + d2, b, b == Blocks.field_150390_bg ? this.getStairMeta(7, j, d2) : m);
                array.setBlock(x - 7, y + j, z + d2, b, b == Blocks.field_150390_bg ? this.getStairMeta(-7, j, d2) : m);
                if (j != 4) continue;
                array.setBlock(x + d2, y + j, z + 7, Blocks.field_150346_d);
                array.setBlock(x + d2, y + j, z - 7, Blocks.field_150346_d);
                array.setBlock(x + 7, y + j, z + d2, Blocks.field_150346_d);
                array.setBlock(x - 7, y + j, z + d2, Blocks.field_150346_d);
            }
        }
        for (i = -6; i <= 6; ++i) {
            for (k = -6; k <= 6; ++k) {
                int d4 = Math.max(Math.abs(i), Math.abs(k));
                if (d4 < 4 || d4 > 6) continue;
                m = BlockStructureShield.BlockType.STONE.metadata;
                if (Math.abs(i) == 5 && Math.abs(k) == 5) {
                    m = BlockStructureShield.BlockType.LIGHT.metadata;
                }
                array.setBlock(x + i, y + 5, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m);
            }
        }
        for (i = -7; i <= 7; ++i) {
            for (k = -7; k <= 7; ++k) {
                int d5 = Math.max(Math.abs(i), Math.abs(k));
                if (d5 < 5 || d5 > 7 || Math.abs(i) + Math.abs(k) > 12) continue;
                array.setBlock(x + i, y + 9, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            }
        }
        array.setBlock(x + 2, y + 9, z + 7, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        array.setBlock(x - 2, y + 9, z + 7, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        array.setBlock(x + 2, y + 9, z - 7, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        array.setBlock(x - 2, y + 9, z - 7, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        array.setBlock(x + 7, y + 9, z + 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        array.setBlock(x + 7, y + 9, z - 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        array.setBlock(x - 7, y + 9, z + 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        array.setBlock(x - 7, y + 9, z - 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        for (i = -4; i <= 4; ++i) {
            for (k = -4; k <= 4; ++k) {
                if (Math.abs(i) + Math.abs(k) > 6) continue;
                int m4 = BlockStructureShield.BlockType.STONE.metadata;
                if (i == 0 && Math.abs(k) == 2) {
                    m4 = BlockStructureShield.BlockType.LIGHT.metadata;
                } else if (k == 0 && Math.abs(i) == 2) {
                    m4 = BlockStructureShield.BlockType.LIGHT.metadata;
                } else if (Math.abs(i) == 4 || Math.abs(k) == 4) {
                    m4 = BlockStructureShield.BlockType.COBBLE.metadata;
                } else if (Math.abs(i) == 3 && Math.abs(k) == 3) {
                    m4 = BlockStructureShield.BlockType.COBBLE.metadata;
                }
                array.setBlock(x + i, y + 10, z + k, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), m4);
            }
        }
        for (j = 6; j <= 8; ++j) {
            array.setBlock(x + 6, y + j, z + 6, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            array.setBlock(x - 6, y + j, z + 6, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            array.setBlock(x + 6, y + j, z - 6, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
            array.setBlock(x - 6, y + j, z - 6, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata);
        }
        for (d = 5; d <= 7; ++d) {
            array.setBlock(x - d, y + 10, z - 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x - d, y + 10, z + 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x + d, y + 10, z - 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x + d, y + 10, z + 2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x - 2, y + 10, z - d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x + 2, y + 10, z - d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x - 2, y + 10, z + d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x + 2, y + 10, z + d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        }
        for (d = 3; d <= 5; ++d) {
            array.setBlock(x - d, y + 10, z - d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x + d, y + 10, z - d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x - d, y + 10, z + d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
            array.setBlock(x + d, y + 10, z + d, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata);
        }
        for (j = 1; j <= 4; ++j) {
            for (d2 = -6; d2 <= 6; ++d2) {
                Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                m = BlockStructureShield.BlockType.STONE.metadata;
                array.setBlock(x + d2, y + j, z + 6, b, m);
                array.setBlock(x + d2, y + j, z - 6, b, m);
                array.setBlock(x + 6, y + j, z + d2, b, m);
                array.setBlock(x - 6, y + j, z + d2, b, m);
            }
        }
        for (j = 1; j <= 4; ++j) {
            for (i2 = -5; i2 <= 5; ++i2) {
                for (int k4 = -5; k4 <= 5; ++k4) {
                    int d6 = Math.max(Math.abs(i2), Math.abs(k4));
                    if (d6 < 4 || d6 > 5) continue;
                    Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
                    int m5 = BlockStructureShield.BlockType.STONE.metadata;
                    if (k4 > 0 && i2 == 2 || k4 < 0 && i2 == -2 || i2 < 0 && k4 == 2 || i2 > 0 && k4 == -2) {
                        if (j == 3) {
                            m5 = BlockStructureShield.BlockType.GLASS.metadata;
                        }
                    } else if (j == 2 && (k4 > 0 && i2 == 1 || k4 < 0 && i2 == -1 || i2 < 0 && k4 == 1 || i2 > 0 && k4 == -1)) {
                        b = ChromaBlocks.MUSICTRIGGER.getBlockInstance();
                        m5 = 0;
                    } else if (j > 1) {
                        b = Blocks.field_150350_a;
                        m5 = 0;
                    }
                    array.setBlock(x + i2, y + j, z + k4, b, m5);
                }
            }
        }
        this.addLootChest(array, x - 5, y + 2, z + 4, ForgeDirection.EAST);
        this.addLootChest(array, x + 4, y + 2, z + 5, ForgeDirection.NORTH);
        this.addLootChest(array, x + 5, y + 2, z - 4, ForgeDirection.WEST);
        this.addLootChest(array, x - 4, y + 2, z - 5, ForgeDirection.SOUTH);
        this.addLootChest(array, x - 4, y + 6, z + 4, ForgeDirection.WEST);
        this.addLootChest(array, x + 4, y + 6, z + 4, ForgeDirection.SOUTH);
        this.addLootChest(array, x + 4, y + 6, z - 4, ForgeDirection.EAST);
        this.addLootChest(array, x - 4, y + 6, z - 4, ForgeDirection.NORTH);
        for (i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
            for (int a = 3; a <= 5; ++a) {
                for (int b = 4; b <= 5; ++b) {
                    array.setBlock(x + dir.offsetX * b + left.offsetX * a, y, z + left.offsetZ * a + dir.offsetZ * b, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata);
                }
            }
        }
        if (this.isDisplay()) {
            this.puzzle.addToArray(array, x, y, z);
        }
        return array;
    }

    private int getStairMeta(int dx, int dy, int dz) {
        boolean x;
        boolean invert = dy == 9;
        boolean bl = x = Math.abs(dx) > Math.abs(dz);
        if (x) {
            if (dx > 0) {
                return invert ? 4 : 1;
            }
            return invert ? 5 : 0;
        }
        if (dz > 0) {
            return invert ? 6 : 3;
        }
        return invert ? 7 : 2;
    }

    @Override
    public void onPlace(World world, TileEntityStructControl te) {
        this.puzzle.placeData(world, te);
    }

    @Override
    public String getChestLootTable(Coordinate c, BlockLootChest.TileEntityLootChest te, FilledBlockArray arr, Random r) {
        return "villageBlacksmith";
    }

    @Override
    public int getChestYield(Coordinate c, BlockLootChest.TileEntityLootChest te, FilledBlockArray arr, Random r) {
        return te.field_145848_d - arr.getMinY() <= 4 ? 3 : 1;
    }

    @Override
    public int modifyLootCount(BlockLootChest.TileEntityLootChest tileEntityLootChest, String s, int bonus, Random r, int count) {
        return count * 3 / 2;
    }

    @Override
    public float getFragmentChance(BlockLootChest.TileEntityLootChest te, String s, int bonus, Random r) {
        return 1.0f;
    }

    @Override
    public int getFragmentCount(BlockLootChest.TileEntityLootChest te, String s, int bonus, Random r) {
        if (bonus == 3) {
            int n = r.nextInt(12);
            if (n == 11) {
                return 4;
            }
            if (n > 7) {
                return 3;
            }
            if (n > 2) {
                return 2;
            }
            return 1;
        }
        return r.nextInt(3) > 0 ? 2 : 1;
    }

    public void setPuzzle(BiomeStructurePuzzle data) {
        this.puzzle = data;
    }

    private static class ControllerDelegateCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final Coordinate controllerLocation;

        private ControllerDelegateCallback(Coordinate c) {
            this.controllerLocation = c;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            ((TileEntityStructControl.InteractionDelegateTile)te).setDelegate(this.controllerLocation);
        }
    }

    private static class PuzzleCacheCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final BiomeStructurePuzzle puzzle;

        private PuzzleCacheCallback(BiomeStructurePuzzle p) {
            this.puzzle = p;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            ((TileEntityStructControl)te).setStructureData(this.puzzle);
        }
    }
}

