/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Structure.Worldgen;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Base.FragmentStructureBase;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.BlockHeatLamp;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Items.Tools.ItemDoorKey;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.ItemDrop;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class BurrowStructure
extends FragmentStructureBase {
    private static WeightedRandom<OreType> furnaceOres = new WeightedRandom();
    private static WeightedRandom<ItemDrop> lootItems = new WeightedRandom();
    private UUID doorID;
    private final ChunkSplicedGenerationCache.TileCallback furnaceCall = new ChunkSplicedGenerationCache.TileCallback(){

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            world.func_147465_d(x, y + 1, z, ChromaBlocks.HEATLAMP.getBlockInstance(), ForgeDirection.UP.ordinal(), 2);
            ((BlockHeatLamp.TileEntityHeatLamp)world.func_147438_o((int)x, (int)(y + 1), (int)z)).temperature = ReikaRandomHelper.getRandomBetween((int)50, (int)160);
            TileEntityFurnace tf = (TileEntityFurnace)te;
            if (tf == null) {
                tf = new TileEntityFurnace();
                world.func_147455_a(x, y, z, (TileEntity)tf);
            }
            OreType ore = (OreType)furnaceOres.getRandomEntry();
            ItemStack is = (ItemStack)ReikaJavaLibrary.getRandomCollectionEntry((Random)world.field_73012_v, (Collection)ore.getAllOreBlocks());
            is = is.func_77946_l();
            int max = is.func_77976_d();
            if (ore.getRarity() == OreType.OreRarity.RARE) {
                max = Math.min(max, 8);
            } else if (ore.getRarity() == OreType.OreRarity.SCARCE) {
                max = Math.min(max, 24);
            } else if (ore.getRarity() == OreType.OreRarity.SCATTERED) {
                max = Math.min(max, 40);
            }
            is.field_77994_a = ReikaRandomHelper.getRandomBetween((int)4, (int)max);
            tf.func_70299_a(0, is);
            world.func_72921_c(x, y, z, 3, 3);
        }
    };
    private final ChunkSplicedGenerationCache.TileCallback doorCall = new ChunkSplicedGenerationCache.TileCallback(){

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (BurrowStructure.this.doorID != null) {
                if (te == null) {
                    te = new BlockChromaDoor.TileEntityChromaDoor();
                    world.func_147455_a(x, y, z, te);
                }
            } else {
                throw new IllegalStateException("Burrow has no chest ID!");
            }
            ((BlockChromaDoor.TileEntityChromaDoor)te).bindUUID(null, BurrowStructure.this.doorID, 0);
        }
    };
    private final ChunkSplicedGenerationCache.TileCallback keyChestCall = new ChunkSplicedGenerationCache.TileCallback(){

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (BurrowStructure.this.doorID != null) {
                if (te == null) {
                    te = new TileEntityChest();
                    world.func_147455_a(x, y, z, te);
                }
            } else {
                throw new IllegalStateException("Burrow has no chest ID!");
            }
            ((TileEntityChest)te).func_70299_a(world.field_73012_v.nextInt(27), this.getDoorKey());
        }

        private ItemStack getDoorKey() {
            ItemStack ret = ChromaItems.KEY.getStackOf();
            ((ItemDoorKey)ret.func_77973_b()).setID(ret, BurrowStructure.this.doorID);
            return ret;
        }
    };
    private final ChunkSplicedGenerationCache.TileCallback lootCall = new ChunkSplicedGenerationCache.TileCallback(){

        public void onTilePlaced(World world, int x, int y, int z, TileEntity tile) {
            TreeType tree;
            BlockLootChest.TileEntityLootChest te = (BlockLootChest.TileEntityLootChest)tile;
            if (te == null) {
                te = new BlockLootChest.TileEntityLootChest();
                world.func_147455_a(x, y, z, (TileEntity)te);
            }
            ReikaInventoryHelper.clearInventory((IInventory)te);
            int filled = ReikaRandomHelper.getRandomBetween((int)13, (int)20);
            ArrayList add = new ArrayList();
            for (int i = 0; i < filled; ++i) {
                ItemStack is = ((ItemDrop)lootItems.getRandomEntry()).getItem();
                while (is == null) {
                    is = ((ItemDrop)lootItems.getRandomEntry()).getItem();
                }
                add.add(is);
            }
            BiomeGenBase biome = world.func_72807_a(x, z);
            if (ReikaBiomeHelper.isSnowBiome((BiomeGenBase)biome) && world.field_73012_v.nextInt(4) == 0) {
                add.add(new ItemStack(Blocks.field_150432_aD, ReikaRandomHelper.getRandomBetween((int)12, (int)32), 0));
            }
            if (world.field_73012_v.nextInt(3) == 0 && (tree = ReikaBiomeHelper.getDominantTreeType((BiomeGenBase)biome)) != null && tree.getSaplingID() != null) {
                ItemStack sapling = new ItemStack(tree.getSaplingID(), ReikaRandomHelper.getRandomBetween((int)1, (int)6), tree.getSaplingMeta());
                add.add(sapling);
            }
            add = ReikaItemHelper.collateItemList(add);
            Collections.sort(add, ReikaItemHelper.comparator);
            int slot = 0;
            boolean items = false;
            for (int i = 0; i < add.size(); ++i) {
                ItemStack stack = (ItemStack)add.get(i);
                if (Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) {
                    if (!items) {
                        slot = 27;
                    }
                    items = true;
                }
                te.func_70299_a(slot, stack);
                ++slot;
            }
        }

        private ItemStack getDoorKey() {
            ItemStack ret = ChromaItems.KEY.getStackOf();
            ((ItemDoorKey)ret.func_77973_b()).setID(ret, BurrowStructure.this.doorID);
            return ret;
        }
    };

    public static void buildLootCache() {
        furnaceOres.addEntry((Object)ReikaOreHelper.IRON, 40.0);
        furnaceOres.addEntry((Object)ReikaOreHelper.GOLD, 15.0);
        BurrowStructure.addOreIf(ModOreList.COPPER, 50);
        BurrowStructure.addOreIf(ModOreList.TIN, 50);
        BurrowStructure.addOreIf(ModOreList.LEAD, 10);
        BurrowStructure.addOreIf(ModOreList.NICKEL, 10);
        BurrowStructure.addOreIf(ModOreList.SILVER, 15);
        BurrowStructure.addOreIf(ModOreList.ALUMINUM, 20);
        BurrowStructure.addOreIf(ModOreList.PLATINUM, 2);
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150366_p, 12, 32), 35.0);
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150352_o, 8, 24), 15.0);
        lootItems.addEntry((Object)new ItemDrop.OreDrop("oreCopper", 16, 40), 40.0);
        lootItems.addEntry((Object)new ItemDrop.OreDrop("oreTin", 16, 40), 40.0);
        lootItems.addEntry((Object)new ItemDrop.OreDrop("oreSilver", 12, 24), 20.0);
        lootItems.addEntry((Object)new ItemDrop.OreDrop("oreNickel", 12, 24), 15.0);
        lootItems.addEntry((Object)new ItemDrop.OreDrop("oreLead", 12, 24), 20.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151045_i, 1, 4), 5.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151045_i, 3, 12), 2.0);
        lootItems.addEntry((Object)new ItemDrop(ReikaItemHelper.lapisDye, 2, 6), 20.0);
        lootItems.addEntry((Object)new ItemDrop(ReikaItemHelper.lapisDye, 12, 30), 5.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151137_ax, 4, 64), 40.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151044_h, 16, 64), 40.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151044_h, 4, 24), 60.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151043_k, 4, 16), 25.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151043_k, 16, 40), 10.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151042_j, 16, 40), 60.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151042_j, 32, 64), 20.0);
        lootItems.addEntry((Object)new ItemDrop.OreDrop("ingotNickel", 16, 48), 40.0);
        lootItems.addEntry((Object)new ItemDrop.OreDrop("ingotLead", 16, 48), 40.0);
        lootItems.addEntry((Object)new ItemDrop.OreDrop("ingotSilver", 16, 48), 50.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151145_ak, 12, 32), 40.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151119_aD, 30, 60), 40.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151123_aH, 10, 20), 15.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151103_aS, 5, 15), 40.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151078_bh, 5, 15), 50.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151007_F, 10, 30), 50.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151016_H, 5, 20), 30.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151116_aA, 10, 25), 30.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151008_G, 5, 15), 25.0);
        lootItems.addEntry((Object)new ItemDrop(ReikaItemHelper.inksac, 5, 15), 30.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151079_bi, 4, 12), 10.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151015_O, 18, 30), 35.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151172_bF, 18, 30), 35.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151174_bG, 18, 30), 35.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151034_e, 18, 30), 35.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151147_al, 8, 16), 20.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151082_bd, 8, 16), 20.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151115_aP, 8, 16), 20.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151076_bf, 8, 16), 20.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151120_aE, 1, 6), 20.0);
        for (int i = 0; i < 16; ++i) {
            lootItems.addEntry((Object)new ItemDrop(ChromaItems.SHARD.getStackOfMetadata(i), 2, 8), 5.0);
            lootItems.addEntry((Object)new ItemDrop(ChromaBlocks.CRYSTAL.getStackOfMetadata(i), 2, 8), 1.0);
        }
        lootItems.addEntry((Object)new ItemDrop(ChromaStacks.auraDust, 6, 30), 5.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151129_at, 1, 1), 10.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151128_bU, 12, 32), 15.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151114_aO, 4, 12), 25.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151114_aO, 16, 32), 5.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151065_br, 4, 8), 15.0);
        if (ModList.THAUMCRAFT.isLoaded()) {
            lootItems.addEntry((Object)new ItemDrop(Items.field_151065_br, 12, 24), 10.0);
        }
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150478_aa, 4, 20), 50.0);
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150344_f, 24, 64), 50.0);
        lootItems.addEntry((Object)new ItemDrop((Block)Blocks.field_150354_m, 24, 64), 50.0);
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150343_Z, 4, 8), 10.0);
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150343_Z, 8, 16), 5.0);
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150341_Y, 16, 32), 15.0);
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150347_e, 32, 64), 100.0);
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150346_d, 32, 64), 100.0);
        lootItems.addEntry((Object)new ItemDrop(Blocks.field_150351_n, 32, 64), 40.0);
        lootItems.addEntry((Object)new ItemDrop(ReikaItemHelper.redDye, 4, 16), 20.0);
        lootItems.addEntry((Object)new ItemDrop(ReikaItemHelper.yellowDye, 4, 16), 20.0);
        lootItems.addEntry((Object)new ItemDrop(ReikaItemHelper.cactusDye, 4, 16), 20.0);
        lootItems.addEntry((Object)new ItemDrop(Items.field_151121_aF, 2, 8), 15.0);
    }

    private static void addOreIf(ModOreList ore, int wt) {
        if (ore.existsInGame()) {
            furnaceOres.addEntry((Object)ore, (double)wt);
        }
    }

    @Override
    protected void preCallbacks(World world, Random rand) {
        this.doorID = UUID.randomUUID();
    }

    @Override
    public Coordinate getControllerRelativeLocation() {
        return new Coordinate(-5, -8, -2);
    }

    public FilledBlockArray getArray(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        array.setBlock((x -= 8) + 5, (y -= 11) + 4, (z -= 5) + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 0, y + 2, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 0, y + 3, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 0, y + 5, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 0, y + 5, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 0, y + 6, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 0, y + 6, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 0, y + 6, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 0, y + 7, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 1, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 1, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 1, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 2, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 2, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 3, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 3, z + 3, shield, BlockStructureShield.BlockType.CRACK.metadata);
        array.setBlock(x + 1, y + 3, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 4, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 4, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 4, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 5, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 5, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 5, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 5, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 5, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 6, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 6, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 6, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 6, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 7, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 7, z + 3, shield, BlockStructureShield.BlockType.CRACK.metadata);
        array.setBlock(x + 1, y + 7, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 7, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 8, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 0, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 0, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 0, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 1, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 1, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 2, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 2, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 3, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 3, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 5, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 5, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 5, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 5, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 6, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 6, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 6, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 6, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 7, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 7, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 8, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 8, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 8, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 0, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 0, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 0, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 1, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 1, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 2, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 2, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 3, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 3, z + 1, shield, BlockStructureShield.BlockType.CRACK.metadata);
        array.setBlock(x + 3, y + 3, z + 5, shield, BlockStructureShield.BlockType.CRACK.metadata);
        array.setBlock(x + 3, y + 3, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 5, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 5, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 6, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 6, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 7, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 7, z + 1, shield, BlockStructureShield.BlockType.CRACK.metadata);
        array.setBlock(x + 3, y + 7, z + 5, shield, BlockStructureShield.BlockType.CRACK.metadata);
        array.setBlock(x + 3, y + 7, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 8, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 8, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 8, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 8, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 8, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 0, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 0, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 0, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 1, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 1, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 3, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 3, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 4, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 4, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 4, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 4, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 4, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 5, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 5, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 5, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 5, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 6, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 6, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 6, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 6, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 7, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 7, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 8, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 8, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 8, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 1, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 1, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 1, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 1, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 1, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 2, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 2, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 3, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 3, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 4, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 4, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 5, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 5, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 6, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 6, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 7, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 7, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 8, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 8, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 2, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 2, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 2, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 4, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 5, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 5, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 5, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 6, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 6, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 7, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 7, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 8, z + 1, Blocks.field_150348_b);
        array.setBlock(x + 6, y + 8, z + 5, Blocks.field_150348_b);
        array.setBlock(x + 7, y + 6, z + 1, Blocks.field_150348_b);
        array.setBlock(x + 7, y + 6, z + 2, Blocks.field_150348_b);
        array.setBlock(x + 7, y + 6, z + 3, Blocks.field_150348_b);
        array.setBlock(x + 7, y + 6, z + 4, Blocks.field_150348_b);
        array.setBlock(x + 7, y + 7, z + 1, Blocks.field_150348_b);
        array.setBlock(x + 7, y + 7, z + 5, Blocks.field_150348_b);
        array.setBlock(x + 7, y + 8, z + 1, Blocks.field_150348_b);
        array.setBlock(x + 7, y + 8, z + 5, Blocks.field_150348_b);
        array.setBlock(x + 8, y + 7, z + 2, Blocks.field_150348_b);
        array.setBlock(x + 8, y + 7, z + 3, Blocks.field_150348_b);
        array.setBlock(x + 8, y + 7, z + 4, Blocks.field_150348_b);
        array.setBlock(x + 7, y + 10, z + 5, (Block)Blocks.field_150349_c);
        array.setBlock(x + 7, y + 11, z + 2, (Block)Blocks.field_150349_c);
        array.setBlock(x + 7, y + 11, z + 3, (Block)Blocks.field_150349_c);
        array.setBlock(x + 7, y + 11, z + 4, (Block)Blocks.field_150349_c);
        array.setBlock(x + 8, y + 8, z + 2, Blocks.field_150346_d);
        array.setBlock(x + 8, y + 8, z + 3, Blocks.field_150346_d);
        array.setBlock(x + 8, y + 8, z + 4, Blocks.field_150346_d);
        array.setBlock(x + 8, y + 9, z + 2, Blocks.field_150346_d);
        array.setBlock(x + 8, y + 9, z + 3, (Block)Blocks.field_150349_c);
        array.setBlock(x + 8, y + 9, z + 4, Blocks.field_150346_d);
        array.setBlock(x + 8, y + 10, z + 1, (Block)Blocks.field_150349_c);
        array.setBlock(x + 8, y + 10, z + 2, (Block)Blocks.field_150349_c);
        array.setBlock(x + 8, y + 10, z + 4, (Block)Blocks.field_150349_c);
        array.setBlock(x + 8, y + 10, z + 5, (Block)Blocks.field_150349_c);
        array.setBlock(x + 9, y + 10, z + 1, (Block)Blocks.field_150349_c);
        array.setBlock(x + 9, y + 10, z + 2, (Block)Blocks.field_150349_c);
        array.setBlock(x + 9, y + 10, z + 3, (Block)Blocks.field_150349_c);
        array.setBlock(x + 9, y + 10, z + 4, (Block)Blocks.field_150349_c);
        array.setBlock(x + 9, y + 10, z + 5, (Block)Blocks.field_150349_c);
        array.setBlock(x + 7, y + 9, z + 1, Blocks.field_150346_d);
        array.setBlock(x + 7, y + 9, z + 5, Blocks.field_150346_d);
        array.setBlock(x + 7, y + 10, z + 1, Blocks.field_150346_d);
        array.setBlock(x + 6, y + 9, z + 1, Blocks.field_150346_d);
        array.setBlock(x + 6, y + 9, z + 5, Blocks.field_150346_d);
        array.setBlock(x + 6, y + 10, z + 2, Blocks.field_150346_d);
        array.setBlock(x + 6, y + 10, z + 3, Blocks.field_150346_d);
        array.setBlock(x + 6, y + 10, z + 4, Blocks.field_150346_d);
        array.setBlock(x + 6, y + 11, z + 2, (Block)Blocks.field_150349_c);
        array.setBlock(x + 6, y + 11, z + 3, (Block)Blocks.field_150349_c);
        array.setBlock(x + 6, y + 11, z + 4, (Block)Blocks.field_150349_c);
        array.setBlock(x + 5, y + 9, z + 1, Blocks.field_150346_d);
        array.setBlock(x + 5, y + 9, z + 5, Blocks.field_150346_d);
        array.setBlock(x + 5, y + 10, z + 2, Blocks.field_150346_d);
        array.setBlock(x + 5, y + 10, z + 3, Blocks.field_150346_d);
        array.setBlock(x + 5, y + 10, z + 4, Blocks.field_150346_d);
        array.setBlock(x + 5, y + 11, z + 2, (Block)Blocks.field_150349_c);
        array.setBlock(x + 5, y + 11, z + 3, (Block)Blocks.field_150349_c);
        array.setBlock(x + 5, y + 11, z + 4, (Block)Blocks.field_150349_c);
        array.setBlock(x + 4, y + 9, z + 2, Blocks.field_150346_d);
        array.setBlock(x + 4, y + 9, z + 3, Blocks.field_150346_d);
        array.setBlock(x + 4, y + 9, z + 4, Blocks.field_150346_d);
        array.setBlock(x + 3, y + 1, z + 3, ChromaBlocks.LAMP.getBlockInstance(), this.getCurrentColor().ordinal());
        array.setBlock(x + 3, y + 5, z + 3, Blocks.field_150478_aa, 5);
        this.addLootChest(array, x + 3, y + 6, z + 1, ForgeDirection.SOUTH);
        this.addLootChest(array, x + 1, y + 6, z + 3, ForgeDirection.EAST);
        this.addLootChest(array, x + 3, y + 6, z + 5, ForgeDirection.NORTH);
        this.addLootChest(array, x + 3, y + 2, z + 1, ForgeDirection.SOUTH);
        this.addLootChest(array, x + 1, y + 2, z + 3, ForgeDirection.EAST);
        this.addLootChest(array, x + 3, y + 2, z + 5, ForgeDirection.NORTH);
        array.setBlock(x + 2, y + 1, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 1, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 1, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 2, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 2, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 2, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 3, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 3, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 3, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 5, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 5, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 5, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 1, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 1, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 2, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 2, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 2, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 3, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 3, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 3, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 5, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 5, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 1, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 1, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 1, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 2, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 2, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 2, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 3, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 3, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 3, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 5, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 5, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 5, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 2, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 2, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 2, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 3, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 3, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 3, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 5, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 5, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 5, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 9, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 9, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 9, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 9, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 9, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 9, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 9, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 9, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 9, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 10, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 10, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 10, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 10, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 11, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 11, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 11, z + 4, Blocks.field_150350_a);
        return array;
    }

    public FilledBlockArray getFurnaceRoom(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        array.setBlock((x -= 5) + 1, (y -= 11) + 2, (z -= 6) + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 2, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 2, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 3, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 3, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 3, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 4, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 4, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 4, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 1, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 1, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 1, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 2, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 3, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 5, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 5, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 5, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 1, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 1, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 1, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 2, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 2, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 2, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 3, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 3, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 3, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 5, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 5, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 5, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 5, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 3, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 3, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 4, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 4, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 5, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 5, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 5, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 5, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 2, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 2, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 2, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 2, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 2, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 3, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 3, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 4, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 4, z + 10, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 5, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 5, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 5, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 5, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 4, z + 6, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 4, z + 7, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 4, z + 8, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 4, z + 9, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 2, z + 6, shield, BlockStructureShield.BlockType.CRACK.metadata);
        array.setBlock(x + 2, y + 3, z + 6, shield, BlockStructureShield.BlockType.CRACK.metadata);
        this.placeFurnace(array, x + 4, y + 3, z + 6);
        this.placeFurnace(array, x + 5, y + 3, z + 6);
        array.setBlock(x + 2, y + 2, z + 8, Blocks.field_150478_aa, 5);
        array.setBlock(x + 5, y + 3, z + 8, Blocks.field_150478_aa, 5);
        array.setBlock(x + 5, y + 3, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 3, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 4, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 4, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 4, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 2, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 2, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 3, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 3, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 3, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 4, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 4, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 2, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 2, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 3, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 3, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 4, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 4, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 3, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 3, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 3, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 4, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 4, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 4, z + 9, Blocks.field_150350_a);
        return array;
    }

    public FilledBlockArray getLootRoom(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        array.setBlock((x -= 5) + 1, (y -= 11) + 2, (z -= 6) + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 1, y + 3, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 1, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 1, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 2, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 3, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 4, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 1, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 1, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 1, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 1, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 2, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 2, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 3, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 3, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 3, y + 4, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 0, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 0, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 0, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 0, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 1, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 1, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 1, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 1, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 2, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 3, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 3, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 3, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 3, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 4, y + 4, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 0, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 0, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 0, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 0, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 1, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 1, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 2, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 2, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 3, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 3, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 3, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 3, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 5, y + 4, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 0, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 0, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 0, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 0, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 1, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 1, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 2, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 2, z + 5, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 0, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 3, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 6, y + 4, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 1, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 1, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 1, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 1, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 2, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 2, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 2, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 2, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 3, z + 1, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 3, z + 2, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 3, z + 3, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 7, y + 3, z + 4, shield, BlockStructureShield.BlockType.STONE.metadata);
        array.setBlock(x + 2, y + 2, z + 2, shield, BlockStructureShield.BlockType.CRACK.metadata);
        array.setBlock(x + 2, y + 3, z + 2, shield, BlockStructureShield.BlockType.CRACK.metadata);
        array.setBlock(x + 3, y + 4, z + 6, shield, BlockStructureShield.BlockType.CRACK.metadata);
        this.placeDoor(array, x + 5, y + 1, z + 2);
        this.placeDoor(array, x + 5, y + 2, z + 2);
        this.placeDoor(array, x + 6, y + 1, z + 2);
        this.placeDoor(array, x + 6, y + 2, z + 2);
        array.setBlock(x + 3, y + 4, z + 5, (Block)Blocks.field_150486_ae, 3);
        if (this.isWorldgen()) {
            this.addCallback(x + 3, y + 4, z + 5, this.keyChestCall);
        }
        array.setBlock(x + 6, y + 1, z + 4, BurrowStructure.getChestGen(), 2);
        array.setBlock(x + 5, y + 1, z + 4, BurrowStructure.getChestGen(), 2);
        if (this.isWorldgen()) {
            this.addCallback(x + 6, y + 1, z + 4, this.lootCall);
            this.addCallback(x + 5, y + 1, z + 4, this.lootCall);
        }
        array.setBlock(x + 3, y + 2, z + 1, Blocks.field_150478_aa, 5);
        array.setBlock(x + 6, y + 1, z + 3, Blocks.field_150478_aa, 5);
        array.setBlock(x + 2, y + 2, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 3, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 3, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 1, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 2, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 3, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 1, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 1, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 2, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 2, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 2, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 3, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 1, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 2, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 2, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 2, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 3, z + 1, Blocks.field_150350_a);
        return array;
    }

    private void placeFurnace(FilledBlockArray array, int x, int y, int z) {
        array.setBlock(x, y, z, Blocks.field_150470_am, 3);
        if (this.isWorldgen()) {
            this.addCallback(x, y, z, this.furnaceCall);
        }
    }

    private void placeDoor(FilledBlockArray array, int x, int y, int z) {
        array.setBlock(x, y, z, ChromaBlocks.DOOR.getBlockInstance(), BlockChromaDoor.getMetadata(false, false, true, true));
        if (this.isWorldgen()) {
            this.addCallback(x, y, z, this.doorCall);
        }
    }

    @Override
    public int getStructureVersion() {
        return 0;
    }

    @Override
    public void resetToDefaults() {
        super.resetToDefaults();
        this.doorID = null;
    }

    @Override
    public int getChestYield(Coordinate c, BlockLootChest.TileEntityLootChest te, FilledBlockArray arr, Random r) {
        return c.yCoord <= arr.getMinY() + 4 ? 0 : -1;
    }

    @Override
    public String getChestLootTable(Coordinate c, BlockLootChest.TileEntityLootChest te, FilledBlockArray arr, Random r) {
        return "bonusChest";
    }

    @Override
    public int modifyLootCount(BlockLootChest.TileEntityLootChest tileEntityLootChest, String s, int bonus, Random r, int count) {
        return (int)((double)count * (0.4 + (double)((float)bonus * 0.2f)));
    }

    @Override
    public float getFragmentChance(BlockLootChest.TileEntityLootChest te, String s, int bonus, Random r) {
        return 0.667f + (float)bonus * 0.208f;
    }

    @Override
    public int getFragmentCount(BlockLootChest.TileEntityLootChest te, String s, int bonus, Random r) {
        return r.nextInt(3) == 0 ? 2 : 1;
    }
}

