/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Auxiliary.Structure.Worldgen;

import Reika.ChromatiCraft.Base.FragmentStructureBase;
import Reika.ChromatiCraft.Block.Dimension.Structure.ShiftMaze.BlockShiftLock;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.ModList;
import Reika.GeoStrata.Blocks.BlockLavaRock;
import Reika.GeoStrata.Registry.GeoBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SnowStructure
extends FragmentStructureBase {
    private static final Block b2 = ChromaBlocks.TRAPFLOOR.getBlockInstance();
    private static final int ms = BlockStructureShield.BlockType.STONE.metadata;
    private static final int mc = BlockStructureShield.BlockType.COBBLE.metadata;
    private static final int mg = BlockStructureShield.BlockType.GLASS.metadata;
    private static final int mcrack = ms;

    public static Collection<Coordinate> getCrackToCenter() {
        ArrayList<Coordinate> li = new ArrayList<Coordinate>();
        li.add(new Coordinate(9, 5, 7));
        li.add(new Coordinate(9, 5, 8));
        li.add(new Coordinate(9, 5, 9));
        li.add(new Coordinate(9, 5, 10));
        li.add(new Coordinate(8, 5, 7));
        li.add(new Coordinate(8, 5, 8));
        li.add(new Coordinate(8, 5, 9));
        li.add(new Coordinate(8, 5, 10));
        li.add(new Coordinate(7, 5, 7));
        li.add(new Coordinate(7, 5, 8));
        li.add(new Coordinate(7, 5, 9));
        li.add(new Coordinate(7, 5, 10));
        return li;
    }

    public static Collection<Coordinate> getRoofCracks(Random rand) {
        ArrayList<Coordinate> li = new ArrayList<Coordinate>();
        switch (rand.nextInt(8)) {
            case 0: {
                li.add(new Coordinate(4, 10, 5));
                li.add(new Coordinate(4, 10, 6));
                li.add(new Coordinate(4, 11, 5));
                li.add(new Coordinate(4, 11, 6));
                break;
            }
            case 1: {
                li.add(new Coordinate(4, 10, 10));
                li.add(new Coordinate(4, 10, 11));
                li.add(new Coordinate(4, 11, 10));
                li.add(new Coordinate(4, 11, 11));
                break;
            }
            case 2: {
                li.add(new Coordinate(5, 10, 4));
                li.add(new Coordinate(5, 11, 4));
                li.add(new Coordinate(6, 10, 4));
                li.add(new Coordinate(6, 11, 4));
                break;
            }
            case 3: {
                li.add(new Coordinate(5, 10, 12));
                li.add(new Coordinate(5, 11, 12));
                li.add(new Coordinate(6, 10, 12));
                li.add(new Coordinate(6, 11, 12));
                break;
            }
            case 4: {
                li.add(new Coordinate(10, 10, 4));
                li.add(new Coordinate(10, 11, 4));
                li.add(new Coordinate(11, 10, 4));
                li.add(new Coordinate(11, 11, 4));
                break;
            }
            case 5: {
                li.add(new Coordinate(10, 10, 12));
                li.add(new Coordinate(10, 11, 12));
                li.add(new Coordinate(11, 10, 12));
                li.add(new Coordinate(11, 11, 12));
                break;
            }
            case 6: {
                li.add(new Coordinate(12, 10, 5));
                li.add(new Coordinate(12, 10, 6));
                li.add(new Coordinate(12, 11, 5));
                li.add(new Coordinate(12, 11, 6));
                break;
            }
            case 7: {
                li.add(new Coordinate(12, 10, 10));
                li.add(new Coordinate(12, 10, 11));
                li.add(new Coordinate(12, 11, 10));
                li.add(new Coordinate(12, 11, 11));
            }
        }
        return li;
    }

    public static Collection<Coordinate> getCenterAccess(ForgeDirection dir) {
        ArrayList<Coordinate> li = new ArrayList<Coordinate>();
        switch (dir) {
            case WEST: {
                li.add(new Coordinate(6, 6, 7));
                li.add(new Coordinate(6, 6, 8));
                li.add(new Coordinate(6, 6, 9));
                li.add(new Coordinate(6, 7, 7));
                li.add(new Coordinate(6, 7, 8));
                li.add(new Coordinate(6, 7, 9));
                li.add(new Coordinate(6, 8, 7));
                li.add(new Coordinate(6, 8, 8));
                li.add(new Coordinate(6, 8, 9));
                break;
            }
            case SOUTH: {
                li.add(new Coordinate(7, 6, 10));
                li.add(new Coordinate(7, 7, 10));
                li.add(new Coordinate(7, 8, 10));
                li.add(new Coordinate(8, 6, 10));
                li.add(new Coordinate(8, 7, 10));
                li.add(new Coordinate(8, 8, 10));
                li.add(new Coordinate(9, 6, 10));
                li.add(new Coordinate(9, 7, 10));
                li.add(new Coordinate(9, 8, 10));
                break;
            }
            case NORTH: {
                li.add(new Coordinate(7, 6, 6));
                li.add(new Coordinate(7, 7, 6));
                li.add(new Coordinate(7, 8, 6));
                li.add(new Coordinate(8, 6, 6));
                li.add(new Coordinate(8, 7, 6));
                li.add(new Coordinate(8, 8, 6));
                li.add(new Coordinate(9, 6, 6));
                li.add(new Coordinate(9, 7, 6));
                li.add(new Coordinate(9, 8, 6));
                break;
            }
            case EAST: {
                li.add(new Coordinate(10, 6, 7));
                li.add(new Coordinate(10, 6, 8));
                li.add(new Coordinate(10, 6, 9));
                li.add(new Coordinate(10, 7, 7));
                li.add(new Coordinate(10, 7, 8));
                li.add(new Coordinate(10, 7, 9));
                li.add(new Coordinate(10, 8, 7));
                li.add(new Coordinate(10, 8, 8));
                li.add(new Coordinate(10, 8, 9));
                break;
            }
        }
        return li;
    }

    @Override
    public Coordinate getControllerRelativeLocation() {
        return new Coordinate(8, 3, 6);
    }

    public FilledBlockArray getArray(World world, int x, int y, int z) {
        FilledBlockArray array = new FilledBlockArray(world);
        this.getBaseStructure(array, x, y, z);
        this.getAirSpaces(array, x, y, z);
        Block spw = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        array.setBlock(x + 14, y + 4, z + 14, spw);
        array.setBlock(x + 3, y + 4, z + 14, spw);
        array.setBlock(x + 2, y + 4, z + 4, spw);
        for (Coordinate c : this.getCrackToCenter()) {
            array.setBlock(x + c.xCoord, y + c.yCoord, z + c.zCoord, shield, mcrack);
        }
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            for (Coordinate c : SnowStructure.getCenterAccess(dir)) {
                array.setBlock(x + c.xCoord, y + c.yCoord, z + c.zCoord, ChromaBlocks.SHIFTLOCK.getBlockInstance(), BlockShiftLock.Passability.CLOSED_HIDDEN.ordinal());
            }
        }
        for (Coordinate c : SnowStructure.getRoofCracks(this.rand)) {
            array.setBlock(x + c.xCoord, y + c.yCoord, z + c.zCoord, shield, ms);
        }
        array.setBlock(x + 5, y + 10, z + 4, shield, ms);
        array.setBlock(x + 5, y + 11, z + 4, shield, ms);
        array.setBlock(x + 6, y + 10, z + 4, shield, ms);
        array.setBlock(x + 6, y + 11, z + 4, shield, ms);
        array.setBlock(x + 5, y + 10, z + 12, shield, ms);
        array.setBlock(x + 5, y + 11, z + 12, shield, ms);
        array.setBlock(x + 6, y + 10, z + 12, shield, ms);
        array.setBlock(x + 6, y + 11, z + 12, shield, ms);
        return array;
    }

    /*
     * Opcode count of 16611 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void getBaseStructure(FilledBlockArray array, int x, int y, int z) {
        array.setBlock(x + 0, y + 5, z + 6, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 0, y + 5, z + 7, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 0, y + 5, z + 8, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 0, y + 5, z + 9, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 0, y + 5, z + 10, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 1, y + 4, z + 4, shield, ms);
        array.setBlock(x + 1, y + 4, z + 5, shield, ms);
        array.setBlock(x + 1, y + 4, z + 6, shield, ms);
        array.setBlock(x + 1, y + 4, z + 7, shield, ms);
        array.setBlock(x + 1, y + 4, z + 8, shield, ms);
        array.setBlock(x + 1, y + 5, z + 3, shield, ms);
        array.setBlock(x + 1, y + 5, z + 4, shield, ms);
        array.setBlock(x + 1, y + 5, z + 5, shield, ms);
        array.setBlock(x + 1, y + 5, z + 6, shield, ms);
        array.setBlock(x + 1, y + 5, z + 7, shield, ms);
        array.setBlock(x + 1, y + 5, z + 8, b2);
        array.setBlock(x + 1, y + 5, z + 9, shield, ms);
        array.setBlock(x + 1, y + 5, z + 10, shield, ms);
        array.setBlock(x + 1, y + 5, z + 11, shield, ms);
        array.setBlock(x + 1, y + 5, z + 12, shield, ms);
        array.setBlock(x + 1, y + 5, z + 13, shield, ms);
        array.setBlock(x + 1, y + 6, z + 3, shield, mc);
        array.setBlock(x + 1, y + 6, z + 4, shield, mg);
        array.setBlock(x + 1, y + 6, z + 5, shield, mg);
        array.setBlock(x + 1, y + 6, z + 6, shield, mg);
        array.setBlock(x + 1, y + 6, z + 7, shield, mc);
        array.setBlock(x + 1, y + 6, z + 9, shield, mc);
        array.setBlock(x + 1, y + 6, z + 10, shield, mg);
        array.setBlock(x + 1, y + 6, z + 11, shield, mg);
        array.setBlock(x + 1, y + 6, z + 12, shield, mg);
        array.setBlock(x + 1, y + 6, z + 13, shield, mc);
        array.setBlock(x + 1, y + 7, z + 3, shield, mc);
        array.setBlock(x + 1, y + 7, z + 4, shield, mg);
        array.setBlock(x + 1, y + 7, z + 5, shield, mg);
        array.setBlock(x + 1, y + 7, z + 6, shield, mg);
        array.setBlock(x + 1, y + 7, z + 7, shield, mc);
        array.setBlock(x + 1, y + 7, z + 9, shield, mc);
        array.setBlock(x + 1, y + 7, z + 10, shield, mg);
        array.setBlock(x + 1, y + 7, z + 11, shield, mg);
        array.setBlock(x + 1, y + 7, z + 12, shield, mg);
        array.setBlock(x + 1, y + 7, z + 13, shield, mc);
        array.setBlock(x + 1, y + 8, z + 3, shield, mc);
        array.setBlock(x + 1, y + 8, z + 4, shield, mg);
        array.setBlock(x + 1, y + 8, z + 5, shield, mg);
        array.setBlock(x + 1, y + 8, z + 6, shield, mg);
        array.setBlock(x + 1, y + 8, z + 7, shield, mc);
        array.setBlock(x + 1, y + 8, z + 8, shield, mc);
        array.setBlock(x + 1, y + 8, z + 9, shield, mc);
        array.setBlock(x + 1, y + 8, z + 10, shield, mg);
        array.setBlock(x + 1, y + 8, z + 11, shield, mg);
        array.setBlock(x + 1, y + 8, z + 12, shield, mg);
        array.setBlock(x + 1, y + 8, z + 13, shield, mc);
        array.setBlock(x + 1, y + 9, z + 3, shield, mc);
        array.setBlock(x + 1, y + 9, z + 4, shield, mc);
        array.setBlock(x + 1, y + 9, z + 5, shield, mc);
        array.setBlock(x + 1, y + 9, z + 6, shield, mc);
        array.setBlock(x + 1, y + 9, z + 7, shield, mc);
        array.setBlock(x + 1, y + 9, z + 8, shield, mc);
        array.setBlock(x + 1, y + 9, z + 9, shield, mc);
        array.setBlock(x + 1, y + 9, z + 10, shield, mc);
        array.setBlock(x + 1, y + 9, z + 11, shield, mc);
        array.setBlock(x + 1, y + 9, z + 12, shield, mc);
        array.setBlock(x + 1, y + 9, z + 13, shield, mc);
        array.setBlock(x + 1, y + 10, z + 3, shield, mc);
        array.setBlock(x + 1, y + 10, z + 5, shield, mc);
        array.setBlock(x + 1, y + 10, z + 11, shield, mc);
        array.setBlock(x + 1, y + 10, z + 13, shield, mc);
        array.setBlock(x + 2, y + 3, z + 4, shield, ms);
        array.setBlock(x + 2, y + 3, z + 5, shield, ms);
        array.setBlock(x + 2, y + 3, z + 6, shield, ms);
        array.setBlock(x + 2, y + 3, z + 7, shield, ms);
        array.setBlock(x + 2, y + 3, z + 8, shield, ms);
        array.setBlock(x + 2, y + 3, z + 9, shield, ms);
        array.setBlock(x + 2, y + 4, z + 3, shield, ms);
        array.setBlock(x + 2, y + 4, z + 5, shield, ms);
        array.setBlock(x + 2, y + 4, z + 6, shield, ms);
        array.setBlock(x + 2, y + 4, z + 7, shield, ms);
        array.setBlock(x + 2, y + 4, z + 8, shield, ms);
        array.setBlock(x + 2, y + 4, z + 9, shield, ms);
        array.setBlock(x + 2, y + 4, z + 10, shield, ms);
        array.setBlock(x + 2, y + 4, z + 11, shield, ms);
        array.setBlock(x + 2, y + 4, z + 12, shield, ms);
        array.setBlock(x + 2, y + 4, z + 13, shield, ms);
        array.setBlock(x + 2, y + 4, z + 14, shield, ms);
        array.setBlock(x + 2, y + 5, z + 2, shield, ms);
        array.setBlock(x + 2, y + 5, z + 3, b2);
        array.setBlock(x + 2, y + 5, z + 4, b2);
        array.setBlock(x + 2, y + 5, z + 5, b2);
        array.setBlock(x + 2, y + 5, z + 6, b2);
        array.setBlock(x + 2, y + 5, z + 7, b2);
        array.setBlock(x + 2, y + 5, z + 8, b2);
        array.setBlock(x + 2, y + 5, z + 9, shield, ms);
        array.setBlock(x + 2, y + 5, z + 10, b2);
        array.setBlock(x + 2, y + 5, z + 11, b2);
        array.setBlock(x + 2, y + 5, z + 12, b2);
        array.setBlock(x + 2, y + 5, z + 13, b2);
        array.setBlock(x + 2, y + 5, z + 14, shield, ms);
        array.setBlock(x + 2, y + 6, z + 2, shield, ms);
        array.setBlock(x + 2, y + 6, z + 9, shield, ms);
        array.setBlock(x + 2, y + 6, z + 14, shield, ms);
        array.setBlock(x + 2, y + 7, z + 2, shield, ms);
        array.setBlock(x + 2, y + 7, z + 9, shield, ms);
        array.setBlock(x + 2, y + 7, z + 14, shield, ms);
        array.setBlock(x + 2, y + 8, z + 2, shield, ms);
        array.setBlock(x + 2, y + 8, z + 9, shield, ms);
        array.setBlock(x + 2, y + 8, z + 14, shield, ms);
        array.setBlock(x + 2, y + 9, z + 2, shield, mc);
        array.setBlock(x + 2, y + 9, z + 3, shield, mc);
        array.setBlock(x + 2, y + 9, z + 4, shield, ms);
        array.setBlock(x + 2, y + 9, z + 5, shield, ms);
        array.setBlock(x + 2, y + 9, z + 6, shield, ms);
        array.setBlock(x + 2, y + 9, z + 7, shield, ms);
        array.setBlock(x + 2, y + 9, z + 8, shield, ms);
        array.setBlock(x + 2, y + 9, z + 9, shield, ms);
        array.setBlock(x + 2, y + 9, z + 10, shield, ms);
        array.setBlock(x + 2, y + 9, z + 11, shield, ms);
        array.setBlock(x + 2, y + 9, z + 12, shield, ms);
        array.setBlock(x + 2, y + 9, z + 13, shield, mc);
        array.setBlock(x + 2, y + 9, z + 14, shield, mc);
        array.setBlock(x + 2, y + 10, z + 5, shield, mc);
        array.setBlock(x + 2, y + 10, z + 6, shield, ms);
        array.setBlock(x + 2, y + 10, z + 7, shield, ms);
        array.setBlock(x + 2, y + 10, z + 8, shield, ms);
        array.setBlock(x + 2, y + 10, z + 9, shield, ms);
        array.setBlock(x + 2, y + 10, z + 10, shield, ms);
        array.setBlock(x + 2, y + 10, z + 11, shield, mc);
        array.setBlock(x + 3, y + 3, z + 4, shield, ms);
        array.setBlock(x + 3, y + 3, z + 5, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 3, y + 3, z + 6, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 3, y + 3, z + 7, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 3, y + 3, z + 8, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 3, y + 3, z + 9, shield, ms);
        array.setBlock(x + 3, y + 3, z + 10, shield, ms);
        array.setBlock(x + 3, y + 3, z + 11, shield, ms);
        array.setBlock(x + 3, y + 3, z + 12, shield, ms);
        array.setBlock(x + 3, y + 3, z + 13, shield, ms);
        array.setBlock(x + 3, y + 3, z + 14, shield, ms);
        array.setBlock(x + 3, y + 4, z + 2, shield, ms);
        array.setBlock(x + 3, y + 4, z + 3, shield, ms);
        array.setBlock(x + 3, y + 4, z + 4, shield, ms);
        array.setBlock(x + 3, y + 4, z + 9, shield, ms);
        array.setBlock(x + 3, y + 4, z + 10, shield, ms);
        array.setBlock(x + 3, y + 4, z + 11, shield, ms);
        array.setBlock(x + 3, y + 4, z + 12, shield, ms);
        array.setBlock(x + 3, y + 4, z + 13, shield, ms);
        array.setBlock(x + 3, y + 4, z + 15, shield, ms);
        array.setBlock(x + 3, y + 5, z + 1, shield, ms);
        array.setBlock(x + 3, y + 5, z + 2, b2);
        array.setBlock(x + 3, y + 5, z + 3, b2);
        array.setBlock(x + 3, y + 5, z + 4, b2);
        array.setBlock(x + 3, y + 5, z + 5, b2);
        array.setBlock(x + 3, y + 5, z + 6, b2);
        array.setBlock(x + 3, y + 5, z + 7, b2);
        array.setBlock(x + 3, y + 5, z + 8, b2);
        array.setBlock(x + 3, y + 5, z + 9, shield, ms);
        array.setBlock(x + 3, y + 5, z + 10, b2);
        array.setBlock(x + 3, y + 5, z + 11, b2);
        array.setBlock(x + 3, y + 5, z + 12, b2);
        array.setBlock(x + 3, y + 5, z + 13, b2);
        array.setBlock(x + 3, y + 5, z + 14, b2);
        array.setBlock(x + 3, y + 5, z + 15, shield, ms);
        array.setBlock(x + 3, y + 6, z + 1, shield, mc);
        array.setBlock(x + 3, y + 6, z + 9, shield, ms);
        array.setBlock(x + 3, y + 6, z + 15, shield, mc);
        array.setBlock(x + 3, y + 7, z + 1, shield, mc);
        array.setBlock(x + 3, y + 7, z + 9, shield, ms);
        array.setBlock(x + 3, y + 7, z + 15, shield, mc);
        array.setBlock(x + 3, y + 8, z + 1, shield, mc);
        array.setBlock(x + 3, y + 8, z + 9, shield, ms);
        array.setBlock(x + 3, y + 8, z + 15, shield, mc);
        array.setBlock(x + 3, y + 9, z + 1, shield, mc);
        array.setBlock(x + 3, y + 9, z + 2, shield, mc);
        array.setBlock(x + 3, y + 9, z + 3, shield, ms);
        array.setBlock(x + 3, y + 9, z + 4, shield, ms);
        array.setBlock(x + 3, y + 9, z + 5, shield, ms);
        array.setBlock(x + 3, y + 9, z + 6, shield, ms);
        array.setBlock(x + 3, y + 9, z + 7, shield, ms);
        array.setBlock(x + 3, y + 9, z + 8, shield, ms);
        array.setBlock(x + 3, y + 9, z + 9, shield, ms);
        array.setBlock(x + 3, y + 9, z + 10, shield, ms);
        array.setBlock(x + 3, y + 9, z + 11, shield, ms);
        array.setBlock(x + 3, y + 9, z + 12, shield, ms);
        array.setBlock(x + 3, y + 9, z + 13, shield, ms);
        array.setBlock(x + 3, y + 9, z + 14, shield, mc);
        array.setBlock(x + 3, y + 9, z + 15, shield, mc);
        array.setBlock(x + 3, y + 10, z + 1, shield, mc);
        array.setBlock(x + 3, y + 10, z + 5, shield, mc);
        array.setBlock(x + 3, y + 10, z + 6, shield, ms);
        array.setBlock(x + 3, y + 10, z + 7, shield, ms);
        array.setBlock(x + 3, y + 10, z + 8, shield, ms);
        array.setBlock(x + 3, y + 10, z + 9, shield, ms);
        array.setBlock(x + 3, y + 10, z + 10, shield, ms);
        array.setBlock(x + 3, y + 10, z + 11, shield, mc);
        array.setBlock(x + 3, y + 10, z + 15, shield, mc);
        array.setBlock(x + 3, y + 11, z + 5, shield, mc);
        array.setBlock(x + 3, y + 11, z + 6, shield, ms);
        array.setBlock(x + 3, y + 11, z + 7, shield, ms);
        array.setBlock(x + 3, y + 11, z + 8, shield, ms);
        array.setBlock(x + 3, y + 11, z + 9, shield, ms);
        array.setBlock(x + 3, y + 11, z + 10, shield, ms);
        array.setBlock(x + 3, y + 11, z + 11, shield, mc);
        array.setBlock(x + 3, y + 12, z + 5, shield, mc);
        array.setBlock(x + 3, y + 12, z + 6, shield, mc);
        array.setBlock(x + 3, y + 12, z + 7, shield, mc);
        array.setBlock(x + 3, y + 12, z + 8, shield, mc);
        array.setBlock(x + 3, y + 12, z + 9, shield, mc);
        array.setBlock(x + 3, y + 12, z + 10, shield, mc);
        array.setBlock(x + 3, y + 12, z + 11, shield, mc);
        array.setBlock(x + 3, y + 13, z + 5, shield, mc);
        array.setBlock(x + 3, y + 13, z + 11, shield, mc);
        array.setBlock(x + 4, y + 3, z + 4, shield, ms);
        array.setBlock(x + 4, y + 3, z + 5, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 4, y + 3, z + 6, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 4, y + 3, z + 7, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 4, y + 3, z + 8, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 4, y + 3, z + 9, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 4, y + 3, z + 10, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 4, y + 3, z + 11, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 4, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 4, y + 3, z + 13, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 4, y + 3, z + 14, shield, ms);
        array.setBlock(x + 4, y + 4, z + 2, shield, ms);
        array.setBlock(x + 4, y + 4, z + 3, shield, ms);
        array.setBlock(x + 4, y + 4, z + 4, shield, ms);
        array.setBlock(x + 4, y + 4, z + 14, shield, ms);
        array.setBlock(x + 4, y + 4, z + 15, shield, ms);
        array.setBlock(x + 4, y + 5, z + 1, shield, ms);
        array.setBlock(x + 4, y + 5, z + 2, b2);
        array.setBlock(x + 4, y + 5, z + 3, b2);
        array.setBlock(x + 4, y + 5, z + 4, b2);
        array.setBlock(x + 4, y + 5, z + 5, b2);
        array.setBlock(x + 4, y + 5, z + 6, b2);
        array.setBlock(x + 4, y + 5, z + 7, b2);
        array.setBlock(x + 4, y + 5, z + 8, b2);
        array.setBlock(x + 4, y + 5, z + 9, b2);
        array.setBlock(x + 4, y + 5, z + 10, shield, ms);
        array.setBlock(x + 4, y + 5, z + 11, b2);
        array.setBlock(x + 4, y + 5, z + 12, b2);
        array.setBlock(x + 4, y + 5, z + 13, b2);
        array.setBlock(x + 4, y + 5, z + 14, b2);
        array.setBlock(x + 4, y + 5, z + 15, shield, ms);
        array.setBlock(x + 4, y + 6, z + 1, shield, mg);
        array.setBlock(x + 4, y + 6, z + 10, shield, ms);
        array.setBlock(x + 4, y + 6, z + 15, shield, mg);
        array.setBlock(x + 4, y + 7, z + 1, shield, mg);
        array.setBlock(x + 4, y + 7, z + 10, shield, ms);
        array.setBlock(x + 4, y + 7, z + 15, shield, mg);
        array.setBlock(x + 4, y + 8, z + 1, shield, mg);
        array.setBlock(x + 4, y + 8, z + 10, shield, ms);
        array.setBlock(x + 4, y + 8, z + 15, shield, mg);
        array.setBlock(x + 4, y + 9, z + 1, shield, mc);
        array.setBlock(x + 4, y + 9, z + 2, shield, ms);
        array.setBlock(x + 4, y + 9, z + 3, shield, ms);
        array.setBlock(x + 4, y + 9, z + 4, shield, ms);
        array.setBlock(x + 4, y + 9, z + 5, shield, ms);
        array.setBlock(x + 4, y + 9, z + 6, shield, ms);
        array.setBlock(x + 4, y + 9, z + 7, shield, ms);
        array.setBlock(x + 4, y + 9, z + 8, shield, ms);
        array.setBlock(x + 4, y + 9, z + 9, shield, ms);
        array.setBlock(x + 4, y + 9, z + 10, shield, ms);
        array.setBlock(x + 4, y + 9, z + 11, shield, ms);
        array.setBlock(x + 4, y + 9, z + 12, shield, ms);
        array.setBlock(x + 4, y + 9, z + 13, shield, ms);
        array.setBlock(x + 4, y + 9, z + 14, shield, ms);
        array.setBlock(x + 4, y + 9, z + 15, shield, mc);
        array.setBlock(x + 4, y + 10, z + 5, shield, ms);
        array.setBlock(x + 4, y + 10, z + 6, shield, ms);
        array.setBlock(x + 4, y + 10, z + 7, shield, ms);
        array.setBlock(x + 4, y + 10, z + 9, shield, ms);
        array.setBlock(x + 4, y + 10, z + 10, shield, ms);
        array.setBlock(x + 4, y + 10, z + 11, shield, ms);
        array.setBlock(x + 4, y + 11, z + 5, shield, ms);
        array.setBlock(x + 4, y + 11, z + 6, shield, ms);
        array.setBlock(x + 4, y + 11, z + 7, shield, ms);
        array.setBlock(x + 4, y + 11, z + 8, shield, ms);
        array.setBlock(x + 4, y + 11, z + 9, shield, ms);
        array.setBlock(x + 4, y + 11, z + 10, shield, ms);
        array.setBlock(x + 4, y + 11, z + 11, shield, ms);
        array.setBlock(x + 4, y + 12, z + 5, shield, mc);
        array.setBlock(x + 4, y + 12, z + 6, shield, ms);
        array.setBlock(x + 4, y + 12, z + 7, shield, ms);
        array.setBlock(x + 4, y + 12, z + 8, shield, ms);
        array.setBlock(x + 4, y + 12, z + 9, shield, ms);
        array.setBlock(x + 4, y + 12, z + 10, shield, ms);
        array.setBlock(x + 4, y + 12, z + 11, shield, mc);
        array.setBlock(x + 5, y + 1, z + 5, shield, ms);
        array.setBlock(x + 5, y + 2, z + 4, shield, ms);
        array.setBlock(x + 5, y + 2, z + 5, shield, ms);
        array.setBlock(x + 5, y + 2, z + 6, shield, ms);
        array.setBlock(x + 5, y + 3, z + 4, shield, ms);
        array.setBlock(x + 5, y + 3, z + 5, shield, ms);
        array.setBlock(x + 5, y + 3, z + 6, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 5, y + 3, z + 7, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 5, y + 3, z + 8, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 5, y + 3, z + 9, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 5, y + 3, z + 10, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 5, y + 3, z + 11, shield, ms);
        array.setBlock(x + 5, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 5, y + 3, z + 13, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 5, y + 3, z + 14, shield, ms);
        array.setBlock(x + 5, y + 4, z + 2, shield, ms);
        array.setBlock(x + 5, y + 4, z + 3, shield, ms);
        array.setBlock(x + 5, y + 4, z + 4, shield, ms);
        array.setBlock(x + 5, y + 4, z + 5, shield, ms);
        array.setBlock(x + 5, y + 4, z + 11, shield, ms);
        array.setBlock(x + 5, y + 4, z + 14, shield, ms);
        array.setBlock(x + 5, y + 4, z + 15, shield, ms);
        array.setBlock(x + 5, y + 5, z + 1, shield, ms);
        array.setBlock(x + 5, y + 5, z + 2, b2);
        array.setBlock(x + 5, y + 5, z + 3, b2);
        array.setBlock(x + 5, y + 5, z + 4, b2);
        array.setBlock(x + 5, y + 5, z + 5, shield, ms);
        array.setBlock(x + 5, y + 5, z + 6, b2);
        array.setBlock(x + 5, y + 5, z + 7, b2);
        array.setBlock(x + 5, y + 5, z + 8, b2);
        array.setBlock(x + 5, y + 5, z + 9, b2);
        array.setBlock(x + 5, y + 5, z + 10, shield, ms);
        array.setBlock(x + 5, y + 5, z + 11, shield, ms);
        array.setBlock(x + 5, y + 5, z + 12, b2);
        array.setBlock(x + 5, y + 5, z + 13, b2);
        array.setBlock(x + 5, y + 5, z + 14, b2);
        array.setBlock(x + 5, y + 5, z + 15, shield, ms);
        array.setBlock(x + 5, y + 6, z + 1, shield, mg);
        array.setBlock(x + 5, y + 6, z + 5, shield, ms);
        array.setBlock(x + 5, y + 6, z + 10, shield, ms);
        array.setBlock(x + 5, y + 6, z + 11, shield, ms);
        array.setBlock(x + 5, y + 6, z + 15, shield, mg);
        array.setBlock(x + 5, y + 7, z + 1, shield, mg);
        array.setBlock(x + 5, y + 7, z + 5, shield, BlockStructureShield.BlockType.LIGHT.metadata);
        array.setBlock(x + 5, y + 7, z + 11, shield, BlockStructureShield.BlockType.LIGHT.metadata);
        array.setBlock(x + 5, y + 7, z + 15, shield, mg);
        array.setBlock(x + 5, y + 8, z + 1, shield, mg);
        array.setBlock(x + 5, y + 8, z + 5, shield, ms);
        array.setBlock(x + 5, y + 8, z + 10, shield, ms);
        array.setBlock(x + 5, y + 8, z + 11, shield, ms);
        array.setBlock(x + 5, y + 8, z + 15, shield, mg);
        array.setBlock(x + 5, y + 9, z + 1, shield, mc);
        array.setBlock(x + 5, y + 9, z + 2, shield, ms);
        array.setBlock(x + 5, y + 9, z + 3, shield, ms);
        array.setBlock(x + 5, y + 9, z + 4, shield, ms);
        array.setBlock(x + 5, y + 9, z + 5, shield, ms);
        array.setBlock(x + 5, y + 9, z + 6, shield, ms);
        array.setBlock(x + 5, y + 9, z + 7, shield, ms);
        array.setBlock(x + 5, y + 9, z + 8, shield, ms);
        array.setBlock(x + 5, y + 9, z + 9, shield, ms);
        array.setBlock(x + 5, y + 9, z + 10, shield, ms);
        array.setBlock(x + 5, y + 9, z + 11, shield, ms);
        array.setBlock(x + 5, y + 9, z + 12, shield, ms);
        array.setBlock(x + 5, y + 9, z + 13, shield, ms);
        array.setBlock(x + 5, y + 9, z + 14, shield, ms);
        array.setBlock(x + 5, y + 9, z + 15, shield, mc);
        array.setBlock(x + 5, y + 10, z + 1, shield, mc);
        array.setBlock(x + 5, y + 10, z + 2, shield, mc);
        array.setBlock(x + 5, y + 10, z + 3, shield, mc);
        array.setBlock(x + 5, y + 10, z + 5, shield, ms);
        array.setBlock(x + 5, y + 10, z + 11, shield, ms);
        array.setBlock(x + 5, y + 10, z + 13, shield, mc);
        array.setBlock(x + 5, y + 10, z + 14, shield, mc);
        array.setBlock(x + 5, y + 10, z + 15, shield, mc);
        array.setBlock(x + 5, y + 11, z + 3, shield, mc);
        array.setBlock(x + 5, y + 11, z + 5, shield, ms);
        array.setBlock(x + 5, y + 11, z + 11, shield, ms);
        array.setBlock(x + 5, y + 11, z + 13, shield, mc);
        array.setBlock(x + 5, y + 12, z + 3, shield, mc);
        array.setBlock(x + 5, y + 12, z + 4, shield, mc);
        array.setBlock(x + 5, y + 12, z + 5, shield, mc);
        array.setBlock(x + 5, y + 12, z + 6, shield, mc);
        array.setBlock(x + 5, y + 12, z + 7, shield, ms);
        array.setBlock(x + 5, y + 12, z + 8, shield, ms);
        array.setBlock(x + 5, y + 12, z + 9, shield, ms);
        array.setBlock(x + 5, y + 12, z + 10, shield, mc);
        array.setBlock(x + 5, y + 12, z + 11, shield, mc);
        array.setBlock(x + 5, y + 12, z + 12, shield, mc);
        array.setBlock(x + 5, y + 12, z + 13, shield, mc);
        array.setBlock(x + 5, y + 13, z + 3, shield, mc);
        array.setBlock(x + 5, y + 13, z + 13, shield, mc);
        array.setBlock(x + 6, y + 0, z + 5, shield, ms);
        array.setBlock(x + 6, y + 1, z + 4, shield, ms);
        array.setBlock(x + 6, y + 1, z + 5, shield, BlockStructureShield.BlockType.LIGHT.metadata);
        array.setBlock(x + 6, y + 1, z + 6, shield, ms);
        array.setBlock(x + 6, y + 1, z + 7, shield, ms);
        array.setBlock(x + 6, y + 2, z + 4, shield, ms);
        array.setBlock(x + 6, y + 2, z + 6, shield, ms);
        array.setBlock(x + 6, y + 2, z + 7, shield, ms);
        array.setBlock(x + 6, y + 2, z + 8, shield, ms);
        array.setBlock(x + 6, y + 2, z + 9, shield, ms);
        array.setBlock(x + 6, y + 3, z + 4, shield, ms);
        array.setBlock(x + 6, y + 3, z + 5, shield, ms);
        array.setBlock(x + 6, y + 3, z + 6, shield, ms);
        array.setBlock(x + 6, y + 3, z + 7, shield, ms);
        array.setBlock(x + 6, y + 3, z + 8, shield, ms);
        array.setBlock(x + 6, y + 3, z + 9, shield, ms);
        array.setBlock(x + 6, y + 3, z + 10, shield, ms);
        array.setBlock(x + 6, y + 3, z + 11, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 6, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 6, y + 3, z + 13, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 6, y + 3, z + 14, shield, ms);
        array.setBlock(x + 6, y + 4, z + 2, shield, ms);
        array.setBlock(x + 6, y + 4, z + 3, shield, ms);
        array.setBlock(x + 6, y + 4, z + 4, shield, ms);
        array.setBlock(x + 6, y + 4, z + 5, shield, ms);
        array.setBlock(x + 6, y + 4, z + 6, shield, ms);
        array.setBlock(x + 6, y + 4, z + 7, shield, ms);
        array.setBlock(x + 6, y + 4, z + 8, shield, ms);
        array.setBlock(x + 6, y + 4, z + 9, shield, ms);
        array.setBlock(x + 6, y + 4, z + 10, shield, ms);
        array.setBlock(x + 6, y + 4, z + 14, shield, ms);
        array.setBlock(x + 6, y + 4, z + 15, shield, ms);
        array.setBlock(x + 6, y + 5, z + 0, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 6, y + 5, z + 1, shield, ms);
        array.setBlock(x + 6, y + 5, z + 2, b2);
        array.setBlock(x + 6, y + 5, z + 3, b2);
        array.setBlock(x + 6, y + 5, z + 4, shield, ms);
        array.setBlock(x + 6, y + 5, z + 5, shield, ms);
        array.setBlock(x + 6, y + 5, z + 6, shield, ms);
        array.setBlock(x + 6, y + 5, z + 7, shield, ms);
        array.setBlock(x + 6, y + 5, z + 8, shield, ms);
        array.setBlock(x + 6, y + 5, z + 9, shield, ms);
        array.setBlock(x + 6, y + 5, z + 10, shield, ms);
        array.setBlock(x + 6, y + 5, z + 11, b2);
        array.setBlock(x + 6, y + 5, z + 12, b2);
        array.setBlock(x + 6, y + 5, z + 13, b2);
        array.setBlock(x + 6, y + 5, z + 14, b2);
        array.setBlock(x + 6, y + 5, z + 15, shield, ms);
        array.setBlock(x + 6, y + 5, z + 16, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 6, y + 6, z + 1, shield, mg);
        array.setBlock(x + 6, y + 6, z + 4, shield, ms);
        array.setBlock(x + 6, y + 6, z + 5, shield, ms);
        array.setBlock(x + 6, y + 6, z + 6, shield, ms);
        array.setBlock(x + 6, y + 6, z + 7, shield, ms);
        array.setBlock(x + 6, y + 6, z + 8, shield, ms);
        array.setBlock(x + 6, y + 6, z + 9, shield, ms);
        array.setBlock(x + 6, y + 6, z + 10, shield, ms);
        array.setBlock(x + 6, y + 6, z + 15, shield, mg);
        array.setBlock(x + 6, y + 7, z + 1, shield, mg);
        array.setBlock(x + 6, y + 7, z + 4, shield, ms);
        array.setBlock(x + 6, y + 7, z + 6, shield, ms);
        array.setBlock(x + 6, y + 7, z + 7, shield, ms);
        array.setBlock(x + 6, y + 7, z + 8, shield, ms);
        array.setBlock(x + 6, y + 7, z + 9, shield, ms);
        array.setBlock(x + 6, y + 7, z + 10, shield, ms);
        array.setBlock(x + 6, y + 7, z + 15, shield, mg);
        array.setBlock(x + 6, y + 8, z + 1, shield, mg);
        array.setBlock(x + 6, y + 8, z + 4, shield, ms);
        array.setBlock(x + 6, y + 8, z + 5, shield, ms);
        array.setBlock(x + 6, y + 8, z + 6, shield, ms);
        array.setBlock(x + 6, y + 8, z + 7, shield, ms);
        array.setBlock(x + 6, y + 8, z + 8, shield, ms);
        array.setBlock(x + 6, y + 8, z + 9, shield, ms);
        array.setBlock(x + 6, y + 8, z + 10, shield, ms);
        array.setBlock(x + 6, y + 8, z + 15, shield, mg);
        array.setBlock(x + 6, y + 9, z + 1, shield, mc);
        array.setBlock(x + 6, y + 9, z + 2, shield, ms);
        array.setBlock(x + 6, y + 9, z + 3, shield, ms);
        array.setBlock(x + 6, y + 9, z + 4, shield, ms);
        array.setBlock(x + 6, y + 9, z + 5, shield, ms);
        array.setBlock(x + 6, y + 9, z + 6, shield, ms);
        array.setBlock(x + 6, y + 9, z + 7, shield, ms);
        array.setBlock(x + 6, y + 9, z + 8, shield, ms);
        array.setBlock(x + 6, y + 9, z + 9, shield, ms);
        array.setBlock(x + 6, y + 9, z + 10, shield, ms);
        array.setBlock(x + 6, y + 9, z + 11, shield, ms);
        array.setBlock(x + 6, y + 9, z + 12, shield, ms);
        array.setBlock(x + 6, y + 9, z + 13, shield, ms);
        array.setBlock(x + 6, y + 9, z + 14, shield, ms);
        array.setBlock(x + 6, y + 9, z + 15, shield, mc);
        array.setBlock(x + 6, y + 10, z + 2, shield, ms);
        array.setBlock(x + 6, y + 10, z + 3, shield, ms);
        array.setBlock(x + 6, y + 10, z + 13, shield, ms);
        array.setBlock(x + 6, y + 10, z + 14, shield, ms);
        array.setBlock(x + 6, y + 11, z + 3, shield, ms);
        array.setBlock(x + 6, y + 11, z + 13, shield, ms);
        array.setBlock(x + 6, y + 12, z + 3, shield, mc);
        array.setBlock(x + 6, y + 12, z + 4, shield, ms);
        array.setBlock(x + 6, y + 12, z + 5, shield, mc);
        array.setBlock(x + 6, y + 12, z + 6, shield, mc);
        array.setBlock(x + 6, y + 12, z + 7, shield, mc);
        array.setBlock(x + 6, y + 12, z + 8, shield, mc);
        array.setBlock(x + 6, y + 12, z + 9, shield, mc);
        array.setBlock(x + 6, y + 12, z + 10, shield, mc);
        array.setBlock(x + 6, y + 12, z + 11, shield, mc);
        array.setBlock(x + 6, y + 12, z + 12, shield, ms);
        array.setBlock(x + 6, y + 12, z + 13, shield, mc);
        array.setBlock(x + 6, y + 13, z + 6, shield, mc);
        array.setBlock(x + 6, y + 13, z + 7, shield, mc);
        array.setBlock(x + 6, y + 13, z + 8, shield, mc);
        array.setBlock(x + 6, y + 13, z + 9, shield, mc);
        array.setBlock(x + 6, y + 13, z + 10, shield, mc);
        array.setBlock(x + 6, y + 14, z + 6, shield, mc);
        array.setBlock(x + 6, y + 14, z + 10, shield, mc);
        array.setBlock(x + 7, y + 0, z + 5, shield, ms);
        array.setBlock(x + 7, y + 1, z + 4, shield, ms);
        array.setBlock(x + 7, y + 1, z + 5, shield, ms);
        array.setBlock(x + 7, y + 1, z + 6, shield, ms);
        array.setBlock(x + 7, y + 1, z + 7, shield, ms);
        array.setBlock(x + 7, y + 2, z + 3, shield, ms);
        array.setBlock(x + 7, y + 2, z + 4, shield, ms);
        array.setBlock(x + 7, y + 2, z + 8, shield, ms);
        array.setBlock(x + 7, y + 2, z + 9, shield, ms);
        array.setBlock(x + 7, y + 3, z + 3, shield, ms);
        array.setBlock(x + 7, y + 3, z + 4, shield, ms);
        array.setBlock(x + 7, y + 3, z + 9, shield, ms);
        array.setBlock(x + 7, y + 3, z + 10, shield, ms);
        array.setBlock(x + 7, y + 3, z + 11, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 7, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 7, y + 3, z + 13, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 7, y + 3, z + 14, shield, ms);
        array.setBlock(x + 7, y + 4, z + 2, shield, ms);
        array.setBlock(x + 7, y + 4, z + 3, shield, ms);
        array.setBlock(x + 7, y + 4, z + 4, shield, ms);
        array.setBlock(x + 7, y + 4, z + 5, shield, ms);
        array.setBlock(x + 7, y + 4, z + 10, shield, ms);
        array.setBlock(x + 7, y + 4, z + 14, shield, ms);
        array.setBlock(x + 7, y + 4, z + 15, shield, ms);
        array.setBlock(x + 7, y + 5, z + 0, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 7, y + 5, z + 1, shield, ms);
        array.setBlock(x + 7, y + 5, z + 2, shield, ms);
        array.setBlock(x + 7, y + 5, z + 3, shield, ms);
        array.setBlock(x + 7, y + 5, z + 4, b2);
        array.setBlock(x + 7, y + 5, z + 5, b2);
        array.setBlock(x + 7, y + 5, z + 6, shield, ms);
        array.setBlock(x + 7, y + 5, z + 11, b2);
        array.setBlock(x + 7, y + 5, z + 12, b2);
        array.setBlock(x + 7, y + 5, z + 13, b2);
        array.setBlock(x + 7, y + 5, z + 14, b2);
        array.setBlock(x + 7, y + 5, z + 15, shield, ms);
        array.setBlock(x + 7, y + 5, z + 16, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 7, y + 6, z + 1, shield, mc);
        array.setBlock(x + 7, y + 6, z + 2, shield, ms);
        array.setBlock(x + 7, y + 6, z + 3, shield, ms);
        array.setBlock(x + 7, y + 6, z + 6, shield, ms);
        array.setBlock(x + 7, y + 6, z + 15, shield, mc);
        array.setBlock(x + 7, y + 7, z + 1, shield, mc);
        array.setBlock(x + 7, y + 7, z + 2, shield, ms);
        array.setBlock(x + 7, y + 7, z + 3, shield, ms);
        array.setBlock(x + 7, y + 7, z + 6, shield, ms);
        array.setBlock(x + 7, y + 7, z + 15, shield, mc);
        array.setBlock(x + 7, y + 8, z + 1, shield, mc);
        array.setBlock(x + 7, y + 8, z + 2, shield, ms);
        array.setBlock(x + 7, y + 8, z + 3, shield, ms);
        array.setBlock(x + 7, y + 8, z + 6, shield, ms);
        array.setBlock(x + 7, y + 8, z + 15, shield, mc);
        array.setBlock(x + 7, y + 9, z + 1, shield, mc);
        array.setBlock(x + 7, y + 9, z + 2, shield, ms);
        array.setBlock(x + 7, y + 9, z + 3, shield, ms);
        array.setBlock(x + 7, y + 9, z + 4, shield, ms);
        array.setBlock(x + 7, y + 9, z + 5, shield, ms);
        array.setBlock(x + 7, y + 9, z + 6, shield, ms);
        array.setBlock(x + 7, y + 9, z + 7, shield, mg);
        array.setBlock(x + 7, y + 9, z + 8, shield, mg);
        array.setBlock(x + 7, y + 9, z + 9, shield, mg);
        array.setBlock(x + 7, y + 9, z + 10, shield, ms);
        array.setBlock(x + 7, y + 9, z + 11, shield, ms);
        array.setBlock(x + 7, y + 9, z + 12, shield, ms);
        array.setBlock(x + 7, y + 9, z + 13, shield, ms);
        array.setBlock(x + 7, y + 9, z + 14, shield, ms);
        array.setBlock(x + 7, y + 9, z + 15, shield, mc);
        array.setBlock(x + 7, y + 10, z + 2, shield, ms);
        array.setBlock(x + 7, y + 10, z + 3, shield, ms);
        array.setBlock(x + 7, y + 10, z + 4, shield, ms);
        array.setBlock(x + 7, y + 10, z + 7, shield, mg);
        array.setBlock(x + 7, y + 10, z + 8, shield, mg);
        array.setBlock(x + 7, y + 10, z + 9, shield, mg);
        array.setBlock(x + 7, y + 10, z + 12, shield, ms);
        array.setBlock(x + 7, y + 10, z + 13, shield, ms);
        array.setBlock(x + 7, y + 10, z + 14, shield, ms);
        array.setBlock(x + 7, y + 11, z + 3, shield, ms);
        array.setBlock(x + 7, y + 11, z + 4, shield, ms);
        array.setBlock(x + 7, y + 11, z + 7, shield, mg);
        array.setBlock(x + 7, y + 11, z + 8, shield, mg);
        array.setBlock(x + 7, y + 11, z + 9, shield, mg);
        array.setBlock(x + 7, y + 11, z + 12, shield, ms);
        array.setBlock(x + 7, y + 11, z + 13, shield, ms);
        array.setBlock(x + 7, y + 12, z + 3, shield, mc);
        array.setBlock(x + 7, y + 12, z + 4, shield, ms);
        array.setBlock(x + 7, y + 12, z + 5, shield, ms);
        array.setBlock(x + 7, y + 12, z + 6, shield, mc);
        array.setBlock(x + 7, y + 12, z + 7, shield, mg);
        array.setBlock(x + 7, y + 12, z + 8, shield, mg);
        array.setBlock(x + 7, y + 12, z + 9, shield, mg);
        array.setBlock(x + 7, y + 12, z + 10, shield, mc);
        array.setBlock(x + 7, y + 12, z + 11, shield, ms);
        array.setBlock(x + 7, y + 12, z + 12, shield, ms);
        array.setBlock(x + 7, y + 12, z + 13, shield, mc);
        array.setBlock(x + 7, y + 13, z + 6, shield, mc);
        array.setBlock(x + 7, y + 13, z + 10, shield, mc);
        array.setBlock(x + 8, y + 0, z + 4, shield, ms);
        array.setBlock(x + 8, y + 0, z + 5, shield, ms);
        array.setBlock(x + 8, y + 1, z + 3, shield, ms);
        array.setBlock(x + 8, y + 1, z + 4, shield, BlockStructureShield.BlockType.LIGHT.metadata);
        array.setBlock(x + 8, y + 1, z + 5, shield, ms);
        array.setBlock(x + 8, y + 1, z + 6, shield, ms);
        array.setBlock(x + 8, y + 1, z + 7, shield, ms);
        array.setBlock(x + 8, y + 2, z + 3, shield, ms);
        array.setBlock(x + 8, y + 2, z + 8, shield, ms);
        array.setBlock(x + 8, y + 2, z + 9, shield, ms);
        array.setBlock(x + 8, y + 3, z + 3, shield, ms);
        array.setBlock(x + 8, y + 3, z + 4, shield, ms);
        array.setBlock(x + 8, y + 3, z + 9, shield, ms);
        array.setBlock(x + 8, y + 3, z + 10, shield, ms);
        array.setBlock(x + 8, y + 3, z + 11, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 8, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 8, y + 3, z + 13, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 8, y + 3, z + 14, shield, ms);
        array.setBlock(x + 8, y + 4, z + 1, shield, ms);
        array.setBlock(x + 8, y + 4, z + 2, shield, ms);
        array.setBlock(x + 8, y + 4, z + 3, shield, ms);
        array.setBlock(x + 8, y + 4, z + 4, shield, ms);
        array.setBlock(x + 8, y + 4, z + 5, shield, ms);
        array.setBlock(x + 8, y + 4, z + 10, shield, ms);
        array.setBlock(x + 8, y + 4, z + 14, shield, ms);
        array.setBlock(x + 8, y + 4, z + 15, shield, ms);
        array.setBlock(x + 8, y + 5, z + 0, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 8, y + 5, z + 1, b2);
        array.setBlock(x + 8, y + 5, z + 2, b2);
        array.setBlock(x + 8, y + 5, z + 3, b2);
        array.setBlock(x + 8, y + 5, z + 4, b2);
        array.setBlock(x + 8, y + 5, z + 5, b2);
        array.setBlock(x + 8, y + 5, z + 6, shield, ms);
        array.setBlock(x + 8, y + 5, z + 11, b2);
        array.setBlock(x + 8, y + 5, z + 12, b2);
        array.setBlock(x + 8, y + 5, z + 13, b2);
        array.setBlock(x + 8, y + 5, z + 14, b2);
        array.setBlock(x + 8, y + 5, z + 15, b2);
        array.setBlock(x + 8, y + 5, z + 16, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 8, y + 6, z + 6, shield, ms);
        array.setBlock(x + 8, y + 7, z + 6, shield, ms);
        array.setBlock(x + 8, y + 8, z + 1, shield, mc);
        array.setBlock(x + 8, y + 8, z + 6, shield, ms);
        array.setBlock(x + 8, y + 8, z + 15, shield, mc);
        array.setBlock(x + 8, y + 9, z + 1, shield, mc);
        array.setBlock(x + 8, y + 9, z + 2, shield, ms);
        array.setBlock(x + 8, y + 9, z + 3, shield, ms);
        array.setBlock(x + 8, y + 9, z + 4, shield, ms);
        array.setBlock(x + 8, y + 9, z + 5, shield, ms);
        array.setBlock(x + 8, y + 9, z + 6, shield, ms);
        array.setBlock(x + 8, y + 9, z + 7, shield, mg);
        array.setBlock(x + 8, y + 9, z + 8, shield, mg);
        array.setBlock(x + 8, y + 9, z + 9, shield, mg);
        array.setBlock(x + 8, y + 9, z + 10, shield, ms);
        array.setBlock(x + 8, y + 9, z + 11, shield, ms);
        array.setBlock(x + 8, y + 9, z + 12, shield, ms);
        array.setBlock(x + 8, y + 9, z + 13, shield, ms);
        array.setBlock(x + 8, y + 9, z + 14, shield, ms);
        array.setBlock(x + 8, y + 9, z + 15, shield, mc);
        array.setBlock(x + 8, y + 10, z + 2, shield, ms);
        array.setBlock(x + 8, y + 10, z + 3, shield, ms);
        array.setBlock(x + 8, y + 10, z + 7, shield, mg);
        array.setBlock(x + 8, y + 10, z + 8, shield, mg);
        array.setBlock(x + 8, y + 10, z + 9, shield, mg);
        array.setBlock(x + 8, y + 10, z + 13, shield, ms);
        array.setBlock(x + 8, y + 10, z + 14, shield, ms);
        array.setBlock(x + 8, y + 11, z + 3, shield, ms);
        array.setBlock(x + 8, y + 11, z + 4, shield, ms);
        array.setBlock(x + 8, y + 11, z + 7, shield, mg);
        array.setBlock(x + 8, y + 11, z + 8, shield, mg);
        array.setBlock(x + 8, y + 11, z + 9, shield, mg);
        array.setBlock(x + 8, y + 11, z + 12, shield, ms);
        array.setBlock(x + 8, y + 11, z + 13, shield, ms);
        array.setBlock(x + 8, y + 12, z + 3, shield, mc);
        array.setBlock(x + 8, y + 12, z + 4, shield, ms);
        array.setBlock(x + 8, y + 12, z + 5, shield, ms);
        array.setBlock(x + 8, y + 12, z + 6, shield, mc);
        array.setBlock(x + 8, y + 12, z + 7, shield, mg);
        array.setBlock(x + 8, y + 12, z + 8, shield, mg);
        array.setBlock(x + 8, y + 12, z + 9, shield, mg);
        array.setBlock(x + 8, y + 12, z + 10, shield, mc);
        array.setBlock(x + 8, y + 12, z + 11, shield, ms);
        array.setBlock(x + 8, y + 12, z + 12, shield, ms);
        array.setBlock(x + 8, y + 12, z + 13, shield, mc);
        array.setBlock(x + 8, y + 13, z + 6, shield, mc);
        array.setBlock(x + 8, y + 13, z + 10, shield, mc);
        array.setBlock(x + 9, y + 0, z + 5, shield, ms);
        array.setBlock(x + 9, y + 1, z + 4, shield, ms);
        array.setBlock(x + 9, y + 1, z + 5, shield, ms);
        array.setBlock(x + 9, y + 1, z + 6, shield, ms);
        array.setBlock(x + 9, y + 1, z + 7, shield, ms);
        array.setBlock(x + 9, y + 2, z + 3, shield, ms);
        array.setBlock(x + 9, y + 2, z + 4, shield, ms);
        array.setBlock(x + 9, y + 2, z + 8, shield, ms);
        array.setBlock(x + 9, y + 2, z + 9, shield, ms);
        array.setBlock(x + 9, y + 3, z + 3, shield, ms);
        array.setBlock(x + 9, y + 3, z + 4, shield, ms);
        array.setBlock(x + 9, y + 3, z + 9, shield, ms);
        array.setBlock(x + 9, y + 3, z + 10, shield, ms);
        array.setBlock(x + 9, y + 3, z + 11, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 9, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 9, y + 3, z + 13, shield, ms);
        array.setBlock(x + 9, y + 3, z + 14, shield, ms);
        array.setBlock(x + 9, y + 4, z + 2, shield, ms);
        array.setBlock(x + 9, y + 4, z + 3, shield, ms);
        array.setBlock(x + 9, y + 4, z + 4, shield, ms);
        array.setBlock(x + 9, y + 4, z + 5, shield, ms);
        array.setBlock(x + 9, y + 4, z + 10, shield, ms);
        array.setBlock(x + 9, y + 4, z + 13, shield, ms);
        array.setBlock(x + 9, y + 4, z + 14, shield, ms);
        array.setBlock(x + 9, y + 4, z + 15, shield, ms);
        array.setBlock(x + 9, y + 5, z + 0, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 9, y + 5, z + 1, shield, ms);
        array.setBlock(x + 9, y + 5, z + 2, b2);
        array.setBlock(x + 9, y + 5, z + 3, b2);
        array.setBlock(x + 9, y + 5, z + 4, b2);
        array.setBlock(x + 9, y + 5, z + 5, b2);
        array.setBlock(x + 9, y + 5, z + 6, shield, ms);
        array.setBlock(x + 9, y + 5, z + 11, b2);
        array.setBlock(x + 9, y + 5, z + 12, b2);
        array.setBlock(x + 9, y + 5, z + 13, shield, ms);
        array.setBlock(x + 9, y + 5, z + 14, shield, ms);
        array.setBlock(x + 9, y + 5, z + 15, shield, ms);
        array.setBlock(x + 9, y + 5, z + 16, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 9, y + 6, z + 1, shield, mc);
        array.setBlock(x + 9, y + 6, z + 6, shield, ms);
        array.setBlock(x + 9, y + 6, z + 13, shield, ms);
        array.setBlock(x + 9, y + 6, z + 14, shield, ms);
        array.setBlock(x + 9, y + 6, z + 15, shield, mc);
        array.setBlock(x + 9, y + 7, z + 1, shield, mc);
        array.setBlock(x + 9, y + 7, z + 6, shield, ms);
        array.setBlock(x + 9, y + 7, z + 13, shield, ms);
        array.setBlock(x + 9, y + 7, z + 14, shield, ms);
        array.setBlock(x + 9, y + 7, z + 15, shield, mc);
        array.setBlock(x + 9, y + 8, z + 1, shield, mc);
        array.setBlock(x + 9, y + 8, z + 6, shield, ms);
        array.setBlock(x + 9, y + 8, z + 13, shield, ms);
        array.setBlock(x + 9, y + 8, z + 14, shield, ms);
        array.setBlock(x + 9, y + 8, z + 15, shield, mc);
        array.setBlock(x + 9, y + 9, z + 1, shield, mc);
        array.setBlock(x + 9, y + 9, z + 2, shield, ms);
        array.setBlock(x + 9, y + 9, z + 3, shield, ms);
        array.setBlock(x + 9, y + 9, z + 4, shield, ms);
        array.setBlock(x + 9, y + 9, z + 5, shield, ms);
        array.setBlock(x + 9, y + 9, z + 6, shield, ms);
        array.setBlock(x + 9, y + 9, z + 7, shield, mg);
        array.setBlock(x + 9, y + 9, z + 8, shield, mg);
        array.setBlock(x + 9, y + 9, z + 9, shield, mg);
        array.setBlock(x + 9, y + 9, z + 10, shield, ms);
        array.setBlock(x + 9, y + 9, z + 11, shield, ms);
        array.setBlock(x + 9, y + 9, z + 12, shield, ms);
        array.setBlock(x + 9, y + 9, z + 13, shield, ms);
        array.setBlock(x + 9, y + 9, z + 14, shield, ms);
        array.setBlock(x + 9, y + 9, z + 15, shield, mc);
        array.setBlock(x + 9, y + 10, z + 2, shield, ms);
        array.setBlock(x + 9, y + 10, z + 3, shield, ms);
        array.setBlock(x + 9, y + 10, z + 4, shield, ms);
        array.setBlock(x + 9, y + 10, z + 7, shield, mg);
        array.setBlock(x + 9, y + 10, z + 8, shield, mg);
        array.setBlock(x + 9, y + 10, z + 9, shield, mg);
        array.setBlock(x + 9, y + 10, z + 12, shield, ms);
        array.setBlock(x + 9, y + 10, z + 13, shield, ms);
        array.setBlock(x + 9, y + 10, z + 14, shield, ms);
        array.setBlock(x + 9, y + 11, z + 3, shield, ms);
        array.setBlock(x + 9, y + 11, z + 4, shield, ms);
        array.setBlock(x + 9, y + 11, z + 7, shield, mg);
        array.setBlock(x + 9, y + 11, z + 8, shield, mg);
        array.setBlock(x + 9, y + 11, z + 9, shield, mg);
        array.setBlock(x + 9, y + 11, z + 12, shield, ms);
        array.setBlock(x + 9, y + 11, z + 13, shield, ms);
        array.setBlock(x + 9, y + 12, z + 3, shield, mc);
        array.setBlock(x + 9, y + 12, z + 4, shield, ms);
        array.setBlock(x + 9, y + 12, z + 5, shield, ms);
        array.setBlock(x + 9, y + 12, z + 6, shield, mc);
        array.setBlock(x + 9, y + 12, z + 7, shield, mg);
        array.setBlock(x + 9, y + 12, z + 8, shield, mg);
        array.setBlock(x + 9, y + 12, z + 9, shield, mg);
        array.setBlock(x + 9, y + 12, z + 10, shield, mc);
        array.setBlock(x + 9, y + 12, z + 11, shield, ms);
        array.setBlock(x + 9, y + 12, z + 12, shield, ms);
        array.setBlock(x + 9, y + 12, z + 13, shield, mc);
        array.setBlock(x + 9, y + 13, z + 6, shield, mc);
        array.setBlock(x + 9, y + 13, z + 10, shield, mc);
        array.setBlock(x + 10, y + 0, z + 5, shield, ms);
        array.setBlock(x + 10, y + 1, z + 4, shield, ms);
        array.setBlock(x + 10, y + 1, z + 5, shield, BlockStructureShield.BlockType.LIGHT.metadata);
        array.setBlock(x + 10, y + 1, z + 6, shield, ms);
        array.setBlock(x + 10, y + 1, z + 7, shield, ms);
        array.setBlock(x + 10, y + 2, z + 4, shield, ms);
        array.setBlock(x + 10, y + 2, z + 6, shield, ms);
        array.setBlock(x + 10, y + 2, z + 7, shield, ms);
        array.setBlock(x + 10, y + 2, z + 8, shield, ms);
        array.setBlock(x + 10, y + 2, z + 9, shield, ms);
        array.setBlock(x + 10, y + 3, z + 4, shield, ms);
        array.setBlock(x + 10, y + 3, z + 5, shield, ms);
        array.setBlock(x + 10, y + 3, z + 6, shield, ms);
        array.setBlock(x + 10, y + 3, z + 7, shield, ms);
        array.setBlock(x + 10, y + 3, z + 8, shield, ms);
        array.setBlock(x + 10, y + 3, z + 9, shield, ms);
        array.setBlock(x + 10, y + 3, z + 10, shield, ms);
        array.setBlock(x + 10, y + 3, z + 11, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 10, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 10, y + 3, z + 13, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 10, y + 3, z + 14, shield, ms);
        array.setBlock(x + 10, y + 4, z + 2, shield, ms);
        array.setBlock(x + 10, y + 4, z + 3, shield, ms);
        array.setBlock(x + 10, y + 4, z + 4, shield, ms);
        array.setBlock(x + 10, y + 4, z + 5, shield, ms);
        array.setBlock(x + 10, y + 4, z + 6, shield, ms);
        array.setBlock(x + 10, y + 4, z + 7, shield, ms);
        array.setBlock(x + 10, y + 4, z + 8, shield, ms);
        array.setBlock(x + 10, y + 4, z + 9, shield, ms);
        array.setBlock(x + 10, y + 4, z + 10, shield, ms);
        array.setBlock(x + 10, y + 4, z + 14, shield, ms);
        array.setBlock(x + 10, y + 4, z + 15, shield, ms);
        array.setBlock(x + 10, y + 5, z + 0, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 10, y + 5, z + 1, shield, ms);
        array.setBlock(x + 10, y + 5, z + 2, b2);
        array.setBlock(x + 10, y + 5, z + 3, b2);
        array.setBlock(x + 10, y + 5, z + 4, b2);
        array.setBlock(x + 10, y + 5, z + 5, b2);
        array.setBlock(x + 10, y + 5, z + 6, shield, ms);
        array.setBlock(x + 10, y + 5, z + 7, shield, ms);
        array.setBlock(x + 10, y + 5, z + 8, shield, ms);
        array.setBlock(x + 10, y + 5, z + 9, shield, ms);
        array.setBlock(x + 10, y + 5, z + 10, shield, ms);
        array.setBlock(x + 10, y + 5, z + 11, shield, ms);
        array.setBlock(x + 10, y + 5, z + 12, shield, ms);
        array.setBlock(x + 10, y + 5, z + 13, b2);
        array.setBlock(x + 10, y + 5, z + 14, b2);
        array.setBlock(x + 10, y + 5, z + 15, shield, ms);
        array.setBlock(x + 10, y + 5, z + 16, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 10, y + 6, z + 1, shield, mg);
        array.setBlock(x + 10, y + 6, z + 6, shield, ms);
        array.setBlock(x + 10, y + 6, z + 7, shield, ms);
        array.setBlock(x + 10, y + 6, z + 8, shield, ms);
        array.setBlock(x + 10, y + 6, z + 9, shield, ms);
        array.setBlock(x + 10, y + 6, z + 10, shield, ms);
        array.setBlock(x + 10, y + 6, z + 11, shield, ms);
        array.setBlock(x + 10, y + 6, z + 12, shield, ms);
        array.setBlock(x + 10, y + 6, z + 15, shield, mg);
        array.setBlock(x + 10, y + 7, z + 1, shield, mg);
        array.setBlock(x + 10, y + 7, z + 6, shield, ms);
        array.setBlock(x + 10, y + 7, z + 7, shield, ms);
        array.setBlock(x + 10, y + 7, z + 8, shield, ms);
        array.setBlock(x + 10, y + 7, z + 9, shield, ms);
        array.setBlock(x + 10, y + 7, z + 10, shield, ms);
        array.setBlock(x + 10, y + 7, z + 12, shield, ms);
        array.setBlock(x + 10, y + 7, z + 15, shield, mg);
        array.setBlock(x + 10, y + 8, z + 1, shield, mg);
        array.setBlock(x + 10, y + 8, z + 6, shield, ms);
        array.setBlock(x + 10, y + 8, z + 7, shield, ms);
        array.setBlock(x + 10, y + 8, z + 8, shield, ms);
        array.setBlock(x + 10, y + 8, z + 9, shield, ms);
        array.setBlock(x + 10, y + 8, z + 10, shield, ms);
        array.setBlock(x + 10, y + 8, z + 11, shield, ms);
        array.setBlock(x + 10, y + 8, z + 12, shield, ms);
        array.setBlock(x + 10, y + 8, z + 15, shield, mg);
        array.setBlock(x + 10, y + 9, z + 1, shield, mc);
        array.setBlock(x + 10, y + 9, z + 2, shield, ms);
        array.setBlock(x + 10, y + 9, z + 3, shield, ms);
        array.setBlock(x + 10, y + 9, z + 4, shield, ms);
        array.setBlock(x + 10, y + 9, z + 5, shield, ms);
        array.setBlock(x + 10, y + 9, z + 6, shield, ms);
        array.setBlock(x + 10, y + 9, z + 7, shield, ms);
        array.setBlock(x + 10, y + 9, z + 8, shield, ms);
        array.setBlock(x + 10, y + 9, z + 9, shield, ms);
        array.setBlock(x + 10, y + 9, z + 10, shield, ms);
        array.setBlock(x + 10, y + 9, z + 11, shield, ms);
        array.setBlock(x + 10, y + 9, z + 12, shield, ms);
        array.setBlock(x + 10, y + 9, z + 13, shield, ms);
        array.setBlock(x + 10, y + 9, z + 14, shield, ms);
        array.setBlock(x + 10, y + 9, z + 15, shield, mc);
        array.setBlock(x + 10, y + 10, z + 2, shield, ms);
        array.setBlock(x + 10, y + 10, z + 3, shield, ms);
        array.setBlock(x + 10, y + 10, z + 4, shield, ms);
        array.setBlock(x + 10, y + 10, z + 12, shield, ms);
        array.setBlock(x + 10, y + 10, z + 13, shield, ms);
        array.setBlock(x + 10, y + 10, z + 14, shield, ms);
        array.setBlock(x + 10, y + 11, z + 3, shield, ms);
        array.setBlock(x + 10, y + 11, z + 4, shield, ms);
        array.setBlock(x + 10, y + 11, z + 12, shield, ms);
        array.setBlock(x + 10, y + 11, z + 13, shield, ms);
        array.setBlock(x + 10, y + 12, z + 3, shield, mc);
        array.setBlock(x + 10, y + 12, z + 4, shield, ms);
        array.setBlock(x + 10, y + 12, z + 5, shield, mc);
        array.setBlock(x + 10, y + 12, z + 6, shield, mc);
        array.setBlock(x + 10, y + 12, z + 7, shield, mc);
        array.setBlock(x + 10, y + 12, z + 8, shield, mc);
        array.setBlock(x + 10, y + 12, z + 9, shield, mc);
        array.setBlock(x + 10, y + 12, z + 10, shield, mc);
        array.setBlock(x + 10, y + 12, z + 11, shield, mc);
        array.setBlock(x + 10, y + 12, z + 12, shield, ms);
        array.setBlock(x + 10, y + 12, z + 13, shield, mc);
        array.setBlock(x + 10, y + 13, z + 6, shield, mc);
        array.setBlock(x + 10, y + 13, z + 7, shield, mc);
        array.setBlock(x + 10, y + 13, z + 8, shield, mc);
        array.setBlock(x + 10, y + 13, z + 9, shield, mc);
        array.setBlock(x + 10, y + 13, z + 10, shield, mc);
        array.setBlock(x + 10, y + 14, z + 6, shield, mc);
        array.setBlock(x + 10, y + 14, z + 10, shield, mc);
        array.setBlock(x + 11, y + 1, z + 5, shield, ms);
        array.setBlock(x + 11, y + 2, z + 4, shield, ms);
        array.setBlock(x + 11, y + 2, z + 5, shield, ms);
        array.setBlock(x + 11, y + 2, z + 6, shield, ms);
        array.setBlock(x + 11, y + 3, z + 4, shield, ms);
        array.setBlock(x + 11, y + 3, z + 5, shield, ms);
        array.setBlock(x + 11, y + 3, z + 6, shield, ms);
        array.setBlock(x + 11, y + 3, z + 7, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 11, y + 3, z + 8, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 11, y + 3, z + 9, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 11, y + 3, z + 10, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 11, y + 3, z + 11, shield, ms);
        array.setBlock(x + 11, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 11, y + 3, z + 13, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 11, y + 3, z + 14, shield, ms);
        array.setBlock(x + 11, y + 4, z + 2, shield, ms);
        array.setBlock(x + 11, y + 4, z + 3, shield, ms);
        array.setBlock(x + 11, y + 4, z + 4, shield, ms);
        array.setBlock(x + 11, y + 4, z + 5, shield, ms);
        array.setBlock(x + 11, y + 4, z + 6, shield, ms);
        array.setBlock(x + 11, y + 4, z + 11, shield, ms);
        array.setBlock(x + 11, y + 4, z + 14, shield, ms);
        array.setBlock(x + 11, y + 4, z + 15, shield, ms);
        array.setBlock(x + 11, y + 5, z + 1, shield, ms);
        array.setBlock(x + 11, y + 5, z + 2, b2);
        array.setBlock(x + 11, y + 5, z + 3, b2);
        array.setBlock(x + 11, y + 5, z + 4, b2);
        array.setBlock(x + 11, y + 5, z + 5, shield, ms);
        array.setBlock(x + 11, y + 5, z + 6, shield, ms);
        array.setBlock(x + 11, y + 5, z + 7, b2);
        array.setBlock(x + 11, y + 5, z + 8, b2);
        array.setBlock(x + 11, y + 5, z + 9, b2);
        array.setBlock(x + 11, y + 5, z + 10, b2);
        array.setBlock(x + 11, y + 5, z + 11, shield, ms);
        array.setBlock(x + 11, y + 5, z + 12, b2);
        array.setBlock(x + 11, y + 5, z + 13, b2);
        array.setBlock(x + 11, y + 5, z + 14, b2);
        array.setBlock(x + 11, y + 5, z + 15, shield, ms);
        array.setBlock(x + 11, y + 6, z + 1, shield, mg);
        array.setBlock(x + 11, y + 6, z + 5, shield, ms);
        array.setBlock(x + 11, y + 6, z + 6, shield, ms);
        array.setBlock(x + 11, y + 6, z + 11, shield, ms);
        array.setBlock(x + 11, y + 6, z + 15, shield, mg);
        array.setBlock(x + 11, y + 7, z + 1, shield, mg);
        array.setBlock(x + 11, y + 7, z + 5, shield, BlockStructureShield.BlockType.LIGHT.metadata);
        array.setBlock(x + 11, y + 7, z + 11, shield, BlockStructureShield.BlockType.LIGHT.metadata);
        array.setBlock(x + 11, y + 7, z + 15, shield, mg);
        array.setBlock(x + 11, y + 8, z + 1, shield, mg);
        array.setBlock(x + 11, y + 8, z + 5, shield, ms);
        array.setBlock(x + 11, y + 8, z + 6, shield, ms);
        array.setBlock(x + 11, y + 8, z + 11, shield, ms);
        array.setBlock(x + 11, y + 8, z + 15, shield, mg);
        array.setBlock(x + 11, y + 9, z + 1, shield, mc);
        array.setBlock(x + 11, y + 9, z + 2, shield, ms);
        array.setBlock(x + 11, y + 9, z + 3, shield, ms);
        array.setBlock(x + 11, y + 9, z + 4, shield, ms);
        array.setBlock(x + 11, y + 9, z + 5, shield, ms);
        array.setBlock(x + 11, y + 9, z + 6, shield, ms);
        array.setBlock(x + 11, y + 9, z + 7, shield, ms);
        array.setBlock(x + 11, y + 9, z + 8, shield, ms);
        array.setBlock(x + 11, y + 9, z + 9, shield, ms);
        array.setBlock(x + 11, y + 9, z + 10, shield, ms);
        array.setBlock(x + 11, y + 9, z + 11, shield, ms);
        array.setBlock(x + 11, y + 9, z + 12, shield, ms);
        array.setBlock(x + 11, y + 9, z + 13, shield, ms);
        array.setBlock(x + 11, y + 9, z + 14, shield, ms);
        array.setBlock(x + 11, y + 9, z + 15, shield, mc);
        array.setBlock(x + 11, y + 10, z + 1, shield, mc);
        array.setBlock(x + 11, y + 10, z + 2, shield, mc);
        array.setBlock(x + 11, y + 10, z + 3, shield, mc);
        array.setBlock(x + 11, y + 10, z + 4, shield, ms);
        array.setBlock(x + 11, y + 10, z + 5, shield, ms);
        array.setBlock(x + 11, y + 10, z + 11, shield, ms);
        array.setBlock(x + 11, y + 10, z + 12, shield, ms);
        array.setBlock(x + 11, y + 10, z + 13, shield, mc);
        array.setBlock(x + 11, y + 10, z + 14, shield, mc);
        array.setBlock(x + 11, y + 10, z + 15, shield, mc);
        array.setBlock(x + 11, y + 11, z + 3, shield, mc);
        array.setBlock(x + 11, y + 11, z + 4, shield, ms);
        array.setBlock(x + 11, y + 11, z + 5, shield, ms);
        array.setBlock(x + 11, y + 11, z + 11, shield, ms);
        array.setBlock(x + 11, y + 11, z + 12, shield, ms);
        array.setBlock(x + 11, y + 11, z + 13, shield, mc);
        array.setBlock(x + 11, y + 12, z + 3, shield, mc);
        array.setBlock(x + 11, y + 12, z + 4, shield, mc);
        array.setBlock(x + 11, y + 12, z + 5, shield, mc);
        array.setBlock(x + 11, y + 12, z + 6, shield, mc);
        array.setBlock(x + 11, y + 12, z + 7, shield, ms);
        array.setBlock(x + 11, y + 12, z + 8, shield, ms);
        array.setBlock(x + 11, y + 12, z + 9, shield, ms);
        array.setBlock(x + 11, y + 12, z + 10, shield, mc);
        array.setBlock(x + 11, y + 12, z + 11, shield, mc);
        array.setBlock(x + 11, y + 12, z + 12, shield, mc);
        array.setBlock(x + 11, y + 12, z + 13, shield, mc);
        array.setBlock(x + 11, y + 13, z + 3, shield, mc);
        array.setBlock(x + 11, y + 13, z + 13, shield, mc);
        array.setBlock(x + 12, y + 3, z + 6, shield, ms);
        array.setBlock(x + 12, y + 3, z + 7, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 12, y + 3, z + 8, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 12, y + 3, z + 9, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 12, y + 3, z + 10, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 12, y + 3, z + 11, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 12, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 12, y + 3, z + 13, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 12, y + 3, z + 14, shield, ms);
        array.setBlock(x + 12, y + 4, z + 2, shield, ms);
        array.setBlock(x + 12, y + 4, z + 3, shield, ms);
        array.setBlock(x + 12, y + 4, z + 4, shield, ms);
        array.setBlock(x + 12, y + 4, z + 5, shield, ms);
        array.setBlock(x + 12, y + 4, z + 6, shield, ms);
        array.setBlock(x + 12, y + 4, z + 14, shield, ms);
        array.setBlock(x + 12, y + 4, z + 15, shield, ms);
        array.setBlock(x + 12, y + 5, z + 1, shield, ms);
        array.setBlock(x + 12, y + 5, z + 2, b2);
        array.setBlock(x + 12, y + 5, z + 3, b2);
        array.setBlock(x + 12, y + 5, z + 4, b2);
        array.setBlock(x + 12, y + 5, z + 5, b2);
        array.setBlock(x + 12, y + 5, z + 6, shield, ms);
        array.setBlock(x + 12, y + 5, z + 7, b2);
        array.setBlock(x + 12, y + 5, z + 8, b2);
        array.setBlock(x + 12, y + 5, z + 9, b2);
        array.setBlock(x + 12, y + 5, z + 10, b2);
        array.setBlock(x + 12, y + 5, z + 11, b2);
        array.setBlock(x + 12, y + 5, z + 12, b2);
        array.setBlock(x + 12, y + 5, z + 13, b2);
        array.setBlock(x + 12, y + 5, z + 14, b2);
        array.setBlock(x + 12, y + 5, z + 15, shield, ms);
        array.setBlock(x + 12, y + 6, z + 1, shield, mg);
        array.setBlock(x + 12, y + 6, z + 6, shield, ms);
        array.setBlock(x + 12, y + 6, z + 15, shield, mg);
        array.setBlock(x + 12, y + 7, z + 1, shield, mg);
        array.setBlock(x + 12, y + 7, z + 6, shield, ms);
        array.setBlock(x + 12, y + 7, z + 15, shield, mg);
        array.setBlock(x + 12, y + 8, z + 1, shield, mg);
        array.setBlock(x + 12, y + 8, z + 6, shield, ms);
        array.setBlock(x + 12, y + 8, z + 15, shield, mg);
        array.setBlock(x + 12, y + 9, z + 1, shield, mc);
        array.setBlock(x + 12, y + 9, z + 2, shield, ms);
        array.setBlock(x + 12, y + 9, z + 3, shield, ms);
        array.setBlock(x + 12, y + 9, z + 4, shield, ms);
        array.setBlock(x + 12, y + 9, z + 5, shield, ms);
        array.setBlock(x + 12, y + 9, z + 6, shield, ms);
        array.setBlock(x + 12, y + 9, z + 7, shield, ms);
        array.setBlock(x + 12, y + 9, z + 8, shield, ms);
        array.setBlock(x + 12, y + 9, z + 9, shield, ms);
        array.setBlock(x + 12, y + 9, z + 10, shield, ms);
        array.setBlock(x + 12, y + 9, z + 11, shield, ms);
        array.setBlock(x + 12, y + 9, z + 12, shield, ms);
        array.setBlock(x + 12, y + 9, z + 13, shield, ms);
        array.setBlock(x + 12, y + 9, z + 14, shield, ms);
        array.setBlock(x + 12, y + 9, z + 15, shield, mc);
        array.setBlock(x + 12, y + 10, z + 5, shield, ms);
        array.setBlock(x + 12, y + 10, z + 6, shield, ms);
        array.setBlock(x + 12, y + 10, z + 7, shield, ms);
        array.setBlock(x + 12, y + 10, z + 9, shield, ms);
        array.setBlock(x + 12, y + 10, z + 10, shield, ms);
        array.setBlock(x + 12, y + 10, z + 11, shield, ms);
        array.setBlock(x + 12, y + 11, z + 5, shield, ms);
        array.setBlock(x + 12, y + 11, z + 6, shield, ms);
        array.setBlock(x + 12, y + 11, z + 7, shield, ms);
        array.setBlock(x + 12, y + 11, z + 8, shield, ms);
        array.setBlock(x + 12, y + 11, z + 9, shield, ms);
        array.setBlock(x + 12, y + 11, z + 10, shield, ms);
        array.setBlock(x + 12, y + 11, z + 11, shield, ms);
        array.setBlock(x + 12, y + 12, z + 5, shield, mc);
        array.setBlock(x + 12, y + 12, z + 6, shield, ms);
        array.setBlock(x + 12, y + 12, z + 7, shield, ms);
        array.setBlock(x + 12, y + 12, z + 8, shield, ms);
        array.setBlock(x + 12, y + 12, z + 9, shield, ms);
        array.setBlock(x + 12, y + 12, z + 10, shield, ms);
        array.setBlock(x + 12, y + 12, z + 11, shield, mc);
        array.setBlock(x + 13, y + 3, z + 6, shield, ms);
        array.setBlock(x + 13, y + 3, z + 7, shield, ms);
        array.setBlock(x + 13, y + 3, z + 8, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 13, y + 3, z + 9, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 13, y + 3, z + 10, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 13, y + 3, z + 11, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 13, y + 3, z + 12, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 13, y + 3, z + 13, shield, BlockStructureShield.BlockType.CLOAK.metadata);
        array.setBlock(x + 13, y + 3, z + 14, shield, ms);
        array.setBlock(x + 13, y + 4, z + 2, shield, ms);
        array.setBlock(x + 13, y + 4, z + 3, shield, ms);
        array.setBlock(x + 13, y + 4, z + 4, shield, ms);
        array.setBlock(x + 13, y + 4, z + 5, shield, ms);
        array.setBlock(x + 13, y + 4, z + 6, shield, ms);
        array.setBlock(x + 13, y + 4, z + 7, shield, ms);
        array.setBlock(x + 13, y + 4, z + 14, shield, ms);
        array.setBlock(x + 13, y + 4, z + 15, shield, ms);
        array.setBlock(x + 13, y + 5, z + 1, shield, ms);
        array.setBlock(x + 13, y + 5, z + 2, b2);
        array.setBlock(x + 13, y + 5, z + 3, b2);
        array.setBlock(x + 13, y + 5, z + 4, b2);
        array.setBlock(x + 13, y + 5, z + 5, b2);
        array.setBlock(x + 13, y + 5, z + 6, b2);
        array.setBlock(x + 13, y + 5, z + 7, shield, ms);
        array.setBlock(x + 13, y + 5, z + 8, b2);
        array.setBlock(x + 13, y + 5, z + 9, b2);
        array.setBlock(x + 13, y + 5, z + 10, b2);
        array.setBlock(x + 13, y + 5, z + 11, b2);
        array.setBlock(x + 13, y + 5, z + 12, b2);
        array.setBlock(x + 13, y + 5, z + 13, b2);
        array.setBlock(x + 13, y + 5, z + 14, b2);
        array.setBlock(x + 13, y + 5, z + 15, shield, ms);
        array.setBlock(x + 13, y + 6, z + 1, shield, mc);
        array.setBlock(x + 13, y + 6, z + 7, shield, ms);
        array.setBlock(x + 13, y + 6, z + 15, shield, mc);
        array.setBlock(x + 13, y + 7, z + 1, shield, mc);
        array.setBlock(x + 13, y + 7, z + 7, shield, ms);
        array.setBlock(x + 13, y + 7, z + 15, shield, mc);
        array.setBlock(x + 13, y + 8, z + 1, shield, mc);
        array.setBlock(x + 13, y + 8, z + 7, shield, ms);
        array.setBlock(x + 13, y + 8, z + 15, shield, mc);
        array.setBlock(x + 13, y + 9, z + 1, shield, mc);
        array.setBlock(x + 13, y + 9, z + 2, shield, mc);
        array.setBlock(x + 13, y + 9, z + 3, shield, ms);
        array.setBlock(x + 13, y + 9, z + 4, shield, ms);
        array.setBlock(x + 13, y + 9, z + 5, shield, ms);
        array.setBlock(x + 13, y + 9, z + 6, shield, ms);
        array.setBlock(x + 13, y + 9, z + 7, shield, ms);
        array.setBlock(x + 13, y + 9, z + 8, shield, ms);
        array.setBlock(x + 13, y + 9, z + 9, shield, ms);
        array.setBlock(x + 13, y + 9, z + 10, shield, ms);
        array.setBlock(x + 13, y + 9, z + 11, shield, ms);
        array.setBlock(x + 13, y + 9, z + 12, shield, ms);
        array.setBlock(x + 13, y + 9, z + 13, shield, ms);
        array.setBlock(x + 13, y + 9, z + 14, shield, mc);
        array.setBlock(x + 13, y + 9, z + 15, shield, mc);
        array.setBlock(x + 13, y + 10, z + 1, shield, mc);
        array.setBlock(x + 13, y + 10, z + 5, shield, mc);
        array.setBlock(x + 13, y + 10, z + 6, shield, ms);
        array.setBlock(x + 13, y + 10, z + 7, shield, ms);
        array.setBlock(x + 13, y + 10, z + 8, shield, ms);
        array.setBlock(x + 13, y + 10, z + 9, shield, ms);
        array.setBlock(x + 13, y + 10, z + 10, shield, ms);
        array.setBlock(x + 13, y + 10, z + 11, shield, mc);
        array.setBlock(x + 13, y + 10, z + 15, shield, mc);
        array.setBlock(x + 13, y + 11, z + 5, shield, mc);
        array.setBlock(x + 13, y + 11, z + 6, shield, ms);
        array.setBlock(x + 13, y + 11, z + 7, shield, ms);
        array.setBlock(x + 13, y + 11, z + 8, shield, ms);
        array.setBlock(x + 13, y + 11, z + 9, shield, ms);
        array.setBlock(x + 13, y + 11, z + 10, shield, ms);
        array.setBlock(x + 13, y + 11, z + 11, shield, mc);
        array.setBlock(x + 13, y + 12, z + 5, shield, mc);
        array.setBlock(x + 13, y + 12, z + 6, shield, mc);
        array.setBlock(x + 13, y + 12, z + 7, shield, mc);
        array.setBlock(x + 13, y + 12, z + 8, shield, mc);
        array.setBlock(x + 13, y + 12, z + 9, shield, mc);
        array.setBlock(x + 13, y + 12, z + 10, shield, mc);
        array.setBlock(x + 13, y + 12, z + 11, shield, mc);
        array.setBlock(x + 13, y + 13, z + 5, shield, mc);
        array.setBlock(x + 13, y + 13, z + 11, shield, mc);
        array.setBlock(x + 14, y + 3, z + 7, shield, ms);
        array.setBlock(x + 14, y + 3, z + 8, shield, ms);
        array.setBlock(x + 14, y + 3, z + 9, shield, ms);
        array.setBlock(x + 14, y + 3, z + 10, shield, ms);
        array.setBlock(x + 14, y + 3, z + 11, shield, ms);
        array.setBlock(x + 14, y + 3, z + 12, shield, ms);
        array.setBlock(x + 14, y + 3, z + 13, shield, ms);
        array.setBlock(x + 14, y + 3, z + 14, shield, ms);
        array.setBlock(x + 14, y + 4, z + 3, shield, ms);
        array.setBlock(x + 14, y + 4, z + 4, shield, ms);
        array.setBlock(x + 14, y + 4, z + 5, shield, ms);
        array.setBlock(x + 14, y + 4, z + 6, shield, ms);
        array.setBlock(x + 14, y + 4, z + 7, shield, ms);
        array.setBlock(x + 14, y + 4, z + 8, shield, ms);
        array.setBlock(x + 14, y + 4, z + 9, shield, ms);
        array.setBlock(x + 14, y + 4, z + 10, shield, ms);
        array.setBlock(x + 14, y + 4, z + 11, shield, ms);
        array.setBlock(x + 14, y + 4, z + 12, shield, ms);
        array.setBlock(x + 14, y + 4, z + 13, shield, ms);
        array.setBlock(x + 14, y + 4, z + 15, shield, ms);
        array.setBlock(x + 14, y + 5, z + 2, shield, ms);
        array.setBlock(x + 14, y + 5, z + 3, b2);
        array.setBlock(x + 14, y + 5, z + 4, b2);
        array.setBlock(x + 14, y + 5, z + 5, b2);
        array.setBlock(x + 14, y + 5, z + 6, b2);
        array.setBlock(x + 14, y + 5, z + 7, shield, ms);
        array.setBlock(x + 14, y + 5, z + 8, b2);
        array.setBlock(x + 14, y + 5, z + 9, b2);
        array.setBlock(x + 14, y + 5, z + 10, b2);
        array.setBlock(x + 14, y + 5, z + 11, b2);
        array.setBlock(x + 14, y + 5, z + 12, b2);
        array.setBlock(x + 14, y + 5, z + 13, b2);
        array.setBlock(x + 14, y + 5, z + 14, shield, ms);
        array.setBlock(x + 14, y + 6, z + 2, shield, ms);
        array.setBlock(x + 14, y + 6, z + 7, shield, ms);
        array.setBlock(x + 14, y + 6, z + 14, shield, ms);
        array.setBlock(x + 14, y + 7, z + 2, shield, ms);
        array.setBlock(x + 14, y + 7, z + 7, shield, ms);
        array.setBlock(x + 14, y + 7, z + 14, shield, ms);
        array.setBlock(x + 14, y + 8, z + 2, shield, ms);
        array.setBlock(x + 14, y + 8, z + 7, shield, ms);
        array.setBlock(x + 14, y + 8, z + 14, shield, ms);
        array.setBlock(x + 14, y + 9, z + 2, shield, mc);
        array.setBlock(x + 14, y + 9, z + 3, shield, mc);
        array.setBlock(x + 14, y + 9, z + 4, shield, ms);
        array.setBlock(x + 14, y + 9, z + 5, shield, ms);
        array.setBlock(x + 14, y + 9, z + 6, shield, ms);
        array.setBlock(x + 14, y + 9, z + 7, shield, ms);
        array.setBlock(x + 14, y + 9, z + 8, shield, ms);
        array.setBlock(x + 14, y + 9, z + 9, shield, ms);
        array.setBlock(x + 14, y + 9, z + 10, shield, ms);
        array.setBlock(x + 14, y + 9, z + 11, shield, ms);
        array.setBlock(x + 14, y + 9, z + 12, shield, ms);
        array.setBlock(x + 14, y + 9, z + 13, shield, mc);
        array.setBlock(x + 14, y + 9, z + 14, shield, mc);
        array.setBlock(x + 14, y + 10, z + 5, shield, mc);
        array.setBlock(x + 14, y + 10, z + 6, shield, ms);
        array.setBlock(x + 14, y + 10, z + 7, shield, ms);
        array.setBlock(x + 14, y + 10, z + 8, shield, ms);
        array.setBlock(x + 14, y + 10, z + 9, shield, ms);
        array.setBlock(x + 14, y + 10, z + 10, shield, ms);
        array.setBlock(x + 14, y + 10, z + 11, shield, mc);
        array.setBlock(x + 15, y + 4, z + 8, shield, ms);
        array.setBlock(x + 15, y + 4, z + 9, shield, ms);
        array.setBlock(x + 15, y + 4, z + 10, shield, ms);
        array.setBlock(x + 15, y + 4, z + 11, shield, ms);
        array.setBlock(x + 15, y + 4, z + 12, shield, ms);
        array.setBlock(x + 15, y + 4, z + 13, shield, ms);
        array.setBlock(x + 15, y + 4, z + 14, shield, ms);
        array.setBlock(x + 15, y + 5, z + 3, shield, ms);
        array.setBlock(x + 15, y + 5, z + 4, shield, ms);
        array.setBlock(x + 15, y + 5, z + 5, shield, ms);
        array.setBlock(x + 15, y + 5, z + 6, shield, ms);
        array.setBlock(x + 15, y + 5, z + 7, shield, ms);
        array.setBlock(x + 15, y + 5, z + 8, b2);
        array.setBlock(x + 15, y + 5, z + 9, shield, ms);
        array.setBlock(x + 15, y + 5, z + 10, shield, ms);
        array.setBlock(x + 15, y + 5, z + 11, shield, ms);
        array.setBlock(x + 15, y + 5, z + 12, shield, ms);
        array.setBlock(x + 15, y + 5, z + 13, shield, ms);
        array.setBlock(x + 15, y + 6, z + 3, shield, mc);
        array.setBlock(x + 15, y + 6, z + 4, shield, mg);
        array.setBlock(x + 15, y + 6, z + 5, shield, mg);
        array.setBlock(x + 15, y + 6, z + 6, shield, mg);
        array.setBlock(x + 15, y + 6, z + 7, shield, mc);
        array.setBlock(x + 15, y + 6, z + 9, shield, mc);
        array.setBlock(x + 15, y + 6, z + 10, shield, mg);
        array.setBlock(x + 15, y + 6, z + 11, shield, mg);
        array.setBlock(x + 15, y + 6, z + 12, shield, mg);
        array.setBlock(x + 15, y + 6, z + 13, shield, mc);
        array.setBlock(x + 15, y + 7, z + 3, shield, mc);
        array.setBlock(x + 15, y + 7, z + 4, shield, mg);
        array.setBlock(x + 15, y + 7, z + 5, shield, mg);
        array.setBlock(x + 15, y + 7, z + 6, shield, mg);
        array.setBlock(x + 15, y + 7, z + 7, shield, mc);
        array.setBlock(x + 15, y + 7, z + 9, shield, mc);
        array.setBlock(x + 15, y + 7, z + 10, shield, mg);
        array.setBlock(x + 15, y + 7, z + 11, shield, mg);
        array.setBlock(x + 15, y + 7, z + 12, shield, mg);
        array.setBlock(x + 15, y + 7, z + 13, shield, mc);
        array.setBlock(x + 15, y + 8, z + 3, shield, mc);
        array.setBlock(x + 15, y + 8, z + 4, shield, mg);
        array.setBlock(x + 15, y + 8, z + 5, shield, mg);
        array.setBlock(x + 15, y + 8, z + 6, shield, mg);
        array.setBlock(x + 15, y + 8, z + 7, shield, mc);
        array.setBlock(x + 15, y + 8, z + 8, shield, mc);
        array.setBlock(x + 15, y + 8, z + 9, shield, mc);
        array.setBlock(x + 15, y + 8, z + 10, shield, mg);
        array.setBlock(x + 15, y + 8, z + 11, shield, mg);
        array.setBlock(x + 15, y + 8, z + 12, shield, mg);
        array.setBlock(x + 15, y + 8, z + 13, shield, mc);
        array.setBlock(x + 15, y + 9, z + 3, shield, mc);
        array.setBlock(x + 15, y + 9, z + 4, shield, mc);
        array.setBlock(x + 15, y + 9, z + 5, shield, mc);
        array.setBlock(x + 15, y + 9, z + 6, shield, mc);
        array.setBlock(x + 15, y + 9, z + 7, shield, mc);
        array.setBlock(x + 15, y + 9, z + 8, shield, mc);
        array.setBlock(x + 15, y + 9, z + 9, shield, mc);
        array.setBlock(x + 15, y + 9, z + 10, shield, mc);
        array.setBlock(x + 15, y + 9, z + 11, shield, mc);
        array.setBlock(x + 15, y + 9, z + 12, shield, mc);
        array.setBlock(x + 15, y + 9, z + 13, shield, mc);
        array.setBlock(x + 15, y + 10, z + 3, shield, mc);
        array.setBlock(x + 15, y + 10, z + 5, shield, mc);
        array.setBlock(x + 15, y + 10, z + 11, shield, mc);
        array.setBlock(x + 15, y + 10, z + 13, shield, mc);
        array.setBlock(x + 16, y + 5, z + 6, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 16, y + 5, z + 7, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 16, y + 5, z + 8, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 16, y + 5, z + 9, shield, BlockStructureShield.BlockType.MOSS.metadata);
        array.setBlock(x + 16, y + 5, z + 10, shield, BlockStructureShield.BlockType.MOSS.metadata);
        this.addLootChest(array, x + 12, y + 10, z + 8, 0);
        this.addLootChest(array, x + 11, y + 7, z + 6, 3);
        this.addLootChest(array, x + 10, y + 7, z + 11, 0);
        this.addLootChest(array, x + 10, y + 2, z + 5, 0);
        this.addLootChest(array, x + 4, y + 10, z + 8, 1);
        this.addLootChest(array, x + 5, y + 7, z + 10, 2);
        this.addLootChest(array, x + 6, y + 2, z + 5, 1);
        this.addLootChest(array, x + 6, y + 7, z + 5, 1);
        this.addLootChest(array, x + 8, y + 2, z + 4, 3);
        this.addLootChest(array, x + 8, y + 10, z + 4, 3);
        this.addLootChest(array, x + 8, y + 10, z + 12, 2);
    }

    private void getAirSpaces(FilledBlockArray array, int x, int y, int z) {
        array.setBlock(x + 1, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 1, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 2, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 4, z + 5, (BlockCheck)this.getLava());
        array.setBlock(x + 3, y + 4, z + 6, (BlockCheck)this.getLava());
        array.setBlock(x + 3, y + 4, z + 7, (BlockCheck)this.getLava());
        array.setBlock(x + 3, y + 4, z + 8, (BlockCheck)this.getLava());
        array.setBlock(x + 3, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 3, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 4, z + 5, (BlockCheck)this.getLava());
        array.setBlock(x + 4, y + 4, z + 6, (BlockCheck)this.getLava());
        array.setBlock(x + 4, y + 4, z + 7, (BlockCheck)this.getLava());
        array.setBlock(x + 4, y + 4, z + 8, (BlockCheck)this.getLava());
        array.setBlock(x + 4, y + 4, z + 9, (BlockCheck)this.getLava());
        array.setBlock(x + 4, y + 4, z + 10, (BlockCheck)this.getLava());
        array.setBlock(x + 4, y + 4, z + 11, (BlockCheck)this.getLava());
        array.setBlock(x + 4, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 4, y + 4, z + 13, (BlockCheck)this.getLava());
        array.setBlock(x + 4, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 4, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 4, z + 6, (BlockCheck)this.getLava());
        array.setBlock(x + 5, y + 4, z + 7, (BlockCheck)this.getLava());
        array.setBlock(x + 5, y + 4, z + 8, (BlockCheck)this.getLava());
        array.setBlock(x + 5, y + 4, z + 9, (BlockCheck)this.getLava());
        array.setBlock(x + 5, y + 4, z + 10, (BlockCheck)this.getLava());
        array.setBlock(x + 5, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 5, y + 4, z + 13, (BlockCheck)this.getLava());
        array.setBlock(x + 5, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 10, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 10, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 10, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 10, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 10, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 11, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 11, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 11, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 11, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 5, y + 11, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 4, z + 11, (BlockCheck)this.getLava());
        array.setBlock(x + 6, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 6, y + 4, z + 13, (BlockCheck)this.getLava());
        array.setBlock(x + 6, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 10, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 10, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 10, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 10, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 10, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 10, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 10, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 11, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 11, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 11, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 11, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 11, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 11, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 6, y + 11, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 2, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 2, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 2, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 3, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 3, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 3, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 3, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 4, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 4, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 4, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 4, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 4, z + 11, (BlockCheck)this.getLava());
        array.setBlock(x + 7, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 7, y + 4, z + 13, (BlockCheck)this.getLava());
        array.setBlock(x + 7, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 6, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 6, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 10, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 10, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 10, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 10, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 11, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 11, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 11, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 7, y + 11, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 2, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 2, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 2, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 3, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 3, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 3, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 4, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 4, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 4, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 4, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 4, z + 11, (BlockCheck)this.getLava());
        array.setBlock(x + 8, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 8, y + 4, z + 13, (BlockCheck)this.getLava());
        array.setBlock(x + 8, y + 6, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 6, z + 15, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 1, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 7, z + 15, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 10, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 10, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 10, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 10, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 11, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 11, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 11, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 8, y + 11, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 2, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 2, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 2, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 3, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 3, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 3, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 3, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 4, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 4, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 4, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 4, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 4, z + 11, (BlockCheck)this.getLava());
        array.setBlock(x + 9, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 9, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 6, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 6, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 7, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 7, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 8, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 8, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 10, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 10, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 10, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 10, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 11, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 11, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 11, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 9, y + 11, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 4, z + 11, (BlockCheck)this.getLava());
        array.setBlock(x + 10, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 10, y + 4, z + 13, (BlockCheck)this.getLava());
        array.setBlock(x + 10, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 10, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 10, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 10, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 10, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 10, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 10, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 10, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 11, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 11, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 11, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 11, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 11, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 11, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 10, y + 11, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 4, z + 7, (BlockCheck)this.getLava());
        array.setBlock(x + 11, y + 4, z + 8, (BlockCheck)this.getLava());
        array.setBlock(x + 11, y + 4, z + 9, (BlockCheck)this.getLava());
        array.setBlock(x + 11, y + 4, z + 10, (BlockCheck)this.getLava());
        array.setBlock(x + 11, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 11, y + 4, z + 13, (BlockCheck)this.getLava());
        array.setBlock(x + 11, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 6, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 6, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 6, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 10, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 10, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 10, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 10, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 10, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 11, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 11, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 11, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 11, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 11, y + 11, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 4, z + 7, (BlockCheck)this.getLava());
        array.setBlock(x + 12, y + 4, z + 8, (BlockCheck)this.getLava());
        array.setBlock(x + 12, y + 4, z + 9, (BlockCheck)this.getLava());
        array.setBlock(x + 12, y + 4, z + 10, (BlockCheck)this.getLava());
        array.setBlock(x + 12, y + 4, z + 11, (BlockCheck)this.getLava());
        array.setBlock(x + 12, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 12, y + 4, z + 13, (BlockCheck)this.getLava());
        array.setBlock(x + 12, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 7, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 12, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 4, z + 8, (BlockCheck)this.getLava());
        array.setBlock(x + 13, y + 4, z + 9, (BlockCheck)this.getLava());
        array.setBlock(x + 13, y + 4, z + 10, (BlockCheck)this.getLava());
        array.setBlock(x + 13, y + 4, z + 11, (BlockCheck)this.getLava());
        array.setBlock(x + 13, y + 4, z + 12, (BlockCheck)this.getLava());
        array.setBlock(x + 13, y + 4, z + 13, (BlockCheck)this.getLava());
        array.setBlock(x + 13, y + 6, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 6, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 7, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 2, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 13, y + 8, z + 14, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 6, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 7, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 3, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 4, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 5, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 6, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 9, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 10, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 11, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 12, Blocks.field_150350_a);
        array.setBlock(x + 14, y + 8, z + 13, Blocks.field_150350_a);
        array.setBlock(x + 15, y + 6, z + 8, Blocks.field_150350_a);
        array.setBlock(x + 15, y + 7, z + 8, Blocks.field_150350_a);
    }

    private BlockKey getLava() {
        if (ModList.GEOSTRATA.isLoaded()) {
            return this.getLavaRock();
        }
        return new BlockKey(Blocks.field_150353_l, 0);
    }

    @DependentMethodStripper.ModDependent(value={ModList.GEOSTRATA})
    private BlockKey getLavaRock() {
        return new BlockKey(GeoBlocks.LAVAROCK.getBlockInstance(), 0 | BlockLavaRock.Flags.NONREPLACEABLE.flag());
    }

    @Override
    public int getStructureVersion() {
        return 0;
    }

    @Override
    public int getChestYield(Coordinate c, BlockLootChest.TileEntityLootChest te, FilledBlockArray arr, Random r) {
        return c.yCoord - arr.getMinY() < 4 ? 2 : 1;
    }

    @Override
    public String getChestLootTable(Coordinate c, BlockLootChest.TileEntityLootChest te, FilledBlockArray arr, Random r) {
        return "strongholdCorridor";
    }

    @Override
    public float getFragmentChance(BlockLootChest.TileEntityLootChest te, String s, int bonus, Random r) {
        return bonus > 1 ? 0.875f : 0.7f;
    }
}

