/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.Auxiliary.Interfaces.SidedBlock;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockAttachableMini
extends Block
implements SidedBlock {
    public BlockAttachableMini(Material mat) {
        super(mat);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
        this.field_149762_H = new Block.SoundType("stone", 1.0f, 0.5f);
        this.setBounds(ForgeDirection.EAST);
    }

    public final int getLightValue(IBlockAccess iba, int x, int y, int z) {
        return ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)this.getColor(iba, x, y, z), (int)7) : 7;
    }

    public final int func_149692_a(int meta) {
        return meta & 0xFFFFFFF8;
    }

    public final Item func_149650_a(int dmg, Random r, int fortune) {
        return super.func_149650_a(dmg, r, fortune);
    }

    @Override
    public final boolean canPlaceOn(World world, int x, int y, int z, int side) {
        ForgeDirection dir;
        Block b = world.func_147439_a(x, y, z);
        if (b.isSideSolid((IBlockAccess)world, x, y, z, dir = ForgeDirection.VALID_DIRECTIONS[side])) {
            return true;
        }
        if (b.func_149688_o().func_76220_a()) {
            b.func_149719_a((IBlockAccess)world, x, y, z);
            switch (dir) {
                case DOWN: {
                    if (b.func_149665_z() != 0.0) break;
                    return true;
                }
                case UP: {
                    if (b.func_149669_A() != 1.0) break;
                    return true;
                }
                case EAST: {
                    if (b.func_149704_x() != 0.0) break;
                    return true;
                }
                case WEST: {
                    if (b.func_149753_y() != 1.0) break;
                    return true;
                }
                case NORTH: {
                    if (b.func_149706_B() != 0.0) break;
                    return true;
                }
                case SOUTH: {
                    if (b.func_149693_C() != 1.0) break;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public final void setSide(World world, int x, int y, int z, int side) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) & 0xFFFFFFF8 | side, 3);
    }

    @Override
    public final ForgeDirection getSide(IBlockAccess world, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS[world.func_72805_g(x, y, z) & 7];
    }

    public final AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public final boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        int meta = world.func_72805_g(x, y, z) & 7;
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[meta];
        if (!this.canPlaceOn(world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, meta)) {
            ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)this);
            this.drop(world, x, y, z);
        }
    }

    public final void drop(World world, int x, int y, int z) {
        ItemStack is = new ItemStack((Block)this, 1, this.func_149692_a(world.func_72805_g(x, y, z)));
        ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)is);
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }

    public final void func_149683_g() {
        this.setBounds(ForgeDirection.EAST);
    }

    public final void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        this.setBounds(this.getSide(iba, x, y, z));
    }

    private void setBounds(ForgeDirection dir) {
        float xmin = 0.0f;
        float ymin = 0.0f;
        float zmin = 0.0f;
        float xmax = 1.0f;
        float ymax = 1.0f;
        float zmax = 1.0f;
        float h = 0.25f;
        float w = 0.25f;
        switch (dir) {
            case WEST: {
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                xmin = 1.0f - h;
                break;
            }
            case EAST: {
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                xmax = h;
                break;
            }
            case NORTH: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                zmin = 1.0f - h;
                break;
            }
            case SOUTH: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                zmax = h;
                break;
            }
            case UP: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymax = h;
                break;
            }
            case DOWN: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymin = 1.0f - h;
                break;
            }
        }
        this.func_149676_a(xmin, ymin, zmin, xmax, ymax, zmax);
    }

    public final boolean func_149662_c() {
        return false;
    }

    public final boolean func_149686_d() {
        return false;
    }

    public final int func_149645_b() {
        return 0;
    }

    public final int func_149701_w() {
        return 0;
    }

    public final boolean canRenderInPass(int pass) {
        return super.canRenderInPass(pass);
    }

    public final void func_149726_b(World world, int x, int y, int z) {
    }

    public final void func_149749_a(World world, int x, int y, int z, Block b, int meta) {
        this.onBlockBreak(world, x, y, z);
        super.func_149749_a(world, x, y, z, b, meta);
        this.updateNeighbors(world, x, y, z, meta);
    }

    protected void onBlockBreak(World world, int x, int y, int z) {
    }

    protected final void updateNeighbors(World world, int x, int y, int z, int meta) {
        world.func_147471_g(x, y, z);
        ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[meta & 7].getOpposite();
        ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)(x + dir.offsetX), (int)(y + dir.offsetY), (int)(z + dir.offsetZ));
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149734_b(World world, int x, int y, int z, Random r) {
        ForgeDirection dir = this.getSide((IBlockAccess)world, x, y, z);
        double dx = (double)x + 0.5 - (double)dir.offsetX * 0.3125;
        double dy = (double)y + 0.5 - (double)dir.offsetY * 0.3125;
        double dz = (double)z + 0.5 - (double)dir.offsetZ * 0.3125;
        double w = 0.1875;
        double h = 0.125;
        if (Math.abs(dir.offsetX) == 1) {
            dx = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)h);
            dy = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)w);
            dz = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)w);
        } else if (Math.abs(dir.offsetY) == 1) {
            dx = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)w);
            dy = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)h);
            dz = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)w);
        } else if (Math.abs(dir.offsetZ) == 1) {
            dx = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)w);
            dy = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)w);
            dz = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)h);
        }
        this.createFX(world, x, y, z, dx, dy, dz, r);
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void createFX(World var1, int var2, int var3, int var4, double var5, double var7, double var9, Random var11);

    public abstract int getColor(IBlockAccess var1, int var2, int var3, int var4);
}

