/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.GuardianStoneManager;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaExtractable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaPowered;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Auxiliary.Interfaces.VariableTexture;
import Reika.ChromatiCraft.Base.TileEntity.FluidEmitterChromaticBase;
import Reika.ChromatiCraft.Base.TileEntity.FluidIOChromaticBase;
import Reika.ChromatiCraft.Base.TileEntity.FluidReceiverChromaticBase;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityMassStorage;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.TileEntityAspectJar;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.Defence.TileEntityChromaLamp;
import Reika.ChromatiCraft.TileEntity.AOE.Defence.TileEntityGuardianStone;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityAccelerator;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityCrystalLaser;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityItemCollector;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityMultiBuilder;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFocusCrystal;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFunctionRelay;
import Reika.ChromatiCraft.TileEntity.Decoration.TileEntityCrystalMusic;
import Reika.ChromatiCraft.TileEntity.Decoration.TileEntityParticleSpawner;
import Reika.ChromatiCraft.TileEntity.Processing.TileEntityGlowFire;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityItemStand;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityRitualTable;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityCrystalTank;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityDimensionCore;
import Reika.ChromatiCraft.TileEntity.TileEntityDataNode;
import Reika.ChromatiCraft.TileEntity.Transport.TileEntityRift;
import Reika.ChromatiCraft.TileEntity.Transport.TileEntityTransportWindow;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.BlockTEBase;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Interfaces.Block.MachineRegistryBlock;
import Reika.DragonAPI.Interfaces.Item.MusicDataItem;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Interfaces.TileEntity.AdjacentUpdateWatcher;
import Reika.DragonAPI.Interfaces.TileEntity.ConditionalUnbreakability;
import Reika.DragonAPI.Interfaces.TileEntity.HitAction;
import Reika.DragonAPI.Interfaces.TileEntity.RedstoneTile;
import Reika.DragonAPI.Interfaces.TileEntity.SidePlacedTile;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BotaniaHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.DartItemHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockChromaTile
extends BlockTEBase
implements MachineRegistryBlock,
IWailaDataProvider {
    private static final Random par5Random = new Random();
    private static final HashMap<Coordinate, Long> lastNoTileWarning = new HashMap();
    private final IIcon[][][] icons = new IIcon[16][6][2];

    public BlockChromaTile(Material par2Material) {
        super(par2Material);
        this.func_149647_a(null);
        this.field_149782_v = 5.0f;
        this.field_149781_w = 40.0f;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        ChromaTiles c = ChromaTiles.getTile(world, x, y, z);
        if (c == null) {
            long time = System.currentTimeMillis();
            Coordinate loc = new Coordinate(x, y, z);
            Long get = lastNoTileWarning.get(loc);
            if (get == null || time - get > 2000L) {
                ChromatiCraft.logger.logError((Object)("No tile at location " + loc + " [" + loc.getBlock(world) + ":" + loc.getBlockMetadata(world) + "] !?"));
                lastNoTileWarning.put(loc, time);
            }
            return super.isSideSolid(world, x, y, z, dir);
        }
        switch (c) {
            case TABLE: {
                return dir != ForgeDirection.UP;
            }
        }
        return super.isSideSolid(world, x, y, z, dir);
    }

    public float getExplosionResistance(Entity e, World world, int x, int y, int z, double eX, double eY, double eZ) {
        ChromaTiles t = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (t == ChromaTiles.TABLE || t == ChromaTiles.DATANODE || t == ChromaTiles.EXPLOSIONSHIELD) {
            return Float.MAX_VALUE;
        }
        if (t == ChromaTiles.LANDMARK) {
            return 2.5f;
        }
        return super.getExplosionResistance(e, world, x, y, z, eX, eY, eZ);
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        OwnedTile o;
        TileEntityBase te = (TileEntityBase)world.func_147438_o(x, y, z);
        if (te instanceof OwnedTile && (o = (OwnedTile)te).onlyAllowOwnersToMine() && !o.isOwnedByPlayer(ep)) {
            return -1.0f;
        }
        if (te instanceof ConditionalUnbreakability && ((ConditionalUnbreakability)te).isUnbreakable(ep)) {
            return -1.0f;
        }
        if (te instanceof SneakPop && !((SneakPop)te).allowMining(ep)) {
            return -1.0f;
        }
        if (te instanceof TileEntityDataNode) {
            return -1.0f;
        }
        return super.func_149737_a(ep, world, x, y, z);
    }

    public final boolean hasTileEntity(int meta) {
        return true;
    }

    public final TileEntity createTileEntity(World world, int meta) {
        TileEntity te = ChromaTiles.createTEFromIDAndMetadata((Block)this, meta);
        return te;
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta][s][0];
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        int meta = iba.func_72805_g(x, y, z);
        TileEntityChromaticBase te = (TileEntityChromaticBase)iba.func_147438_o(x, y, z);
        return this.icons[meta][s][te instanceof VariableTexture ? ((VariableTexture)((Object)te)).getIconState(s) : 0];
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer ep) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof HitAction) {
            ((HitAction)te).onHit(world, x, y, z, ep);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        ChromaTiles c = ChromaTiles.getTile(world, x, y, z);
        if (c == ChromaTiles.LASER) {
            return 15;
        }
        if (c == ChromaTiles.LAMP) {
            return 15;
        }
        if (c == ChromaTiles.TANK) {
            TileEntityCrystalTank te = (TileEntityCrystalTank)world.func_147438_o(x, y, z);
            return te.getCurrentFluid() != null ? te.getCurrentFluid().getLuminosity() : 0;
        }
        if (c == ChromaTiles.ASPECTJAR) {
            TileEntityAspectJar te = (TileEntityAspectJar)world.func_147438_o(x, y, z);
            return te.hasAspects() ? 8 : 0;
        }
        if (c == ChromaTiles.STAND) {
            TileEntityItemStand te = (TileEntityItemStand)world.func_147438_o(x, y, z);
            return te.getItem() != null ? 6 : 0;
        }
        if (c == ChromaTiles.PYLONTURBO) {
            return 15;
        }
        return 0;
    }

    public void func_149651_a(IIconRegister ico) {
        ArrayList<ChromaTiles> tiles = ChromaTiles.getTilesForBlock((Block)this);
        for (int i = 0; i < tiles.size(); ++i) {
            ChromaTiles c = tiles.get(i);
            if (!c.hasBlockRender()) continue;
            for (int k = 0; k < 6; ++k) {
                String s = k == 0 ? "bottom" : (k == 1 ? "top" : "side");
                String path = c.name().toLowerCase(Locale.ENGLISH) + "_" + s;
                this.icons[c.getBlockMetadata()][k][0] = ico.func_94245_a("chromaticraft:tile/" + path);
                if (!c.hasTextureVariants()) continue;
                this.icons[c.getBlockMetadata()][k][1] = ico.func_94245_a("chromaticraft:tile/" + path + "_variant");
            }
        }
    }

    public final boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        boolean flag;
        super.func_149695_a(world, x, y, z, b);
        ChromaTiles t = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (t == ChromaTiles.WINDOW) {
            ((TileEntityTransportWindow)te).validateStructure();
        } else if (t.isSidePlaced() && !(flag = ((SidePlacedTile)te).checkLocationValidity())) {
            ((SidePlacedTile)te).drop();
        }
        if (te instanceof AdjacentUpdateWatcher) {
            ((AdjacentUpdateWatcher)te).onAdjacentUpdate(world, x, y, z, b);
        }
        if (te instanceof MultiBlockChromaTile) {
            ((MultiBlockChromaTile)te).validateStructure();
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion e) {
        ChromaTiles t = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (t == ChromaTiles.LANDMARK) {
            ReikaItemHelper.dropItem((World)world, (double)((double)x + par5Random.nextDouble()), (double)((double)y + par5Random.nextDouble()), (double)((double)z + par5Random.nextDouble()), (ItemStack)t.getCraftedProduct());
        }
        super.onBlockExploded(world, x, y, z, e);
    }

    public boolean func_149659_a(Explosion e) {
        return false;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int s) {
        ChromaTiles c = ChromaTiles.getTile(world, x, y, z);
        TileEntityChromaticBase te = (TileEntityChromaticBase)world.func_147438_o(x, y, z);
        if (c.suppliesRedstone()) {
            return ((RedstoneTile)te).getStrongPower(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[s].getOpposite());
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int s) {
        ChromaTiles c = ChromaTiles.getTile(world, x, y, z);
        TileEntityChromaticBase te = (TileEntityChromaticBase)world.func_147438_o(x, y, z);
        if (c.suppliesRedstone()) {
            return ((RedstoneTile)te).getWeakPower(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[s].getOpposite());
        }
        return 0;
    }

    public final boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int side, float par7, float par8, float par9) {
        FluidStack fs;
        TileEntityRitualTable tr;
        super.func_149727_a(world, x, y, z, ep, side, par7, par8, par9);
        if (ChromatiCraft.instance.isLocked()) {
            return false;
        }
        if (ReikaPlayerAPI.isFakeOrNotInteractable((EntityPlayer)ep, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (double)8.0)) {
            return false;
        }
        if (ReikaRandomHelper.doWithChance((double)2.0)) {
            ChromaAux.spawnInteractionBallLightning(world, x, y, z, CrystalElement.randomElement());
        }
        world.func_147471_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        ChromaTiles m = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        ItemStack is = ep.func_71045_bC();
        if (ModList.DARTCRAFT.isLoaded() && DartItemHandler.getInstance().isWrench(is)) {
            ep.func_70062_b(0, null);
            ep.func_85030_a("random.break", 1.0f, 1.0f);
            ep.func_70097_a(DamageSource.field_76368_d, 2.0f);
            ReikaChatHelper.write((Object)"Your tool has shattered into a dozen pieces.");
            return true;
        }
        if (ep.func_70093_af() && !m.hasSneakActions()) {
            return false;
        }
        if (is != null && ChromaItems.isRegistered(is) && ChromaItems.getEntry(is).overridesRightClick(is)) {
            return false;
        }
        if (is != null && ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)ChromaBlocks.ROUTERNODE.getBlockInstance())) {
            return false;
        }
        if (is != null && ModList.THAUMCRAFT.isLoaded() && is.func_77973_b() == ThaumItemHelper.ItemEntry.WAND.getItem().func_77973_b() && ReikaThaumHelper.getWandFocus((ItemStack)is) == ChromaItems.MANIPFOCUS.getItemInstance()) {
            return false;
        }
        if (m == ChromaTiles.STAND && ep.func_70093_af() && is == null) {
            if (!world.field_72995_K) {
                ((TileEntityItemStand)te).spreadItemWith(ep, is);
            }
            return true;
        }
        if (m == ChromaTiles.TABLE && is != null && ModList.BOTANIA.isLoaded() && is.func_77973_b() == BotaniaHandler.getInstance().wandID) {
            if (world.field_72995_K) {
                int[] colors = BotaniaHandler.getInstance().getWandColors(is);
                ReikaDyeHelper dye1 = ReikaDyeHelper.dyes[15 - colors[0]];
                ReikaDyeHelper dye2 = ReikaDyeHelper.dyes[15 - colors[1]];
                ((TileEntityCastingTable)te).onClickedWithBotaniaWand(dye1, dye2);
            }
            return true;
        }
        if (m == ChromaTiles.TABLE && ep.func_70093_af() && is == null) {
            if (!world.field_72995_K) {
                ((TileEntityCastingTable)te).dumpAllStands();
            }
            return true;
        }
        if (te instanceof ItemOnRightClick) {
            ItemStack ret = ((ItemOnRightClick)te).onRightClickWith(is, ep);
            ((TileEntityBase)te).syncAllData(true);
            ep.func_70062_b(0, ret);
            return true;
        }
        if (ChromaItems.BUCKET.matchWith(is) && is.func_77960_j() == 0 && is.field_77994_a == 1 && te instanceof ChromaPowered && ((ChromaPowered)te).addChroma(1000)) {
            if (!ep.field_71075_bZ.field_75098_d) {
                ep.func_70062_b(0, new ItemStack(Items.field_151133_ar));
            }
            return true;
        }
        if (is != null && is.func_77973_b() == Items.field_151133_ar && is.field_77994_a == 1 && te instanceof ChromaExtractable && ((ChromaExtractable)te).getChromaLevel() >= 1000) {
            ((ChromaExtractable)te).removeLiquid(1000);
            if (!ep.field_71075_bZ.field_75098_d) {
                ep.func_70062_b(0, ChromaItems.BUCKET.getStackOfMetadata(0));
            }
            return true;
        }
        if (ModList.THAUMCRAFT.isLoaded() && te instanceof TileEntityAspectJar && is != null) {
            TileEntityAspectJar jar = (TileEntityAspectJar)te;
            if (is.func_77973_b() instanceof IEssentiaContainerItem && is.field_77994_a == 1) {
                IEssentiaContainerItem ieci = (IEssentiaContainerItem)is.func_77973_b();
                AspectList al = ieci.getAspects(is);
                if (al != null && al.size() > 0) {
                    Aspect a = al.getAspects()[0];
                    int left = jar.addToContainer(a, al.getAmount(a));
                    int added = al.getAmount(a) - left;
                    ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"game.neutral.swim", (float)0.6f, (float)((float)ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)1.0)));
                    if (!ep.field_71075_bZ.field_75098_d) {
                        al.remove(a, added);
                        ieci.setAspects(is, al);
                        if (ieci == ThaumItemHelper.ItemEntry.PHIAL.getItem().func_77973_b()) {
                            is.func_77964_b(al.size() == 0 ? 0 : 1);
                        }
                    }
                    return true;
                }
                Aspect a = jar.getFirstAspect();
                if (a != null && jar.takeFromContainer(a, 8)) {
                    al = new AspectList();
                    al.add(a, 8);
                    ieci.setAspects(is, al);
                    if (ieci == ThaumItemHelper.ItemEntry.PHIAL.getItem().func_77973_b()) {
                        is.func_77964_b(al.size() == 0 ? 0 : 1);
                    }
                    ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"game.neutral.swim", (float)0.6f, (float)((float)ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)1.0)));
                    return true;
                }
            } else if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaStacks.glowChunk) && jar.upgradeForDirectDrain() && !ep.field_71075_bZ.field_75098_d) {
                --is.field_77994_a;
            }
        }
        if (m == ChromaTiles.MUSIC && is != null && is.func_77973_b() instanceof MusicDataItem) {
            TileEntityCrystalMusic mus = (TileEntityCrystalMusic)te;
            mus.setTrack(((MusicDataItem)is.func_77973_b()).getMusic(is));
            return true;
        }
        if (m == ChromaTiles.MULTIBUILDER) {
            TileEntityMultiBuilder tm = (TileEntityMultiBuilder)te;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
            if (dir.offsetY != 0) {
                tm.cycleShape();
            } else {
                dir = dir.getOpposite();
                if (ep.func_70093_af()) {
                    tm.contractArea(dir);
                } else {
                    tm.expandArea(dir);
                }
            }
            return true;
        }
        if (m == ChromaTiles.RITUAL && (tr = (TileEntityRitualTable)te).isOwnedByPlayer(ep)) {
            tr.initEnhancementCheck(ep);
        }
        if (ChromaItems.SHARD.matchWith(is) && is.func_77960_j() >= 16 && m == ChromaTiles.LAMP && ((TileEntityChromaLamp)te).addColor(CrystalElement.elements[is.func_77960_j() % 16]) && !ep.field_71075_bZ.field_75098_d) {
            --is.field_77994_a;
        }
        if (te instanceof TileEntityMassStorage) {
            ItemStack take;
            TileEntityMassStorage ts = (TileEntityMassStorage)te;
            if (is != null && ts.func_94041_b(0, is)) {
                ts.func_70299_a(0, is.func_77946_l());
                ep.func_70062_b(0, null);
                return true;
            }
            if (is == null && (take = ts.removeLastItem()) != null) {
                ep.func_70062_b(0, take);
            }
        }
        if (m == ChromaTiles.PARTICLES && is != null) {
            TileEntityParticleSpawner tp = (TileEntityParticleSpawner)te;
            if (is.func_77973_b() == Items.field_151122_aG) {
                if (is.field_77990_d != null && is.field_77990_d.func_74764_b("particleprogram")) {
                    tp.readCopyableData(is.field_77990_d.func_74775_l("particleprogram"));
                    world.func_147471_g(x, y, z);
                    ReikaSoundHelper.playPlaceSound((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
                } else {
                    is.field_77990_d = new NBTTagCompound();
                    NBTTagCompound tag = new NBTTagCompound();
                    tp.writeCopyableData(tag);
                    is.field_77990_d.func_74782_a("particleprogram", (NBTBase)tag);
                }
            } else {
                fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
                if (fs != null) {
                    tp.markAsFluid(fs.getFluid());
                    return true;
                }
            }
        }
        if (is != null && is.field_77994_a == 1 && m == ChromaTiles.TANK) {
            TileEntityCrystalTank tile = (TileEntityCrystalTank)te;
            fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
            if (fs != null) {
                int drain = tile.fill(null, fs, false);
                if (drain == fs.amount) {
                    tile.fill(null, fs, true);
                    if (!ep.field_71075_bZ.field_75098_d) {
                        ItemStack is2 = FluidContainerRegistry.drainFluidContainer((ItemStack)is);
                        ep.func_70062_b(0, is2);
                    }
                }
                return true;
            }
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)is)) {
                ItemStack fill;
                FluidStack rem = tile.drain(null, tile.getCurrentFluidLevel(), false);
                if (rem != null && (fill = FluidContainerRegistry.fillFluidContainer((FluidStack)rem, (ItemStack)is)) != null) {
                    FluidStack removed = FluidContainerRegistry.getFluidForFilledItem((ItemStack)fill);
                    tile.drain(null, removed.amount, true);
                    if (!ep.field_71075_bZ.field_75098_d) {
                        ep.func_70062_b(0, fill);
                    }
                }
                return true;
            }
        }
        if (ChromaItems.LENS.matchWith(is) && is.field_77994_a == 1 && te instanceof TileEntityCrystalLaser) {
            ItemStack ret = ((TileEntityCrystalLaser)te).swapLens(is);
            ep.func_70062_b(0, ret);
            return true;
        }
        if (m != ChromaTiles.TELEPORT && te != null && ChromaAux.hasGui(world, x, y, z, ep) && ((TileEntityBase)te).isPlayerAccessible(ep)) {
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, x, y, z);
            return true;
        }
        if (m == ChromaTiles.RITUAL) {
            return true;
        }
        ((TileEntityBase)te).syncAllData(true);
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        ChromaTiles m = ChromaTiles.getTileFromIDandMetadata((Block)this, meta);
        if (m == null) {
            return null;
        }
        TileEntity tile = world.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        ItemStack core = m.getCraftedProduct();
        if (core != null && m.hasNBTVariants()) {
            NBTTile nb = (NBTTile)tile;
            NBTTagCompound nbt = new NBTTagCompound();
            nb.getTagsToWriteToStack(nbt);
            core.field_77990_d = nbt.func_82582_d() ? null : (NBTTagCompound)nbt.func_74737_b();
        }
        return core;
    }

    public final boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harvest) {
        if (this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    private boolean canHarvest(World world, EntityPlayer ep, int x, int y, int z) {
        return !ep.field_71075_bZ.field_75098_d;
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        ChromaTiles m = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (m != null) {
            float f;
            ItemStack is = m.getCraftedProduct();
            ArrayList li = new ArrayList();
            if (is != null && m.hasNBTVariants()) {
                NBTTagCompound nbt = new NBTTagCompound();
                ((NBTTile)te).getTagsToWriteToStack(nbt);
                is.field_77990_d = (NBTTagCompound)(!nbt.func_82582_d() ? nbt.func_74737_b() : null);
            }
            if (m == ChromaTiles.GLOWFIRE && (f = ((TileEntityGlowFire)te).isSmothered()) > 0.0f && ReikaRandomHelper.doWithChance((double)f)) {
                is = ChromaStacks.transformCore.func_77946_l();
            }
            if (m == ChromaTiles.PYLONLINK) {
                is = ChromaBlocks.PYLONSTRUCT.getStackOf();
            }
            if (m == ChromaTiles.PYLONTURBO && ((TileEntityChromaticBase)te).getOwners(false).isEmpty()) {
                is = null;
            }
            if (is != null) {
                li = ReikaJavaLibrary.makeListFrom((Object)is);
            }
            if (m == ChromaTiles.ASPECTJAR && ((TileEntityAspectJar)te).hasDirectDrainUpgrade()) {
                li.add(ChromaStacks.glowChunk.func_77946_l());
            }
            ReikaItemHelper.dropItems((World)world, (double)((double)x + par5Random.nextDouble()), (double)((double)y + par5Random.nextDouble()), (double)((double)z + par5Random.nextDouble()), (Collection)li);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList li = new ArrayList();
        TileEntity te = world.func_147438_o(x, y, z);
        ChromaTiles m = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (m != null) {
            ItemStack is = m.getCraftedProduct();
            if (is != null && m.hasNBTVariants()) {
                NBTTagCompound nbt = new NBTTagCompound();
                ((NBTTile)te).getTagsToWriteToStack(nbt);
                is.field_77990_d = (NBTTagCompound)(!nbt.func_82582_d() ? nbt.func_74737_b() : null);
            }
            if (is != null) {
                li = ReikaJavaLibrary.makeListFrom((Object)is);
            }
        }
        return li;
    }

    public final void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityItemCollector) {
            ((TileEntityItemCollector)te).canIntake = false;
            ReikaWorldHelper.splitAndSpawnXP((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (int)((TileEntityItemCollector)te).getExperience());
        }
        if (te instanceof TileEntityRift) {
            ((TileEntityRift)te).resetOther();
        }
        if (te instanceof TileEntityGuardianStone) {
            GuardianStoneManager.instance.removeAreasForStone((TileEntityGuardianStone)te);
        }
        if (te instanceof CrystalNetworkTile) {
            ((CrystalNetworkTile)te).removeFromCache();
        }
        if (te instanceof CrystalReceiver) {
            CrystalNetworker.instance.breakPaths((CrystalReceiver)te);
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public float getEnchantPowerBonus(World world, int x, int y, int z) {
        ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (c == ChromaTiles.FUNCTIONRELAY) {
            return ((TileEntityFunctionRelay)world.func_147438_o(x, y, z)).getEnchantPowerInRange(world, x, y, z);
        }
        return super.getEnchantPowerBonus(world, x, y, z);
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        FluidTankInfo[] tanks;
        String input;
        Fluid in;
        TileEntityChromaticBase liq;
        TileEntityFocusCrystal.CrystalTier ct;
        TileEntityChromaticBase te = (TileEntityChromaticBase)acc.getTileEntity();
        if (te.getTile() != ChromaTiles.MUSIC) {
            te.syncAllData(te.getTile() == ChromaTiles.CHROMACRAFTER);
        }
        if (te instanceof TileEntityRift) {
            WorldLocation loc = ((TileEntityRift)te).getLinkTarget();
            if (loc != null) {
                currenttip.add("Linked to " + loc);
            } else {
                currenttip.add("Unlinked");
            }
            return currenttip;
        }
        if (te instanceof TileEntityAccelerator) {
            currenttip.add(String.format("Time Acceleration Factor: %dx", 1 + ((TileEntityAccelerator)te).getAccel()));
        }
        if (te instanceof TileEntityFocusCrystal && (ct = ((TileEntityFocusCrystal)te).getTier()) == TileEntityFocusCrystal.CrystalTier.TURBOCHARGED) {
            currenttip.add("Turbocharged");
        }
        if (te instanceof TileEntityDimensionCore) {
            CrystalElement e = ((TileEntityDimensionCore)te).getColor();
            currenttip.add("Color: " + e.displayName);
        }
        if (te instanceof TileEntityMassStorage) {
            TileEntityMassStorage ts = (TileEntityMassStorage)te;
            Map<KeyedItemStack, Integer> map = ts.getItemTypes();
            for (KeyedItemStack ks : map.keySet()) {
                int has = map.get(ks);
                currenttip.add(ks.getDisplayName() + " x" + has);
            }
        }
        if (te instanceof TileEntityCrystalTank) {
            TileEntityCrystalTank tank = (TileEntityCrystalTank)te;
            int amt = tank.getCurrentFluidLevel();
            int capacity = tank.getCapacity();
            Fluid f = tank.getCurrentFluid();
            if (amt > 0 && f != null) {
                currenttip.add(String.format("Tank: %dmB/%dmB of %s", amt, capacity, f.getLocalizedName()));
            } else {
                currenttip.add(String.format("Tank: Empty (Capacity %dmB)", capacity));
            }
        } else if (te instanceof FluidIOChromaticBase) {
            liq = (FluidIOChromaticBase)te;
            in = ((FluidIOChromaticBase)liq).getFluidInInput();
            Fluid out = ((FluidIOChromaticBase)liq).getFluidInOutput();
            int amtin = ((FluidIOChromaticBase)liq).getInputLevel();
            int amtout = ((FluidIOChromaticBase)liq).getOutputLevel();
            String input2 = in != null ? String.format("%d/%d mB of %s", amtin, ((FluidIOChromaticBase)liq).getCapacity(), in.getLocalizedName()) : "Empty";
            String output = out != null ? String.format("%d/%d mB of %s", amtout, ((FluidIOChromaticBase)liq).getCapacity(), out.getLocalizedName()) : "Empty";
            currenttip.add("Input Tank: " + input2);
            currenttip.add("Output Tank: " + output);
        } else if (te instanceof FluidReceiverChromaticBase) {
            liq = (FluidReceiverChromaticBase)te;
            in = ((FluidReceiverChromaticBase)liq).getContainedFluid();
            int amt = ((FluidReceiverChromaticBase)liq).getLevel();
            input = in != null ? String.format("%d/%d mB of %s", amt, ((FluidReceiverChromaticBase)liq).getCapacity(), in.getLocalizedName()) : "Empty";
            currenttip.add("Tank: " + input);
        } else if (te instanceof FluidEmitterChromaticBase) {
            liq = (FluidEmitterChromaticBase)te;
            in = ((FluidEmitterChromaticBase)liq).getContainedFluid();
            int amt = ((FluidEmitterChromaticBase)liq).getLevel();
            input = in != null ? String.format("%d/%d mB of %s", amt, ((FluidEmitterChromaticBase)liq).getCapacity(), in.getLocalizedName()) : "Empty";
            currenttip.add("Tank: " + input);
        } else if (te instanceof IFluidHandler && (tanks = ((IFluidHandler)te).getTankInfo(ForgeDirection.UP)) != null) {
            for (int i = 0; i < tanks.length; ++i) {
                FluidTankInfo info = tanks[i];
                FluidStack fs = info.fluid;
                String input3 = fs != null ? String.format("%d/%d mB of %s", fs.amount, info.capacity, fs.getFluid().getLocalizedName(fs)) : "Empty";
                currenttip.add("Tank " + i + ": " + input3);
            }
        }
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public final TileEnum getMachine(IBlockAccess world, int x, int y, int z) {
        return ChromaTiles.getTile(world, x, y, z);
    }
}

