/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BreadthFirstSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockProtectedByStructure
extends Block {
    protected BlockProtectedByStructure(Material mat) {
        super(mat);
    }

    public final float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        int dy = y;
        MultiBlockChromaTile te = this.getMultiblockTile(world, x, y, z);
        if (te == null) {
            return super.func_149737_a(ep, world, x, y, z);
        }
        if (te instanceof CrystalSource) {
            return -1.0f;
        }
        return te instanceof OwnedTile && !((OwnedTile)((Object)te)).isOwnedByPlayer(ep) ? -1.0f : super.func_149737_a(ep, world, x, y, z);
    }

    private MultiBlockChromaTile getMultiblockTile(World world, int x, int y, int z) {
        BreadthFirstSearch bfs = new BreadthFirstSearch(x, y, z);
        bfs.limit = BlockBox.block((int)x, (int)y, (int)z).expand(15, 40, 15);
        AbstractSearch.PropagationCondition prop = new AbstractSearch.PropagationCondition(){

            public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
                Block b = world.func_147439_a(x, y, z);
                return b instanceof BlockProtectedByStructure || b == ChromaBlocks.RUNE.getBlockInstance();
            }
        };
        AbstractSearch.TerminationCondition end = new AbstractSearch.TerminationCondition(){

            public boolean isValidTerminus(World world, int x, int y, int z) {
                return world.func_147438_o(x, y, z) instanceof MultiBlockChromaTile;
            }
        };
        bfs.complete(world, prop, end);
        LinkedList li = bfs.getResult();
        if (li == null || li.isEmpty()) {
            return null;
        }
        TileEntity te = ((Coordinate)li.getLast()).getTileEntity((IBlockAccess)world);
        return te instanceof MultiBlockChromaTile ? (MultiBlockChromaTile)te : null;
    }
}

